/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.compile.AbstractOptions;
import org.gradle.api.tasks.compile.GroovyForkOptions;

public class GroovyCompileOptions
extends AbstractOptions {
    private static final long serialVersionUID = 0L;
    private static final ImmutableSet<String> EXCLUDE_FROM_ANT_PROPERTIES = ImmutableSet.of((Object)"forkOptions", (Object)"optimizationOptions", (Object)"stubDir", (Object)"keepStubs", (Object)"fileExtensions");
    private boolean failOnError = true;
    private boolean verbose;
    private boolean listFiles;
    private String encoding = "UTF-8";
    private boolean fork = true;
    private boolean keepStubs;
    private List<String> fileExtensions = ImmutableList.of((Object)"java", (Object)"groovy");
    private GroovyForkOptions forkOptions = new GroovyForkOptions();
    private Map<String, Boolean> optimizationOptions = Maps.newHashMap();
    private File stubDir;
    private File configurationScript;
    private boolean javaAnnotationProcessing;
    private boolean parameters;

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Console
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Console
    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    public File getConfigurationScript() {
        return this.configurationScript;
    }

    public void setConfigurationScript(@Nullable File configurationFile) {
        this.configurationScript = configurationFile;
    }

    @Input
    public boolean isJavaAnnotationProcessing() {
        return this.javaAnnotationProcessing;
    }

    public void setJavaAnnotationProcessing(boolean javaAnnotationProcessing) {
        this.javaAnnotationProcessing = javaAnnotationProcessing;
    }

    @Incubating
    @Input
    public boolean isParameters() {
        return this.parameters;
    }

    @Incubating
    public void setParameters(boolean parameters) {
        this.parameters = parameters;
    }

    @Nested
    public GroovyForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(GroovyForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    @Nullable
    @Optional
    @Input
    public Map<String, Boolean> getOptimizationOptions() {
        return this.optimizationOptions;
    }

    public void setOptimizationOptions(@Nullable Map<String, Boolean> optimizationOptions) {
        this.optimizationOptions = optimizationOptions;
    }

    @Internal
    public File getStubDir() {
        return this.stubDir;
    }

    public void setStubDir(File stubDir) {
        this.stubDir = stubDir;
    }

    @Input
    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(List<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    @Input
    public boolean isKeepStubs() {
        return this.keepStubs;
    }

    public void setKeepStubs(boolean keepStubs) {
        this.keepStubs = keepStubs;
    }

    public GroovyCompileOptions fork(Map<String, Object> forkArgs) {
        this.fork = true;
        this.forkOptions.define(forkArgs);
        return this;
    }

    protected boolean excludeFromAntProperties(String fieldName) {
        return EXCLUDE_FROM_ANT_PROPERTIES.contains((Object)fieldName);
    }

    public Map<String, Object> optionMap() {
        Map map = super.optionMap();
        map.putAll(this.forkOptions.optionMap());
        if (this.optimizationOptions.containsKey("indy")) {
            map.put("indy", this.optimizationOptions.get("indy"));
        }
        return map;
    }
}

