/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.desktopgui.router;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class RouterManager {
    private static I2PAppContext getAppContext() {
        return I2PAppContext.getGlobalContext();
    }

    public static void start() {
        try {
            String separator = System.getProperty("file.separator");
            String location = RouterManager.getAppContext().getBaseDir().getAbsolutePath();
            String[] args = new String[]{location + separator + "i2psvc", location + separator + "wrapper.config"};
            Runtime.getRuntime().exec(args);
        }
        catch (IOException e) {
            Log log = RouterManager.getAppContext().logManager().getLog(RouterManager.class);
            log.log(30, "Failed to start I2P", (Throwable)e);
        }
    }

    public static void restart(RouterContext ctx) {
        ctx.router().shutdownGracefully(4);
    }

    public static void shutDown(RouterContext ctx) {
        ctx.router().shutdownGracefully(3);
    }

    public static void restartGracefully(RouterContext ctx) {
        ctx.router().shutdownGracefully(5);
    }

    public static void shutDownGracefully(RouterContext ctx) {
        ctx.router().shutdownGracefully();
    }

    public static void cancelShutdown(RouterContext ctx) {
        ctx.router().cancelGracefulShutdown();
    }

    public static boolean isShutdownInProgress(RouterContext ctx) {
        return ctx.router().scheduledGracefulExitCode() > 0;
    }

    public static long getShutdownTimeRemaining(RouterContext ctx) {
        return ctx.router().getShutdownTimeRemaining();
    }

    public static String getStatus(RouterContext ctx) {
        return ctx.commSystem().getStatus().toStatusString();
    }
}

