/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XTable;

public class TableSorter
extends DefaultTableModel
implements MouseListener {
    private boolean ascending = true;
    private TableColumnModel columnModel;
    private JTable tableView;
    private Vector<TableModelListener> evtListenerList = new Vector();
    private int sortColumn = 0;
    private int[] invertedIndex;

    public TableSorter() {
    }

    public TableSorter(Object[] objectArray, int n) {
        super(objectArray, n);
    }

    @Override
    public void newDataAvailable(TableModelEvent tableModelEvent) {
        super.newDataAvailable(tableModelEvent);
        this.invertedIndex = new int[this.getRowCount()];
        for (int i = 0; i < this.invertedIndex.length; ++i) {
            this.invertedIndex[i] = i;
        }
        this.sort(this.sortColumn, this.ascending);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.evtListenerList.add(tableModelListener);
        super.addTableModelListener(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.evtListenerList.remove(tableModelListener);
        super.removeTableModelListener(tableModelListener);
    }

    private void removeListeners() {
        for (TableModelListener tableModelListener : this.evtListenerList) {
            super.removeTableModelListener(tableModelListener);
        }
    }

    private void restoreListeners() {
        for (TableModelListener tableModelListener : this.evtListenerList) {
            super.addTableModelListener(tableModelListener);
        }
    }

    private int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        if (object.getClass().equals(object2.getClass()) && object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        return object.toString().compareTo(object2.toString());
    }

    private void sort(int n, boolean bl) {
        XMBeanAttributes xMBeanAttributes;
        XMBeanAttributes xMBeanAttributes2 = xMBeanAttributes = this.tableView instanceof XMBeanAttributes ? (XMBeanAttributes)this.tableView : null;
        if (xMBeanAttributes != null && xMBeanAttributes.isEditing()) {
            xMBeanAttributes.cancelCellEditing();
        }
        this.removeListeners();
        if (JConsole.isDebug()) {
            System.err.println("sorting table against column=" + n + " ascending=" + bl);
        }
        this.quickSort(0, this.getRowCount() - 1, n, bl);
        this.restoreListeners();
        if (xMBeanAttributes != null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Vector vector = (Vector)this.dataVector.elementAt(i);
                xMBeanAttributes.updateRowHeight(vector.elementAt(1), i);
            }
        }
    }

    private boolean compareS(Object object, Object object2, boolean bl) {
        if (bl) {
            return this.compare(object, object2) > 0;
        }
        return this.compare(object, object2) < 0;
    }

    private boolean compareG(Object object, Object object2, boolean bl) {
        if (bl) {
            return this.compare(object, object2) < 0;
        }
        return this.compare(object, object2) > 0;
    }

    private void quickSort(int n, int n2, int n3, boolean bl) {
        int n4 = n;
        int n5 = n2;
        if (n2 > n) {
            Object object = this.getValueAt((n + n2) / 2, n3);
            while (n4 <= n5) {
                while (n4 < n2 && this.compareS(object, this.getValueAt(n4, n3), bl)) {
                    ++n4;
                }
                while (n5 > n && this.compareG(object, this.getValueAt(n5, n3), bl)) {
                    --n5;
                }
                if (n4 > n5) continue;
                this.swap(n4, n5, n3);
                ++n4;
                --n5;
            }
            if (n < n5) {
                this.quickSort(n, n5, n3, bl);
            }
            if (n4 <= n2) {
                this.quickSort(n4, n2, n3, bl);
            }
        }
    }

    private Vector getRow(int n) {
        return (Vector)this.dataVector.elementAt(n);
    }

    private void setRow(Vector vector, int n) {
        this.dataVector.setElementAt(vector, n);
    }

    private void swap(int n, int n2, int n3) {
        Vector vector = this.getRow(n);
        this.setRow(this.getRow(n2), n);
        this.setRow(vector, n2);
        int n4 = this.invertedIndex[n];
        this.invertedIndex[n] = this.invertedIndex[n2];
        this.invertedIndex[n2] = n4;
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, !this.ascending);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortColumn = n;
        this.sort(n, bl);
    }

    public int getIndexOfRow(int n) {
        return this.invertedIndex[n];
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        this.tableView = jTable;
        this.columnModel = this.tableView.getColumnModel();
        JTableHeader jTableHeader = this.tableView.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.columnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.tableView.convertColumnIndexToModel(n);
        if (mouseEvent.getClickCount() == 1 && n2 != -1) {
            if (this.tableView instanceof XTable) {
                XTable xTable = (XTable)this.tableView;
                xTable.sortRequested(n2);
            }
            this.tableView.invalidate();
            this.sortByColumn(n2);
            this.tableView.validate();
            this.tableView.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

