/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsNullNullCipher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class RecordStream {
    private static int DEFAULT_PLAINTEXT_LIMIT = 16384;
    private final Record inputRecord = new Record();
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private SequenceNumber readSeqNo = new SequenceNumber();
    private SequenceNumber writeSeqNo = new SequenceNumber();
    private ProtocolVersion writeVersion = null;
    private int plaintextLimit;
    private int ciphertextLimit;

    RecordStream(TlsProtocol tlsProtocol, InputStream inputStream, OutputStream outputStream) {
        this.handler = tlsProtocol;
        this.input = inputStream;
        this.output = outputStream;
    }

    void init(TlsContext tlsContext) {
        this.writeCipher = this.readCipher = TlsNullNullCipher.INSTANCE;
        this.setPlaintextLimit(DEFAULT_PLAINTEXT_LIMIT);
    }

    int getPlaintextLimit() {
        return this.plaintextLimit;
    }

    void setPlaintextLimit(int n) {
        this.plaintextLimit = n;
        this.ciphertextLimit = this.readCipher.getCiphertextDecodeLimit(n);
    }

    void setWriteVersion(ProtocolVersion protocolVersion) {
        this.writeVersion = protocolVersion;
    }

    void setPendingConnectionState(TlsCipher tlsCipher) {
        this.pendingCipher = tlsCipher;
    }

    void sentWriteCipherSpec() throws IOException {
        if (this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo = new SequenceNumber();
    }

    void receivedReadCipherSpec() throws IOException {
        if (this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.readCipher = this.pendingCipher;
        this.ciphertextLimit = this.readCipher.getCiphertextDecodeLimit(this.plaintextLimit);
        this.readSeqNo = new SequenceNumber();
    }

    void finaliseHandshake() throws IOException {
        if (this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCipher = null;
    }

    RecordPreview previewRecordHeader(byte[] byArray) throws IOException {
        short s = TlsUtils.readUint8(byArray, 0);
        this.checkRecordType(s);
        int n = TlsUtils.readUint16(byArray, 3);
        RecordStream.checkLength(n, this.ciphertextLimit, (short)22);
        int n2 = 5 + n;
        int n3 = 0;
        if (23 == s && this.handler.isApplicationDataReady()) {
            n3 = Math.max(0, Math.min(this.plaintextLimit, this.readCipher.getPlaintextLimit(n)));
        }
        return new RecordPreview(n2, n3);
    }

    RecordPreview previewOutputRecord(int n) {
        int n2 = Math.max(0, Math.min(this.plaintextLimit, n));
        int n3 = 5 + this.writeCipher.getCiphertextEncodeLimit(n2, this.plaintextLimit);
        return new RecordPreview(n3, n2);
    }

    boolean readFullRecord(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 5) {
            return false;
        }
        int n3 = TlsUtils.readUint16(byArray, n + 3);
        if (n2 != 5 + n3) {
            return false;
        }
        short s = TlsUtils.readUint8(byArray, n + 0);
        this.checkRecordType(s);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byArray, n + 1);
        RecordStream.checkLength(n3, this.ciphertextLimit, (short)22);
        TlsDecodeResult tlsDecodeResult = this.decodeAndVerify(s, protocolVersion, byArray, n + 5, n3);
        this.handler.processRecord(tlsDecodeResult.contentType, tlsDecodeResult.buf, tlsDecodeResult.off, tlsDecodeResult.len);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readRecord() throws IOException {
        TlsDecodeResult tlsDecodeResult;
        if (!this.inputRecord.readHeader(this.input)) {
            return false;
        }
        short s = TlsUtils.readUint8(this.inputRecord.buf, 0);
        this.checkRecordType(s);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(this.inputRecord.buf, 1);
        int n = TlsUtils.readUint16(this.inputRecord.buf, 3);
        RecordStream.checkLength(n, this.ciphertextLimit, (short)22);
        this.inputRecord.readFragment(this.input, n);
        try {
            tlsDecodeResult = this.decodeAndVerify(s, protocolVersion, this.inputRecord.buf, 5, n);
        }
        finally {
            this.inputRecord.reset();
        }
        this.handler.processRecord(tlsDecodeResult.contentType, tlsDecodeResult.buf, tlsDecodeResult.off, tlsDecodeResult.len);
        return true;
    }

    TlsDecodeResult decodeAndVerify(short s, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        long l = this.readSeqNo.nextValue((short)10);
        TlsDecodeResult tlsDecodeResult = this.readCipher.decodeCiphertext(l, s, protocolVersion, byArray, n, n2);
        RecordStream.checkLength(tlsDecodeResult.len, this.plaintextLimit, (short)22);
        if (tlsDecodeResult.len < 1 && tlsDecodeResult.contentType != 23) {
            throw new TlsFatalAlert(47);
        }
        return tlsDecodeResult;
    }

    void writeRecord(short s, byte[] byArray, int n, int n2) throws IOException {
        if (this.writeVersion == null) {
            return;
        }
        RecordStream.checkLength(n2, this.plaintextLimit, (short)80);
        if (n2 < 1 && s != 23) {
            throw new TlsFatalAlert(80);
        }
        long l = this.writeSeqNo.nextValue((short)80);
        ProtocolVersion protocolVersion = this.writeVersion;
        TlsEncodeResult tlsEncodeResult = this.writeCipher.encodePlaintext(l, s, protocolVersion, 5, byArray, n, n2);
        int n3 = tlsEncodeResult.len - 5;
        TlsUtils.checkUint16(n3);
        TlsUtils.writeUint8(tlsEncodeResult.recordType, tlsEncodeResult.buf, tlsEncodeResult.off + 0);
        TlsUtils.writeVersion(protocolVersion, tlsEncodeResult.buf, tlsEncodeResult.off + 1);
        TlsUtils.writeUint16(n3, tlsEncodeResult.buf, tlsEncodeResult.off + 3);
        try {
            this.output.write(tlsEncodeResult.buf, tlsEncodeResult.off, tlsEncodeResult.len);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new TlsFatalAlert(80, (Throwable)interruptedIOException);
        }
        this.output.flush();
    }

    void close() throws IOException {
        IOException iOException;
        block5: {
            this.inputRecord.reset();
            iOException = null;
            try {
                this.input.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            try {
                this.output.close();
            }
            catch (IOException iOException3) {
                if (iOException != null) break block5;
                iOException = iOException3;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    void flush() throws IOException {
        this.output.flush();
    }

    private void checkRecordType(short s) throws IOException {
        if (this.readCipher.usesOpaqueRecordType()) {
            if (23 != s) {
                throw new TlsFatalAlert(10);
            }
        } else {
            switch (s) {
                case 23: {
                    if (this.handler.isApplicationDataReady()) break;
                    throw new TlsFatalAlert(10);
                }
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(10);
                }
            }
        }
    }

    private static void checkLength(int n, int n2, short s) throws IOException {
        if (n > n2) {
            throw new TlsFatalAlert(s);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Record {
        private final byte[] header = new byte[5];
        volatile byte[] buf = this.header;
        volatile int pos = 0;

        private Record() {
        }

        void fillTo(InputStream inputStream, int n) throws IOException {
            while (this.pos < n) {
                try {
                    int n2 = inputStream.read(this.buf, this.pos, n - this.pos);
                    if (n2 < 0) break;
                    this.pos += n2;
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.pos += interruptedIOException.bytesTransferred;
                    interruptedIOException.bytesTransferred = 0;
                    throw interruptedIOException;
                }
            }
        }

        void readFragment(InputStream inputStream, int n) throws IOException {
            int n2 = 5 + n;
            this.resize(n2);
            this.fillTo(inputStream, n2);
            if (this.pos < n2) {
                throw new EOFException();
            }
        }

        boolean readHeader(InputStream inputStream) throws IOException {
            this.fillTo(inputStream, 5);
            if (this.pos == 0) {
                return false;
            }
            if (this.pos < 5) {
                throw new EOFException();
            }
            return true;
        }

        void reset() {
            this.buf = this.header;
            this.pos = 0;
        }

        private void resize(int n) {
            if (this.buf.length < n) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class SequenceNumber {
        private long value = 0L;
        private boolean exhausted = false;

        private SequenceNumber() {
        }

        synchronized long nextValue(short s) throws TlsFatalAlert {
            if (this.exhausted) {
                throw new TlsFatalAlert(s);
            }
            long l = this.value++;
            if (this.value == 0L) {
                this.exhausted = true;
            }
            return l;
        }
    }
}

