"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
function isOverElement(prevProps, nextProps) {
    if (!nextProps) {
        return false;
    }
    if (!nextProps.settings || !nextProps.settings.onElementOver) {
        return false;
    }
    var nextGeomValues = nextProps.highlightedGeometries;
    var prevGeomValues = prevProps ? prevProps.highlightedGeometries : [];
    if (nextGeomValues.length > 0) {
        if (nextGeomValues.length !== prevGeomValues.length) {
            return true;
        }
        return !nextGeomValues.every(function (_a, index) {
            var next = _a.value;
            var prev = prevGeomValues[index].value;
            return prev && prev.x === next.x && prev.y === next.y && prev.accessor === next.accessor;
        });
    }
    return false;
}
function createOnElementOverCaller() {
    var prevProps = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.XYAxis) {
            selector = re_reselect_1.default([get_tooltip_values_highlighted_geoms_1.getTooltipInfoAndGeometriesSelector, get_settings_specs_1.getSettingsSpecSelector], function (_a, settings) {
                var highlightedGeometries = _a.highlightedGeometries;
                var nextProps = {
                    settings: settings,
                    highlightedGeometries: highlightedGeometries,
                };
                if (isOverElement(prevProps, nextProps) && settings.onElementOver) {
                    var elements = highlightedGeometries.map(function (_a) {
                        var value = _a.value, seriesIdentifier = _a.seriesIdentifier;
                        return [value, seriesIdentifier];
                    });
                    settings.onElementOver(elements);
                }
                prevProps = nextProps;
            })({
                keySelector: get_chart_id_1.getChartIdSelector,
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnElementOverCaller = createOnElementOverCaller;
//# sourceMappingURL=on_element_over_caller.js.map