/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkBindImageMemoryDeviceGroupInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEINDEXCOUNT;
    public static final int PDEVICEINDICES;
    public static final int SPLITINSTANCEBINDREGIONCOUNT;
    public static final int PSPLITINSTANCEBINDREGIONS;

    public VkBindImageMemoryDeviceGroupInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindImageMemoryDeviceGroupInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindImageMemoryDeviceGroupInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindImageMemoryDeviceGroupInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceIndexCount() {
        return VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pDeviceIndices() {
        return VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address());
    }

    @NativeType(value="uint32_t")
    public int splitInstanceBindRegionCount() {
        return VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(this.address());
    }

    @Nullable
    @NativeType(value="VkRect2D const *")
    public VkRect2D.Buffer pSplitInstanceBindRegions() {
        return VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address());
    }

    public VkBindImageMemoryDeviceGroupInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindImageMemoryDeviceGroupInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo pNext(@NativeType(value="void const *") long value) {
        VkBindImageMemoryDeviceGroupInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo pSplitInstanceBindRegions(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
        VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address(), value);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo set(int sType, long pNext, @Nullable IntBuffer pDeviceIndices, @Nullable VkRect2D.Buffer pSplitInstanceBindRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDeviceIndices(pDeviceIndices);
        this.pSplitInstanceBindRegions(pSplitInstanceBindRegions);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfo set(VkBindImageMemoryDeviceGroupInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindImageMemoryDeviceGroupInfo malloc() {
        return (VkBindImageMemoryDeviceGroupInfo)VkBindImageMemoryDeviceGroupInfo.wrap(VkBindImageMemoryDeviceGroupInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBindImageMemoryDeviceGroupInfo calloc() {
        return (VkBindImageMemoryDeviceGroupInfo)VkBindImageMemoryDeviceGroupInfo.wrap(VkBindImageMemoryDeviceGroupInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBindImageMemoryDeviceGroupInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBindImageMemoryDeviceGroupInfo)VkBindImageMemoryDeviceGroupInfo.wrap(VkBindImageMemoryDeviceGroupInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBindImageMemoryDeviceGroupInfo create(long address) {
        return (VkBindImageMemoryDeviceGroupInfo)VkBindImageMemoryDeviceGroupInfo.wrap(VkBindImageMemoryDeviceGroupInfo.class, (long)address);
    }

    @Nullable
    public static VkBindImageMemoryDeviceGroupInfo createSafe(long address) {
        return address == 0L ? null : (VkBindImageMemoryDeviceGroupInfo)VkBindImageMemoryDeviceGroupInfo.wrap(VkBindImageMemoryDeviceGroupInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBindImageMemoryDeviceGroupInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBindImageMemoryDeviceGroupInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBindImageMemoryDeviceGroupInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImageMemoryDeviceGroupInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBindImageMemoryDeviceGroupInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBindImageMemoryDeviceGroupInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBindImageMemoryDeviceGroupInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBindImageMemoryDeviceGroupInfo mallocStack() {
        return VkBindImageMemoryDeviceGroupInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryDeviceGroupInfo callocStack() {
        return VkBindImageMemoryDeviceGroupInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryDeviceGroupInfo mallocStack(MemoryStack stack) {
        return (VkBindImageMemoryDeviceGroupInfo)VkBindImageMemoryDeviceGroupInfo.wrap(VkBindImageMemoryDeviceGroupInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImageMemoryDeviceGroupInfo callocStack(MemoryStack stack) {
        return (VkBindImageMemoryDeviceGroupInfo)VkBindImageMemoryDeviceGroupInfo.wrap(VkBindImageMemoryDeviceGroupInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImageMemoryDeviceGroupInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImageMemoryDeviceGroupInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBindImageMemoryDeviceGroupInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBindImageMemoryDeviceGroupInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndeviceIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npDeviceIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEVICEINDICES)), (int)VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(struct));
    }

    public static int nsplitInstanceBindRegionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SPLITINSTANCEBINDREGIONCOUNT);
    }

    @Nullable
    public static VkRect2D.Buffer npSplitInstanceBindRegions(long struct) {
        return VkRect2D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSPLITINSTANCEBINDREGIONS)), VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndeviceIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEINDEXCOUNT, value);
    }

    public static void npDeviceIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEVICEINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsplitInstanceBindRegionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SPLITINSTANCEBINDREGIONCOUNT, value);
    }

    public static void npSplitInstanceBindRegions(long struct, @Nullable VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSPLITINSTANCEBINDREGIONS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEVICEINDICES)));
        }
        if (VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSPLITINSTANCEBINDREGIONS)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkBindImageMemoryDeviceGroupInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkBindImageMemoryDeviceGroupInfo.__struct((Struct.Member[])new Struct.Member[]{VkBindImageMemoryDeviceGroupInfo.__member((int)4), VkBindImageMemoryDeviceGroupInfo.__member((int)POINTER_SIZE), VkBindImageMemoryDeviceGroupInfo.__member((int)4), VkBindImageMemoryDeviceGroupInfo.__member((int)POINTER_SIZE), VkBindImageMemoryDeviceGroupInfo.__member((int)4), VkBindImageMemoryDeviceGroupInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEINDEXCOUNT = layout.offsetof(2);
        PDEVICEINDICES = layout.offsetof(3);
        SPLITINSTANCEBINDREGIONCOUNT = layout.offsetof(4);
        PSPLITINSTANCEBINDREGIONS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkBindImageMemoryDeviceGroupInfo, Buffer>
    implements NativeResource {
        private static final VkBindImageMemoryDeviceGroupInfo ELEMENT_FACTORY = VkBindImageMemoryDeviceGroupInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBindImageMemoryDeviceGroupInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindImageMemoryDeviceGroupInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindImageMemoryDeviceGroupInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceIndexCount() {
            return VkBindImageMemoryDeviceGroupInfo.ndeviceIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pDeviceIndices() {
            return VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address());
        }

        @NativeType(value="uint32_t")
        public int splitInstanceBindRegionCount() {
            return VkBindImageMemoryDeviceGroupInfo.nsplitInstanceBindRegionCount(this.address());
        }

        @Nullable
        @NativeType(value="VkRect2D const *")
        public VkRect2D.Buffer pSplitInstanceBindRegions() {
            return VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImageMemoryDeviceGroupInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImageMemoryDeviceGroupInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBindImageMemoryDeviceGroupInfo.npDeviceIndices(this.address(), value);
            return this;
        }

        public Buffer pSplitInstanceBindRegions(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
            VkBindImageMemoryDeviceGroupInfo.npSplitInstanceBindRegions(this.address(), value);
            return this;
        }
    }
}

