/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandleDevice;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VkDevice
extends DispatchableHandleDevice {
    private final VkPhysicalDevice physicalDevice;

    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci) {
        this(handle, physicalDevice, ci, 0);
    }

    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci, int apiVersion) {
        super(handle, VkDevice.getDeviceCapabilities(handle, physicalDevice, ci, apiVersion));
        this.physicalDevice = physicalDevice;
    }

    public VkPhysicalDevice getPhysicalDevice() {
        return this.physicalDevice;
    }

    private static VKCapabilitiesDevice getDeviceCapabilities(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci, int apiVersion) {
        long GetDeviceProcAddr;
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (apiVersion == 0) {
                long GetPhysicalDeviceProperties = JNI.callPPP((long)physicalDevice.getInstance().address(), (long)MemoryUtil.memAddress((ByteBuffer)stack.ASCII((CharSequence)"vkGetPhysicalDeviceProperties")), (long)VK.getGlobalCommands().vkGetInstanceProcAddr);
                VkPhysicalDeviceProperties props = VkPhysicalDeviceProperties.callocStack(stack);
                JNI.callPPV((long)physicalDevice.address(), (long)props.address(), (long)GetPhysicalDeviceProperties);
                apiVersion = props.apiVersion();
                if (apiVersion == 0) {
                    apiVersion = physicalDevice.getInstance().getCapabilities().apiVersion;
                }
            }
            GetDeviceProcAddr = JNI.callPPP((long)physicalDevice.getInstance().address(), (long)MemoryUtil.memAddress((ByteBuffer)stack.ASCII((CharSequence)"vkGetDeviceProcAddr")), (long)VK.getGlobalCommands().vkGetInstanceProcAddr);
        }
        return new VKCapabilitiesDevice(functionName -> {
            long address = JNI.callPPP((long)handle, (long)MemoryUtil.memAddress((ByteBuffer)functionName), (long)GetDeviceProcAddr);
            if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog((CharSequence)("Failed to locate address for VK device function " + MemoryUtil.memASCII((ByteBuffer)functionName)));
            }
            return address;
        }, physicalDevice.getCapabilities(), VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()));
    }
}

