/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXType
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int DATA;

    public CXType(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXType.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXTypeKind")
    public int kind() {
        return CXType.nkind(this.address());
    }

    @NativeType(value="void *[2]")
    public PointerBuffer data() {
        return CXType.ndata(this.address());
    }

    @NativeType(value="void *")
    public long data(int index) {
        return CXType.ndata(this.address(), index);
    }

    public static CXType malloc() {
        return (CXType)CXType.wrap(CXType.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXType calloc() {
        return (CXType)CXType.wrap(CXType.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXType create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXType)CXType.wrap(CXType.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXType create(long address) {
        return (CXType)CXType.wrap(CXType.class, (long)address);
    }

    @Nullable
    public static CXType createSafe(long address) {
        return address == 0L ? null : (CXType)CXType.wrap(CXType.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXType.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXType.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXType.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXType.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXType.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXType.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXType.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXType mallocStack() {
        return CXType.mallocStack(MemoryStack.stackGet());
    }

    public static CXType callocStack() {
        return CXType.callocStack(MemoryStack.stackGet());
    }

    public static CXType mallocStack(MemoryStack stack) {
        return (CXType)CXType.wrap(CXType.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXType callocStack(MemoryStack stack) {
        return (CXType)CXType.wrap(CXType.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXType.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXType.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXType.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXType.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static PointerBuffer ndata(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)DATA), (int)2);
    }

    public static long ndata(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    static {
        Struct.Layout layout = CXType.__struct((Struct.Member[])new Struct.Member[]{CXType.__member((int)4), CXType.__array((int)POINTER_SIZE, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXType, Buffer>
    implements NativeResource {
        private static final CXType ELEMENT_FACTORY = CXType.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXType getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXTypeKind")
        public int kind() {
            return CXType.nkind(this.address());
        }

        @NativeType(value="void *[2]")
        public PointerBuffer data() {
            return CXType.ndata(this.address());
        }

        @NativeType(value="void *")
        public long data(int index) {
            return CXType.ndata(this.address(), index);
        }
    }
}

