/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pdftk.com.lowagie.text.Rectangle;

class LoadableRectangle {
    static final NumberFormat c_format = NumberFormat.getInstance(Locale.ROOT);
    Rectangle rr = null;

    static Rectangle BufferFloats(String buff, int buff_ii) {
        String FLOATRE = "(-?\\d*\\.?\\d+)";
        Pattern p = Pattern.compile("\\s?(-?\\d*\\.?\\d+)\\s(-?\\d*\\.?\\d+)\\s(-?\\d*\\.?\\d+)\\s(-?\\d*\\.?\\d+).*");
        Matcher m = p.matcher(buff.substring(buff_ii));
        if (m.matches()) {
            return new Rectangle(Float.parseFloat(m.group(1)), Float.parseFloat(m.group(2)), Float.parseFloat(m.group(3)), Float.parseFloat(m.group(4)));
        }
        return null;
    }

    boolean LoadRectangle(String buff, String label) {
        int label_len = label.length();
        if (buff.startsWith(label)) {
            if (this.rr == null) {
                this.rr = LoadableRectangle.BufferFloats(buff, label_len);
            } else {
                System.err.println("pdftk Warning: " + label + " (" + this.position() + ") not empty when reading new " + label + " (" + LoadableRectangle.position(LoadableRectangle.BufferFloats(buff, label_len)) + ") -- skipping newer item");
            }
            return this.rr != null;
        }
        return false;
    }

    LoadableRectangle(Rectangle rr) {
        this.rr = rr;
    }

    static boolean equalPosition(Rectangle r, Rectangle s) {
        return r != null && s != null && r.left() == s.left() && r.bottom() == s.bottom() && r.right() == s.right() && r.top() == s.top();
    }

    String position() {
        return LoadableRectangle.position(this.rr);
    }

    static String position(Rectangle r) {
        if (r == null) {
            return "";
        }
        return c_format.format(r.left()) + " " + c_format.format(r.bottom()) + " " + c_format.format(r.right()) + " " + c_format.format(r.top());
    }

    String dimensions() {
        return LoadableRectangle.dimensions(this.rr);
    }

    static String dimensions(Rectangle r) {
        if (r == null) {
            return "";
        }
        return c_format.format(r.right() - r.left()) + " " + c_format.format(r.top() - r.bottom());
    }
}

