/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.views;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.document.Document;
import com.projectlibre1.document.ObjectEvent;
import com.projectlibre1.graphic.configuration.SpreadSheetFieldArray;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.help.HelpUtil;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.pm.graphic.views.BaseView;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.UndoController;
import com.projectlibre1.workspace.WorkspaceSetting;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ProjectView
extends JScrollPane
implements BaseView,
ObjectEvent.Listener {
    private static final long serialVersionUID = -4440711646626221865L;
    private static final String spreadsheetCategory = "projectSpreadsheet";
    protected SpreadSheet spreadSheet;
    protected NodeModel model;
    protected NodeModelCache cache;
    Document document;

    public ProjectView(NodeModel nodeModel, Document document) {
        this.model = nodeModel;
        this.document = document;
        HelpUtil.addDocHelp(this, "Projects_View");
        this.createSpreadsheet(nodeModel);
        GraphicManager.getInstance(this).getProjectFactory().getPortfolio().addObjectListener(this);
    }

    @Override
    public void cleanUp() {
        GraphicManager.getInstance(this).getProjectFactory().getPortfolio().removeObjectListener(this);
        this.spreadSheet.cleanUp();
        this.spreadSheet = null;
        this.model = null;
        this.cache = null;
        this.document = null;
    }

    public void createSpreadsheet(NodeModel nodeModel) {
        this.spreadSheet = new SpreadSheet();
        this.spreadSheet.setSpreadSheetCategory(spreadsheetCategory);
        this.cache = NodeModelCacheFactory.getInstance().createDefaultCache(nodeModel, this.document, 8, this.getViewName(), null);
        SpreadSheetFieldArray spreadSheetFieldArray = ProjectView.getFields();
        this.spreadSheet.setCache(this.cache, spreadSheetFieldArray, spreadSheetFieldArray.getCellStyle(), spreadSheetFieldArray.getActionList());
        JViewport jViewport = this.createViewport();
        jViewport.setView(this.spreadSheet);
        this.setViewport(jViewport);
        this.cache.update();
    }

    private static SpreadSheetFieldArray getFields() {
        return (SpreadSheetFieldArray)Dictionary.get(spreadsheetCategory, Messages.getString("Spreadsheet.Project.default"));
    }

    @Override
    public SpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
        if (objectEvent.getObject() instanceof Project && objectEvent.isCreate()) {
            if (this.model == null) {
                return;
            }
            this.cache.update();
            this.spreadSheet.invalidate();
        }
    }

    @Override
    public UndoController getUndoController() {
        return null;
    }

    @Override
    public void zoomIn() {
    }

    @Override
    public void zoomOut() {
    }

    @Override
    public boolean canZoomIn() {
        return false;
    }

    @Override
    public boolean canZoomOut() {
        return false;
    }

    @Override
    public int getScale() {
        return -1;
    }

    @Override
    public boolean hasNormalMinWidth() {
        return true;
    }

    @Override
    public String getViewName() {
        return "Projects";
    }

    @Override
    public boolean showsTasks() {
        return false;
    }

    @Override
    public boolean showsResources() {
        return false;
    }

    @Override
    public void onActivate(boolean bl) {
    }

    @Override
    public boolean isPrintable() {
        return true;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.spreadSheet.restoreWorkspace(workspace.spreadSheet, n);
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.spreadSheet = this.spreadSheet.createWorkspace(n);
        return workspace;
    }

    @Override
    public boolean canScrollToTask() {
        return false;
    }

    @Override
    public void scrollToTask() {
    }

    @Override
    public NodeModelCache getCache() {
        return this.cache;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -1801198970620970719L;
        WorkspaceSetting spreadSheet;

        public WorkspaceSetting getSpreadSheet() {
            return this.spreadSheet;
        }

        public void setSpreadSheet(WorkspaceSetting workspaceSetting) {
            this.spreadSheet = workspaceSetting;
        }
    }
}

