from . import SimLibrary
from .. import SIM_PROCEDURES as P
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from ...sim_type import SimTypeFunction, SimTypeLong


lib = SimLibrary()
lib.set_library_names('advapi32.dll')
if 'advapi32' in P:
    # The above check can be removed when procedures/advapi32 contains at least one SimProcedure
    lib.add_all_from_dict(P['advapi32'])

lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)

prototypes = {
    "A_SHAFinal": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "A_SHAInit": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "A_SHAUpdate": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "AbortSystemShutdownA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AbortSystemShutdownW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AccessCheck": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "AccessCheckAndAuditAlarmA": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "AccessCheckAndAuditAlarmW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "AccessCheckByType": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "AccessCheckByTypeAndAuditAlarmA": SimTypeFunction((SimTypeLong(),)*16, SimTypeLong()),
    "AccessCheckByTypeAndAuditAlarmW": SimTypeFunction((SimTypeLong(),)*16, SimTypeLong()),
    "AccessCheckByTypeResultList": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "AccessCheckByTypeResultListAndAuditAlarmA": SimTypeFunction((SimTypeLong(),)*16, SimTypeLong()),
    "AccessCheckByTypeResultListAndAuditAlarmByHandleA": SimTypeFunction((SimTypeLong(),)*17, SimTypeLong()),
    "AccessCheckByTypeResultListAndAuditAlarmByHandleW": SimTypeFunction((SimTypeLong(),)*17, SimTypeLong()),
    "AccessCheckByTypeResultListAndAuditAlarmW": SimTypeFunction((SimTypeLong(),)*16, SimTypeLong()),
    "AddAccessAllowedAce": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "AddAccessAllowedAceEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "AddAccessAllowedObjectAce": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "AddAccessDeniedAce": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "AddAccessDeniedAceEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "AddAccessDeniedObjectAce": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "AddAce": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "AddAuditAccessAce": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "AddAuditAccessAceEx": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "AddAuditAccessObjectAce": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "AddConditionalAce": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "AddMandatoryAce": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "AddUsersToEncryptedFile": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AddUsersToEncryptedFileEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "AdjustTokenGroups": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "AdjustTokenPrivileges": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "AllocateAndInitializeSid": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "AllocateLocallyUniqueId": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AreAllAccessesGranted": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AreAnyAccessesGranted": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditComputeEffectivePolicyBySid": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "AuditComputeEffectivePolicyByToken": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "AuditEnumerateCategories": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditEnumeratePerUserPolicy": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AuditEnumerateSubCategories": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "AuditFree": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AuditLookupCategoryGuidFromCategoryId": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditLookupCategoryIdFromCategoryGuid": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditLookupCategoryNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditLookupCategoryNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditLookupSubCategoryNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditLookupSubCategoryNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditQueryGlobalSaclA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditQueryGlobalSaclW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditQueryPerUserPolicy": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "AuditQuerySecurity": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditQuerySystemPolicy": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "AuditSetGlobalSaclA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditSetGlobalSaclW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditSetPerUserPolicy": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "AuditSetSecurity": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AuditSetSystemPolicy": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BackupEventLogA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BackupEventLogW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BuildExplicitAccessWithNameA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "BuildExplicitAccessWithNameW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "BuildImpersonateExplicitAccessWithNameA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "BuildImpersonateExplicitAccessWithNameW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "BuildImpersonateTrusteeA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BuildImpersonateTrusteeW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BuildSecurityDescriptorA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "BuildSecurityDescriptorW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "BuildTrusteeWithNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BuildTrusteeWithNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BuildTrusteeWithObjectsAndNameA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "BuildTrusteeWithObjectsAndNameW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "BuildTrusteeWithObjectsAndSidA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "BuildTrusteeWithObjectsAndSidW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "BuildTrusteeWithSidA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BuildTrusteeWithSidW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CancelOverlappedAccess": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ChangeServiceConfig2A": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ChangeServiceConfig2W": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ChangeServiceConfigA": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "ChangeServiceConfigW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "CheckTokenMembership": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ClearEventLogA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ClearEventLogW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CloseCodeAuthzLevel": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseEncryptedFileRaw": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseEventLog": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseServiceHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseThreadWaitChainSession": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseTrace": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CommandLineFromMsiDescriptor": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ComputeAccessTokenFromCodeAuthzLevel": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ControlService": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ControlServiceExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ControlServiceExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ControlTraceA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ControlTraceW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ConvertAccessToSecurityDescriptorA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ConvertAccessToSecurityDescriptorW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ConvertSDToStringSDRootDomainA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ConvertSDToStringSDRootDomainW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ConvertSecurityDescriptorToAccessA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "ConvertSecurityDescriptorToAccessNamedA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "ConvertSecurityDescriptorToAccessNamedW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "ConvertSecurityDescriptorToAccessW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "ConvertSecurityDescriptorToStringSecurityDescriptorA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ConvertSecurityDescriptorToStringSecurityDescriptorW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ConvertSidToStringSidA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ConvertSidToStringSidW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ConvertStringSDToSDDomainA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ConvertStringSDToSDDomainW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ConvertStringSDToSDRootDomainA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ConvertStringSDToSDRootDomainW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ConvertStringSecurityDescriptorToSecurityDescriptorA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ConvertStringSecurityDescriptorToSecurityDescriptorW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ConvertStringSidToSidA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ConvertStringSidToSidW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ConvertToAutoInheritPrivateObjectSecurity": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CopySid": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateCodeAuthzLevel": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CreatePrivateObjectSecurity": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CreatePrivateObjectSecurityEx": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "CreatePrivateObjectSecurityWithMultipleInheritance": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "CreateProcessAsUserA": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "CreateProcessAsUserW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "CreateProcessWithLogonW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "CreateProcessWithTokenW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "CreateRestrictedToken": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "CreateServiceA": SimTypeFunction((SimTypeLong(),)*13, SimTypeLong()),
    "CreateServiceW": SimTypeFunction((SimTypeLong(),)*13, SimTypeLong()),
    "CreateTraceInstanceId": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateWellKnownSid": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredBackupCredentials": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CredDeleteA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredDeleteW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredEncryptAndMarshalBinaryBlob": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredEnumerateA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredEnumerateW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredFindBestCredentialA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredFindBestCredentialW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredFree": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CredGetSessionTypes": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CredGetTargetInfoA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredGetTargetInfoW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredIsMarshaledCredentialA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CredIsMarshaledCredentialW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CredIsProtectedA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CredIsProtectedW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CredMarshalCredentialA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredMarshalCredentialW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredProfileLoaded": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "CredProfileUnloaded": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "CredProtectA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CredProtectW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CredReadA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredReadByTokenHandle": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CredReadDomainCredentialsA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredReadDomainCredentialsW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredReadW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredRenameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredRenameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredRestoreCredentials": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredUnmarshalCredentialA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredUnmarshalCredentialW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredUnprotectA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CredUnprotectW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CredWriteA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CredWriteDomainCredentialsA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredWriteDomainCredentialsW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CredWriteW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CredpConvertCredential": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredpConvertOneCredentialSize": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CredpConvertTargetInfo": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CredpDecodeCredential": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CredpEncodeCredential": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CredpEncodeSecret": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptAcquireContextA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptAcquireContextW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptContextAddRef": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CryptCreateHash": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptDecrypt": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptDeriveKey": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptDestroyHash": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CryptDestroyKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CryptDuplicateHash": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptDuplicateKey": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptEncrypt": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CryptEnumProviderTypesA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptEnumProviderTypesW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptEnumProvidersA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptEnumProvidersW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptExportKey": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptGenKey": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptGenRandom": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CryptGetDefaultProviderA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptGetDefaultProviderW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptGetHashParam": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptGetKeyParam": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptGetProvParam": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CryptGetUserKey": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CryptHashData": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptHashSessionKey": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CryptImportKey": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptReleaseContext": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CryptSetHashParam": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptSetKeyParam": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptSetProvParam": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptSetProviderA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CryptSetProviderExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptSetProviderExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CryptSetProviderW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CryptSignHashA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptSignHashW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptVerifySignatureA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CryptVerifySignatureW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "DecryptFileA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DecryptFileW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DeleteAce": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DeleteService": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeregisterEventSource": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DestroyPrivateObjectSecurity": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DuplicateEncryptionInfoFile": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "DuplicateToken": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DuplicateTokenEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ElfBackupEventLogFileA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ElfBackupEventLogFileW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ElfChangeNotify": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ElfClearEventLogFileA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ElfClearEventLogFileW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ElfCloseEventLog": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ElfDeregisterEventSource": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ElfFlushEventLog": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ElfNumberOfRecords": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ElfOldestRecord": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ElfOpenBackupEventLogA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ElfOpenBackupEventLogW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ElfOpenEventLogA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ElfOpenEventLogW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ElfReadEventLogA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "ElfReadEventLogW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "ElfRegisterEventSourceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ElfRegisterEventSourceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ElfReportEventA": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "ElfReportEventAndSourceW": SimTypeFunction((SimTypeLong(),)*15, SimTypeLong()),
    "ElfReportEventW": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "EnableTrace": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EnableTraceEx": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "EnableTraceEx2": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "EncryptFileA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "EncryptFileW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "EncryptedFileKeyInfo": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EncryptionDisable": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EnumDependentServicesA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EnumDependentServicesW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EnumServiceGroupW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "EnumServicesStatusA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "EnumServicesStatusExA": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "EnumServicesStatusExW": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "EnumServicesStatusW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "EnumerateTraceGuids": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumerateTraceGuidsEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EqualDomainSid": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EqualPrefixSid": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EqualSid": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EventAccessControl": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EventAccessQuery": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EventAccessRemove": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "EventActivityIdControl": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EventEnabled": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EventProviderEnabled": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EventRegister": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EventUnregister": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EventWrite": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EventWriteEndScenario": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EventWriteEx": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "EventWriteStartScenario": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EventWriteString": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EventWriteTransfer": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "FileEncryptionStatusA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FileEncryptionStatusW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindFirstFreeAce": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FlushEfsCache": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FlushTraceA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "FlushTraceW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "FreeEncryptedFileKeyInfo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FreeEncryptedFileMetadata": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FreeEncryptionCertificateHashList": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FreeInheritedFromArray": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FreeSid": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetAccessPermissionsForObjectA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "GetAccessPermissionsForObjectW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "GetAce": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetAclInformation": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetAuditedPermissionsFromAclA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetAuditedPermissionsFromAclW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetCurrentHwProfileA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetCurrentHwProfileW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetEffectiveRightsFromAclA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetEffectiveRightsFromAclW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetEncryptedFileMetadata": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetEventLogInformation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetExplicitEntriesFromAclA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetExplicitEntriesFromAclW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetFileSecurityA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetFileSecurityW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetInformationCodeAuthzLevelW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetInformationCodeAuthzPolicyW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetInheritanceSourceA": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "GetInheritanceSourceW": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "GetKernelObjectSecurity": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetLengthSid": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetLocalManagedApplicationData": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetLocalManagedApplications": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetManagedApplicationCategories": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetManagedApplications": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetMultipleTrusteeA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetMultipleTrusteeOperationA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetMultipleTrusteeOperationW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetMultipleTrusteeW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetNamedSecurityInfoA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetNamedSecurityInfoExA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "GetNamedSecurityInfoExW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "GetNamedSecurityInfoW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetNumberOfEventLogRecords": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetOldestEventLogRecord": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetOverlappedAccessResults": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetPrivateObjectSecurity": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetSecurityDescriptorControl": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetSecurityDescriptorDacl": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetSecurityDescriptorGroup": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetSecurityDescriptorLength": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetSecurityDescriptorOwner": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetSecurityDescriptorRMControl": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSecurityDescriptorSacl": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetSecurityInfo": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetSecurityInfoExA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "GetSecurityInfoExW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "GetServiceDisplayNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetServiceDisplayNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetServiceKeyNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetServiceKeyNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetSidIdentifierAuthority": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetSidLengthRequired": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetSidSubAuthority": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSidSubAuthorityCount": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetThreadWaitChain": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "GetTokenInformation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetTraceEnableFlags": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetTraceEnableLevel": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetTraceLoggerHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTrusteeFormA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTrusteeFormW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTrusteeNameA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTrusteeNameW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTrusteeTypeA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTrusteeTypeW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetUserNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetUserNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetWindowsAccountDomainSid": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "I_QueryTagInformation": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "I_ScGetCurrentGroupStateW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "I_ScIsSecurityProcess": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "I_ScPnPGetServiceName": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "I_ScQueryServiceConfig": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "I_ScSendPnPMessage": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "I_ScSendTSMessage": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "I_ScSetServiceBitsA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "I_ScSetServiceBitsW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "I_ScValidatePnPService": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "IdentifyCodeAuthzLevelW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ImpersonateAnonymousToken": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ImpersonateLoggedOnUser": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ImpersonateNamedPipeClient": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ImpersonateSelf": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InitializeAcl": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "InitializeSecurityDescriptor": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "InitializeSid": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "InitiateShutdownA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "InitiateShutdownW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "InitiateSystemShutdownA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "InitiateSystemShutdownExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "InitiateSystemShutdownExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "InitiateSystemShutdownW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "InstallApplication": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsTextUnicode": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "IsTokenRestricted": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsTokenUntrusted": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsValidAcl": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsValidRelativeSecurityDescriptor": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "IsValidSecurityDescriptor": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsValidSid": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsWellKnownSid": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LockServiceDatabase": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LogonUserA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "LogonUserExA": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "LogonUserExExW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "LogonUserExW": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "LogonUserW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "LookupAccountNameA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "LookupAccountNameW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "LookupAccountSidA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "LookupAccountSidW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "LookupPrivilegeDisplayNameA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LookupPrivilegeDisplayNameW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LookupPrivilegeNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LookupPrivilegeNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LookupPrivilegeValueA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LookupPrivilegeValueW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LookupSecurityDescriptorPartsA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "LookupSecurityDescriptorPartsW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "LsaAddAccountRights": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaAddPrivilegesToAccount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaClearAuditLog": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LsaClose": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LsaCreateAccount": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaCreateSecret": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaCreateTrustedDomain": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaCreateTrustedDomainEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaDelete": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LsaDeleteTrustedDomain": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaEnumerateAccountRights": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaEnumerateAccounts": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaEnumerateAccountsWithUserRight": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaEnumeratePrivileges": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaEnumeratePrivilegesOfAccount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaEnumerateTrustedDomains": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaEnumerateTrustedDomainsEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaFreeMemory": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LsaGetQuotasForAccount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaGetRemoteUserName": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaGetSystemAccessAccount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaGetUserName": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaICLookupNames": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "LsaICLookupNamesWithCreds": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "LsaICLookupSids": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "LsaICLookupSidsWithCreds": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "LsaLookupNames": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaLookupNames2": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "LsaLookupPrivilegeDisplayName": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaLookupPrivilegeName": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaLookupPrivilegeValue": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaLookupSids": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaManageSidNameMapping": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaNtStatusToWinError": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LsaOpenAccount": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaOpenPolicy": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaOpenPolicySce": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaOpenSecret": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaOpenTrustedDomain": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaOpenTrustedDomainByName": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaQueryDomainInformationPolicy": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaQueryForestTrustInformation": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaQueryInfoTrustedDomain": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaQueryInformationPolicy": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaQuerySecret": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaQuerySecurityObject": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaQueryTrustedDomainInfo": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaQueryTrustedDomainInfoByName": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaRemoveAccountRights": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaRemovePrivilegesFromAccount": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaRetrievePrivateData": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaSetDomainInformationPolicy": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaSetForestTrustInformation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LsaSetInformationPolicy": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaSetInformationTrustedDomain": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaSetQuotasForAccount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaSetSecret": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaSetSecurityObject": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LsaSetSystemAccessAccount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LsaSetTrustedDomainInfoByName": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaSetTrustedDomainInformation": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LsaStorePrivateData": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MD4Final": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "MD4Init": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "MD4Update": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MD5Final": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "MD5Init": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "MD5Update": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MSChapSrvChangePassword": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "MSChapSrvChangePassword2": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "MakeAbsoluteSD": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "MakeAbsoluteSD2": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "MakeSelfRelativeSD": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MapGenericMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "NotifyBootConfigStatus": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "NotifyChangeEventLog": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "NotifyServiceStatusChange": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "NotifyServiceStatusChangeA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "NotifyServiceStatusChangeW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ObjectCloseAuditAlarmA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ObjectCloseAuditAlarmW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ObjectDeleteAuditAlarmA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ObjectDeleteAuditAlarmW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ObjectOpenAuditAlarmA": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "ObjectOpenAuditAlarmW": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "ObjectPrivilegeAuditAlarmA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ObjectPrivilegeAuditAlarmW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "OpenBackupEventLogA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "OpenBackupEventLogW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "OpenEncryptedFileRawA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenEncryptedFileRawW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenEventLogA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "OpenEventLogW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "OpenProcessToken": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenSCManagerA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenSCManagerW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenServiceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenServiceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenThreadToken": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "OpenThreadWaitChainSession": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "OpenTraceA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "OpenTraceW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "PerfAddCounters": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "PerfCloseQueryHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "PerfCreateInstance": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfDecrementULongCounterValue": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfDecrementULongLongCounterValue": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "PerfDeleteCounters": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "PerfDeleteInstance": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "PerfEnumerateCounterSet": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfEnumerateCounterSetInstances": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "PerfIncrementULongCounterValue": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfIncrementULongLongCounterValue": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "PerfOpenQueryHandle": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "PerfQueryCounterData": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfQueryCounterInfo": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfQueryCounterSetRegistrationInfo": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "PerfQueryInstance": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfSetCounterRefValue": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfSetCounterSetInfo": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "PerfSetULongCounterValue": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PerfSetULongLongCounterValue": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "PerfStartProvider": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "PerfStartProviderEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "PerfStopProvider": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "PrivilegeCheck": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "PrivilegedServiceAuditAlarmA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "PrivilegedServiceAuditAlarmW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ProcessIdleTasks": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "ProcessIdleTasksW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ProcessTrace": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryAllTracesA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "QueryAllTracesW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "QueryRecoveryAgentsOnEncryptedFile": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QuerySecurityAccessMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryServiceConfig2A": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "QueryServiceConfig2W": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "QueryServiceConfigA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryServiceConfigW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryServiceLockStatusA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryServiceLockStatusW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryServiceObjectSecurity": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "QueryServiceStatus": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryServiceStatusEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "QueryTraceA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryTraceW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryUsersOnEncryptedFile": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ReadEncryptedFileRaw": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ReadEventLogA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "ReadEventLogW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegCloseKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegConnectRegistryA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegConnectRegistryExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegConnectRegistryExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegConnectRegistryW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegCopyTreeA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegCopyTreeW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegCreateKeyA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegCreateKeyExA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "RegCreateKeyExW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "RegCreateKeyTransactedA": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "RegCreateKeyTransactedW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "RegCreateKeyW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegDeleteKeyA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteKeyExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegDeleteKeyExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegDeleteKeyTransactedA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegDeleteKeyTransactedW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegDeleteKeyValueA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegDeleteKeyValueW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegDeleteKeyW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteTreeA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteTreeW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteValueA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteValueW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDisablePredefinedCache": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "RegDisablePredefinedCacheEx": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "RegDisableReflectionKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegEnableReflectionKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegEnumKeyA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegEnumKeyExA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegEnumKeyExW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegEnumKeyW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegEnumValueA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegEnumValueW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegFlushKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegGetKeySecurity": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegGetValueA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegGetValueW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegLoadAppKeyA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegLoadAppKeyW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegLoadKeyA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegLoadKeyW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegLoadMUIStringA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegLoadMUIStringW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegNotifyChangeKeyValue": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegOpenCurrentUser": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegOpenKeyA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegOpenKeyExA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegOpenKeyExW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegOpenKeyTransactedA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegOpenKeyTransactedW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegOpenKeyW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegOpenUserClassesRoot": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegOverridePredefKey": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegQueryInfoKeyA": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "RegQueryInfoKeyW": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "RegQueryMultipleValuesA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegQueryMultipleValuesW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegQueryReflectionKey": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegQueryValueA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegQueryValueExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegQueryValueExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegQueryValueW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegRenameKey": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegReplaceKeyA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegReplaceKeyW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegRestoreKeyA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegRestoreKeyW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegSaveKeyA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegSaveKeyExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegSaveKeyExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegSaveKeyW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegSetKeySecurity": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegSetKeyValueA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegSetKeyValueW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegSetValueA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegSetValueExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegSetValueExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegSetValueW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegUnLoadKeyA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegUnLoadKeyW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterEventSourceA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterEventSourceW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterIdleTask": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegisterServiceCtrlHandlerA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterServiceCtrlHandlerExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegisterServiceCtrlHandlerExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegisterServiceCtrlHandlerW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterTraceGuidsA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegisterTraceGuidsW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegisterWaitChainCOMCallback": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RemoveTraceCallback": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RemoveUsersFromEncryptedFile": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ReportEventA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "ReportEventW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "RevertToSelf": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "SaferCloseLevel": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SaferComputeTokenFromLevel": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SaferCreateLevel": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SaferGetLevelInformation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SaferGetPolicyInformation": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SaferIdentifyLevel": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SaferRecordEventLogEntry": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SaferSetLevelInformation": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SaferSetPolicyInformation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SaferiChangeRegistryScope": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SaferiCompareTokenLevels": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SaferiIsDllAllowed": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SaferiIsExecutableFileType": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SaferiPopulateDefaultsInRegistry": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SaferiRecordEventLogEntry": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SaferiRegisterExtensionDll": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SaferiSearchMatchingHashRules": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetAclInformation": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetEncryptedFileMetadata": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetEntriesInAccessListA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetEntriesInAccessListW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetEntriesInAclA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetEntriesInAclW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetEntriesInAuditListA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetEntriesInAuditListW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetFileSecurityA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetFileSecurityW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetInformationCodeAuthzLevelW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetInformationCodeAuthzPolicyW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SetKernelObjectSecurity": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetNamedSecurityInfoA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "SetNamedSecurityInfoExA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "SetNamedSecurityInfoExW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "SetNamedSecurityInfoW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "SetPrivateObjectSecurity": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SetPrivateObjectSecurityEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetSecurityAccessMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetSecurityDescriptorControl": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetSecurityDescriptorDacl": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetSecurityDescriptorGroup": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetSecurityDescriptorOwner": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetSecurityDescriptorRMControl": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetSecurityDescriptorSacl": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetSecurityInfo": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "SetSecurityInfoExA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "SetSecurityInfoExW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "SetServiceBits": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetServiceObjectSecurity": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetServiceStatus": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadToken": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetTokenInformation": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetTraceCallback": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetUserFileEncryptionKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetUserFileEncryptionKeyEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "StartServiceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "StartServiceCtrlDispatcherA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "StartServiceCtrlDispatcherW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "StartServiceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "StartTraceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "StartTraceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "StopTraceA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "StopTraceW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SystemFunction001": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction002": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction003": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction004": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction005": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction006": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction007": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction008": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction009": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction010": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction011": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction012": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction013": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction014": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction015": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction016": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction017": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction018": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction019": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction020": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction021": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction022": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction023": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction024": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction025": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction026": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction027": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction028": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction029": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction030": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction031": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction032": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction033": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction034": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction035": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SystemFunction036": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemFunction040": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SystemFunction041": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "TraceEvent": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "TraceEventInstance": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "TraceMessage": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "TraceMessageVa": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "TraceSetInformation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "TreeResetNamedSecurityInfoA": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "TreeResetNamedSecurityInfoW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "TreeSetNamedSecurityInfoA": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "TreeSetNamedSecurityInfoW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "TrusteeAccessToObjectA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "TrusteeAccessToObjectW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "UninstallApplication": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "UnlockServiceDatabase": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "UnregisterIdleTask": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "UnregisterTraceGuids": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "UpdateTraceA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "UpdateTraceW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "UsePinForEncryptedFilesA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "UsePinForEncryptedFilesW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WmiCloseBlock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WmiDevInstToInstanceNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiDevInstToInstanceNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiEnumerateGuids": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WmiExecuteMethodA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "WmiExecuteMethodW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "WmiFileHandleToInstanceNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiFileHandleToInstanceNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiFreeBuffer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WmiMofEnumerateResourcesA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WmiMofEnumerateResourcesW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WmiNotificationRegistrationA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WmiNotificationRegistrationW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WmiOpenBlock": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WmiQueryAllDataA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WmiQueryAllDataMultipleA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiQueryAllDataMultipleW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiQueryAllDataW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WmiQueryGuidInformation": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WmiQuerySingleInstanceA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiQuerySingleInstanceMultipleA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WmiQuerySingleInstanceMultipleW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WmiQuerySingleInstanceW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiReceiveNotificationsA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiReceiveNotificationsW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WmiSetSingleInstanceA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WmiSetSingleInstanceW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WmiSetSingleItemA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "WmiSetSingleItemW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "WriteEncryptedFileRaw": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong())
}

lib.set_prototypes(prototypes)
