/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.backup.Checksum;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.util.PropertiesInputStream;

public class ShardBackupMetadata {
    private Map<String, BackedFile> allFiles = new HashMap<String, BackedFile>();
    private List<String> uniqueFileNames = new ArrayList<String>();

    public void addBackedFile(String uniqueFileName, String originalFileName, Checksum fileChecksum) {
        this.addBackedFile(new BackedFile(uniqueFileName, originalFileName, fileChecksum));
    }

    public int numFiles() {
        return this.uniqueFileNames.size();
    }

    public long totalSize() {
        return this.allFiles.values().stream().map(bf -> bf.fileChecksum.size).reduce(0L, Long::sum);
    }

    public void addBackedFile(BackedFile backedFile) {
        this.allFiles.put(backedFile.originalFileName, backedFile);
        this.uniqueFileNames.add(backedFile.uniqueFileName);
    }

    public Optional<BackedFile> getFile(String originalFileName) {
        return Optional.ofNullable(this.allFiles.get(originalFileName));
    }

    public List<String> listUniqueFileNames() {
        return Collections.unmodifiableList(this.uniqueFileNames);
    }

    public static ShardBackupMetadata empty() {
        return new ShardBackupMetadata();
    }

    public static ShardBackupMetadata from(BackupRepository repository, URI dir, ShardBackupId shardBackupId) throws IOException {
        String shardBackupMetadataFilename = shardBackupId.getBackupMetadataFilename();
        if (!repository.exists(repository.resolve(dir, shardBackupMetadataFilename))) {
            return null;
        }
        try (IndexInput is = repository.openInput(dir, shardBackupMetadataFilename, IOContext.DEFAULT);){
            ShardBackupMetadata shardBackupMetadata = ShardBackupMetadata.from(new PropertiesInputStream(is));
            return shardBackupMetadata;
        }
    }

    public void store(BackupRepository repository, URI folderURI, ShardBackupId shardBackupId) throws IOException {
        String filename = shardBackupId.getBackupMetadataFilename();
        URI fileURI = repository.resolve(folderURI, filename);
        if (repository.exists(fileURI)) {
            repository.delete(folderURI, Collections.singleton(filename), true);
        }
        try (OutputStream os = repository.createOutput(repository.resolve(folderURI, filename));){
            this.store(os);
        }
    }

    public Collection<String> listOriginalFileNames() {
        return Collections.unmodifiableSet(this.allFiles.keySet());
    }

    private void store(OutputStream os) throws IOException {
        HashMap map = new HashMap();
        for (BackedFile backedFile : this.allFiles.values()) {
            HashMap<String, Object> fileMap = new HashMap<String, Object>();
            fileMap.put("fileName", backedFile.originalFileName);
            fileMap.put("checksum", backedFile.fileChecksum.checksum);
            fileMap.put("size", backedFile.fileChecksum.size);
            map.put(backedFile.uniqueFileName, fileMap);
        }
        Utils.writeJson(map, (OutputStream)os, (boolean)false);
    }

    private static ShardBackupMetadata from(InputStream is) {
        Map map = (Map)Utils.fromJSON((InputStream)is);
        ShardBackupMetadata shardBackupMetadata = new ShardBackupMetadata();
        for (String uniqueFileName : map.keySet()) {
            Map fileMap = (Map)map.get(uniqueFileName);
            String fileName = (String)fileMap.get("fileName");
            long checksum = (Long)fileMap.get("checksum");
            long size = (Long)fileMap.get("size");
            shardBackupMetadata.addBackedFile(new BackedFile(uniqueFileName, fileName, new Checksum(checksum, size)));
        }
        return shardBackupMetadata;
    }

    public static class BackedFile {
        public final String uniqueFileName;
        public final String originalFileName;
        public final Checksum fileChecksum;

        BackedFile(String uniqueFileName, String originalFileName, Checksum fileChecksum) {
            this.uniqueFileName = uniqueFileName;
            this.originalFileName = originalFileName;
            this.fileChecksum = fileChecksum;
        }
    }
}

