# -*- coding: utf-8 -*-

"""Data literal storing emoji French names and Unicode codes."""

__all__ = ['EMOJI_UNICODE_FRENCH', 'UNICODE_EMOJI_FRENCH',]


EMOJI_UNICODE_FRENCH = {
    u':visage_rieur:': u'\U0001F600',
    u':visage_souriant_avec_de_grands_yeux:': u'\U0001F603',
    u':visage_très_souriant_aux_yeux_rieurs:': u'\U0001F604',
    u':visage_souriant_aux_yeux_rieurs:': u'\U0001F601',
    u':visage_souriant_avec_yeux_plissés:': u'\U0001F606',
    u':visage_souriant_avec_une_goutte_de_sueur:': u'\U0001F605',
    u':se_rouler_par_terre_de_rire:': u'\U0001F923',
    u':visage_riant_aux_larmes:': u'\U0001F602',
    u':visage_avec_un_léger_sourire:': u'\U0001F642',
    u':tête_à_l’envers:': u'\U0001F643',
    u':visage_faisant_un_clin_d’œil:': u'\U0001F609',
    u':visage_souriant_avec_yeux_rieurs:': u'\U0001F60A',
    u':visage_souriant_avec_auréole:': u'\U0001F607',
    u':visage_souriant_avec_cœurs:': u'\U0001F970',
    u':visage_souriant_avec_yeux_en_forme_de_cœur:': u'\U0001F60D',
    u':visage_avec_des_étoiles_à_la_place_des_yeux:': u'\U0001F929',
    u':visage_envoyant_un_bisou:': u'\U0001F618',
    u':visage_faisant_un_bisou:': u'\U0001F617',
    u':visage_souriant:': u'\U0000263A\U0000FE0F',
    u':visage_faisant_un_bisou_avec_les_yeux_fermés:': u'\U0001F61A',
    u':visage_aux_yeux_rieurs_faisant_un_bisou:': u'\U0001F619',
    u':visage_souriant_avec_une_larme:': u'\U0001F972',
    u':miam:': u'\U0001F60B',
    u':visage_qui_tire_la_langue:': u'\U0001F61B',
    u':visage_qui_tire_la_langue_et_fait_un_clin_d’œil:': u'\U0001F61C',
    u':tête_de_fou:': u'\U0001F92A',
    u':visage_qui_tire_la_langue_les_yeux_plissés:': u'\U0001F61D',
    u':argent_dans_les_yeux_et_la_bouche:': u'\U0001F911',
    u':visage_qui_fait_un_câlin:': u'\U0001F917',
    u':visage_avec_une_main_sur_la_bouche:': u'\U0001F92D',
    u':visage_avec_un_doigt_sur_la_bouche:': u'\U0001F92B',
    u':visage_en_pleine_réflexion:': u'\U0001F914',
    u':visage_avec_bouche_fermeture_éclair:': u'\U0001F910',
    u':visage_avec_les_sourcils_relevés:': u'\U0001F928',
    u':visage_neutre:': u'\U0001F610',
    u':visage_sans_expression:': u'\U0001F611',
    u':visage_sans_bouche:': u'\U0001F636',
    u':visage_avec_un_sourire_malin:': u'\U0001F60F',
    u':visage_blasé:': u'\U0001F612',
    u':visage_roulant_des_yeux:': u'\U0001F644',
    u':visage_grimaçant:': u'\U0001F62C',
    u':visage_de_menteur:': u'\U0001F925',
    u':visage_soulagé:': u'\U0001F60C',
    u':visage_pensif:': u'\U0001F614',
    u':visage_endormi:': u'\U0001F62A',
    u':visage_qui_bave:': u'\U0001F924',
    u':visage_somnolent:': u'\U0001F634',
    u':visage_avec_masque:': u'\U0001F637',
    u':visage_avec_thermomètre:': u'\U0001F912',
    u':visage_avec_bandage_autour_de_la_tête:': u'\U0001F915',
    u':visage_nauséeux:': u'\U0001F922',
    u':visage_qui_vomit:': u'\U0001F92E',
    u':visage_qui_éternue:': u'\U0001F927',
    u':visage_rouge_et_chaud:': u'\U0001F975',
    u':visage_bleu_et_froid:': u'\U0001F976',
    u':visage_éméché:': u'\U0001F974',
    u':visage_étourdi:': u'\U0001F635',
    u':tête_qui_explose:': u'\U0001F92F',
    u':visage_avec_chapeau_de_cowboy:': u'\U0001F920',
    u':visage_festif:': u'\U0001F973',
    u':visage_déguisé:': u'\U0001F978',
    u':visage_avec_lunettes_de_soleil:': u'\U0001F60E',
    u':visage_de_geek:': u'\U0001F913',
    u':visage_avec_un_monocle:': u'\U0001F9D0',
    u':visage_confus:': u'\U0001F615',
    u':visage_inquiet:': u'\U0001F61F',
    u':visage_légèrement_mécontent:': u'\U0001F641',
    u':visage_mécontent:': u'\U00002639\U0000FE0F',
    u':visage_avec_bouche_ouverte:': u'\U0001F62E',
    u':visage_ébahi:': u'\U0001F62F',
    u':visage_stupéfait:': u'\U0001F632',
    u':visage_qui_rougit:': u'\U0001F633',
    u':visage_implorant:': u'\U0001F97A',
    u':visage_mécontent_avec_bouche_ouverte:': u'\U0001F626',
    u':visage_angoissé:': u'\U0001F627',
    u':visage_effrayé:': u'\U0001F628',
    u':visage_anxieux_avec_goutte_de_sueur:': u'\U0001F630',
    u':visage_triste_mais_soulagé:': u'\U0001F625',
    u':visage_qui_pleure:': u'\U0001F622',
    u':visage_qui_pleure_à_chaudes_larmes:': u'\U0001F62D',
    u':visage_qui_hurle_de_peur:': u'\U0001F631',
    u':visage_déconcerté:': u'\U0001F616',
    u':visage_persévérant:': u'\U0001F623',
    u':visage_déçu:': u'\U0001F61E',
    u':visage_démoralisé_avec_goutte_de_sueur:': u'\U0001F613',
    u':visage_épuisé:': u'\U0001F629',
    u':visage_fatigué:': u'\U0001F62B',
    u':visage_bâillant:': u'\U0001F971',
    u':visage_avec_fumée_sortant_des_narines:': u'\U0001F624',
    u':visage_boudeur:': u'\U0001F621',
    u':visage_en_colère:': u'\U0001F620',
    u':visage_avec_des_symboles_dans_la_bouche:': u'\U0001F92C',
    u':visage_souriant_avec_des_cornes:': u'\U0001F608',
    u':visage_en_colère_avec_des_cornes:': u'\U0001F47F',
    u':crâne:': u'\U0001F480',
    u':tête_de_mort:': u'\U00002620\U0000FE0F',
    u':tas_de_crotte:': u'\U0001F4A9',
    u':visage_de_clown:': u'\U0001F921',
    u':ogre:': u'\U0001F479',
    u':monstre_japonais:': u'\U0001F47A',
    u':fantôme:': u'\U0001F47B',
    u':alien:': u'\U0001F47D',
    u':monstre_de_l’espace:': u'\U0001F47E',
    u':robot:': u'\U0001F916',
    u':chat_qui_sourit:': u'\U0001F63A',
    u':chat_qui_sourit_avec_des_yeux_rieurs:': u'\U0001F638',
    u':chat_qui_pleure_de_joie:': u'\U0001F639',
    u':chat_souriant_aux_yeux_en_cœurs:': u'\U0001F63B',
    u':chat_avec_sourire_en_coin:': u'\U0001F63C',
    u':chat_qui_fait_un_bisou:': u'\U0001F63D',
    u':chat_fatigué:': u'\U0001F640',
    u':chat_qui_pleure:': u'\U0001F63F',
    u':chat_qui_boude:': u'\U0001F63E',
    u':singe_ne_rien_voir:': u'\U0001F648',
    u':singe_ne_rien_entendre:': u'\U0001F649',
    u':singe_ne_rien_dire:': u'\U0001F64A',
    u':trace_de_rouge_à_lèvres:': u'\U0001F48B',
    u':lettre_d’amour:': u'\U0001F48C',
    u':cœur_et_flèche:': u'\U0001F498',
    u':cœur_avec_ruban:': u'\U0001F49D',
    u':cœur_étincelant:': u'\U0001F496',
    u':cœur_grandissant:': u'\U0001F497',
    u':cœur_battant:': u'\U0001F493',
    u':cœurs_qui_tournent:': u'\U0001F49E',
    u':deux_cœurs:': u'\U0001F495',
    u':décoration_avec_cœur:': u'\U0001F49F',
    u':cœur_point_d’exclamation:': u'\U00002763\U0000FE0F',
    u':cœur_brisé:': u'\U0001F494',
    u':cœur_rouge:': u'\U00002764\U0000FE0F',
    u':cœur_orange:': u'\U0001F9E1',
    u':cœur_jaune:': u'\U0001F49B',
    u':cœur_vert:': u'\U0001F49A',
    u':cœur_bleu:': u'\U0001F499',
    u':cœur_violet:': u'\U0001F49C',
    u':cœur_marron:': u'\U0001F90E',
    u':cœur_noir:': u'\U0001F5A4',
    u':cœur_blanc:': u'\U0001F90D',
    u':cent_points:': u'\U0001F4AF',
    u':symbole_de_colère:': u'\U0001F4A2',
    u':explosion:': u'\U0001F4A5',
    u':étourdissement:': u'\U0001F4AB',
    u':gouttes_de_sueur:': u'\U0001F4A6',
    u':décamper:': u'\U0001F4A8',
    u':trou:': u'\U0001F573\U0000FE0F',
    u':bombe:': u'\U0001F4A3',
    u':bulle_de_parole:': u'\U0001F4AC',
    u':œil_dans_une_bulle_de_bd:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F',
    u':bulle_de_parole_gauche:': u'\U0001F5E8\U0000FE0F',
    u':bulle_colère_droite:': u'\U0001F5EF\U0000FE0F',
    u':bulle_de_pensée:': u'\U0001F4AD',
    u':endormi:': u'\U0001F4A4',
    u':signe_de_la_main:': u'\U0001F44B',
    u':signe_de_la_main_peau_claire:': u'\U0001F44B\U0001F3FB',
    u':signe_de_la_main_peau_moyennement_claire:': u'\U0001F44B\U0001F3FC',
    u':signe_de_la_main_peau_légèrement_mate:': u'\U0001F44B\U0001F3FD',
    u':signe_de_la_main_peau_mate:': u'\U0001F44B\U0001F3FE',
    u':signe_de_la_main_peau_foncée:': u'\U0001F44B\U0001F3FF',
    u':dos_de_main_levée:': u'\U0001F91A',
    u':dos_de_main_levée_peau_claire:': u'\U0001F91A\U0001F3FB',
    u':dos_de_main_levée_peau_moyennement_claire:': u'\U0001F91A\U0001F3FC',
    u':dos_de_main_levée_peau_légèrement_mate:': u'\U0001F91A\U0001F3FD',
    u':dos_de_main_levée_peau_mate:': u'\U0001F91A\U0001F3FE',
    u':dos_de_main_levée_peau_foncée:': u'\U0001F91A\U0001F3FF',
    u':main_levée_doigts_écartés:': u'\U0001F590\U0000FE0F',
    u':main_levée_doigts_écartés_peau_claire:': u'\U0001F590\U0001F3FB',
    u':main_levée_doigts_écartés_peau_moyennement_claire:': u'\U0001F590\U0001F3FC',
    u':main_levée_doigts_écartés_peau_légèrement_mate:': u'\U0001F590\U0001F3FD',
    u':main_levée_doigts_écartés_peau_mate:': u'\U0001F590\U0001F3FE',
    u':main_levée_doigts_écartés_peau_foncée:': u'\U0001F590\U0001F3FF',
    u':main_levée:': u'\U0000270B',
    u':main_levée_peau_claire:': u'\U0000270B\U0001F3FB',
    u':main_levée_peau_moyennement_claire:': u'\U0000270B\U0001F3FC',
    u':main_levée_peau_légèrement_mate:': u'\U0000270B\U0001F3FD',
    u':main_levée_peau_mate:': u'\U0000270B\U0001F3FE',
    u':main_levée_peau_foncée:': u'\U0000270B\U0001F3FF',
    u':salut_vulcain:': u'\U0001F596',
    u':salut_vulcain_peau_claire:': u'\U0001F596\U0001F3FB',
    u':salut_vulcain_peau_moyennement_claire:': u'\U0001F596\U0001F3FC',
    u':salut_vulcain_peau_légèrement_mate:': u'\U0001F596\U0001F3FD',
    u':salut_vulcain_peau_mate:': u'\U0001F596\U0001F3FE',
    u':salut_vulcain_peau_foncée:': u'\U0001F596\U0001F3FF',
    u':ok:': u'\U0001F44C',
    u':ok_peau_claire:': u'\U0001F44C\U0001F3FB',
    u':ok_peau_moyennement_claire:': u'\U0001F44C\U0001F3FC',
    u':ok_peau_légèrement_mate:': u'\U0001F44C\U0001F3FD',
    u':ok_peau_mate:': u'\U0001F44C\U0001F3FE',
    u':ok_peau_foncée:': u'\U0001F44C\U0001F3FF',
    u':bout_des_doigts_joints:': u'\U0001F90C',
    u':bout_des_doigts_joints_peau_claire:': u'\U0001F90C\U0001F3FB',
    u':bout_des_doigts_joints_peau_moyennement_claire:': u'\U0001F90C\U0001F3FC',
    u':bout_des_doigts_joints_peau_légèrement_mate:': u'\U0001F90C\U0001F3FD',
    u':bout_des_doigts_joints_peau_mate:': u'\U0001F90C\U0001F3FE',
    u':bout_des_doigts_joints_peau_foncée:': u'\U0001F90C\U0001F3FF',
    u':pouce_et_index_rapprochés:': u'\U0001F90F',
    u':pouce_et_index_rapprochés_peau_claire:': u'\U0001F90F\U0001F3FB',
    u':pouce_et_index_rapprochés_peau_moyennement_claire:': u'\U0001F90F\U0001F3FC',
    u':pouce_et_index_rapprochés_peau_légèrement_mate:': u'\U0001F90F\U0001F3FD',
    u':pouce_et_index_rapprochés_peau_mate:': u'\U0001F90F\U0001F3FE',
    u':pouce_et_index_rapprochés_peau_foncée:': u'\U0001F90F\U0001F3FF',
    u':v_de_la_victoire:': u'\U0000270C\U0000FE0F',
    u':v_de_la_victoire_peau_claire:': u'\U0000270C\U0001F3FB',
    u':v_de_la_victoire_peau_moyennement_claire:': u'\U0000270C\U0001F3FC',
    u':v_de_la_victoire_peau_légèrement_mate:': u'\U0000270C\U0001F3FD',
    u':v_de_la_victoire_peau_mate:': u'\U0000270C\U0001F3FE',
    u':v_de_la_victoire_peau_foncée:': u'\U0000270C\U0001F3FF',
    u':doigts_croisés:': u'\U0001F91E',
    u':doigts_croisés_peau_claire:': u'\U0001F91E\U0001F3FB',
    u':doigts_croisés_peau_moyennement_claire:': u'\U0001F91E\U0001F3FC',
    u':doigts_croisés_peau_légèrement_mate:': u'\U0001F91E\U0001F3FD',
    u':doigts_croisés_peau_mate:': u'\U0001F91E\U0001F3FE',
    u':doigts_croisés_peau_foncée:': u'\U0001F91E\U0001F3FF',
    u':signe_je_t’aime:': u'\U0001F91F',
    u':signe_je_t’aime_peau_claire:': u'\U0001F91F\U0001F3FB',
    u':signe_je_t’aime_peau_moyennement_claire:': u'\U0001F91F\U0001F3FC',
    u':signe_je_t’aime_peau_légèrement_mate:': u'\U0001F91F\U0001F3FD',
    u':signe_je_t’aime_peau_mate:': u'\U0001F91F\U0001F3FE',
    u':signe_je_t’aime_peau_foncée:': u'\U0001F91F\U0001F3FF',
    u':cornes_avec_les_doigts:': u'\U0001F918',
    u':cornes_avec_les_doigts_peau_claire:': u'\U0001F918\U0001F3FB',
    u':cornes_avec_les_doigts_peau_moyennement_claire:': u'\U0001F918\U0001F3FC',
    u':cornes_avec_les_doigts_peau_légèrement_mate:': u'\U0001F918\U0001F3FD',
    u':cornes_avec_les_doigts_peau_mate:': u'\U0001F918\U0001F3FE',
    u':cornes_avec_les_doigts_peau_foncée:': u'\U0001F918\U0001F3FF',
    u':signe_appel_téléphonique_avec_les_doigts:': u'\U0001F919',
    u':signe_appel_téléphonique_avec_les_doigts_peau_claire:': u'\U0001F919\U0001F3FB',
    u':signe_appel_téléphonique_avec_les_doigts_peau_moyennement_claire:': u'\U0001F919\U0001F3FC',
    u':signe_appel_téléphonique_avec_les_doigts_peau_légèrement_mate:': u'\U0001F919\U0001F3FD',
    u':signe_appel_téléphonique_avec_les_doigts_peau_mate:': u'\U0001F919\U0001F3FE',
    u':signe_appel_téléphonique_avec_les_doigts_peau_foncée:': u'\U0001F919\U0001F3FF',
    u':main_avec_index_pointant_à_gauche:': u'\U0001F448',
    u':main_avec_index_pointant_à_gauche_peau_claire:': u'\U0001F448\U0001F3FB',
    u':main_avec_index_pointant_à_gauche_peau_moyennement_claire:': u'\U0001F448\U0001F3FC',
    u':main_avec_index_pointant_à_gauche_peau_légèrement_mate:': u'\U0001F448\U0001F3FD',
    u':main_avec_index_pointant_à_gauche_peau_mate:': u'\U0001F448\U0001F3FE',
    u':main_avec_index_pointant_à_gauche_peau_foncée:': u'\U0001F448\U0001F3FF',
    u':main_avec_index_pointant_à_droite:': u'\U0001F449',
    u':main_avec_index_pointant_à_droite_peau_claire:': u'\U0001F449\U0001F3FB',
    u':main_avec_index_pointant_à_droite_peau_moyennement_claire:': u'\U0001F449\U0001F3FC',
    u':main_avec_index_pointant_à_droite_peau_légèrement_mate:': u'\U0001F449\U0001F3FD',
    u':main_avec_index_pointant_à_droite_peau_mate:': u'\U0001F449\U0001F3FE',
    u':main_avec_index_pointant_à_droite_peau_foncée:': u'\U0001F449\U0001F3FF',
    u':main_avec_index_pointant_vers_le_haut:': u'\U0001F446',
    u':main_avec_index_pointant_vers_le_haut_peau_claire:': u'\U0001F446\U0001F3FB',
    u':main_avec_index_pointant_vers_le_haut_peau_moyennement_claire:': u'\U0001F446\U0001F3FC',
    u':main_avec_index_pointant_vers_le_haut_peau_légèrement_mate:': u'\U0001F446\U0001F3FD',
    u':main_avec_index_pointant_vers_le_haut_peau_mate:': u'\U0001F446\U0001F3FE',
    u':main_avec_index_pointant_vers_le_haut_peau_foncée:': u'\U0001F446\U0001F3FF',
    u':doigt_d’honneur:': u'\U0001F595',
    u':doigt_d’honneur_peau_claire:': u'\U0001F595\U0001F3FB',
    u':doigt_d’honneur_peau_moyennement_claire:': u'\U0001F595\U0001F3FC',
    u':doigt_d’honneur_peau_légèrement_mate:': u'\U0001F595\U0001F3FD',
    u':doigt_d’honneur_peau_mate:': u'\U0001F595\U0001F3FE',
    u':doigt_d’honneur_peau_foncée:': u'\U0001F595\U0001F3FF',
    u':main_avec_index_pointant_vers_le_bas:': u'\U0001F447',
    u':main_avec_index_pointant_vers_le_bas_peau_claire:': u'\U0001F447\U0001F3FB',
    u':main_avec_index_pointant_vers_le_bas_peau_moyennement_claire:': u'\U0001F447\U0001F3FC',
    u':main_avec_index_pointant_vers_le_bas_peau_légèrement_mate:': u'\U0001F447\U0001F3FD',
    u':main_avec_index_pointant_vers_le_bas_peau_mate:': u'\U0001F447\U0001F3FE',
    u':main_avec_index_pointant_vers_le_bas_peau_foncée:': u'\U0001F447\U0001F3FF',
    u':index_pointant_vers_le_haut:': u'\U0000261D\U0000FE0F',
    u':index_pointant_vers_le_haut_peau_claire:': u'\U0000261D\U0001F3FB',
    u':index_pointant_vers_le_haut_peau_moyennement_claire:': u'\U0000261D\U0001F3FC',
    u':index_pointant_vers_le_haut_peau_légèrement_mate:': u'\U0000261D\U0001F3FD',
    u':index_pointant_vers_le_haut_peau_mate:': u'\U0000261D\U0001F3FE',
    u':index_pointant_vers_le_haut_peau_foncée:': u'\U0000261D\U0001F3FF',
    u':pouce_vers_le_haut:': u'\U0001F44D',
    u':pouce_vers_le_haut_peau_claire:': u'\U0001F44D\U0001F3FB',
    u':pouce_vers_le_haut_peau_moyennement_claire:': u'\U0001F44D\U0001F3FC',
    u':pouce_vers_le_haut_peau_légèrement_mate:': u'\U0001F44D\U0001F3FD',
    u':pouce_vers_le_haut_peau_mate:': u'\U0001F44D\U0001F3FE',
    u':pouce_vers_le_haut_peau_foncée:': u'\U0001F44D\U0001F3FF',
    u':pouce_vers_le_bas:': u'\U0001F44E',
    u':pouce_vers_le_bas_peau_claire:': u'\U0001F44E\U0001F3FB',
    u':pouce_vers_le_bas_peau_moyennement_claire:': u'\U0001F44E\U0001F3FC',
    u':pouce_vers_le_bas_peau_légèrement_mate:': u'\U0001F44E\U0001F3FD',
    u':pouce_vers_le_bas_peau_mate:': u'\U0001F44E\U0001F3FE',
    u':pouce_vers_le_bas_peau_foncée:': u'\U0001F44E\U0001F3FF',
    u':poing_levé:': u'\U0000270A',
    u':poing_levé_peau_claire:': u'\U0000270A\U0001F3FB',
    u':poing_levé_peau_moyennement_claire:': u'\U0000270A\U0001F3FC',
    u':poing_levé_peau_légèrement_mate:': u'\U0000270A\U0001F3FD',
    u':poing_levé_peau_mate:': u'\U0000270A\U0001F3FE',
    u':poing_levé_peau_foncée:': u'\U0000270A\U0001F3FF',
    u':poing_de_face:': u'\U0001F44A',
    u':poing_de_face_peau_claire:': u'\U0001F44A\U0001F3FB',
    u':poing_de_face_peau_moyennement_claire:': u'\U0001F44A\U0001F3FC',
    u':poing_de_face_peau_légèrement_mate:': u'\U0001F44A\U0001F3FD',
    u':poing_de_face_peau_mate:': u'\U0001F44A\U0001F3FE',
    u':poing_de_face_peau_foncée:': u'\U0001F44A\U0001F3FF',
    u':poing_à_gauche:': u'\U0001F91B',
    u':poing_à_gauche_peau_claire:': u'\U0001F91B\U0001F3FB',
    u':poing_à_gauche_peau_moyennement_claire:': u'\U0001F91B\U0001F3FC',
    u':poing_à_gauche_peau_légèrement_mate:': u'\U0001F91B\U0001F3FD',
    u':poing_à_gauche_peau_mate:': u'\U0001F91B\U0001F3FE',
    u':poing_à_gauche_peau_foncée:': u'\U0001F91B\U0001F3FF',
    u':poing_à_droite:': u'\U0001F91C',
    u':poing_à_droite_peau_claire:': u'\U0001F91C\U0001F3FB',
    u':poing_à_droite_peau_moyennement_claire:': u'\U0001F91C\U0001F3FC',
    u':poing_à_droite_peau_légèrement_mate:': u'\U0001F91C\U0001F3FD',
    u':poing_à_droite_peau_mate:': u'\U0001F91C\U0001F3FE',
    u':poing_à_droite_peau_foncée:': u'\U0001F91C\U0001F3FF',
    u':applaudissements:': u'\U0001F44F',
    u':applaudissements_peau_claire:': u'\U0001F44F\U0001F3FB',
    u':applaudissements_peau_moyennement_claire:': u'\U0001F44F\U0001F3FC',
    u':applaudissements_peau_légèrement_mate:': u'\U0001F44F\U0001F3FD',
    u':applaudissements_peau_mate:': u'\U0001F44F\U0001F3FE',
    u':applaudissements_peau_foncée:': u'\U0001F44F\U0001F3FF',
    u':mains_levées:': u'\U0001F64C',
    u':mains_levées_peau_claire:': u'\U0001F64C\U0001F3FB',
    u':mains_levées_peau_moyennement_claire:': u'\U0001F64C\U0001F3FC',
    u':mains_levées_peau_légèrement_mate:': u'\U0001F64C\U0001F3FD',
    u':mains_levées_peau_mate:': u'\U0001F64C\U0001F3FE',
    u':mains_levées_peau_foncée:': u'\U0001F64C\U0001F3FF',
    u':mains_ouvertes:': u'\U0001F450',
    u':mains_ouvertes_peau_claire:': u'\U0001F450\U0001F3FB',
    u':mains_ouvertes_peau_moyennement_claire:': u'\U0001F450\U0001F3FC',
    u':mains_ouvertes_peau_légèrement_mate:': u'\U0001F450\U0001F3FD',
    u':mains_ouvertes_peau_mate:': u'\U0001F450\U0001F3FE',
    u':mains_ouvertes_peau_foncée:': u'\U0001F450\U0001F3FF',
    u':paume_contre_paume_doigts_vers_le_haut:': u'\U0001F932',
    u':paume_contre_paume_doigts_vers_le_haut_peau_claire:': u'\U0001F932\U0001F3FB',
    u':paume_contre_paume_doigts_vers_le_haut_peau_moyennement_claire:': u'\U0001F932\U0001F3FC',
    u':paume_contre_paume_doigts_vers_le_haut_peau_légèrement_mate:': u'\U0001F932\U0001F3FD',
    u':paume_contre_paume_doigts_vers_le_haut_peau_mate:': u'\U0001F932\U0001F3FE',
    u':paume_contre_paume_doigts_vers_le_haut_peau_foncée:': u'\U0001F932\U0001F3FF',
    u':poignée_de_main:': u'\U0001F91D',
    u':mains_en_prière:': u'\U0001F64F',
    u':mains_en_prière_peau_claire:': u'\U0001F64F\U0001F3FB',
    u':mains_en_prière_peau_moyennement_claire:': u'\U0001F64F\U0001F3FC',
    u':mains_en_prière_peau_légèrement_mate:': u'\U0001F64F\U0001F3FD',
    u':mains_en_prière_peau_mate:': u'\U0001F64F\U0001F3FE',
    u':mains_en_prière_peau_foncée:': u'\U0001F64F\U0001F3FF',
    u':main_qui_écrit:': u'\U0000270D\U0000FE0F',
    u':main_qui_écrit_peau_claire:': u'\U0000270D\U0001F3FB',
    u':main_qui_écrit_peau_moyennement_claire:': u'\U0000270D\U0001F3FC',
    u':main_qui_écrit_peau_légèrement_mate:': u'\U0000270D\U0001F3FD',
    u':main_qui_écrit_peau_mate:': u'\U0000270D\U0001F3FE',
    u':main_qui_écrit_peau_foncée:': u'\U0000270D\U0001F3FF',
    u':vernis_à_ongles:': u'\U0001F485',
    u':vernis_à_ongles_peau_claire:': u'\U0001F485\U0001F3FB',
    u':vernis_à_ongles_peau_moyennement_claire:': u'\U0001F485\U0001F3FC',
    u':vernis_à_ongles_peau_légèrement_mate:': u'\U0001F485\U0001F3FD',
    u':vernis_à_ongles_peau_mate:': u'\U0001F485\U0001F3FE',
    u':vernis_à_ongles_peau_foncée:': u'\U0001F485\U0001F3FF',
    u':selfie:': u'\U0001F933',
    u':selfie_peau_claire:': u'\U0001F933\U0001F3FB',
    u':selfie_peau_moyennement_claire:': u'\U0001F933\U0001F3FC',
    u':selfie_peau_légèrement_mate:': u'\U0001F933\U0001F3FD',
    u':selfie_peau_mate:': u'\U0001F933\U0001F3FE',
    u':selfie_peau_foncée:': u'\U0001F933\U0001F3FF',
    u':biceps_contracté:': u'\U0001F4AA',
    u':biceps_contracté_peau_claire:': u'\U0001F4AA\U0001F3FB',
    u':biceps_contracté_peau_moyennement_claire:': u'\U0001F4AA\U0001F3FC',
    u':biceps_contracté_peau_légèrement_mate:': u'\U0001F4AA\U0001F3FD',
    u':biceps_contracté_peau_mate:': u'\U0001F4AA\U0001F3FE',
    u':biceps_contracté_peau_foncée:': u'\U0001F4AA\U0001F3FF',
    u':bras_mécanique:': u'\U0001F9BE',
    u':jambe_mécanique:': u'\U0001F9BF',
    u':jambe:': u'\U0001F9B5',
    u':jambe_peau_claire:': u'\U0001F9B5\U0001F3FB',
    u':jambe_peau_moyennement_claire:': u'\U0001F9B5\U0001F3FC',
    u':jambe_peau_légèrement_mate:': u'\U0001F9B5\U0001F3FD',
    u':jambe_peau_mate:': u'\U0001F9B5\U0001F3FE',
    u':jambe_peau_foncée:': u'\U0001F9B5\U0001F3FF',
    u':pied:': u'\U0001F9B6',
    u':pied_peau_claire:': u'\U0001F9B6\U0001F3FB',
    u':pied_peau_moyennement_claire:': u'\U0001F9B6\U0001F3FC',
    u':pied_peau_légèrement_mate:': u'\U0001F9B6\U0001F3FD',
    u':pied_peau_mate:': u'\U0001F9B6\U0001F3FE',
    u':pied_peau_foncée:': u'\U0001F9B6\U0001F3FF',
    u':oreille:': u'\U0001F442',
    u':oreille_peau_claire:': u'\U0001F442\U0001F3FB',
    u':oreille_peau_moyennement_claire:': u'\U0001F442\U0001F3FC',
    u':oreille_peau_légèrement_mate:': u'\U0001F442\U0001F3FD',
    u':oreille_peau_mate:': u'\U0001F442\U0001F3FE',
    u':oreille_peau_foncée:': u'\U0001F442\U0001F3FF',
    u':oreille_appareillée:': u'\U0001F9BB',
    u':oreille_appareillée_peau_claire:': u'\U0001F9BB\U0001F3FB',
    u':oreille_appareillée_peau_moyennement_claire:': u'\U0001F9BB\U0001F3FC',
    u':oreille_appareillée_peau_légèrement_mate:': u'\U0001F9BB\U0001F3FD',
    u':oreille_appareillée_peau_mate:': u'\U0001F9BB\U0001F3FE',
    u':oreille_appareillée_peau_foncée:': u'\U0001F9BB\U0001F3FF',
    u':nez:': u'\U0001F443',
    u':nez_peau_claire:': u'\U0001F443\U0001F3FB',
    u':nez_peau_moyennement_claire:': u'\U0001F443\U0001F3FC',
    u':nez_peau_légèrement_mate:': u'\U0001F443\U0001F3FD',
    u':nez_peau_mate:': u'\U0001F443\U0001F3FE',
    u':nez_peau_foncée:': u'\U0001F443\U0001F3FF',
    u':cerveau:': u'\U0001F9E0',
    u':cœur:': u'\U0001FAC0',
    u':poumons:': u'\U0001FAC1',
    u':dent:': u'\U0001F9B7',
    u':os:': u'\U0001F9B4',
    u':yeux:': u'\U0001F440',
    u':œil:': u'\U0001F441\U0000FE0F',
    u':langue:': u'\U0001F445',
    u':bouche:': u'\U0001F444',
    u':bébé:': u'\U0001F476',
    u':bébé_peau_claire:': u'\U0001F476\U0001F3FB',
    u':bébé_peau_moyennement_claire:': u'\U0001F476\U0001F3FC',
    u':bébé_peau_légèrement_mate:': u'\U0001F476\U0001F3FD',
    u':bébé_peau_mate:': u'\U0001F476\U0001F3FE',
    u':bébé_peau_foncée:': u'\U0001F476\U0001F3FF',
    u':enfant:': u'\U0001F9D2',
    u':enfant_peau_claire:': u'\U0001F9D2\U0001F3FB',
    u':enfant_peau_moyennement_claire:': u'\U0001F9D2\U0001F3FC',
    u':enfant_peau_légèrement_mate:': u'\U0001F9D2\U0001F3FD',
    u':enfant_peau_mate:': u'\U0001F9D2\U0001F3FE',
    u':enfant_peau_foncée:': u'\U0001F9D2\U0001F3FF',
    u':garçon:': u'\U0001F466',
    u':garçon_peau_claire:': u'\U0001F466\U0001F3FB',
    u':garçon_peau_moyennement_claire:': u'\U0001F466\U0001F3FC',
    u':garçon_peau_légèrement_mate:': u'\U0001F466\U0001F3FD',
    u':garçon_peau_mate:': u'\U0001F466\U0001F3FE',
    u':garçon_peau_foncée:': u'\U0001F466\U0001F3FF',
    u':fille:': u'\U0001F467',
    u':fille_peau_claire:': u'\U0001F467\U0001F3FB',
    u':fille_peau_moyennement_claire:': u'\U0001F467\U0001F3FC',
    u':fille_peau_légèrement_mate:': u'\U0001F467\U0001F3FD',
    u':fille_peau_mate:': u'\U0001F467\U0001F3FE',
    u':fille_peau_foncée:': u'\U0001F467\U0001F3FF',
    u':adulte:': u'\U0001F9D1',
    u':adulte_peau_claire:': u'\U0001F9D1\U0001F3FB',
    u':adulte_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC',
    u':adulte_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD',
    u':adulte_peau_mate:': u'\U0001F9D1\U0001F3FE',
    u':adulte_peau_foncée:': u'\U0001F9D1\U0001F3FF',
    u':personne_blonde:': u'\U0001F471',
    u':personne_blonde_peau_claire:': u'\U0001F471\U0001F3FB',
    u':personne_blonde_peau_moyennement_claire:': u'\U0001F471\U0001F3FC',
    u':personne_blonde_peau_légèrement_mate:': u'\U0001F471\U0001F3FD',
    u':personne_blonde_peau_mate:': u'\U0001F471\U0001F3FE',
    u':personne_blonde_peau_foncée:': u'\U0001F471\U0001F3FF',
    u':homme:': u'\U0001F468',
    u':homme_peau_claire:': u'\U0001F468\U0001F3FB',
    u':homme_peau_moyennement_claire:': u'\U0001F468\U0001F3FC',
    u':homme_peau_légèrement_mate:': u'\U0001F468\U0001F3FD',
    u':homme_peau_mate:': u'\U0001F468\U0001F3FE',
    u':homme_peau_foncée:': u'\U0001F468\U0001F3FF',
    u':homme_barbu:': u'\U0001F9D4',
    u':homme_barbu_peau_claire:': u'\U0001F9D4\U0001F3FB',
    u':homme_barbu_peau_moyennement_claire:': u'\U0001F9D4\U0001F3FC',
    u':homme_barbu_peau_légèrement_mate:': u'\U0001F9D4\U0001F3FD',
    u':homme_barbu_peau_mate:': u'\U0001F9D4\U0001F3FE',
    u':homme_barbu_peau_foncée:': u'\U0001F9D4\U0001F3FF',
    u':homme_cheveux_roux:': u'\U0001F468\U0000200D\U0001F9B0',
    u':homme_peau_claire_et_cheveux_roux:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B0',
    u':homme_peau_moyennement_claire_et_cheveux_roux:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B0',
    u':homme_peau_légèrement_mate_et_cheveux_roux:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B0',
    u':homme_peau_mate_et_cheveux_roux:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B0',
    u':homme_peau_foncée_et_cheveux_roux:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B0',
    u':homme_cheveux_bouclés:': u'\U0001F468\U0000200D\U0001F9B1',
    u':homme_peau_claire_et_cheveux_bouclés:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B1',
    u':homme_peau_moyennement_claire_et_cheveux_bouclés:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B1',
    u':homme_peau_légèrement_mate_et_cheveux_bouclés:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B1',
    u':homme_peau_mate_et_cheveux_bouclés:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B1',
    u':homme_peau_foncée_et_cheveux_bouclés:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B1',
    u':homme_cheveux_blancs:': u'\U0001F468\U0000200D\U0001F9B3',
    u':homme_peau_claire_et_cheveux_blancs:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B3',
    u':homme_peau_moyennement_claire_et_cheveux_blancs:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B3',
    u':homme_peau_légèrement_mate_et_cheveux_blancs:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B3',
    u':homme_peau_mate_et_cheveux_blancs:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B3',
    u':homme_peau_foncée_et_cheveux_blancs:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B3',
    u':homme_chauve:': u'\U0001F468\U0000200D\U0001F9B2',
    u':homme_peau_claire_et_chauve:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B2',
    u':homme_peau_moyennement_claire_et_chauve:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B2',
    u':homme_peau_légèrement_mate_et_chauve:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B2',
    u':homme_peau_mate_et_chauve:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B2',
    u':homme_peau_foncée_et_chauve:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B2',
    u':femme:': u'\U0001F469',
    u':femme_peau_claire:': u'\U0001F469\U0001F3FB',
    u':femme_peau_moyennement_claire:': u'\U0001F469\U0001F3FC',
    u':femme_peau_légèrement_mate:': u'\U0001F469\U0001F3FD',
    u':femme_peau_mate:': u'\U0001F469\U0001F3FE',
    u':femme_peau_foncée:': u'\U0001F469\U0001F3FF',
    u':femme_cheveux_roux:': u'\U0001F469\U0000200D\U0001F9B0',
    u':femme_peau_claire_et_cheveux_roux:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B0',
    u':femme_peau_moyennement_claire_et_cheveux_roux:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B0',
    u':femme_peau_légèrement_mate_et_cheveux_roux:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B0',
    u':femme_peau_mate_et_cheveux_roux:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B0',
    u':femme_peau_foncée_et_cheveux_roux:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B0',
    u':adulte_cheveux_roux:': u'\U0001F9D1\U0000200D\U0001F9B0',
    u':adulte_peau_claire_et_cheveux_roux:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B0',
    u':adulte_peau_moyennement_claire_et_cheveux_roux:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B0',
    u':adulte_peau_légèrement_mate_et_cheveux_roux:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B0',
    u':adulte_peau_mate_et_cheveux_roux:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B0',
    u':adulte_peau_foncée_et_cheveux_roux:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B0',
    u':femme_cheveux_bouclés:': u'\U0001F469\U0000200D\U0001F9B1',
    u':femme_peau_claire_et_cheveux_bouclés:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B1',
    u':femme_peau_moyennement_claire_et_cheveux_bouclés:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B1',
    u':femme_peau_légèrement_mate_et_cheveux_bouclés:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B1',
    u':femme_peau_mate_et_cheveux_bouclés:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B1',
    u':femme_peau_foncée_et_cheveux_bouclés:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B1',
    u':adulte_cheveux_bouclés:': u'\U0001F9D1\U0000200D\U0001F9B1',
    u':adulte_peau_claire_et_cheveux_bouclés:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B1',
    u':adulte_peau_moyennement_claire_et_cheveux_bouclés:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B1',
    u':adulte_peau_légèrement_mate_et_cheveux_bouclés:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B1',
    u':adulte_peau_mate_et_cheveux_bouclés:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B1',
    u':adulte_peau_foncée_et_cheveux_bouclés:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B1',
    u':femme_cheveux_blancs:': u'\U0001F469\U0000200D\U0001F9B3',
    u':femme_peau_claire_et_cheveux_blancs:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B3',
    u':femme_peau_moyennement_claire_et_cheveux_blancs:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B3',
    u':femme_peau_légèrement_mate_et_cheveux_blancs:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B3',
    u':femme_peau_mate_et_cheveux_blancs:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B3',
    u':femme_peau_foncée_et_cheveux_blancs:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B3',
    u':adulte_cheveux_blancs:': u'\U0001F9D1\U0000200D\U0001F9B3',
    u':adulte_peau_claire_et_cheveux_blancs:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B3',
    u':adulte_peau_moyennement_claire_et_cheveux_blancs:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B3',
    u':adulte_peau_légèrement_mate_et_cheveux_blancs:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B3',
    u':adulte_peau_mate_et_cheveux_blancs:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B3',
    u':adulte_peau_foncée_et_cheveux_blancs:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B3',
    u':femme_chauve:': u'\U0001F469\U0000200D\U0001F9B2',
    u':femme_peau_claire_et_chauve:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B2',
    u':femme_peau_moyennement_claire_et_chauve:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B2',
    u':femme_peau_légèrement_mate_et_chauve:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B2',
    u':femme_peau_mate_et_chauve:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B2',
    u':femme_peau_foncée_et_chauve:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B2',
    u':adulte_chauve:': u'\U0001F9D1\U0000200D\U0001F9B2',
    u':adulte_peau_claire_et_chauve:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B2',
    u':adulte_peau_moyennement_claire_et_chauve:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B2',
    u':adulte_peau_légèrement_mate_et_chauve:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B2',
    u':adulte_peau_mate_et_chauve:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B2',
    u':adulte_peau_foncée_et_chauve:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B2',
    u':femme_blonde:': u'\U0001F471\U0000200D\U00002640\U0000FE0F',
    u':femme_blonde_peau_claire:': u'\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_blonde_peau_moyennement_claire:': u'\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_blonde_peau_légèrement_mate:': u'\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_blonde_peau_mate:': u'\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_blonde_peau_foncée:': u'\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':homme_blond:': u'\U0001F471\U0000200D\U00002642\U0000FE0F',
    u':homme_blond_peau_claire:': u'\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_blond_peau_moyennement_claire:': u'\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_blond_peau_légèrement_mate:': u'\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_blond_peau_mate:': u'\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_blond_peau_foncée:': u'\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':personne_âgée:': u'\U0001F9D3',
    u':personne_âgée_peau_claire:': u'\U0001F9D3\U0001F3FB',
    u':personne_âgée_peau_moyennement_claire:': u'\U0001F9D3\U0001F3FC',
    u':personne_âgée_peau_légèrement_mate:': u'\U0001F9D3\U0001F3FD',
    u':personne_âgée_peau_mate:': u'\U0001F9D3\U0001F3FE',
    u':personne_âgée_peau_foncée:': u'\U0001F9D3\U0001F3FF',
    u':homme_âgé:': u'\U0001F474',
    u':homme_âgé_peau_claire:': u'\U0001F474\U0001F3FB',
    u':homme_âgé_peau_moyennement_claire:': u'\U0001F474\U0001F3FC',
    u':homme_âgé_peau_légèrement_mate:': u'\U0001F474\U0001F3FD',
    u':homme_âgé_peau_mate:': u'\U0001F474\U0001F3FE',
    u':homme_âgé_peau_foncée:': u'\U0001F474\U0001F3FF',
    u':femme_âgée:': u'\U0001F475',
    u':femme_âgée_peau_claire:': u'\U0001F475\U0001F3FB',
    u':femme_âgée_peau_moyennement_claire:': u'\U0001F475\U0001F3FC',
    u':femme_âgée_peau_légèrement_mate:': u'\U0001F475\U0001F3FD',
    u':femme_âgée_peau_mate:': u'\U0001F475\U0001F3FE',
    u':femme_âgée_peau_foncée:': u'\U0001F475\U0001F3FF',
    u':personne_fronçant_les_sourcils:': u'\U0001F64D',
    u':personne_fronçant_les_sourcils_peau_claire:': u'\U0001F64D\U0001F3FB',
    u':personne_fronçant_les_sourcils_peau_moyennement_claire:': u'\U0001F64D\U0001F3FC',
    u':personne_fronçant_les_sourcils_peau_légèrement_mate:': u'\U0001F64D\U0001F3FD',
    u':personne_fronçant_les_sourcils_peau_mate:': u'\U0001F64D\U0001F3FE',
    u':personne_fronçant_les_sourcils_peau_foncée:': u'\U0001F64D\U0001F3FF',
    u':homme_fronçant_les_sourcils:': u'\U0001F64D\U0000200D\U00002642\U0000FE0F',
    u':homme_fronçant_les_sourcils_peau_claire:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_fronçant_les_sourcils_peau_moyennement_claire:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_fronçant_les_sourcils_peau_légèrement_mate:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_fronçant_les_sourcils_peau_mate:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_fronçant_les_sourcils_peau_foncée:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_fronçant_les_sourcils:': u'\U0001F64D\U0000200D\U00002640\U0000FE0F',
    u':femme_fronçant_les_sourcils_peau_claire:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_fronçant_les_sourcils_peau_moyennement_claire:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_fronçant_les_sourcils_peau_légèrement_mate:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_fronçant_les_sourcils_peau_mate:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_fronçant_les_sourcils_peau_foncée:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_boude:': u'\U0001F64E',
    u':personne_qui_boude_peau_claire:': u'\U0001F64E\U0001F3FB',
    u':personne_qui_boude_peau_moyennement_claire:': u'\U0001F64E\U0001F3FC',
    u':personne_qui_boude_peau_légèrement_mate:': u'\U0001F64E\U0001F3FD',
    u':personne_qui_boude_peau_mate:': u'\U0001F64E\U0001F3FE',
    u':personne_qui_boude_peau_foncée:': u'\U0001F64E\U0001F3FF',
    u':homme_qui_boude:': u'\U0001F64E\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_boude_peau_claire:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_boude_peau_moyennement_claire:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_boude_peau_légèrement_mate:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_boude_peau_mate:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_boude_peau_foncée:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_boude:': u'\U0001F64E\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_boude_peau_claire:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_boude_peau_moyennement_claire:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_boude_peau_légèrement_mate:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_boude_peau_mate:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_boude_peau_foncée:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_faisant_un_geste_d’interdiction:': u'\U0001F645',
    u':personne_faisant_un_geste_d’interdiction_peau_claire:': u'\U0001F645\U0001F3FB',
    u':personne_faisant_un_geste_d’interdiction_peau_moyennement_claire:': u'\U0001F645\U0001F3FC',
    u':personne_faisant_un_geste_d’interdiction_peau_légèrement_mate:': u'\U0001F645\U0001F3FD',
    u':personne_faisant_un_geste_d’interdiction_peau_mate:': u'\U0001F645\U0001F3FE',
    u':personne_faisant_un_geste_d’interdiction_peau_foncée:': u'\U0001F645\U0001F3FF',
    u':homme_faisant_un_geste_d’interdiction:': u'\U0001F645\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’interdiction_peau_claire:': u'\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’interdiction_peau_moyennement_claire:': u'\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’interdiction_peau_légèrement_mate:': u'\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’interdiction_peau_mate:': u'\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’interdiction_peau_foncée:': u'\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_faisant_un_geste_d’interdiction:': u'\U0001F645\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’interdiction_peau_claire:': u'\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’interdiction_peau_moyennement_claire:': u'\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’interdiction_peau_légèrement_mate:': u'\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’interdiction_peau_mate:': u'\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’interdiction_peau_foncée:': u'\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_faisant_un_geste_d’acceptation:': u'\U0001F646',
    u':personne_faisant_un_geste_d’acceptation_peau_claire:': u'\U0001F646\U0001F3FB',
    u':personne_faisant_un_geste_d’acceptation_peau_moyennement_claire:': u'\U0001F646\U0001F3FC',
    u':personne_faisant_un_geste_d’acceptation_peau_légèrement_mate:': u'\U0001F646\U0001F3FD',
    u':personne_faisant_un_geste_d’acceptation_peau_mate:': u'\U0001F646\U0001F3FE',
    u':personne_faisant_un_geste_d’acceptation_peau_foncée:': u'\U0001F646\U0001F3FF',
    u':homme_faisant_un_geste_d’acceptation:': u'\U0001F646\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’acceptation_peau_claire:': u'\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’acceptation_peau_moyennement_claire:': u'\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’acceptation_peau_légèrement_mate:': u'\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’acceptation_peau_mate:': u'\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_un_geste_d’acceptation_peau_foncée:': u'\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_faisant_un_geste_d’acceptation:': u'\U0001F646\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’acceptation_peau_claire:': u'\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’acceptation_peau_moyennement_claire:': u'\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’acceptation_peau_légèrement_mate:': u'\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’acceptation_peau_mate:': u'\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_un_geste_d’acceptation_peau_foncée:': u'\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_paume_vers_le_haut:': u'\U0001F481',
    u':personne_paume_vers_le_haut_peau_claire:': u'\U0001F481\U0001F3FB',
    u':personne_paume_vers_le_haut_peau_moyennement_claire:': u'\U0001F481\U0001F3FC',
    u':personne_paume_vers_le_haut_peau_légèrement_mate:': u'\U0001F481\U0001F3FD',
    u':personne_paume_vers_le_haut_peau_mate:': u'\U0001F481\U0001F3FE',
    u':personne_paume_vers_le_haut_peau_foncée:': u'\U0001F481\U0001F3FF',
    u':homme_paume_vers_le_haut:': u'\U0001F481\U0000200D\U00002642\U0000FE0F',
    u':homme_paume_vers_le_haut_peau_claire:': u'\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_paume_vers_le_haut_peau_moyennement_claire:': u'\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_paume_vers_le_haut_peau_légèrement_mate:': u'\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_paume_vers_le_haut_peau_mate:': u'\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_paume_vers_le_haut_peau_foncée:': u'\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_paume_vers_le_haut:': u'\U0001F481\U0000200D\U00002640\U0000FE0F',
    u':femme_paume_vers_le_haut_peau_claire:': u'\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_paume_vers_le_haut_peau_moyennement_claire:': u'\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_paume_vers_le_haut_peau_légèrement_mate:': u'\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_paume_vers_le_haut_peau_mate:': u'\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_paume_vers_le_haut_peau_foncée:': u'\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_lève_la_main:': u'\U0001F64B',
    u':personne_qui_lève_la_main_peau_claire:': u'\U0001F64B\U0001F3FB',
    u':personne_qui_lève_la_main_peau_moyennement_claire:': u'\U0001F64B\U0001F3FC',
    u':personne_qui_lève_la_main_peau_légèrement_mate:': u'\U0001F64B\U0001F3FD',
    u':personne_qui_lève_la_main_peau_mate:': u'\U0001F64B\U0001F3FE',
    u':personne_qui_lève_la_main_peau_foncée:': u'\U0001F64B\U0001F3FF',
    u':homme_qui_lève_la_main:': u'\U0001F64B\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_lève_la_main_peau_claire:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_lève_la_main_peau_moyennement_claire:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_lève_la_main_peau_légèrement_mate:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_lève_la_main_peau_mate:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_lève_la_main_peau_foncée:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_lève_la_main:': u'\U0001F64B\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_lève_la_main_peau_claire:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_lève_la_main_peau_moyennement_claire:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_lève_la_main_peau_légèrement_mate:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_lève_la_main_peau_mate:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_lève_la_main_peau_foncée:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_sourde:': u'\U0001F9CF',
    u':personne_sourde_peau_claire:': u'\U0001F9CF\U0001F3FB',
    u':personne_sourde_peau_moyennement_claire:': u'\U0001F9CF\U0001F3FC',
    u':personne_sourde_peau_légèrement_mate:': u'\U0001F9CF\U0001F3FD',
    u':personne_sourde_peau_mate:': u'\U0001F9CF\U0001F3FE',
    u':personne_sourde_peau_foncée:': u'\U0001F9CF\U0001F3FF',
    u':homme_sourd:': u'\U0001F9CF\U0000200D\U00002642\U0000FE0F',
    u':homme_sourd_peau_claire:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_sourd_peau_moyennement_claire:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_sourd_peau_légèrement_mate:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_sourd_peau_mate:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_sourd_peau_foncée:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_sourde:': u'\U0001F9CF\U0000200D\U00002640\U0000FE0F',
    u':femme_sourde_peau_claire:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_sourde_peau_moyennement_claire:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_sourde_peau_légèrement_mate:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_sourde_peau_mate:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_sourde_peau_foncée:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_s’incline:': u'\U0001F647',
    u':personne_qui_s’incline_peau_claire:': u'\U0001F647\U0001F3FB',
    u':personne_qui_s’incline_peau_moyennement_claire:': u'\U0001F647\U0001F3FC',
    u':personne_qui_s’incline_peau_légèrement_mate:': u'\U0001F647\U0001F3FD',
    u':personne_qui_s’incline_peau_mate:': u'\U0001F647\U0001F3FE',
    u':personne_qui_s’incline_peau_foncée:': u'\U0001F647\U0001F3FF',
    u':homme_qui_s’incline:': u'\U0001F647\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_s’incline_peau_claire:': u'\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_s’incline_peau_moyennement_claire:': u'\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_s’incline_peau_légèrement_mate:': u'\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_s’incline_peau_mate:': u'\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_s’incline_peau_foncée:': u'\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_s’incline:': u'\U0001F647\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_s’incline_peau_claire:': u'\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_s’incline_peau_moyennement_claire:': u'\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_s’incline_peau_légèrement_mate:': u'\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_s’incline_peau_mate:': u'\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_s’incline_peau_foncée:': u'\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_avec_la_paume_sur_le_visage:': u'\U0001F926',
    u':personne_avec_la_paume_sur_le_visage_peau_claire:': u'\U0001F926\U0001F3FB',
    u':personne_avec_la_paume_sur_le_visage_peau_moyennement_claire:': u'\U0001F926\U0001F3FC',
    u':personne_avec_la_paume_sur_le_visage_peau_légèrement_mate:': u'\U0001F926\U0001F3FD',
    u':personne_avec_la_paume_sur_le_visage_peau_mate:': u'\U0001F926\U0001F3FE',
    u':personne_avec_la_paume_sur_le_visage_peau_foncée:': u'\U0001F926\U0001F3FF',
    u':homme_avec_la_paume_sur_le_visage:': u'\U0001F926\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_la_paume_sur_le_visage_peau_claire:': u'\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_la_paume_sur_le_visage_peau_moyennement_claire:': u'\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_la_paume_sur_le_visage_peau_légèrement_mate:': u'\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_la_paume_sur_le_visage_peau_mate:': u'\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_la_paume_sur_le_visage_peau_foncée:': u'\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_avec_la_paume_sur_le_visage:': u'\U0001F926\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_la_paume_sur_le_visage_peau_claire:': u'\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_la_paume_sur_le_visage_peau_moyennement_claire:': u'\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_la_paume_sur_le_visage_peau_légèrement_mate:': u'\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_la_paume_sur_le_visage_peau_mate:': u'\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_la_paume_sur_le_visage_peau_foncée:': u'\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_hausse_les_épaules:': u'\U0001F937',
    u':personne_qui_hausse_les_épaules_peau_claire:': u'\U0001F937\U0001F3FB',
    u':personne_qui_hausse_les_épaules_peau_moyennement_claire:': u'\U0001F937\U0001F3FC',
    u':personne_qui_hausse_les_épaules_peau_légèrement_mate:': u'\U0001F937\U0001F3FD',
    u':personne_qui_hausse_les_épaules_peau_mate:': u'\U0001F937\U0001F3FE',
    u':personne_qui_hausse_les_épaules_peau_foncée:': u'\U0001F937\U0001F3FF',
    u':homme_qui_hausse_les_épaules:': u'\U0001F937\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_hausse_les_épaules_peau_claire:': u'\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_hausse_les_épaules_peau_moyennement_claire:': u'\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_hausse_les_épaules_peau_légèrement_mate:': u'\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_hausse_les_épaules_peau_mate:': u'\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_hausse_les_épaules_peau_foncée:': u'\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_hausse_les_épaules:': u'\U0001F937\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_hausse_les_épaules_peau_claire:': u'\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_hausse_les_épaules_peau_moyennement_claire:': u'\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_hausse_les_épaules_peau_légèrement_mate:': u'\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_hausse_les_épaules_peau_mate:': u'\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_hausse_les_épaules_peau_foncée:': u'\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':professionnel_de_la_santé_(tous_genres):': u'\U0001F9D1\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé:': u'\U0001F468\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':professionnel_de_la_santé_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':professionnelle_de_la_santé:': u'\U0001F469\U0000200D\U00002695\U0000FE0F',
    u':professionnelle_de_la_santé_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':professionnelle_de_la_santé_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':professionnelle_de_la_santé_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':professionnelle_de_la_santé_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':professionnelle_de_la_santé_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':étudiant_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F393',
    u':étudiant_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F393',
    u':étudiant_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F393',
    u':étudiant_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F393',
    u':étudiant_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F393',
    u':étudiant_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F393',
    u':étudiant:': u'\U0001F468\U0000200D\U0001F393',
    u':étudiant_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F393',
    u':étudiant_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F393',
    u':étudiant_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F393',
    u':étudiant_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F393',
    u':étudiant_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F393',
    u':étudiante:': u'\U0001F469\U0000200D\U0001F393',
    u':étudiante_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F393',
    u':étudiante_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F393',
    u':étudiante_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F393',
    u':étudiante_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F393',
    u':étudiante_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F393',
    u':personnel_enseignant:': u'\U0001F9D1\U0000200D\U0001F3EB',
    u':personnel_enseignant_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3EB',
    u':personnel_enseignant_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3EB',
    u':personnel_enseignant_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3EB',
    u':personnel_enseignant_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3EB',
    u':personnel_enseignant_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3EB',
    u':enseignant:': u'\U0001F468\U0000200D\U0001F3EB',
    u':enseignant_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3EB',
    u':enseignant_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3EB',
    u':enseignant_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3EB',
    u':enseignant_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3EB',
    u':enseignant_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3EB',
    u':enseignante:': u'\U0001F469\U0000200D\U0001F3EB',
    u':enseignante_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3EB',
    u':enseignante_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3EB',
    u':enseignante_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3EB',
    u':enseignante_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3EB',
    u':enseignante_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3EB',
    u':juge:': u'\U0001F9D1\U0000200D\U00002696\U0000FE0F',
    u':juge_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':juge_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':juge_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':juge_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':juge_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':juge_homme:': u'\U0001F468\U0000200D\U00002696\U0000FE0F',
    u':juge_homme_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':juge_homme_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':juge_homme_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':juge_homme_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':juge_homme_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':juge_femme:': u'\U0001F469\U0000200D\U00002696\U0000FE0F',
    u':juge_femme_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':juge_femme_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':juge_femme_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':juge_femme_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':juge_femme_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':fermier_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F33E',
    u':fermier_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F33E',
    u':fermier_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F33E',
    u':fermier_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F33E',
    u':fermier_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F33E',
    u':fermier_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F33E',
    u':fermier:': u'\U0001F468\U0000200D\U0001F33E',
    u':fermier_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F33E',
    u':fermier_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F33E',
    u':fermier_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F33E',
    u':fermier_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F33E',
    u':fermier_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F33E',
    u':fermière:': u'\U0001F469\U0000200D\U0001F33E',
    u':fermière_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F33E',
    u':fermière_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F33E',
    u':fermière_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F33E',
    u':fermière_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F33E',
    u':fermière_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F33E',
    u':cuisinier_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F373',
    u':cuisinier_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F373',
    u':cuisinier_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F373',
    u':cuisinier_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F373',
    u':cuisinier_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F373',
    u':cuisinier_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F373',
    u':cuisinier:': u'\U0001F468\U0000200D\U0001F373',
    u':cuisinier_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F373',
    u':cuisinier_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F373',
    u':cuisinier_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F373',
    u':cuisinier_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F373',
    u':cuisinier_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F373',
    u':cuisinière:': u'\U0001F469\U0000200D\U0001F373',
    u':cuisinière_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F373',
    u':cuisinière_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F373',
    u':cuisinière_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F373',
    u':cuisinière_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F373',
    u':cuisinière_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F373',
    u':mécanicien_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F527',
    u':mécanicien_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F527',
    u':mécanicien_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F527',
    u':mécanicien_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F527',
    u':mécanicien_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F527',
    u':mécanicien_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F527',
    u':mécanicien:': u'\U0001F468\U0000200D\U0001F527',
    u':mécanicien_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F527',
    u':mécanicien_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F527',
    u':mécanicien_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F527',
    u':mécanicien_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F527',
    u':mécanicien_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F527',
    u':mécanicienne:': u'\U0001F469\U0000200D\U0001F527',
    u':mécanicienne_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F527',
    u':mécanicienne_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F527',
    u':mécanicienne_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F527',
    u':mécanicienne_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F527',
    u':mécanicienne_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F527',
    u':ouvrier_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F3ED',
    u':ouvrier_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3ED',
    u':ouvrier_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3ED',
    u':ouvrier_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3ED',
    u':ouvrier_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3ED',
    u':ouvrier_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3ED',
    u':ouvrier:': u'\U0001F468\U0000200D\U0001F3ED',
    u':ouvrier_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3ED',
    u':ouvrier_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3ED',
    u':ouvrier_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3ED',
    u':ouvrier_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3ED',
    u':ouvrier_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3ED',
    u':ouvrière:': u'\U0001F469\U0000200D\U0001F3ED',
    u':ouvrière_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3ED',
    u':ouvrière_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3ED',
    u':ouvrière_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3ED',
    u':ouvrière_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3ED',
    u':ouvrière_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3ED',
    u':employé_de_bureau_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F4BC',
    u':employé_de_bureau_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BC',
    u':employé_de_bureau_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BC',
    u':employé_de_bureau_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BC',
    u':employé_de_bureau_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BC',
    u':employé_de_bureau_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BC',
    u':employé_de_bureau:': u'\U0001F468\U0000200D\U0001F4BC',
    u':employé_de_bureau_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BC',
    u':employé_de_bureau_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BC',
    u':employé_de_bureau_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BC',
    u':employé_de_bureau_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BC',
    u':employé_de_bureau_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BC',
    u':employée_de_bureau:': u'\U0001F469\U0000200D\U0001F4BC',
    u':employée_de_bureau_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BC',
    u':employée_de_bureau_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BC',
    u':employée_de_bureau_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BC',
    u':employée_de_bureau_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BC',
    u':employée_de_bureau_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BC',
    u':scientifique:': u'\U0001F9D1\U0000200D\U0001F52C',
    u':scientifique_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F52C',
    u':scientifique_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F52C',
    u':scientifique_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F52C',
    u':scientifique_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F52C',
    u':scientifique_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F52C',
    u':scientifique_homme:': u'\U0001F468\U0000200D\U0001F52C',
    u':scientifique_homme_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F52C',
    u':scientifique_homme_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F52C',
    u':scientifique_homme_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F52C',
    u':scientifique_homme_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F52C',
    u':scientifique_homme_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F52C',
    u':scientifique_femme:': u'\U0001F469\U0000200D\U0001F52C',
    u':scientifique_femme_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F52C',
    u':scientifique_femme_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F52C',
    u':scientifique_femme_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F52C',
    u':scientifique_femme_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F52C',
    u':scientifique_femme_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F52C',
    u':informaticien_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F4BB',
    u':informaticien_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BB',
    u':informaticien_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BB',
    u':informaticien_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BB',
    u':informaticien_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BB',
    u':informaticien_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BB',
    u':informaticien:': u'\U0001F468\U0000200D\U0001F4BB',
    u':informaticien_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BB',
    u':informaticien_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BB',
    u':informaticien_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BB',
    u':informaticien_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BB',
    u':informaticien_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BB',
    u':informaticienne:': u'\U0001F469\U0000200D\U0001F4BB',
    u':informaticienne_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BB',
    u':informaticienne_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BB',
    u':informaticienne_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BB',
    u':informaticienne_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BB',
    u':informaticienne_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BB',
    u':chanteur_(tous_genres):': u'\U0001F9D1\U0000200D\U0001F3A4',
    u':chanteur_(tous_genres)_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A4',
    u':chanteur_(tous_genres)_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A4',
    u':chanteur_(tous_genres)_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A4',
    u':chanteur_(tous_genres)_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A4',
    u':chanteur_(tous_genres)_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A4',
    u':chanteur:': u'\U0001F468\U0000200D\U0001F3A4',
    u':chanteur_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A4',
    u':chanteur_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A4',
    u':chanteur_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A4',
    u':chanteur_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A4',
    u':chanteur_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A4',
    u':chanteuse:': u'\U0001F469\U0000200D\U0001F3A4',
    u':chanteuse_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A4',
    u':chanteuse_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A4',
    u':chanteuse_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A4',
    u':chanteuse_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A4',
    u':chanteuse_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A4',
    u':artiste:': u'\U0001F9D1\U0000200D\U0001F3A8',
    u':artiste_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A8',
    u':artiste_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A8',
    u':artiste_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A8',
    u':artiste_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A8',
    u':artiste_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A8',
    u':artiste_homme:': u'\U0001F468\U0000200D\U0001F3A8',
    u':artiste_homme_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A8',
    u':artiste_homme_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A8',
    u':artiste_homme_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A8',
    u':artiste_homme_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A8',
    u':artiste_homme_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A8',
    u':artiste_femme:': u'\U0001F469\U0000200D\U0001F3A8',
    u':artiste_femme_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A8',
    u':artiste_femme_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A8',
    u':artiste_femme_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A8',
    u':artiste_femme_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A8',
    u':artiste_femme_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A8',
    u':pilote:': u'\U0001F9D1\U0000200D\U00002708\U0000FE0F',
    u':pilote_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':pilote_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':pilote_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':pilote_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':pilote_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':pilote_homme:': u'\U0001F468\U0000200D\U00002708\U0000FE0F',
    u':pilote_homme_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':pilote_homme_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':pilote_homme_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':pilote_homme_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':pilote_homme_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':pilote_femme:': u'\U0001F469\U0000200D\U00002708\U0000FE0F',
    u':pilote_femme_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':pilote_femme_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':pilote_femme_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':pilote_femme_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':pilote_femme_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':astronaute:': u'\U0001F9D1\U0000200D\U0001F680',
    u':astronaute_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F680',
    u':astronaute_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F680',
    u':astronaute_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F680',
    u':astronaute_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F680',
    u':astronaute_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F680',
    u':astronaute_homme:': u'\U0001F468\U0000200D\U0001F680',
    u':astronaute_homme_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F680',
    u':astronaute_homme_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F680',
    u':astronaute_homme_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F680',
    u':astronaute_homme_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F680',
    u':astronaute_homme_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F680',
    u':astronaute_femme:': u'\U0001F469\U0000200D\U0001F680',
    u':astronaute_femme_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F680',
    u':astronaute_femme_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F680',
    u':astronaute_femme_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F680',
    u':astronaute_femme_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F680',
    u':astronaute_femme_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F680',
    u':pompier:': u'\U0001F9D1\U0000200D\U0001F692',
    u':pompier_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F692',
    u':pompier_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F692',
    u':pompier_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F692',
    u':pompier_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F692',
    u':pompier_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F692',
    u':pompier_homme:': u'\U0001F468\U0000200D\U0001F692',
    u':pompier_homme_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F692',
    u':pompier_homme_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F692',
    u':pompier_homme_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F692',
    u':pompier_homme_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F692',
    u':pompier_homme_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F692',
    u':pompier_femme:': u'\U0001F469\U0000200D\U0001F692',
    u':pompier_femme_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F692',
    u':pompier_femme_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F692',
    u':pompier_femme_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F692',
    u':pompier_femme_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F692',
    u':pompier_femme_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F692',
    u':officier_de_police:': u'\U0001F46E',
    u':officier_de_police_peau_claire:': u'\U0001F46E\U0001F3FB',
    u':officier_de_police_peau_moyennement_claire:': u'\U0001F46E\U0001F3FC',
    u':officier_de_police_peau_légèrement_mate:': u'\U0001F46E\U0001F3FD',
    u':officier_de_police_peau_mate:': u'\U0001F46E\U0001F3FE',
    u':officier_de_police_peau_foncée:': u'\U0001F46E\U0001F3FF',
    u':policier:': u'\U0001F46E\U0000200D\U00002642\U0000FE0F',
    u':policier_peau_claire:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':policier_peau_moyennement_claire:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':policier_peau_légèrement_mate:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':policier_peau_mate:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':policier_peau_foncée:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':policière:': u'\U0001F46E\U0000200D\U00002640\U0000FE0F',
    u':policière_peau_claire:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':policière_peau_moyennement_claire:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':policière_peau_légèrement_mate:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':policière_peau_mate:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':policière_peau_foncée:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':détective:': u'\U0001F575\U0000FE0F',
    u':détective_peau_claire:': u'\U0001F575\U0001F3FB',
    u':détective_peau_moyennement_claire:': u'\U0001F575\U0001F3FC',
    u':détective_peau_légèrement_mate:': u'\U0001F575\U0001F3FD',
    u':détective_peau_mate:': u'\U0001F575\U0001F3FE',
    u':détective_peau_foncée:': u'\U0001F575\U0001F3FF',
    u':détective_homme:': u'\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':détective_homme_peau_claire:': u'\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':détective_homme_peau_moyennement_claire:': u'\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':détective_homme_peau_légèrement_mate:': u'\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':détective_homme_peau_mate:': u'\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':détective_homme_peau_foncée:': u'\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':détective_femme:': u'\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':détective_femme_peau_claire:': u'\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':détective_femme_peau_moyennement_claire:': u'\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':détective_femme_peau_légèrement_mate:': u'\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':détective_femme_peau_mate:': u'\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':détective_femme_peau_foncée:': u'\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':garde:': u'\U0001F482',
    u':garde_peau_claire:': u'\U0001F482\U0001F3FB',
    u':garde_peau_moyennement_claire:': u'\U0001F482\U0001F3FC',
    u':garde_peau_légèrement_mate:': u'\U0001F482\U0001F3FD',
    u':garde_peau_mate:': u'\U0001F482\U0001F3FE',
    u':garde_peau_foncée:': u'\U0001F482\U0001F3FF',
    u':garde_homme:': u'\U0001F482\U0000200D\U00002642\U0000FE0F',
    u':garde_homme_peau_claire:': u'\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':garde_homme_peau_moyennement_claire:': u'\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':garde_homme_peau_légèrement_mate:': u'\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':garde_homme_peau_mate:': u'\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':garde_homme_peau_foncée:': u'\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':garde_femme:': u'\U0001F482\U0000200D\U00002640\U0000FE0F',
    u':garde_femme_peau_claire:': u'\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':garde_femme_peau_moyennement_claire:': u'\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':garde_femme_peau_légèrement_mate:': u'\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':garde_femme_peau_mate:': u'\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':garde_femme_peau_foncée:': u'\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':ninja:': u'\U0001F977',
    u':ninja_peau_claire:': u'\U0001F977\U0001F3FB',
    u':ninja_peau_moyennement_claire:': u'\U0001F977\U0001F3FC',
    u':ninja_peau_légèrement_mate:': u'\U0001F977\U0001F3FD',
    u':ninja_peau_mate:': u'\U0001F977\U0001F3FE',
    u':ninja_peau_foncée:': u'\U0001F977\U0001F3FF',
    u':personnel_du_bâtiment:': u'\U0001F477',
    u':personnel_du_bâtiment_peau_claire:': u'\U0001F477\U0001F3FB',
    u':personnel_du_bâtiment_peau_moyennement_claire:': u'\U0001F477\U0001F3FC',
    u':personnel_du_bâtiment_peau_légèrement_mate:': u'\U0001F477\U0001F3FD',
    u':personnel_du_bâtiment_peau_mate:': u'\U0001F477\U0001F3FE',
    u':personnel_du_bâtiment_peau_foncée:': u'\U0001F477\U0001F3FF',
    u':ouvrier_du_bâtiment:': u'\U0001F477\U0000200D\U00002642\U0000FE0F',
    u':ouvrier_du_bâtiment_peau_claire:': u'\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':ouvrier_du_bâtiment_peau_moyennement_claire:': u'\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':ouvrier_du_bâtiment_peau_légèrement_mate:': u'\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':ouvrier_du_bâtiment_peau_mate:': u'\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':ouvrier_du_bâtiment_peau_foncée:': u'\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':ouvrière_du_bâtiment:': u'\U0001F477\U0000200D\U00002640\U0000FE0F',
    u':ouvrière_du_bâtiment_peau_claire:': u'\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':ouvrière_du_bâtiment_peau_moyennement_claire:': u'\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':ouvrière_du_bâtiment_peau_légèrement_mate:': u'\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':ouvrière_du_bâtiment_peau_mate:': u'\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':ouvrière_du_bâtiment_peau_foncée:': u'\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':prince:': u'\U0001F934',
    u':prince_peau_claire:': u'\U0001F934\U0001F3FB',
    u':prince_peau_moyennement_claire:': u'\U0001F934\U0001F3FC',
    u':prince_peau_légèrement_mate:': u'\U0001F934\U0001F3FD',
    u':prince_peau_mate:': u'\U0001F934\U0001F3FE',
    u':prince_peau_foncée:': u'\U0001F934\U0001F3FF',
    u':princesse:': u'\U0001F478',
    u':princesse_peau_claire:': u'\U0001F478\U0001F3FB',
    u':princesse_peau_moyennement_claire:': u'\U0001F478\U0001F3FC',
    u':princesse_peau_légèrement_mate:': u'\U0001F478\U0001F3FD',
    u':princesse_peau_mate:': u'\U0001F478\U0001F3FE',
    u':princesse_peau_foncée:': u'\U0001F478\U0001F3FF',
    u':personne_en_turban:': u'\U0001F473',
    u':personne_en_turban_peau_claire:': u'\U0001F473\U0001F3FB',
    u':personne_en_turban_peau_moyennement_claire:': u'\U0001F473\U0001F3FC',
    u':personne_en_turban_peau_légèrement_mate:': u'\U0001F473\U0001F3FD',
    u':personne_en_turban_peau_mate:': u'\U0001F473\U0001F3FE',
    u':personne_en_turban_peau_foncée:': u'\U0001F473\U0001F3FF',
    u':homme_en_turban:': u'\U0001F473\U0000200D\U00002642\U0000FE0F',
    u':homme_en_turban_peau_claire:': u'\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_en_turban_peau_moyennement_claire:': u'\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_en_turban_peau_légèrement_mate:': u'\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_en_turban_peau_mate:': u'\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_en_turban_peau_foncée:': u'\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_en_turban:': u'\U0001F473\U0000200D\U00002640\U0000FE0F',
    u':femme_en_turban_peau_claire:': u'\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_en_turban_peau_moyennement_claire:': u'\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_en_turban_peau_légèrement_mate:': u'\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_en_turban_peau_mate:': u'\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_en_turban_peau_foncée:': u'\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':homme_avec_casquette_chinoise:': u'\U0001F472',
    u':homme_avec_casquette_chinoise_peau_claire:': u'\U0001F472\U0001F3FB',
    u':homme_avec_casquette_chinoise_peau_moyennement_claire:': u'\U0001F472\U0001F3FC',
    u':homme_avec_casquette_chinoise_peau_légèrement_mate:': u'\U0001F472\U0001F3FD',
    u':homme_avec_casquette_chinoise_peau_mate:': u'\U0001F472\U0001F3FE',
    u':homme_avec_casquette_chinoise_peau_foncée:': u'\U0001F472\U0001F3FF',
    u':femme_avec_foulard:': u'\U0001F9D5',
    u':femme_avec_foulard_peau_claire:': u'\U0001F9D5\U0001F3FB',
    u':femme_avec_foulard_peau_moyennement_claire:': u'\U0001F9D5\U0001F3FC',
    u':femme_avec_foulard_peau_légèrement_mate:': u'\U0001F9D5\U0001F3FD',
    u':femme_avec_foulard_peau_mate:': u'\U0001F9D5\U0001F3FE',
    u':femme_avec_foulard_peau_foncée:': u'\U0001F9D5\U0001F3FF',
    u':personne_en_smoking:': u'\U0001F935',
    u':personne_en_smoking_peau_claire:': u'\U0001F935\U0001F3FB',
    u':personne_en_smoking_peau_moyennement_claire:': u'\U0001F935\U0001F3FC',
    u':personne_en_smoking_peau_légèrement_mate:': u'\U0001F935\U0001F3FD',
    u':personne_en_smoking_peau_mate:': u'\U0001F935\U0001F3FE',
    u':personne_en_smoking_peau_foncée:': u'\U0001F935\U0001F3FF',
    u':homme_en_smoking:': u'\U0001F935\U0000200D\U00002642\U0000FE0F',
    u':homme_en_smoking_peau_claire:': u'\U0001F935\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_en_smoking_peau_moyennement_claire:': u'\U0001F935\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_en_smoking_peau_légèrement_mate:': u'\U0001F935\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_en_smoking_peau_mate:': u'\U0001F935\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_en_smoking_peau_foncée:': u'\U0001F935\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_en_smoking:': u'\U0001F935\U0000200D\U00002640\U0000FE0F',
    u':femme_en_smoking_peau_claire:': u'\U0001F935\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_en_smoking_peau_moyennement_claire:': u'\U0001F935\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_en_smoking_peau_légèrement_mate:': u'\U0001F935\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_en_smoking_peau_mate:': u'\U0001F935\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_en_smoking_peau_foncée:': u'\U0001F935\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_mariée_avec_voile:': u'\U0001F470',
    u':personne_mariée_avec_voile_peau_claire:': u'\U0001F470\U0001F3FB',
    u':personne_mariée_avec_voile_peau_moyennement_claire:': u'\U0001F470\U0001F3FC',
    u':personne_mariée_avec_voile_peau_légèrement_mate:': u'\U0001F470\U0001F3FD',
    u':personne_mariée_avec_voile_peau_mate:': u'\U0001F470\U0001F3FE',
    u':personne_mariée_avec_voile_peau_foncée:': u'\U0001F470\U0001F3FF',
    u':homme_avec_voile:': u'\U0001F470\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_voile_peau_claire:': u'\U0001F470\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_voile_peau_moyennement_claire:': u'\U0001F470\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_voile_peau_légèrement_mate:': u'\U0001F470\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_voile_peau_mate:': u'\U0001F470\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_voile_peau_foncée:': u'\U0001F470\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_avec_voile:': u'\U0001F470\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_voile_peau_claire:': u'\U0001F470\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_voile_peau_moyennement_claire:': u'\U0001F470\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_voile_peau_légèrement_mate:': u'\U0001F470\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_voile_peau_mate:': u'\U0001F470\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_voile_peau_foncée:': u'\U0001F470\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':femme_enceinte:': u'\U0001F930',
    u':femme_enceinte_peau_claire:': u'\U0001F930\U0001F3FB',
    u':femme_enceinte_peau_moyennement_claire:': u'\U0001F930\U0001F3FC',
    u':femme_enceinte_peau_légèrement_mate:': u'\U0001F930\U0001F3FD',
    u':femme_enceinte_peau_mate:': u'\U0001F930\U0001F3FE',
    u':femme_enceinte_peau_foncée:': u'\U0001F930\U0001F3FF',
    u':allaitement:': u'\U0001F931',
    u':allaitement_peau_claire:': u'\U0001F931\U0001F3FB',
    u':allaitement_peau_moyennement_claire:': u'\U0001F931\U0001F3FC',
    u':allaitement_peau_légèrement_mate:': u'\U0001F931\U0001F3FD',
    u':allaitement_peau_mate:': u'\U0001F931\U0001F3FE',
    u':allaitement_peau_foncée:': u'\U0001F931\U0001F3FF',
    u':femme_allaitant_un_bébé:': u'\U0001F469\U0000200D\U0001F37C',
    u':femme_allaitant_un_bébé_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F37C',
    u':femme_allaitant_un_bébé_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F37C',
    u':femme_allaitant_un_bébé_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F37C',
    u':femme_allaitant_un_bébé_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F37C',
    u':femme_allaitant_un_bébé_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F37C',
    u':homme_allaitant_un_bébé:': u'\U0001F468\U0000200D\U0001F37C',
    u':homme_allaitant_un_bébé_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F37C',
    u':homme_allaitant_un_bébé_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F37C',
    u':homme_allaitant_un_bébé_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F37C',
    u':homme_allaitant_un_bébé_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F37C',
    u':homme_allaitant_un_bébé_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F37C',
    u':personne_allaitant_un_bébé:': u'\U0001F9D1\U0000200D\U0001F37C',
    u':personne_allaitant_un_bébé_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F37C',
    u':personne_allaitant_un_bébé_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F37C',
    u':personne_allaitant_un_bébé_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F37C',
    u':personne_allaitant_un_bébé_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F37C',
    u':personne_allaitant_un_bébé_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F37C',
    u':bébé_ange:': u'\U0001F47C',
    u':bébé_ange_peau_claire:': u'\U0001F47C\U0001F3FB',
    u':bébé_ange_peau_moyennement_claire:': u'\U0001F47C\U0001F3FC',
    u':bébé_ange_peau_légèrement_mate:': u'\U0001F47C\U0001F3FD',
    u':bébé_ange_peau_mate:': u'\U0001F47C\U0001F3FE',
    u':bébé_ange_peau_foncée:': u'\U0001F47C\U0001F3FF',
    u':père_noël:': u'\U0001F385',
    u':père_noël_peau_claire:': u'\U0001F385\U0001F3FB',
    u':père_noël_peau_moyennement_claire:': u'\U0001F385\U0001F3FC',
    u':père_noël_peau_légèrement_mate:': u'\U0001F385\U0001F3FD',
    u':père_noël_peau_mate:': u'\U0001F385\U0001F3FE',
    u':père_noël_peau_foncée:': u'\U0001F385\U0001F3FF',
    u':mère_noël:': u'\U0001F936',
    u':mère_noël_peau_claire:': u'\U0001F936\U0001F3FB',
    u':mère_noël_peau_moyennement_claire:': u'\U0001F936\U0001F3FC',
    u':mère_noël_peau_légèrement_mate:': u'\U0001F936\U0001F3FD',
    u':mère_noël_peau_mate:': u'\U0001F936\U0001F3FE',
    u':mère_noël_peau_foncée:': u'\U0001F936\U0001F3FF',
    u':santa:': u'\U0001F9D1\U0000200D\U0001F384',
    u':santa_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F384',
    u':santa_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F384',
    u':santa_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F384',
    u':santa_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F384',
    u':santa_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F384',
    u':super-héros:': u'\U0001F9B8',
    u':super-héros_peau_claire:': u'\U0001F9B8\U0001F3FB',
    u':super-héros_peau_moyennement_claire:': u'\U0001F9B8\U0001F3FC',
    u':super-héros_peau_légèrement_mate:': u'\U0001F9B8\U0001F3FD',
    u':super-héros_peau_mate:': u'\U0001F9B8\U0001F3FE',
    u':super-héros_peau_foncée:': u'\U0001F9B8\U0001F3FF',
    u':super-héros_homme:': u'\U0001F9B8\U0000200D\U00002642\U0000FE0F',
    u':super-héros_homme_peau_claire:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':super-héros_homme_peau_moyennement_claire:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':super-héros_homme_peau_légèrement_mate:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':super-héros_homme_peau_mate:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':super-héros_homme_peau_foncée:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':super-héroïne:': u'\U0001F9B8\U0000200D\U00002640\U0000FE0F',
    u':super-héroïne_peau_claire:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':super-héroïne_peau_moyennement_claire:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':super-héroïne_peau_légèrement_mate:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':super-héroïne_peau_mate:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':super-héroïne_peau_foncée:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':super-vilain:': u'\U0001F9B9',
    u':super-vilain_peau_claire:': u'\U0001F9B9\U0001F3FB',
    u':super-vilain_peau_moyennement_claire:': u'\U0001F9B9\U0001F3FC',
    u':super-vilain_peau_légèrement_mate:': u'\U0001F9B9\U0001F3FD',
    u':super-vilain_peau_mate:': u'\U0001F9B9\U0001F3FE',
    u':super-vilain_peau_foncée:': u'\U0001F9B9\U0001F3FF',
    u':super-vilain_homme:': u'\U0001F9B9\U0000200D\U00002642\U0000FE0F',
    u':super-vilain_homme_peau_claire:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':super-vilain_homme_peau_moyennement_claire:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':super-vilain_homme_peau_légèrement_mate:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':super-vilain_homme_peau_mate:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':super-vilain_homme_peau_foncée:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':super-vilain_femme:': u'\U0001F9B9\U0000200D\U00002640\U0000FE0F',
    u':super-vilain_femme_peau_claire:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':super-vilain_femme_peau_moyennement_claire:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':super-vilain_femme_peau_légèrement_mate:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':super-vilain_femme_peau_mate:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':super-vilain_femme_peau_foncée:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':mage:': u'\U0001F9D9',
    u':mage_peau_claire:': u'\U0001F9D9\U0001F3FB',
    u':mage_peau_moyennement_claire:': u'\U0001F9D9\U0001F3FC',
    u':mage_peau_légèrement_mate:': u'\U0001F9D9\U0001F3FD',
    u':mage_peau_mate:': u'\U0001F9D9\U0001F3FE',
    u':mage_peau_foncée:': u'\U0001F9D9\U0001F3FF',
    u':mage_homme:': u'\U0001F9D9\U0000200D\U00002642\U0000FE0F',
    u':mage_homme_peau_claire:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':mage_homme_peau_moyennement_claire:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':mage_homme_peau_légèrement_mate:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':mage_homme_peau_mate:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':mage_homme_peau_foncée:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mage_femme:': u'\U0001F9D9\U0000200D\U00002640\U0000FE0F',
    u':mage_femme_peau_claire:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mage_femme_peau_moyennement_claire:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mage_femme_peau_légèrement_mate:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mage_femme_peau_mate:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mage_femme_peau_foncée:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personnage_féérique:': u'\U0001F9DA',
    u':personnage_féérique_peau_claire:': u'\U0001F9DA\U0001F3FB',
    u':personnage_féérique_peau_moyennement_claire:': u'\U0001F9DA\U0001F3FC',
    u':personnage_féérique_peau_légèrement_mate:': u'\U0001F9DA\U0001F3FD',
    u':personnage_féérique_peau_mate:': u'\U0001F9DA\U0001F3FE',
    u':personnage_féérique_peau_foncée:': u'\U0001F9DA\U0001F3FF',
    u':féetaud:': u'\U0001F9DA\U0000200D\U00002642\U0000FE0F',
    u':féetaud_peau_claire:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':féetaud_peau_moyennement_claire:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':féetaud_peau_légèrement_mate:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':féetaud_peau_mate:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':féetaud_peau_foncée:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':fée:': u'\U0001F9DA\U0000200D\U00002640\U0000FE0F',
    u':fée_peau_claire:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':fée_peau_moyennement_claire:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':fée_peau_légèrement_mate:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':fée_peau_mate:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':fée_peau_foncée:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':vampire:': u'\U0001F9DB',
    u':vampire_peau_claire:': u'\U0001F9DB\U0001F3FB',
    u':vampire_peau_moyennement_claire:': u'\U0001F9DB\U0001F3FC',
    u':vampire_peau_légèrement_mate:': u'\U0001F9DB\U0001F3FD',
    u':vampire_peau_mate:': u'\U0001F9DB\U0001F3FE',
    u':vampire_peau_foncée:': u'\U0001F9DB\U0001F3FF',
    u':vampire_homme:': u'\U0001F9DB\U0000200D\U00002642\U0000FE0F',
    u':vampire_homme_peau_claire:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':vampire_homme_peau_moyennement_claire:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':vampire_homme_peau_légèrement_mate:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':vampire_homme_peau_mate:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':vampire_homme_peau_foncée:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':vampire_femme:': u'\U0001F9DB\U0000200D\U00002640\U0000FE0F',
    u':vampire_femme_peau_claire:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':vampire_femme_peau_moyennement_claire:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':vampire_femme_peau_légèrement_mate:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':vampire_femme_peau_mate:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':vampire_femme_peau_foncée:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':créature_aquatique:': u'\U0001F9DC',
    u':créature_aquatique_peau_claire:': u'\U0001F9DC\U0001F3FB',
    u':créature_aquatique_peau_moyennement_claire:': u'\U0001F9DC\U0001F3FC',
    u':créature_aquatique_peau_légèrement_mate:': u'\U0001F9DC\U0001F3FD',
    u':créature_aquatique_peau_mate:': u'\U0001F9DC\U0001F3FE',
    u':créature_aquatique_peau_foncée:': u'\U0001F9DC\U0001F3FF',
    u':triton:': u'\U0001F9DC\U0000200D\U00002642\U0000FE0F',
    u':triton_peau_claire:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':triton_peau_moyennement_claire:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':triton_peau_légèrement_mate:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':triton_peau_mate:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':triton_peau_foncée:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':sirène:': u'\U0001F9DC\U0000200D\U00002640\U0000FE0F',
    u':sirène_peau_claire:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':sirène_peau_moyennement_claire:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':sirène_peau_légèrement_mate:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':sirène_peau_mate:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':sirène_peau_foncée:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':elfe:': u'\U0001F9DD',
    u':elfe_peau_claire:': u'\U0001F9DD\U0001F3FB',
    u':elfe_peau_moyennement_claire:': u'\U0001F9DD\U0001F3FC',
    u':elfe_peau_légèrement_mate:': u'\U0001F9DD\U0001F3FD',
    u':elfe_peau_mate:': u'\U0001F9DD\U0001F3FE',
    u':elfe_peau_foncée:': u'\U0001F9DD\U0001F3FF',
    u':elfe_homme:': u'\U0001F9DD\U0000200D\U00002642\U0000FE0F',
    u':elfe_homme_peau_claire:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':elfe_homme_peau_moyennement_claire:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':elfe_homme_peau_légèrement_mate:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':elfe_homme_peau_mate:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':elfe_homme_peau_foncée:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':elfe_femme:': u'\U0001F9DD\U0000200D\U00002640\U0000FE0F',
    u':elfe_femme_peau_claire:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':elfe_femme_peau_moyennement_claire:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':elfe_femme_peau_légèrement_mate:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':elfe_femme_peau_mate:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':elfe_femme_peau_foncée:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':génie:': u'\U0001F9DE',
    u':génie_homme:': u'\U0001F9DE\U0000200D\U00002642\U0000FE0F',
    u':génie_femme:': u'\U0001F9DE\U0000200D\U00002640\U0000FE0F',
    u':zombie:': u'\U0001F9DF',
    u':zombie_homme:': u'\U0001F9DF\U0000200D\U00002642\U0000FE0F',
    u':zombie_femme:': u'\U0001F9DF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_se_fait_masser:': u'\U0001F486',
    u':personne_qui_se_fait_masser_peau_claire:': u'\U0001F486\U0001F3FB',
    u':personne_qui_se_fait_masser_peau_moyennement_claire:': u'\U0001F486\U0001F3FC',
    u':personne_qui_se_fait_masser_peau_légèrement_mate:': u'\U0001F486\U0001F3FD',
    u':personne_qui_se_fait_masser_peau_mate:': u'\U0001F486\U0001F3FE',
    u':personne_qui_se_fait_masser_peau_foncée:': u'\U0001F486\U0001F3FF',
    u':homme_qui_se_fait_masser:': u'\U0001F486\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_masser_peau_claire:': u'\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_masser_peau_moyennement_claire:': u'\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_masser_peau_légèrement_mate:': u'\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_masser_peau_mate:': u'\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_masser_peau_foncée:': u'\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_se_fait_masser:': u'\U0001F486\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_masser_peau_claire:': u'\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_masser_peau_moyennement_claire:': u'\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_masser_peau_légèrement_mate:': u'\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_masser_peau_mate:': u'\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_masser_peau_foncée:': u'\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_se_fait_couper_les_cheveux:': u'\U0001F487',
    u':personne_qui_se_fait_couper_les_cheveux_peau_claire:': u'\U0001F487\U0001F3FB',
    u':personne_qui_se_fait_couper_les_cheveux_peau_moyennement_claire:': u'\U0001F487\U0001F3FC',
    u':personne_qui_se_fait_couper_les_cheveux_peau_légèrement_mate:': u'\U0001F487\U0001F3FD',
    u':personne_qui_se_fait_couper_les_cheveux_peau_mate:': u'\U0001F487\U0001F3FE',
    u':personne_qui_se_fait_couper_les_cheveux_peau_foncée:': u'\U0001F487\U0001F3FF',
    u':homme_qui_se_fait_couper_les_cheveux:': u'\U0001F487\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_couper_les_cheveux_peau_claire:': u'\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_couper_les_cheveux_peau_moyennement_claire:': u'\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_couper_les_cheveux_peau_légèrement_mate:': u'\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_couper_les_cheveux_peau_mate:': u'\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_se_fait_couper_les_cheveux_peau_foncée:': u'\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_se_fait_couper_les_cheveux:': u'\U0001F487\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_couper_les_cheveux_peau_claire:': u'\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_couper_les_cheveux_peau_moyennement_claire:': u'\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_couper_les_cheveux_peau_légèrement_mate:': u'\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_couper_les_cheveux_peau_mate:': u'\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_se_fait_couper_les_cheveux_peau_foncée:': u'\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_marche:': u'\U0001F6B6',
    u':personne_qui_marche_peau_claire:': u'\U0001F6B6\U0001F3FB',
    u':personne_qui_marche_peau_moyennement_claire:': u'\U0001F6B6\U0001F3FC',
    u':personne_qui_marche_peau_légèrement_mate:': u'\U0001F6B6\U0001F3FD',
    u':personne_qui_marche_peau_mate:': u'\U0001F6B6\U0001F3FE',
    u':personne_qui_marche_peau_foncée:': u'\U0001F6B6\U0001F3FF',
    u':homme_qui_marche:': u'\U0001F6B6\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_marche_peau_claire:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_marche_peau_moyennement_claire:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_marche_peau_légèrement_mate:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_marche_peau_mate:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_marche_peau_foncée:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_marche:': u'\U0001F6B6\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_marche_peau_claire:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_marche_peau_moyennement_claire:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_marche_peau_légèrement_mate:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_marche_peau_mate:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_marche_peau_foncée:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_debout:': u'\U0001F9CD',
    u':personne_debout_peau_claire:': u'\U0001F9CD\U0001F3FB',
    u':personne_debout_peau_moyennement_claire:': u'\U0001F9CD\U0001F3FC',
    u':personne_debout_peau_légèrement_mate:': u'\U0001F9CD\U0001F3FD',
    u':personne_debout_peau_mate:': u'\U0001F9CD\U0001F3FE',
    u':personne_debout_peau_foncée:': u'\U0001F9CD\U0001F3FF',
    u':homme_debout:': u'\U0001F9CD\U0000200D\U00002642\U0000FE0F',
    u':homme_debout_peau_claire:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_debout_peau_moyennement_claire:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_debout_peau_légèrement_mate:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_debout_peau_mate:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_debout_peau_foncée:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_debout:': u'\U0001F9CD\U0000200D\U00002640\U0000FE0F',
    u':femme_debout_peau_claire:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_debout_peau_moyennement_claire:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_debout_peau_légèrement_mate:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_debout_peau_mate:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_debout_peau_foncée:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_à_genoux:': u'\U0001F9CE',
    u':personne_à_genoux_peau_claire:': u'\U0001F9CE\U0001F3FB',
    u':personne_à_genoux_peau_moyennement_claire:': u'\U0001F9CE\U0001F3FC',
    u':personne_à_genoux_peau_légèrement_mate:': u'\U0001F9CE\U0001F3FD',
    u':personne_à_genoux_peau_mate:': u'\U0001F9CE\U0001F3FE',
    u':personne_à_genoux_peau_foncée:': u'\U0001F9CE\U0001F3FF',
    u':homme_à_genoux:': u'\U0001F9CE\U0000200D\U00002642\U0000FE0F',
    u':homme_à_genoux_peau_claire:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_à_genoux_peau_moyennement_claire:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_à_genoux_peau_légèrement_mate:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_à_genoux_peau_mate:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_à_genoux_peau_foncée:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_à_genoux:': u'\U0001F9CE\U0000200D\U00002640\U0000FE0F',
    u':femme_à_genoux_peau_claire:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_à_genoux_peau_moyennement_claire:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_à_genoux_peau_légèrement_mate:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_à_genoux_peau_mate:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_à_genoux_peau_foncée:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_avec_une_canne_blanche:': u'\U0001F9D1\U0000200D\U0001F9AF',
    u':personne_avec_une_canne_blanche_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9AF',
    u':personne_avec_une_canne_blanche_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9AF',
    u':personne_avec_une_canne_blanche_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9AF',
    u':personne_avec_une_canne_blanche_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9AF',
    u':personne_avec_une_canne_blanche_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9AF',
    u':homme_avec_canne_blanche:': u'\U0001F468\U0000200D\U0001F9AF',
    u':homme_avec_canne_blanche_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9AF',
    u':homme_avec_canne_blanche_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9AF',
    u':homme_avec_canne_blanche_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9AF',
    u':homme_avec_canne_blanche_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9AF',
    u':homme_avec_canne_blanche_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9AF',
    u':femme_avec_canne_blanche:': u'\U0001F469\U0000200D\U0001F9AF',
    u':femme_avec_canne_blanche_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9AF',
    u':femme_avec_canne_blanche_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9AF',
    u':femme_avec_canne_blanche_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9AF',
    u':femme_avec_canne_blanche_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9AF',
    u':femme_avec_canne_blanche_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9AF',
    u':personne_en_fauteuil_motorisé:': u'\U0001F9D1\U0000200D\U0001F9BC',
    u':personne_en_fauteuil_motorisé_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BC',
    u':personne_en_fauteuil_motorisé_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BC',
    u':personne_en_fauteuil_motorisé_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BC',
    u':personne_en_fauteuil_motorisé_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BC',
    u':personne_en_fauteuil_motorisé_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BC',
    u':homme_en_fauteuil_motorisé:': u'\U0001F468\U0000200D\U0001F9BC',
    u':homme_en_fauteuil_motorisé_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BC',
    u':homme_en_fauteuil_motorisé_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BC',
    u':homme_en_fauteuil_motorisé_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BC',
    u':homme_en_fauteuil_motorisé_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BC',
    u':homme_en_fauteuil_motorisé_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BC',
    u':femme_en_fauteuil_motorisé:': u'\U0001F469\U0000200D\U0001F9BC',
    u':femme_en_fauteuil_motorisé_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BC',
    u':femme_en_fauteuil_motorisé_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BC',
    u':femme_en_fauteuil_motorisé_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BC',
    u':femme_en_fauteuil_motorisé_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BC',
    u':femme_en_fauteuil_motorisé_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BC',
    u':personne_en_fauteuil_roulant_manuel:': u'\U0001F9D1\U0000200D\U0001F9BD',
    u':personne_en_fauteuil_roulant_manuel_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BD',
    u':personne_en_fauteuil_roulant_manuel_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BD',
    u':personne_en_fauteuil_roulant_manuel_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BD',
    u':personne_en_fauteuil_roulant_manuel_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BD',
    u':personne_en_fauteuil_roulant_manuel_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BD',
    u':homme_en_fauteuil_roulant_manuel:': u'\U0001F468\U0000200D\U0001F9BD',
    u':homme_en_fauteuil_roulant_manuel_peau_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BD',
    u':homme_en_fauteuil_roulant_manuel_peau_moyennement_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BD',
    u':homme_en_fauteuil_roulant_manuel_peau_légèrement_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BD',
    u':homme_en_fauteuil_roulant_manuel_peau_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BD',
    u':homme_en_fauteuil_roulant_manuel_peau_foncée:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BD',
    u':femme_en_fauteuil_roulant_manuel:': u'\U0001F469\U0000200D\U0001F9BD',
    u':femme_en_fauteuil_roulant_manuel_peau_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BD',
    u':femme_en_fauteuil_roulant_manuel_peau_moyennement_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BD',
    u':femme_en_fauteuil_roulant_manuel_peau_légèrement_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BD',
    u':femme_en_fauteuil_roulant_manuel_peau_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BD',
    u':femme_en_fauteuil_roulant_manuel_peau_foncée:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BD',
    u':personne_qui_court:': u'\U0001F3C3',
    u':personne_qui_court_peau_claire:': u'\U0001F3C3\U0001F3FB',
    u':personne_qui_court_peau_moyennement_claire:': u'\U0001F3C3\U0001F3FC',
    u':personne_qui_court_peau_légèrement_mate:': u'\U0001F3C3\U0001F3FD',
    u':personne_qui_court_peau_mate:': u'\U0001F3C3\U0001F3FE',
    u':personne_qui_court_peau_foncée:': u'\U0001F3C3\U0001F3FF',
    u':homme_qui_court:': u'\U0001F3C3\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_court_peau_claire:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_court_peau_moyennement_claire:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_court_peau_légèrement_mate:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_court_peau_mate:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_court_peau_foncée:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_court:': u'\U0001F3C3\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_court_peau_claire:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_court_peau_moyennement_claire:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_court_peau_légèrement_mate:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_court_peau_mate:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_court_peau_foncée:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':danseuse:': u'\U0001F483',
    u':danseuse_peau_claire:': u'\U0001F483\U0001F3FB',
    u':danseuse_peau_moyennement_claire:': u'\U0001F483\U0001F3FC',
    u':danseuse_peau_légèrement_mate:': u'\U0001F483\U0001F3FD',
    u':danseuse_peau_mate:': u'\U0001F483\U0001F3FE',
    u':danseuse_peau_foncée:': u'\U0001F483\U0001F3FF',
    u':danseur:': u'\U0001F57A',
    u':danseur_peau_claire:': u'\U0001F57A\U0001F3FB',
    u':danseur_peau_moyennement_claire:': u'\U0001F57A\U0001F3FC',
    u':danseur_peau_légèrement_mate:': u'\U0001F57A\U0001F3FD',
    u':danseur_peau_mate:': u'\U0001F57A\U0001F3FE',
    u':danseur_peau_foncée:': u'\U0001F57A\U0001F3FF',
    u':homme_d’affaires_en_lévitation:': u'\U0001F574\U0000FE0F',
    u':homme_d’affaires_en_lévitation_peau_claire:': u'\U0001F574\U0001F3FB',
    u':homme_d’affaires_en_lévitation_peau_moyennement_claire:': u'\U0001F574\U0001F3FC',
    u':homme_d’affaires_en_lévitation_peau_légèrement_mate:': u'\U0001F574\U0001F3FD',
    u':homme_d’affaires_en_lévitation_peau_mate:': u'\U0001F574\U0001F3FE',
    u':homme_d’affaires_en_lévitation_peau_foncée:': u'\U0001F574\U0001F3FF',
    u':personnes_avec_des_oreilles_de_lapin:': u'\U0001F46F',
    u':hommes_avec_des_oreilles_de_lapin:': u'\U0001F46F\U0000200D\U00002642\U0000FE0F',
    u':femmes_avec_des_oreilles_de_lapin:': u'\U0001F46F\U0000200D\U00002640\U0000FE0F',
    u':personne_au_hammam:': u'\U0001F9D6',
    u':personne_au_hammam_peau_claire:': u'\U0001F9D6\U0001F3FB',
    u':personne_au_hammam_peau_moyennement_claire:': u'\U0001F9D6\U0001F3FC',
    u':personne_au_hammam_peau_légèrement_mate:': u'\U0001F9D6\U0001F3FD',
    u':personne_au_hammam_peau_mate:': u'\U0001F9D6\U0001F3FE',
    u':personne_au_hammam_peau_foncée:': u'\U0001F9D6\U0001F3FF',
    u':homme_au_hammam:': u'\U0001F9D6\U0000200D\U00002642\U0000FE0F',
    u':homme_au_hammam_peau_claire:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_au_hammam_peau_moyennement_claire:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_au_hammam_peau_légèrement_mate:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_au_hammam_peau_mate:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_au_hammam_peau_foncée:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_au_hammam:': u'\U0001F9D6\U0000200D\U00002640\U0000FE0F',
    u':femme_au_hammam_peau_claire:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_au_hammam_peau_moyennement_claire:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_au_hammam_peau_légèrement_mate:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_au_hammam_peau_mate:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_au_hammam_peau_foncée:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_grimpe:': u'\U0001F9D7',
    u':personne_qui_grimpe_peau_claire:': u'\U0001F9D7\U0001F3FB',
    u':personne_qui_grimpe_peau_moyennement_claire:': u'\U0001F9D7\U0001F3FC',
    u':personne_qui_grimpe_peau_légèrement_mate:': u'\U0001F9D7\U0001F3FD',
    u':personne_qui_grimpe_peau_mate:': u'\U0001F9D7\U0001F3FE',
    u':personne_qui_grimpe_peau_foncée:': u'\U0001F9D7\U0001F3FF',
    u':homme_qui_grimpe:': u'\U0001F9D7\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_grimpe_peau_claire:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_grimpe_peau_moyennement_claire:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_grimpe_peau_légèrement_mate:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_grimpe_peau_mate:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_qui_grimpe_peau_foncée:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_qui_grimpe:': u'\U0001F9D7\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_grimpe_peau_claire:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_grimpe_peau_moyennement_claire:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_grimpe_peau_légèrement_mate:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_grimpe_peau_mate:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_qui_grimpe_peau_foncée:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':escrimeur:': u'\U0001F93A',
    u':course_hippique:': u'\U0001F3C7',
    u':course_hippique_peau_claire:': u'\U0001F3C7\U0001F3FB',
    u':course_hippique_peau_moyennement_claire:': u'\U0001F3C7\U0001F3FC',
    u':course_hippique_peau_légèrement_mate:': u'\U0001F3C7\U0001F3FD',
    u':course_hippique_peau_mate:': u'\U0001F3C7\U0001F3FE',
    u':course_hippique_peau_foncée:': u'\U0001F3C7\U0001F3FF',
    u':skieur:': u'\U000026F7\U0000FE0F',
    u':snowboardeur:': u'\U0001F3C2',
    u':snowboardeur_peau_claire:': u'\U0001F3C2\U0001F3FB',
    u':snowboardeur_peau_moyennement_claire:': u'\U0001F3C2\U0001F3FC',
    u':snowboardeur_peau_légèrement_mate:': u'\U0001F3C2\U0001F3FD',
    u':snowboardeur_peau_mate:': u'\U0001F3C2\U0001F3FE',
    u':snowboardeur_peau_foncée:': u'\U0001F3C2\U0001F3FF',
    u':joueur_de_golf:': u'\U0001F3CC\U0000FE0F',
    u':joueur_de_golf_peau_claire:': u'\U0001F3CC\U0001F3FB',
    u':joueur_de_golf_peau_moyennement_claire:': u'\U0001F3CC\U0001F3FC',
    u':joueur_de_golf_peau_légèrement_mate:': u'\U0001F3CC\U0001F3FD',
    u':joueur_de_golf_peau_mate:': u'\U0001F3CC\U0001F3FE',
    u':joueur_de_golf_peau_foncée:': u'\U0001F3CC\U0001F3FF',
    u':golfeur:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':golfeur_peau_claire:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':golfeur_peau_moyennement_claire:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':golfeur_peau_légèrement_mate:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':golfeur_peau_mate:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':golfeur_peau_foncée:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':golfeuse:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':golfeuse_peau_claire:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':golfeuse_peau_moyennement_claire:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':golfeuse_peau_légèrement_mate:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':golfeuse_peau_mate:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':golfeuse_peau_foncée:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_faisant_du_surf:': u'\U0001F3C4',
    u':personne_faisant_du_surf_peau_claire:': u'\U0001F3C4\U0001F3FB',
    u':personne_faisant_du_surf_peau_moyennement_claire:': u'\U0001F3C4\U0001F3FC',
    u':personne_faisant_du_surf_peau_légèrement_mate:': u'\U0001F3C4\U0001F3FD',
    u':personne_faisant_du_surf_peau_mate:': u'\U0001F3C4\U0001F3FE',
    u':personne_faisant_du_surf_peau_foncée:': u'\U0001F3C4\U0001F3FF',
    u':surfeur:': u'\U0001F3C4\U0000200D\U00002642\U0000FE0F',
    u':surfeur_peau_claire:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':surfeur_peau_moyennement_claire:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':surfeur_peau_légèrement_mate:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':surfeur_peau_mate:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':surfeur_peau_foncée:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':surfeuse:': u'\U0001F3C4\U0000200D\U00002640\U0000FE0F',
    u':surfeuse_peau_claire:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':surfeuse_peau_moyennement_claire:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':surfeuse_peau_légèrement_mate:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':surfeuse_peau_mate:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':surfeuse_peau_foncée:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_ramant_dans_une_barque:': u'\U0001F6A3',
    u':personne_ramant_dans_une_barque_peau_claire:': u'\U0001F6A3\U0001F3FB',
    u':personne_ramant_dans_une_barque_peau_moyennement_claire:': u'\U0001F6A3\U0001F3FC',
    u':personne_ramant_dans_une_barque_peau_légèrement_mate:': u'\U0001F6A3\U0001F3FD',
    u':personne_ramant_dans_une_barque_peau_mate:': u'\U0001F6A3\U0001F3FE',
    u':personne_ramant_dans_une_barque_peau_foncée:': u'\U0001F6A3\U0001F3FF',
    u':rameur_dans_une_barque:': u'\U0001F6A3\U0000200D\U00002642\U0000FE0F',
    u':rameur_dans_une_barque_peau_claire:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':rameur_dans_une_barque_peau_moyennement_claire:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':rameur_dans_une_barque_peau_légèrement_mate:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':rameur_dans_une_barque_peau_mate:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':rameur_dans_une_barque_peau_foncée:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':rameuse_dans_une_barque:': u'\U0001F6A3\U0000200D\U00002640\U0000FE0F',
    u':rameuse_dans_une_barque_peau_claire:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':rameuse_dans_une_barque_peau_moyennement_claire:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':rameuse_dans_une_barque_peau_légèrement_mate:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':rameuse_dans_une_barque_peau_mate:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':rameuse_dans_une_barque_peau_foncée:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_nageant:': u'\U0001F3CA',
    u':personne_nageant_peau_claire:': u'\U0001F3CA\U0001F3FB',
    u':personne_nageant_peau_moyennement_claire:': u'\U0001F3CA\U0001F3FC',
    u':personne_nageant_peau_légèrement_mate:': u'\U0001F3CA\U0001F3FD',
    u':personne_nageant_peau_mate:': u'\U0001F3CA\U0001F3FE',
    u':personne_nageant_peau_foncée:': u'\U0001F3CA\U0001F3FF',
    u':nageur:': u'\U0001F3CA\U0000200D\U00002642\U0000FE0F',
    u':nageur_peau_claire:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':nageur_peau_moyennement_claire:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':nageur_peau_légèrement_mate:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':nageur_peau_mate:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':nageur_peau_foncée:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':nageuse:': u'\U0001F3CA\U0000200D\U00002640\U0000FE0F',
    u':nageuse_peau_claire:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':nageuse_peau_moyennement_claire:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':nageuse_peau_légèrement_mate:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':nageuse_peau_mate:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':nageuse_peau_foncée:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_avec_ballon:': u'\U000026F9\U0000FE0F',
    u':personne_avec_ballon_peau_claire:': u'\U000026F9\U0001F3FB',
    u':personne_avec_ballon_peau_moyennement_claire:': u'\U000026F9\U0001F3FC',
    u':personne_avec_ballon_peau_légèrement_mate:': u'\U000026F9\U0001F3FD',
    u':personne_avec_ballon_peau_mate:': u'\U000026F9\U0001F3FE',
    u':personne_avec_ballon_peau_foncée:': u'\U000026F9\U0001F3FF',
    u':homme_avec_ballon:': u'\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_ballon_peau_claire:': u'\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_ballon_peau_moyennement_claire:': u'\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_ballon_peau_légèrement_mate:': u'\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_ballon_peau_mate:': u'\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_avec_ballon_peau_foncée:': u'\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_avec_ballon:': u'\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_ballon_peau_claire:': u'\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_ballon_peau_moyennement_claire:': u'\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_ballon_peau_légèrement_mate:': u'\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_ballon_peau_mate:': u'\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_avec_ballon_peau_foncée:': u'\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':haltérophile:': u'\U0001F3CB\U0000FE0F',
    u':haltérophile_peau_claire:': u'\U0001F3CB\U0001F3FB',
    u':haltérophile_peau_moyennement_claire:': u'\U0001F3CB\U0001F3FC',
    u':haltérophile_peau_légèrement_mate:': u'\U0001F3CB\U0001F3FD',
    u':haltérophile_peau_mate:': u'\U0001F3CB\U0001F3FE',
    u':haltérophile_peau_foncée:': u'\U0001F3CB\U0001F3FF',
    u':homme_haltérophile:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':homme_haltérophile_peau_claire:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_haltérophile_peau_moyennement_claire:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_haltérophile_peau_légèrement_mate:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_haltérophile_peau_mate:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_haltérophile_peau_foncée:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_haltérophile:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':femme_haltérophile_peau_claire:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_haltérophile_peau_moyennement_claire:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_haltérophile_peau_légèrement_mate:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_haltérophile_peau_mate:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_haltérophile_peau_foncée:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':cycliste:': u'\U0001F6B4',
    u':cycliste_peau_claire:': u'\U0001F6B4\U0001F3FB',
    u':cycliste_peau_moyennement_claire:': u'\U0001F6B4\U0001F3FC',
    u':cycliste_peau_légèrement_mate:': u'\U0001F6B4\U0001F3FD',
    u':cycliste_peau_mate:': u'\U0001F6B4\U0001F3FE',
    u':cycliste_peau_foncée:': u'\U0001F6B4\U0001F3FF',
    u':cycliste_homme:': u'\U0001F6B4\U0000200D\U00002642\U0000FE0F',
    u':cycliste_homme_peau_claire:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':cycliste_homme_peau_moyennement_claire:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':cycliste_homme_peau_légèrement_mate:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':cycliste_homme_peau_mate:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':cycliste_homme_peau_foncée:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':cycliste_femme:': u'\U0001F6B4\U0000200D\U00002640\U0000FE0F',
    u':cycliste_femme_peau_claire:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':cycliste_femme_peau_moyennement_claire:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':cycliste_femme_peau_légèrement_mate:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':cycliste_femme_peau_mate:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':cycliste_femme_peau_foncée:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_en_vtt:': u'\U0001F6B5',
    u':personne_en_vtt_peau_claire:': u'\U0001F6B5\U0001F3FB',
    u':personne_en_vtt_peau_moyennement_claire:': u'\U0001F6B5\U0001F3FC',
    u':personne_en_vtt_peau_légèrement_mate:': u'\U0001F6B5\U0001F3FD',
    u':personne_en_vtt_peau_mate:': u'\U0001F6B5\U0001F3FE',
    u':personne_en_vtt_peau_foncée:': u'\U0001F6B5\U0001F3FF',
    u':homme_en_vtt:': u'\U0001F6B5\U0000200D\U00002642\U0000FE0F',
    u':homme_en_vtt_peau_claire:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_en_vtt_peau_moyennement_claire:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_en_vtt_peau_légèrement_mate:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_en_vtt_peau_mate:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_en_vtt_peau_foncée:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_en_vtt:': u'\U0001F6B5\U0000200D\U00002640\U0000FE0F',
    u':femme_en_vtt_peau_claire:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_en_vtt_peau_moyennement_claire:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_en_vtt_peau_légèrement_mate:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_en_vtt_peau_mate:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_en_vtt_peau_foncée:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_faisant_la_roue:': u'\U0001F938',
    u':personne_faisant_la_roue_peau_claire:': u'\U0001F938\U0001F3FB',
    u':personne_faisant_la_roue_peau_moyennement_claire:': u'\U0001F938\U0001F3FC',
    u':personne_faisant_la_roue_peau_légèrement_mate:': u'\U0001F938\U0001F3FD',
    u':personne_faisant_la_roue_peau_mate:': u'\U0001F938\U0001F3FE',
    u':personne_faisant_la_roue_peau_foncée:': u'\U0001F938\U0001F3FF',
    u':homme_faisant_la_roue:': u'\U0001F938\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_la_roue_peau_claire:': u'\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_la_roue_peau_moyennement_claire:': u'\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_la_roue_peau_légèrement_mate:': u'\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_la_roue_peau_mate:': u'\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_faisant_la_roue_peau_foncée:': u'\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_faisant_la_roue:': u'\U0001F938\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_la_roue_peau_claire:': u'\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_la_roue_peau_moyennement_claire:': u'\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_la_roue_peau_légèrement_mate:': u'\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_la_roue_peau_mate:': u'\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_faisant_la_roue_peau_foncée:': u'\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personnes_faisant_de_la_lutte:': u'\U0001F93C',
    u':lutteurs:': u'\U0001F93C\U0000200D\U00002642\U0000FE0F',
    u':lutteuses:': u'\U0001F93C\U0000200D\U00002640\U0000FE0F',
    u':personne_jouant_au_water-polo:': u'\U0001F93D',
    u':personne_jouant_au_water-polo_peau_claire:': u'\U0001F93D\U0001F3FB',
    u':personne_jouant_au_water-polo_peau_moyennement_claire:': u'\U0001F93D\U0001F3FC',
    u':personne_jouant_au_water-polo_peau_légèrement_mate:': u'\U0001F93D\U0001F3FD',
    u':personne_jouant_au_water-polo_peau_mate:': u'\U0001F93D\U0001F3FE',
    u':personne_jouant_au_water-polo_peau_foncée:': u'\U0001F93D\U0001F3FF',
    u':joueur_de_water-polo:': u'\U0001F93D\U0000200D\U00002642\U0000FE0F',
    u':joueur_de_water-polo_peau_claire:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':joueur_de_water-polo_peau_moyennement_claire:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':joueur_de_water-polo_peau_légèrement_mate:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':joueur_de_water-polo_peau_mate:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':joueur_de_water-polo_peau_foncée:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':joueuse_de_water-polo:': u'\U0001F93D\U0000200D\U00002640\U0000FE0F',
    u':joueuse_de_water-polo_peau_claire:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':joueuse_de_water-polo_peau_moyennement_claire:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':joueuse_de_water-polo_peau_légèrement_mate:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':joueuse_de_water-polo_peau_mate:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':joueuse_de_water-polo_peau_foncée:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_jouant_au_handball:': u'\U0001F93E',
    u':personne_jouant_au_handball_peau_claire:': u'\U0001F93E\U0001F3FB',
    u':personne_jouant_au_handball_peau_moyennement_claire:': u'\U0001F93E\U0001F3FC',
    u':personne_jouant_au_handball_peau_légèrement_mate:': u'\U0001F93E\U0001F3FD',
    u':personne_jouant_au_handball_peau_mate:': u'\U0001F93E\U0001F3FE',
    u':personne_jouant_au_handball_peau_foncée:': u'\U0001F93E\U0001F3FF',
    u':handballeur:': u'\U0001F93E\U0000200D\U00002642\U0000FE0F',
    u':handballeur_peau_claire:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':handballeur_peau_moyennement_claire:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':handballeur_peau_légèrement_mate:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':handballeur_peau_mate:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':handballeur_peau_foncée:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':handballeuse:': u'\U0001F93E\U0000200D\U00002640\U0000FE0F',
    u':handballeuse_peau_claire:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':handballeuse_peau_moyennement_claire:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':handballeuse_peau_légèrement_mate:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':handballeuse_peau_mate:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':handballeuse_peau_foncée:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_qui_jongle:': u'\U0001F939',
    u':personne_qui_jongle_peau_claire:': u'\U0001F939\U0001F3FB',
    u':personne_qui_jongle_peau_moyennement_claire:': u'\U0001F939\U0001F3FC',
    u':personne_qui_jongle_peau_légèrement_mate:': u'\U0001F939\U0001F3FD',
    u':personne_qui_jongle_peau_mate:': u'\U0001F939\U0001F3FE',
    u':personne_qui_jongle_peau_foncée:': u'\U0001F939\U0001F3FF',
    u':jongleur:': u'\U0001F939\U0000200D\U00002642\U0000FE0F',
    u':jongleur_peau_claire:': u'\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':jongleur_peau_moyennement_claire:': u'\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':jongleur_peau_légèrement_mate:': u'\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':jongleur_peau_mate:': u'\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':jongleur_peau_foncée:': u'\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':jongleuse:': u'\U0001F939\U0000200D\U00002640\U0000FE0F',
    u':jongleuse_peau_claire:': u'\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':jongleuse_peau_moyennement_claire:': u'\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':jongleuse_peau_légèrement_mate:': u'\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':jongleuse_peau_mate:': u'\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':jongleuse_peau_foncée:': u'\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_dans_la_posture_du_lotus:': u'\U0001F9D8',
    u':personne_dans_la_posture_du_lotus_peau_claire:': u'\U0001F9D8\U0001F3FB',
    u':personne_dans_la_posture_du_lotus_peau_moyennement_claire:': u'\U0001F9D8\U0001F3FC',
    u':personne_dans_la_posture_du_lotus_peau_légèrement_mate:': u'\U0001F9D8\U0001F3FD',
    u':personne_dans_la_posture_du_lotus_peau_mate:': u'\U0001F9D8\U0001F3FE',
    u':personne_dans_la_posture_du_lotus_peau_foncée:': u'\U0001F9D8\U0001F3FF',
    u':homme_dans_la_posture_du_lotus:': u'\U0001F9D8\U0000200D\U00002642\U0000FE0F',
    u':homme_dans_la_posture_du_lotus_peau_claire:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homme_dans_la_posture_du_lotus_peau_moyennement_claire:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homme_dans_la_posture_du_lotus_peau_légèrement_mate:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homme_dans_la_posture_du_lotus_peau_mate:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homme_dans_la_posture_du_lotus_peau_foncée:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':femme_dans_la_posture_du_lotus:': u'\U0001F9D8\U0000200D\U00002640\U0000FE0F',
    u':femme_dans_la_posture_du_lotus_peau_claire:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':femme_dans_la_posture_du_lotus_peau_moyennement_claire:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':femme_dans_la_posture_du_lotus_peau_légèrement_mate:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':femme_dans_la_posture_du_lotus_peau_mate:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':femme_dans_la_posture_du_lotus_peau_foncée:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personne_prenant_un_bain:': u'\U0001F6C0',
    u':personne_prenant_un_bain_peau_claire:': u'\U0001F6C0\U0001F3FB',
    u':personne_prenant_un_bain_peau_moyennement_claire:': u'\U0001F6C0\U0001F3FC',
    u':personne_prenant_un_bain_peau_légèrement_mate:': u'\U0001F6C0\U0001F3FD',
    u':personne_prenant_un_bain_peau_mate:': u'\U0001F6C0\U0001F3FE',
    u':personne_prenant_un_bain_peau_foncée:': u'\U0001F6C0\U0001F3FF',
    u':personne_au_lit:': u'\U0001F6CC',
    u':personne_au_lit_peau_claire:': u'\U0001F6CC\U0001F3FB',
    u':personne_au_lit_peau_moyennement_claire:': u'\U0001F6CC\U0001F3FC',
    u':personne_au_lit_peau_légèrement_mate:': u'\U0001F6CC\U0001F3FD',
    u':personne_au_lit_peau_mate:': u'\U0001F6CC\U0001F3FE',
    u':personne_au_lit_peau_foncée:': u'\U0001F6CC\U0001F3FF',
    u':deux_personnes_se_tenant_la_main:': u'\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1',
    u':deux_personnes_se_tenant_la_main_peau_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':deux_personnes_se_tenant_la_main_peau_claire_et_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':deux_personnes_se_tenant_la_main_peau_claire_et_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':deux_personnes_se_tenant_la_main_peau_claire_et_peau_mate:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':deux_personnes_se_tenant_la_main_peau_claire_et_peau_foncée:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':deux_personnes_se_tenant_la_main_peau_moyennement_claire_et_peau_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':deux_personnes_se_tenant_la_main_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':deux_personnes_se_tenant_la_main_peau_moyennement_claire_et_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':deux_personnes_se_tenant_la_main_peau_moyennement_claire_et_peau_mate:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':deux_personnes_se_tenant_la_main_peau_moyennement_claire_et_peau_foncée:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':deux_personnes_se_tenant_la_main_peau_légèrement_mate_et_peau_claire:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':deux_personnes_se_tenant_la_main_peau_légèrement_mate_et_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':deux_personnes_se_tenant_la_main_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':deux_personnes_se_tenant_la_main_peau_légèrement_mate_et_peau_mate:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':deux_personnes_se_tenant_la_main_peau_légèrement_mate_et_peau_foncée:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':deux_personnes_se_tenant_la_main_peau_mate_et_peau_claire:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':deux_personnes_se_tenant_la_main_peau_mate_et_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':deux_personnes_se_tenant_la_main_peau_mate_et_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':deux_personnes_se_tenant_la_main_peau_mate:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':deux_personnes_se_tenant_la_main_peau_mate_et_peau_foncée:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':deux_personnes_se_tenant_la_main_peau_foncée_et_peau_claire:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':deux_personnes_se_tenant_la_main_peau_foncée_et_peau_moyennement_claire:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':deux_personnes_se_tenant_la_main_peau_foncée_et_peau_légèrement_mate:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':deux_personnes_se_tenant_la_main_peau_foncée_et_peau_mate:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':deux_personnes_se_tenant_la_main_peau_foncée:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':deux_femmes_se_tenant_la_main:': u'\U0001F46D',
    u':deux_femmes_se_tenant_la_main_peau_claire:': u'\U0001F46D\U0001F3FB',
    u':deux_femmes_se_tenant_la_main_peau_claire_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':deux_femmes_se_tenant_la_main_peau_claire_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':deux_femmes_se_tenant_la_main_peau_claire_et_peau_mate:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':deux_femmes_se_tenant_la_main_peau_claire_et_peau_foncée:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':deux_femmes_se_tenant_la_main_peau_moyennement_claire_et_peau_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':deux_femmes_se_tenant_la_main_peau_moyennement_claire:': u'\U0001F46D\U0001F3FC',
    u':deux_femmes_se_tenant_la_main_peau_moyennement_claire_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':deux_femmes_se_tenant_la_main_peau_moyennement_claire_et_peau_mate:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':deux_femmes_se_tenant_la_main_peau_moyennement_claire_et_peau_foncée:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':deux_femmes_se_tenant_la_main_peau_légèrement_mate_et_peau_claire:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':deux_femmes_se_tenant_la_main_peau_légèrement_mate_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':deux_femmes_se_tenant_la_main_peau_légèrement_mate:': u'\U0001F46D\U0001F3FD',
    u':deux_femmes_se_tenant_la_main_peau_légèrement_mate_et_peau_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':deux_femmes_se_tenant_la_main_peau_légèrement_mate_et_peau_foncée:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':deux_femmes_se_tenant_la_main_peau_mate_et_peau_claire:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':deux_femmes_se_tenant_la_main_peau_mate_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':deux_femmes_se_tenant_la_main_peau_mate_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':deux_femmes_se_tenant_la_main_peau_mate:': u'\U0001F46D\U0001F3FE',
    u':deux_femmes_se_tenant_la_main_peau_mate_et_peau_foncée:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':deux_femmes_se_tenant_la_main_peau_foncée_et_peau_claire:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':deux_femmes_se_tenant_la_main_peau_foncée_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':deux_femmes_se_tenant_la_main_peau_foncée_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':deux_femmes_se_tenant_la_main_peau_foncée_et_peau_mate:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':deux_femmes_se_tenant_la_main_peau_foncée:': u'\U0001F46D\U0001F3FF',
    u':femme_et_homme_se_tenant_la_main:': u'\U0001F46B',
    u':femme_et_homme_se_tenant_la_main_peau_claire:': u'\U0001F46B\U0001F3FB',
    u':femme_et_homme_se_tenant_la_main_peau_claire_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':femme_et_homme_se_tenant_la_main_peau_claire_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':femme_et_homme_se_tenant_la_main_peau_claire_et_peau_mate:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':femme_et_homme_se_tenant_la_main_peau_claire_et_peau_foncée:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':femme_et_homme_se_tenant_la_main_peau_moyennement_claire_et_peau_claire:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':femme_et_homme_se_tenant_la_main_peau_moyennement_claire:': u'\U0001F46B\U0001F3FC',
    u':femme_et_homme_se_tenant_la_main_peau_moyennement_claire_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':femme_et_homme_se_tenant_la_main_peau_moyennement_claire_et_peau_mate:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':femme_et_homme_se_tenant_la_main_peau_moyennement_claire_et_peau_foncée:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':femme_et_homme_se_tenant_la_main_peau_légèrement_mate_et_peau_claire:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':femme_et_homme_se_tenant_la_main_peau_légèrement_mate_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':femme_et_homme_se_tenant_la_main_peau_légèrement_mate:': u'\U0001F46B\U0001F3FD',
    u':femme_et_homme_se_tenant_la_main_peau_légèrement_mate_et_peau_mate:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':femme_et_homme_se_tenant_la_main_peau_légèrement_mate_et_peau_foncée:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':femme_et_homme_se_tenant_la_main_peau_mate_et_peau_claire:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':femme_et_homme_se_tenant_la_main_peau_mate_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':femme_et_homme_se_tenant_la_main_peau_mate_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':femme_et_homme_se_tenant_la_main_peau_mate:': u'\U0001F46B\U0001F3FE',
    u':femme_et_homme_se_tenant_la_main_peau_mate_et_peau_foncée:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':femme_et_homme_se_tenant_la_main_peau_foncée_et_peau_claire:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':femme_et_homme_se_tenant_la_main_peau_foncée_et_peau_moyennement_claire:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':femme_et_homme_se_tenant_la_main_peau_foncée_et_peau_légèrement_mate:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':femme_et_homme_se_tenant_la_main_peau_foncée_et_peau_mate:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':femme_et_homme_se_tenant_la_main_peau_foncée:': u'\U0001F46B\U0001F3FF',
    u':deux_hommes_se_tenant_la_main:': u'\U0001F46C',
    u':deux_hommes_se_tenant_la_main_peau_claire:': u'\U0001F46C\U0001F3FB',
    u':deux_hommes_se_tenant_la_main_peau_claire_et_peau_moyennement_claire:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':deux_hommes_se_tenant_la_main_peau_claire_et_peau_légèrement_mate:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':deux_hommes_se_tenant_la_main_peau_claire_et_peau_mate:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':deux_hommes_se_tenant_la_main_peau_claire_et_peau_foncée:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':deux_hommes_se_tenant_la_main_peau_moyennement_claire_et_peau_claire:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':deux_hommes_se_tenant_la_main_peau_moyennement_claire:': u'\U0001F46C\U0001F3FC',
    u':deux_hommes_se_tenant_la_main_peau_moyennement_claire_et_peau_légèrement_mate:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':deux_hommes_se_tenant_la_main_peau_moyennement_claire_et_peau_mate:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':deux_hommes_se_tenant_la_main_peau_moyennement_claire_et_peau_foncée:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':deux_hommes_se_tenant_la_main_peau_légèrement_mate_et_peau_claire:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':deux_hommes_se_tenant_la_main_peau_légèrement_mate_et_peau_moyennement_claire:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':deux_hommes_se_tenant_la_main_peau_légèrement_mate:': u'\U0001F46C\U0001F3FD',
    u':deux_hommes_se_tenant_la_main_peau_légèrement_mate_et_peau_mate:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':deux_hommes_se_tenant_la_main_peau_légèrement_mate_et_peau_foncée:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':deux_hommes_se_tenant_la_main_peau_mate_et_peau_claire:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':deux_hommes_se_tenant_la_main_peau_mate_et_peau_moyennement_claire:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':deux_hommes_se_tenant_la_main_peau_mate_et_peau_légèrement_mate:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':deux_hommes_se_tenant_la_main_peau_mate:': u'\U0001F46C\U0001F3FE',
    u':deux_hommes_se_tenant_la_main_peau_mate_et_peau_foncée:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':deux_hommes_se_tenant_la_main_peau_foncée_et_peau_claire:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':deux_hommes_se_tenant_la_main_peau_foncée_et_peau_moyennement_claire:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':deux_hommes_se_tenant_la_main_peau_foncée_et_peau_légèrement_mate:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':deux_hommes_se_tenant_la_main_peau_foncée_et_peau_mate:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':deux_hommes_se_tenant_la_main_peau_foncée:': u'\U0001F46C\U0001F3FF',
    u':bisou:': u'\U0001F48F',
    u':bisou_femme_et_homme:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':bisou_homme_et_homme:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':bisou_femme_et_femme:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469',
    u':couple_avec_cœur:': u'\U0001F491',
    u':couple_avec_cœur_femme_et_homme:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':couple_avec_cœur_homme_et_homme:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':couple_avec_cœur_femme_et_femme:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469',
    u':famille:': u'\U0001F46A',
    u':famille_homme,_femme_et_garçon:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466',
    u':famille_homme,_femme_et_fille:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467',
    u':famille_homme,_femme,_fille_et_garçon:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':famille_homme,_femme,_garçon_et_garçon:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':famille_homme,_femme,_fille_et_fille:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':famille_homme,_homme_et_garçon:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466',
    u':famille_homme,_homme_et_fille:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467',
    u':famille_homme,_homme,_fille_et_garçon:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':famille_homme,_homme,_garçon_et_garçon:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':famille_homme,_homme,_fille_et_fille:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':famille_femme,_femme_et_garçon:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466',
    u':famille_femme,_femme_et_fille:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467',
    u':famille_femme,_femme,_fille_et_garçon:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':famille_femme,_femme,_garçon_et_garçon:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':famille_femme,_femme,_fille_et_fille:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':famille_homme_et_garçon:': u'\U0001F468\U0000200D\U0001F466',
    u':famille_homme,_garçon_et_garçon:': u'\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':famille_homme_et_fille:': u'\U0001F468\U0000200D\U0001F467',
    u':famille_homme,_fille_et_garçon:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':famille_homme,_fille_et_fille:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':famille_femme_et_garçon:': u'\U0001F469\U0000200D\U0001F466',
    u':famille_femme,_garçon_et_garçon:': u'\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':famille_femme_et_fille:': u'\U0001F469\U0000200D\U0001F467',
    u':famille_femme,_fille_et_garçon:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':famille_femme,_fille_et_fille:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':tête_qui_parle:': u'\U0001F5E3\U0000FE0F',
    u':silhouette_de_buste:': u'\U0001F464',
    u':silhouettes_de_bustes:': u'\U0001F465',
    u':étreinte:': u'\U0001FAC2',
    u':traces_de_pas:': u'\U0001F463',
    u':peau_claire:': u'\U0001F3FB',
    u':peau_moyennement_claire:': u'\U0001F3FC',
    u':peau_légèrement_mate:': u'\U0001F3FD',
    u':peau_mate:': u'\U0001F3FE',
    u':peau_foncée:': u'\U0001F3FF',
    u':cheveux_roux:': u'\U0001F9B0',
    u':cheveux_bouclés:': u'\U0001F9B1',
    u':cheveux_blancs:': u'\U0001F9B3',
    u':chauve:': u'\U0001F9B2',
    u':tête_de_singe:': u'\U0001F435',
    u':singe:': u'\U0001F412',
    u':gorille:': u'\U0001F98D',
    u':orang-outan:': u'\U0001F9A7',
    u':tête_de_chien:': u'\U0001F436',
    u':chien:': u'\U0001F415',
    u':chien_guide:': u'\U0001F9AE',
    u':chien_d’assistance:': u'\U0001F415\U0000200D\U0001F9BA',
    u':caniche:': u'\U0001F429',
    u':loup:': u'\U0001F43A',
    u':renard:': u'\U0001F98A',
    u':raton_laveur:': u'\U0001F99D',
    u':tête_de_chat:': u'\U0001F431',
    u':chat:': u'\U0001F408',
    u':chat_noir:': u'\U0001F408\U0000200D\U00002B1B',
    u':tête_de_lion:': u'\U0001F981',
    u':tête_de_tigre:': u'\U0001F42F',
    u':tigre:': u'\U0001F405',
    u':léopard:': u'\U0001F406',
    u':tête_de_cheval:': u'\U0001F434',
    u':cheval:': u'\U0001F40E',
    u':licorne:': u'\U0001F984',
    u':zèbre:': u'\U0001F993',
    u':cerf:': u'\U0001F98C',
    u':bison:': u'\U0001F9AC',
    u':tête_de_vache:': u'\U0001F42E',
    u':bœuf:': u'\U0001F402',
    u':buffle:': u'\U0001F403',
    u':vache:': u'\U0001F404',
    u':tête_de_cochon:': u'\U0001F437',
    u':cochon:': u'\U0001F416',
    u':sanglier:': u'\U0001F417',
    u':groin:': u'\U0001F43D',
    u':bélier:': u'\U0001F40F',
    u':mouton:': u'\U0001F411',
    u':chèvre:': u'\U0001F410',
    u':dromadaire:': u'\U0001F42A',
    u':chameau:': u'\U0001F42B',
    u':lama:': u'\U0001F999',
    u':girafe:': u'\U0001F992',
    u':éléphant:': u'\U0001F418',
    u':mammouth:': u'\U0001F9A3',
    u':rhinocéros:': u'\U0001F98F',
    u':hippopotame:': u'\U0001F99B',
    u':tête_de_souris:': u'\U0001F42D',
    u':souris:': u'\U0001F401',
    u':rat:': u'\U0001F400',
    u':hamster:': u'\U0001F439',
    u':tête_de_lapin:': u'\U0001F430',
    u':lapin:': u'\U0001F407',
    u':écureuil:': u'\U0001F43F\U0000FE0F',
    u':castor:': u'\U0001F9AB',
    u':hérisson:': u'\U0001F994',
    u':chauve-souris:': u'\U0001F987',
    u':ours:': u'\U0001F43B',
    u':ours_polaire:': u'\U0001F43B\U0000200D\U00002744\U0000FE0F',
    u':koala:': u'\U0001F428',
    u':panda:': u'\U0001F43C',
    u':paresseux:': u'\U0001F9A5',
    u':loutre:': u'\U0001F9A6',
    u':mouffette:': u'\U0001F9A8',
    u':kangourou:': u'\U0001F998',
    u':blaireau:': u'\U0001F9A1',
    u':empreintes_d’animaux:': u'\U0001F43E',
    u':dindon:': u'\U0001F983',
    u':poule:': u'\U0001F414',
    u':coq:': u'\U0001F413',
    u':poussin_qui_éclôt:': u'\U0001F423',
    u':poussin:': u'\U0001F424',
    u':poussin_de_face:': u'\U0001F425',
    u':oiseau:': u'\U0001F426',
    u':pingouin:': u'\U0001F427',
    u':colombe:': u'\U0001F54A\U0000FE0F',
    u':aigle:': u'\U0001F985',
    u':canard:': u'\U0001F986',
    u':cygne:': u'\U0001F9A2',
    u':chouette:': u'\U0001F989',
    u':dodo:': u'\U0001F9A4',
    u':plume:': u'\U0001FAB6',
    u':flamant:': u'\U0001F9A9',
    u':paon:': u'\U0001F99A',
    u':perroquet:': u'\U0001F99C',
    u':grenouille:': u'\U0001F438',
    u':crocodile:': u'\U0001F40A',
    u':tortue:': u'\U0001F422',
    u':lézard:': u'\U0001F98E',
    u':serpent:': u'\U0001F40D',
    u':tête_de_dragon:': u'\U0001F432',
    u':dragon:': u'\U0001F409',
    u':sauropode:': u'\U0001F995',
    u':t-rex:': u'\U0001F996',
    u':baleine_soufflant_par_son_évent:': u'\U0001F433',
    u':baleine:': u'\U0001F40B',
    u':dauphin:': u'\U0001F42C',
    u':phoque:': u'\U0001F9AD',
    u':poisson:': u'\U0001F41F',
    u':poisson_tropical:': u'\U0001F420',
    u':poisson-lune:': u'\U0001F421',
    u':requin:': u'\U0001F988',
    u':pieuvre:': u'\U0001F419',
    u':coquille_en_spirale:': u'\U0001F41A',
    u':escargot:': u'\U0001F40C',
    u':papillon:': u'\U0001F98B',
    u':chenille:': u'\U0001F41B',
    u':fourmi:': u'\U0001F41C',
    u':abeille:': u'\U0001F41D',
    u':scarabée:': u'\U0001FAB2',
    u':coccinelle:': u'\U0001F41E',
    u':criquet:': u'\U0001F997',
    u':cafard:': u'\U0001FAB3',
    u':araignée:': u'\U0001F577\U0000FE0F',
    u':toile_d’araignée:': u'\U0001F578\U0000FE0F',
    u':scorpion:': u'\U0001F982',
    u':moustique:': u'\U0001F99F',
    u':mouche:': u'\U0001FAB0',
    u':lombric:': u'\U0001FAB1',
    u':microbe:': u'\U0001F9A0',
    u':bouquet:': u'\U0001F490',
    u':fleur_de_cerisier:': u'\U0001F338',
    u':fleur_blanche:': u'\U0001F4AE',
    u':rosette:': u'\U0001F3F5\U0000FE0F',
    u':rose:': u'\U0001F339',
    u':fleur_fanée:': u'\U0001F940',
    u':hibiscus:': u'\U0001F33A',
    u':tournesol:': u'\U0001F33B',
    u':bourgeon:': u'\U0001F33C',
    u':tulipe:': u'\U0001F337',
    u':jeune_pousse:': u'\U0001F331',
    u':plante_en_pot:': u'\U0001FAB4',
    u':conifère:': u'\U0001F332',
    u':arbre_à_feuilles_caduques:': u'\U0001F333',
    u':palmier:': u'\U0001F334',
    u':cactus:': u'\U0001F335',
    u':plant_de_riz:': u'\U0001F33E',
    u':feuille:': u'\U0001F33F',
    u':trèfle:': u'\U00002618\U0000FE0F',
    u':trèfle_à_quatre_feuilles:': u'\U0001F340',
    u':feuille_d’érable:': u'\U0001F341',
    u':feuille_morte:': u'\U0001F342',
    u':feuille_virevoltante:': u'\U0001F343',
    u':raisin:': u'\U0001F347',
    u':melon:': u'\U0001F348',
    u':pastèque:': u'\U0001F349',
    u':mandarine:': u'\U0001F34A',
    u':citron:': u'\U0001F34B',
    u':banane:': u'\U0001F34C',
    u':ananas:': u'\U0001F34D',
    u':mangue:': u'\U0001F96D',
    u':pomme_rouge:': u'\U0001F34E',
    u':pomme_verte:': u'\U0001F34F',
    u':poire:': u'\U0001F350',
    u':pêche:': u'\U0001F351',
    u':cerises:': u'\U0001F352',
    u':fraise:': u'\U0001F353',
    u':myrtilles:': u'\U0001FAD0',
    u':kiwi:': u'\U0001F95D',
    u':tomate:': u'\U0001F345',
    u':olive:': u'\U0001FAD2',
    u':noix_de_coco:': u'\U0001F965',
    u':avocat:': u'\U0001F951',
    u':aubergine:': u'\U0001F346',
    u':pomme_de_terre:': u'\U0001F954',
    u':carotte:': u'\U0001F955',
    u':épi_de_maïs:': u'\U0001F33D',
    u':piment_rouge:': u'\U0001F336\U0000FE0F',
    u':poivron:': u'\U0001FAD1',
    u':concombre:': u'\U0001F952',
    u':légume_à_feuilles_vertes:': u'\U0001F96C',
    u':broccoli:': u'\U0001F966',
    u':ail:': u'\U0001F9C4',
    u':oignon:': u'\U0001F9C5',
    u':champignon:': u'\U0001F344',
    u':cacahuètes:': u'\U0001F95C',
    u':châtaigne:': u'\U0001F330',
    u':pain:': u'\U0001F35E',
    u':croissant:': u'\U0001F950',
    u':baguette:': u'\U0001F956',
    u':galette:': u'\U0001FAD3',
    u':bretzel:': u'\U0001F968',
    u':bagel:': u'\U0001F96F',
    u':pancakes:': u'\U0001F95E',
    u':gaufre:': u'\U0001F9C7',
    u':part_de_fromage:': u'\U0001F9C0',
    u':viande_sur_un_os:': u'\U0001F356',
    u':cuisse_de_poulet:': u'\U0001F357',
    u':morceau_de_viande:': u'\U0001F969',
    u':lard:': u'\U0001F953',
    u':hamburger:': u'\U0001F354',
    u':frites:': u'\U0001F35F',
    u':pizza:': u'\U0001F355',
    u':hot_dog:': u'\U0001F32D',
    u':sandwich:': u'\U0001F96A',
    u':taco:': u'\U0001F32E',
    u':burrito:': u'\U0001F32F',
    u':tamal:': u'\U0001FAD4',
    u':kebab:': u'\U0001F959',
    u':falafels:': u'\U0001F9C6',
    u':œuf:': u'\U0001F95A',
    u':œuf_au_plat:': u'\U0001F373',
    u':plat_mitonné:': u'\U0001F958',
    u':marmite:': u'\U0001F372',
    u':fondue:': u'\U0001FAD5',
    u':bol_avec_cuillère:': u'\U0001F963',
    u':salade_verte:': u'\U0001F957',
    u':pop-corn:': u'\U0001F37F',
    u':beurre:': u'\U0001F9C8',
    u':sel:': u'\U0001F9C2',
    u':aliments_en_conserve:': u'\U0001F96B',
    u':boîte_déjeuner:': u'\U0001F371',
    u':galette_de_riz:': u'\U0001F358',
    u':boulette_de_riz:': u'\U0001F359',
    u':bol_de_riz:': u'\U0001F35A',
    u':riz_au_curry:': u'\U0001F35B',
    u':bol_fumant:': u'\U0001F35C',
    u':spaghetti:': u'\U0001F35D',
    u':patate_douce:': u'\U0001F360',
    u':brochette_de_poisson:': u'\U0001F362',
    u':sushi:': u'\U0001F363',
    u':beignet_de_crevette:': u'\U0001F364',
    u':croquette_de_poisson:': u'\U0001F365',
    u':gâteau_de_lune:': u'\U0001F96E',
    u':brochette_de_bonbons:': u'\U0001F361',
    u':boulette_de_pâte:': u'\U0001F95F',
    u':biscuit_chinois:': u'\U0001F960',
    u':boîte_à_emporter:': u'\U0001F961',
    u':crabe:': u'\U0001F980',
    u':homard:': u'\U0001F99E',
    u':crevette:': u'\U0001F990',
    u':calamar:': u'\U0001F991',
    u':huître:': u'\U0001F9AA',
    u':glace_italienne:': u'\U0001F366',
    u':granité:': u'\U0001F367',
    u':glace:': u'\U0001F368',
    u':doughnut:': u'\U0001F369',
    u':cookie:': u'\U0001F36A',
    u':gâteau_d’anniversaire:': u'\U0001F382',
    u':gâteau_sablé:': u'\U0001F370',
    u':cupcake:': u'\U0001F9C1',
    u':tarte:': u'\U0001F967',
    u':barre_chocolatée:': u'\U0001F36B',
    u':bonbon:': u'\U0001F36C',
    u':sucette:': u'\U0001F36D',
    u':crème_renversée:': u'\U0001F36E',
    u':pot_de_miel:': u'\U0001F36F',
    u':biberon:': u'\U0001F37C',
    u':verre_de_lait:': u'\U0001F95B',
    u':boisson_chaude:': u'\U00002615',
    u':théière:': u'\U0001FAD6',
    u':tasse:': u'\U0001F375',
    u':saké:': u'\U0001F376',
    u':bouteille_de_champagne:': u'\U0001F37E',
    u':verre_de_vin:': u'\U0001F377',
    u':cocktail:': u'\U0001F378',
    u':cocktail_tropical:': u'\U0001F379',
    u':chope:': u'\U0001F37A',
    u':chopes_de_bière:': u'\U0001F37B',
    u':trinquer:': u'\U0001F942',
    u':verre_tumbler:': u'\U0001F943',
    u':gobelet_avec_paille:': u'\U0001F964',
    u':thé_aux_perles:': u'\U0001F9CB',
    u':briquette_de_jus:': u'\U0001F9C3',
    u':maté:': u'\U0001F9C9',
    u':glaçon:': u'\U0001F9CA',
    u':baguettes:': u'\U0001F962',
    u':fourchette_et_couteau_avec_assiette:': u'\U0001F37D\U0000FE0F',
    u':fourchette_et_couteau:': u'\U0001F374',
    u':cuillère:': u'\U0001F944',
    u':couteau_de_cuisine:': u'\U0001F52A',
    u':amphore:': u'\U0001F3FA',
    u':globe_tourné_sur_l’afrique_et_l’europe:': u'\U0001F30D',
    u':globe_tourné_sur_les_amériques:': u'\U0001F30E',
    u':globe_tourné_sur_l’asie_et_l’australie:': u'\U0001F30F',
    u':globe_avec_méridiens:': u'\U0001F310',
    u':carte_du_monde:': u'\U0001F5FA\U0000FE0F',
    u':carte_du_japon:': u'\U0001F5FE',
    u':boussole:': u'\U0001F9ED',
    u':montagne_enneigée:': u'\U0001F3D4\U0000FE0F',
    u':montagne:': u'\U000026F0\U0000FE0F',
    u':volcan:': u'\U0001F30B',
    u':mont_fuji:': u'\U0001F5FB',
    u':camping:': u'\U0001F3D5\U0000FE0F',
    u':plage_avec_parasol:': u'\U0001F3D6\U0000FE0F',
    u':désert:': u'\U0001F3DC\U0000FE0F',
    u':île_déserte:': u'\U0001F3DD\U0000FE0F',
    u':parc_national:': u'\U0001F3DE\U0000FE0F',
    u':stade:': u'\U0001F3DF\U0000FE0F',
    u':monument_classique:': u'\U0001F3DB\U0000FE0F',
    u':construction_d’un_bâtiment:': u'\U0001F3D7\U0000FE0F',
    u':brique:': u'\U0001F9F1',
    u':rocher:': u'\U0001FAA8',
    u':bois:': u'\U0001FAB5',
    u':hutte:': u'\U0001F6D6',
    u':maisons:': u'\U0001F3D8\U0000FE0F',
    u':maison_abandonnée:': u'\U0001F3DA\U0000FE0F',
    u':pavillon:': u'\U0001F3E0',
    u':maison_avec_jardin:': u'\U0001F3E1',
    u':immeuble_de_bureaux:': u'\U0001F3E2',
    u':bureau_de_poste_japonais:': u'\U0001F3E3',
    u':bureau_de_poste:': u'\U0001F3E4',
    u':hôpital:': u'\U0001F3E5',
    u':banque:': u'\U0001F3E6',
    u':hôtel:': u'\U0001F3E8',
    u':love_hotel:': u'\U0001F3E9',
    u':supérette:': u'\U0001F3EA',
    u':école:': u'\U0001F3EB',
    u':grand_magasin:': u'\U0001F3EC',
    u':usine:': u'\U0001F3ED',
    u':château_japonais:': u'\U0001F3EF',
    u':château:': u'\U0001F3F0',
    u':mariage:': u'\U0001F492',
    u':tour_de_tokyo:': u'\U0001F5FC',
    u':statue_de_la_liberté:': u'\U0001F5FD',
    u':église:': u'\U000026EA',
    u':mosquée:': u'\U0001F54C',
    u':temple_hindou:': u'\U0001F6D5',
    u':synagogue:': u'\U0001F54D',
    u':sanctuaire_shinto:': u'\U000026E9\U0000FE0F',
    u':kaaba:': u'\U0001F54B',
    u':fontaine:': u'\U000026F2',
    u':tente:': u'\U000026FA',
    u':brume:': u'\U0001F301',
    u':nuit_étoilée:': u'\U0001F303',
    u':ville:': u'\U0001F3D9\U0000FE0F',
    u':soleil_levant_derrière_les_montagnes:': u'\U0001F304',
    u':soleil_levant:': u'\U0001F305',
    u':ville_au_crépuscule:': u'\U0001F306',
    u':coucher_de_soleil:': u'\U0001F307',
    u':pont_de_nuit:': u'\U0001F309',
    u':sources_chaudes:': u'\U00002668\U0000FE0F',
    u':cheval_de_manège:': u'\U0001F3A0',
    u':grande_roue:': u'\U0001F3A1',
    u':montagnes_russes:': u'\U0001F3A2',
    u':enseigne_de_barbier:': u'\U0001F488',
    u':chapiteau:': u'\U0001F3AA',
    u':locomotive:': u'\U0001F682',
    u':wagon:': u'\U0001F683',
    u':tgv:': u'\U0001F684',
    u':train_à_grande_vitesse:': u'\U0001F685',
    u':train:': u'\U0001F686',
    u':métro:': u'\U0001F687',
    u':métro_léger:': u'\U0001F688',
    u':gare:': u'\U0001F689',
    u':tramway:': u'\U0001F68A',
    u':monorail:': u'\U0001F69D',
    u':train_de_montagne:': u'\U0001F69E',
    u':wagon_de_tramway:': u'\U0001F68B',
    u':bus:': u'\U0001F68C',
    u':bus_de_face:': u'\U0001F68D',
    u':trolleybus:': u'\U0001F68E',
    u':minibus:': u'\U0001F690',
    u':ambulance:': u'\U0001F691',
    u':camion_de_pompier:': u'\U0001F692',
    u':voiture_de_police:': u'\U0001F693',
    u':voiture_de_police_de_face:': u'\U0001F694',
    u':taxi:': u'\U0001F695',
    u':taxi_de_face:': u'\U0001F696',
    u':voiture:': u'\U0001F697',
    u':voiture_de_face:': u'\U0001F698',
    u':véhicule_utilitaire_sport:': u'\U0001F699',
    u':pick-up:': u'\U0001F6FB',
    u':camion_de_livraison:': u'\U0001F69A',
    u':semi-remorque:': u'\U0001F69B',
    u':tracteur:': u'\U0001F69C',
    u':voiture_de_course:': u'\U0001F3CE\U0000FE0F',
    u':moto:': u'\U0001F3CD\U0000FE0F',
    u':scooter:': u'\U0001F6F5',
    u':fauteuil_roulant_manuel:': u'\U0001F9BD',
    u':fauteuil_motorisé:': u'\U0001F9BC',
    u':tuk_tuk:': u'\U0001F6FA',
    u':vélo:': u'\U0001F6B2',
    u':trottinette:': u'\U0001F6F4',
    u':planche_à_roulettes:': u'\U0001F6F9',
    u':patin_à_roulettes:': u'\U0001F6FC',
    u':arrêt_de_bus:': u'\U0001F68F',
    u':autoroute:': u'\U0001F6E3\U0000FE0F',
    u':voie_ferrée:': u'\U0001F6E4\U0000FE0F',
    u':baril_de_pétrole:': u'\U0001F6E2\U0000FE0F',
    u':pompe_à_essence:': u'\U000026FD',
    u':gyrophare:': u'\U0001F6A8',
    u':feu_tricolore_horizontal:': u'\U0001F6A5',
    u':feu_tricolore_vertical:': u'\U0001F6A6',
    u':stop:': u'\U0001F6D1',
    u':travaux:': u'\U0001F6A7',
    u':ancre:': u'\U00002693',
    u':voilier:': u'\U000026F5',
    u':canoë:': u'\U0001F6F6',
    u':hors-bord:': u'\U0001F6A4',
    u':paquebot:': u'\U0001F6F3\U0000FE0F',
    u':ferry:': u'\U000026F4\U0000FE0F',
    u':bateau_à_moteur:': u'\U0001F6E5\U0000FE0F',
    u':navire:': u'\U0001F6A2',
    u':avion:': u'\U00002708\U0000FE0F',
    u':petit_avion:': u'\U0001F6E9\U0000FE0F',
    u':avion_au_décollage:': u'\U0001F6EB',
    u':avion_à_l’atterrissage:': u'\U0001F6EC',
    u':parachute:': u'\U0001FA82',
    u':siège:': u'\U0001F4BA',
    u':hélicoptère:': u'\U0001F681',
    u':train_suspendu:': u'\U0001F69F',
    u':téléphérique:': u'\U0001F6A0',
    u':tramway_aérien:': u'\U0001F6A1',
    u':satellite:': u'\U0001F6F0\U0000FE0F',
    u':fusée:': u'\U0001F680',
    u':soucoupe_volante:': u'\U0001F6F8',
    u':cloche_de_comptoir:': u'\U0001F6CE\U0000FE0F',
    u':bagage:': u'\U0001F9F3',
    u':sablier:': u'\U0000231B',
    u':sablier_avec_sable_qui_coule:': u'\U000023F3',
    u':montre:': u'\U0000231A',
    u':réveil:': u'\U000023F0',
    u':chronomètre:': u'\U000023F1\U0000FE0F',
    u':horloge:': u'\U000023F2\U0000FE0F',
    u':pendule:': u'\U0001F570\U0000FE0F',
    u':midi/minuit:': u'\U0001F55B',
    u':midi/minuit_et_demie:': u'\U0001F567',
    u':une_heure:': u'\U0001F550',
    u':une_heure_et_demie:': u'\U0001F55C',
    u':deux_heures:': u'\U0001F551',
    u':deux_heures_et_demie:': u'\U0001F55D',
    u':trois_heures:': u'\U0001F552',
    u':trois_heures_et_demie:': u'\U0001F55E',
    u':quatre_heures:': u'\U0001F553',
    u':quatre_heures_et_demie:': u'\U0001F55F',
    u':cinq_heures:': u'\U0001F554',
    u':cinq_heures_et_demie:': u'\U0001F560',
    u':six_heures:': u'\U0001F555',
    u':six_heures_et_demie:': u'\U0001F561',
    u':sept_heures:': u'\U0001F556',
    u':sept_heures_et_demie:': u'\U0001F562',
    u':huit_heures:': u'\U0001F557',
    u':huit_heures_et_demie:': u'\U0001F563',
    u':neuf_heures:': u'\U0001F558',
    u':neuf_heures_et_demie:': u'\U0001F564',
    u':dix_heures:': u'\U0001F559',
    u':dix_heures_et_demie:': u'\U0001F565',
    u':onze_heures:': u'\U0001F55A',
    u':onze_heures_et_demie:': u'\U0001F566',
    u':nouvelle_lune:': u'\U0001F311',
    u':lune_croissante:': u'\U0001F312',
    u':premier_quartier_de_lune:': u'\U0001F313',
    u':lune_gibbeuse_croissante:': u'\U0001F314',
    u':pleine_lune:': u'\U0001F315',
    u':lune_gibbeuse_décroissante:': u'\U0001F316',
    u':dernier_quartier:': u'\U0001F317',
    u':lune_décroissante:': u'\U0001F318',
    u':croissant_de_lune:': u'\U0001F319',
    u':nouvelle_lune_avec_visage:': u'\U0001F31A',
    u':premier_quartier_de_lune_avec_visage:': u'\U0001F31B',
    u':dernier_quartier_de_lune_avec_visage:': u'\U0001F31C',
    u':thermomètre:': u'\U0001F321\U0000FE0F',
    u':soleil:': u'\U00002600\U0000FE0F',
    u':pleine_lune_avec_visage:': u'\U0001F31D',
    u':soleil_avec_visage:': u'\U0001F31E',
    u':planète_à_anneaux:': u'\U0001FA90',
    u':étoile:': u'\U00002B50',
    u':étoile_brillante:': u'\U0001F31F',
    u':étoile_filante:': u'\U0001F320',
    u':voie_lactée:': u'\U0001F30C',
    u':nuage:': u'\U00002601\U0000FE0F',
    u':soleil_derrière_les_nuages:': u'\U000026C5',
    u':nuage_avec_éclair_et_pluie:': u'\U000026C8\U0000FE0F',
    u':soleil_derrière_un_petit_nuage:': u'\U0001F324\U0000FE0F',
    u':soleil_derrière_un_gros_nuage:': u'\U0001F325\U0000FE0F',
    u':soleil_derrière_un_nuage_de_pluie:': u'\U0001F326\U0000FE0F',
    u':nuage_avec_pluie:': u'\U0001F327\U0000FE0F',
    u':nuage_avec_neige:': u'\U0001F328\U0000FE0F',
    u':nuage_avec_éclair:': u'\U0001F329\U0000FE0F',
    u':tornade:': u'\U0001F32A\U0000FE0F',
    u':brouillard:': u'\U0001F32B\U0000FE0F',
    u':vent_avec_visage:': u'\U0001F32C\U0000FE0F',
    u':cyclone:': u'\U0001F300',
    u':arc-en-ciel:': u'\U0001F308',
    u':parapluie_fermé:': u'\U0001F302',
    u':parapluie_ouvert:': u'\U00002602\U0000FE0F',
    u':parapluie_avec_gouttes_de_pluie:': u'\U00002614',
    u':parasol_sur_le_sol:': u'\U000026F1\U0000FE0F',
    u':symbole_de_haute_tension:': u'\U000026A1',
    u':flocon:': u'\U00002744\U0000FE0F',
    u':bonhomme_de_neige:': u'\U00002603\U0000FE0F',
    u':bonhomme_de_neige_sans_neige:': u'\U000026C4',
    u':comète:': u'\U00002604\U0000FE0F',
    u':feu:': u'\U0001F525',
    u':goutte_d’eau:': u'\U0001F4A7',
    u':vague:': u'\U0001F30A',
    u':citrouille:': u'\U0001F383',
    u':sapin_de_noël:': u'\U0001F384',
    u':feu_d’artifice:': u'\U0001F386',
    u':cierge_magique:': u'\U0001F387',
    u':pétard:': u'\U0001F9E8',
    u':étincelles:': u'\U00002728',
    u':ballon_gonflable:': u'\U0001F388',
    u':cotillons:': u'\U0001F389',
    u':confettis:': u'\U0001F38A',
    u':arbre_à_vœux:': u'\U0001F38B',
    u':bambou_décoratif:': u'\U0001F38D',
    u':poupées_japonaises:': u'\U0001F38E',
    u':koinobori:': u'\U0001F38F',
    u':carillon_éolien:': u'\U0001F390',
    u':cérémonie_de_la_lune:': u'\U0001F391',
    u':enveloppe_rouge:': u'\U0001F9E7',
    u':ruban:': u'\U0001F380',
    u':cadeau:': u'\U0001F381',
    u':ruban_de_mémoire:': u'\U0001F397\U0000FE0F',
    u':billet_d’entrée:': u'\U0001F39F\U0000FE0F',
    u':billet:': u'\U0001F3AB',
    u':médaille_militaire:': u'\U0001F396\U0000FE0F',
    u':trophée:': u'\U0001F3C6',
    u':médaille_sportive:': u'\U0001F3C5',
    u':médaille_d’or:': u'\U0001F947',
    u':médaille_d’argent:': u'\U0001F948',
    u':médaille_de_bronze:': u'\U0001F949',
    u':ballon_de_football:': u'\U000026BD',
    u':baseball:': u'\U000026BE',
    u':softball:': u'\U0001F94E',
    u':basket:': u'\U0001F3C0',
    u':volley-ball:': u'\U0001F3D0',
    u':football_américain:': u'\U0001F3C8',
    u':rugby:': u'\U0001F3C9',
    u':tennis:': u'\U0001F3BE',
    u':disque-volant:': u'\U0001F94F',
    u':bowling:': u'\U0001F3B3',
    u':cricket:': u'\U0001F3CF',
    u':hockey_sur_gazon:': u'\U0001F3D1',
    u':hockey_sur_glace:': u'\U0001F3D2',
    u':crosse:': u'\U0001F94D',
    u':ping-pong:': u'\U0001F3D3',
    u':badminton:': u'\U0001F3F8',
    u':gant_de_boxe:': u'\U0001F94A',
    u':tenue_d’arts_martiaux:': u'\U0001F94B',
    u':cage:': u'\U0001F945',
    u':drapeau_de_golf:': u'\U000026F3',
    u':patin_à_glace:': u'\U000026F8\U0000FE0F',
    u':pêche_à_la_ligne:': u'\U0001F3A3',
    u':masque_de_plongée:': u'\U0001F93F',
    u':maillot_de_course:': u'\U0001F3BD',
    u':ski:': u'\U0001F3BF',
    u':luge:': u'\U0001F6F7',
    u':pierre_de_curling:': u'\U0001F94C',
    u':dans_le_mille:': u'\U0001F3AF',
    u':yoyo:': u'\U0001FA80',
    u':cerf-volant:': u'\U0001FA81',
    u':billard:': u'\U0001F3B1',
    u':boule_de_cristal:': u'\U0001F52E',
    u':baguette_magique:': u'\U0001FA84',
    u':mauvais_œil:': u'\U0001F9FF',
    u':jeu_vidéo:': u'\U0001F3AE',
    u':manette_de_jeu:': u'\U0001F579\U0000FE0F',
    u':machine_à_sous:': u'\U0001F3B0',
    u':dés:': u'\U0001F3B2',
    u':pièce_de_puzzle:': u'\U0001F9E9',
    u':ours_en_peluche:': u'\U0001F9F8',
    u':piñata:': u'\U0001FA85',
    u':poupées_russes:': u'\U0001FA86',
    u':pique:': u'\U00002660\U0000FE0F',
    u':cœur_cartes:': u'\U00002665\U0000FE0F',
    u':carreau:': u'\U00002666\U0000FE0F',
    u':trèfle_cartes:': u'\U00002663\U0000FE0F',
    u':pion_d’échec:': u'\U0000265F\U0000FE0F',
    u':carte_joker:': u'\U0001F0CF',
    u':dragon_rouge_mahjong:': u'\U0001F004',
    u':jeu_des_fleurs:': u'\U0001F3B4',
    u':spectacle_vivant:': u'\U0001F3AD',
    u':cadre_avec_image:': u'\U0001F5BC\U0000FE0F',
    u':palette_de_peinture:': u'\U0001F3A8',
    u':bobine_de_fil:': u'\U0001F9F5',
    u':aiguille_à_coudre:': u'\U0001FAA1',
    u':fil:': u'\U0001F9F6',
    u':nœud:': u'\U0001FAA2',
    u':lunettes_de_vue:': u'\U0001F453',
    u':lunettes_de_soleil:': u'\U0001F576\U0000FE0F',
    u':lunettes:': u'\U0001F97D',
    u':blouse_blanche:': u'\U0001F97C',
    u':gilet_de_sécurité:': u'\U0001F9BA',
    u':cravate:': u'\U0001F454',
    u':t-shirt:': u'\U0001F455',
    u':jean:': u'\U0001F456',
    u':foulard:': u'\U0001F9E3',
    u':gants:': u'\U0001F9E4',
    u':manteau:': u'\U0001F9E5',
    u':chaussettes:': u'\U0001F9E6',
    u':robe:': u'\U0001F457',
    u':kimono:': u'\U0001F458',
    u':sari:': u'\U0001F97B',
    u':maillot_de_bain_une_pièce:': u'\U0001FA71',
    u':slip:': u'\U0001FA72',
    u':short:': u'\U0001FA73',
    u':bikini:': u'\U0001F459',
    u':vêtements_de_femme:': u'\U0001F45A',
    u':porte-monnaie:': u'\U0001F45B',
    u':sac_à_main:': u'\U0001F45C',
    u':pochette:': u'\U0001F45D',
    u':sacs_de_shopping:': u'\U0001F6CD\U0000FE0F',
    u':cartable:': u'\U0001F392',
    u':tong:': u'\U0001FA74',
    u':chaussure_d’homme:': u'\U0001F45E',
    u':chaussure_de_sport:': u'\U0001F45F',
    u':chaussure_de_randonnée:': u'\U0001F97E',
    u':chaussure_plate:': u'\U0001F97F',
    u':chaussure_à_talon_haut:': u'\U0001F460',
    u':sandale_de_femme:': u'\U0001F461',
    u':chaussons_de_danse:': u'\U0001FA70',
    u':botte_de_femme:': u'\U0001F462',
    u':couronne:': u'\U0001F451',
    u':chapeau_de_femme:': u'\U0001F452',
    u':haut_de_forme:': u'\U0001F3A9',
    u':toque_universitaire:': u'\U0001F393',
    u':casquette_américaine:': u'\U0001F9E2',
    u':casque_militaire:': u'\U0001FA96',
    u':casque_de_secouriste:': u'\U000026D1\U0000FE0F',
    u':chapelet:': u'\U0001F4FF',
    u':rouge_à_lèvres:': u'\U0001F484',
    u':bague:': u'\U0001F48D',
    u':pierre_précieuse:': u'\U0001F48E',
    u':muet:': u'\U0001F507',
    u':volume_des_enceintes_faible:': u'\U0001F508',
    u':volume_des_enceintes_moyen:': u'\U0001F509',
    u':volume_des_enceintes_élevé:': u'\U0001F50A',
    u':haut-parleur:': u'\U0001F4E2',
    u':porte-voix:': u'\U0001F4E3',
    u':cor_postal:': u'\U0001F4EF',
    u':cloche:': u'\U0001F514',
    u':alarme_désactivée:': u'\U0001F515',
    u':partition:': u'\U0001F3BC',
    u':note_de_musique:': u'\U0001F3B5',
    u':notes_de_musique:': u'\U0001F3B6',
    u':micro_de_studio:': u'\U0001F399\U0000FE0F',
    u':curseur_de_niveau:': u'\U0001F39A\U0000FE0F',
    u':boutons_de_réglage:': u'\U0001F39B\U0000FE0F',
    u':micro:': u'\U0001F3A4',
    u':casque:': u'\U0001F3A7',
    u':radio:': u'\U0001F4FB',
    u':saxophone:': u'\U0001F3B7',
    u':accordéon:': u'\U0001FA97',
    u':guitare:': u'\U0001F3B8',
    u':piano:': u'\U0001F3B9',
    u':trompette:': u'\U0001F3BA',
    u':violon:': u'\U0001F3BB',
    u':banjo:': u'\U0001FA95',
    u':batterie:': u'\U0001F941',
    u':djembé:': u'\U0001FA98',
    u':téléphone_portable:': u'\U0001F4F1',
    u':appel_entrant:': u'\U0001F4F2',
    u':téléphone:': u'\U0000260E\U0000FE0F',
    u':combiné_téléphonique:': u'\U0001F4DE',
    u':bipeur:': u'\U0001F4DF',
    u':fax:': u'\U0001F4E0',
    u':pile:': u'\U0001F50B',
    u':câble_avec_fiche_électrique:': u'\U0001F50C',
    u':ordinateur_portable:': u'\U0001F4BB',
    u':ordinateur_de_bureau:': u'\U0001F5A5\U0000FE0F',
    u':imprimante:': u'\U0001F5A8\U0000FE0F',
    u':clavier:': u'\U00002328\U0000FE0F',
    u':souris_d’ordinateur:': u'\U0001F5B1\U0000FE0F',
    u':boule_de_commande:': u'\U0001F5B2\U0000FE0F',
    u':disque_d’ordinateur:': u'\U0001F4BD',
    u':disquette:': u'\U0001F4BE',
    u':cd:': u'\U0001F4BF',
    u':dvd:': u'\U0001F4C0',
    u':abaque:': u'\U0001F9EE',
    u':caméra:': u'\U0001F3A5',
    u':pellicule:': u'\U0001F39E\U0000FE0F',
    u':projecteur_cinématographique:': u'\U0001F4FD\U0000FE0F',
    u':clap:': u'\U0001F3AC',
    u':téléviseur:': u'\U0001F4FA',
    u':appareil_photo:': u'\U0001F4F7',
    u':appareil_photo_avec_flash:': u'\U0001F4F8',
    u':caméscope:': u'\U0001F4F9',
    u':cassette_vidéo:': u'\U0001F4FC',
    u':loupe_orientée_à_gauche:': u'\U0001F50D',
    u':loupe_orientée_à_droite:': u'\U0001F50E',
    u':bougie:': u'\U0001F56F\U0000FE0F',
    u':ampoule:': u'\U0001F4A1',
    u':torche:': u'\U0001F526',
    u':lampion_rouge:': u'\U0001F3EE',
    u':diya:': u'\U0001FA94',
    u':carnet_avec_couverture:': u'\U0001F4D4',
    u':livre_fermé:': u'\U0001F4D5',
    u':livre_ouvert:': u'\U0001F4D6',
    u':livre_vert:': u'\U0001F4D7',
    u':livre_bleu:': u'\U0001F4D8',
    u':livre_orange:': u'\U0001F4D9',
    u':livres:': u'\U0001F4DA',
    u':carnet:': u'\U0001F4D3',
    u':carnet_de_compte:': u'\U0001F4D2',
    u':page_enroulée:': u'\U0001F4C3',
    u':parchemin:': u'\U0001F4DC',
    u':page:': u'\U0001F4C4',
    u':journal:': u'\U0001F4F0',
    u':journal_roulé:': u'\U0001F5DE\U0000FE0F',
    u':signets:': u'\U0001F4D1',
    u':marque-page:': u'\U0001F516',
    u':étiquette:': u'\U0001F3F7\U0000FE0F',
    u':sac_plein_d’argent:': u'\U0001F4B0',
    u':pièce:': u'\U0001FA99',
    u':billet_en_yens:': u'\U0001F4B4',
    u':billet_en_dollars:': u'\U0001F4B5',
    u':billet_en_euros:': u'\U0001F4B6',
    u':billet_en_livres:': u'\U0001F4B7',
    u':billet_avec_des_ailes:': u'\U0001F4B8',
    u':carte_bancaire:': u'\U0001F4B3',
    u':reçu:': u'\U0001F9FE',
    u':courbe_avec_yen_en_hausse:': u'\U0001F4B9',
    u':enveloppe:': u'\U00002709\U0000FE0F',
    u':e-mail:': u'\U0001F4E7',
    u':message_reçu:': u'\U0001F4E8',
    u':enveloppe_avec_flèche:': u'\U0001F4E9',
    u':boîte_d’envoi:': u'\U0001F4E4',
    u':boîte_de_réception:': u'\U0001F4E5',
    u':colis:': u'\U0001F4E6',
    u':boîte_aux_lettres_fermée_drapeau_levé:': u'\U0001F4EB',
    u':boîte_aux_lettres_fermée_drapeau_baissé:': u'\U0001F4EA',
    u':boîte_aux_lettres_ouverte_drapeau_levé:': u'\U0001F4EC',
    u':boîte_aux_lettres_ouverte_drapeau_baissé:': u'\U0001F4ED',
    u':boîte_aux_lettres:': u'\U0001F4EE',
    u':urne_électorale:': u'\U0001F5F3\U0000FE0F',
    u':crayon:': u'\U0000270F\U0000FE0F',
    u':stylo_plume_noir:': u'\U00002712\U0000FE0F',
    u':stylo_plume:': u'\U0001F58B\U0000FE0F',
    u':stylo:': u'\U0001F58A\U0000FE0F',
    u':pinceau:': u'\U0001F58C\U0000FE0F',
    u':crayon_pastel:': u'\U0001F58D\U0000FE0F',
    u':mémo:': u'\U0001F4DD',
    u':porte-documents:': u'\U0001F4BC',
    u':dossier:': u'\U0001F4C1',
    u':dossier_ouvert:': u'\U0001F4C2',
    u':intercalaires:': u'\U0001F5C2\U0000FE0F',
    u':calendrier:': u'\U0001F4C5',
    u':éphéméride:': u'\U0001F4C6',
    u':bloc-notes_à_spirale:': u'\U0001F5D2\U0000FE0F',
    u':calendrier_à_spirale:': u'\U0001F5D3\U0000FE0F',
    u':carnet_d’adresses:': u'\U0001F4C7',
    u':graphique_en_hausse:': u'\U0001F4C8',
    u':graphique_en_baisse:': u'\U0001F4C9',
    u':graphiques_à_barres:': u'\U0001F4CA',
    u':porte-bloc:': u'\U0001F4CB',
    u':punaise:': u'\U0001F4CC',
    u':épingle:': u'\U0001F4CD',
    u':trombone:': u'\U0001F4CE',
    u':trombones:': u'\U0001F587\U0000FE0F',
    u':règle:': u'\U0001F4CF',
    u':équerre:': u'\U0001F4D0',
    u':ciseaux:': u'\U00002702\U0000FE0F',
    u':boîte_à_dossiers:': u'\U0001F5C3\U0000FE0F',
    u':meuble_à_dossiers:': u'\U0001F5C4\U0000FE0F',
    u':corbeille_à_papiers:': u'\U0001F5D1\U0000FE0F',
    u':cadenas_fermé:': u'\U0001F512',
    u':cadenas_ouvert:': u'\U0001F513',
    u':cadenas_fermé_avec_stylo:': u'\U0001F50F',
    u':cadenas_fermé_avec_clé:': u'\U0001F510',
    u':clé:': u'\U0001F511',
    u':clé_ancienne:': u'\U0001F5DD\U0000FE0F',
    u':marteau:': u'\U0001F528',
    u':hache:': u'\U0001FA93',
    u':pioche:': u'\U000026CF\U0000FE0F',
    u':marteau_et_pioche:': u'\U00002692\U0000FE0F',
    u':marteau_et_clé_à_molette:': u'\U0001F6E0\U0000FE0F',
    u':dague:': u'\U0001F5E1\U0000FE0F',
    u':épées_croisées:': u'\U00002694\U0000FE0F',
    u':pistolet:': u'\U0001F52B',
    u':boomerang:': u'\U0001FA83',
    u':arc_et_flèche:': u'\U0001F3F9',
    u':bouclier:': u'\U0001F6E1\U0000FE0F',
    u':scie:': u'\U0001FA9A',
    u':clé_à_molette:': u'\U0001F527',
    u':tournevis:': u'\U0001FA9B',
    u':vis_et_écrou:': u'\U0001F529',
    u':roue_dentée:': u'\U00002699\U0000FE0F',
    u':serre-joint:': u'\U0001F5DC\U0000FE0F',
    u':balance_à_poids:': u'\U00002696\U0000FE0F',
    u':canne_blanche:': u'\U0001F9AF',
    u':chaînons:': u'\U0001F517',
    u':chaînes:': u'\U000026D3\U0000FE0F',
    u':crochet:': u'\U0001FA9D',
    u':boîte_à_outils:': u'\U0001F9F0',
    u':aimant:': u'\U0001F9F2',
    u':échelle:': u'\U0001FA9C',
    u':alambic:': u'\U00002697\U0000FE0F',
    u':tube_à_essai:': u'\U0001F9EA',
    u':boîte_de_pétri:': u'\U0001F9EB',
    u':adn:': u'\U0001F9EC',
    u':microscope:': u'\U0001F52C',
    u':télescope:': u'\U0001F52D',
    u':antenne_satellite:': u'\U0001F4E1',
    u':seringue:': u'\U0001F489',
    u':goutte_de_sang:': u'\U0001FA78',
    u':pilule:': u'\U0001F48A',
    u':sparadrap:': u'\U0001FA79',
    u':stéthoscope:': u'\U0001FA7A',
    u':porte:': u'\U0001F6AA',
    u':ascenseur:': u'\U0001F6D7',
    u':miroir:': u'\U0001FA9E',
    u':fenêtre:': u'\U0001FA9F',
    u':lit:': u'\U0001F6CF\U0000FE0F',
    u':canapé_et_lampe:': u'\U0001F6CB\U0000FE0F',
    u':chaise:': u'\U0001FA91',
    u':toilettes:': u'\U0001F6BD',
    u':ventouse:': u'\U0001FAA0',
    u':douche:': u'\U0001F6BF',
    u':baignoire:': u'\U0001F6C1',
    u':tapette_à_souris:': u'\U0001FAA4',
    u':rasoir:': u'\U0001FA92',
    u':bouteille_de_lotion:': u'\U0001F9F4',
    u':épingle_de_sûreté:': u'\U0001F9F7',
    u':balai:': u'\U0001F9F9',
    u':panier:': u'\U0001F9FA',
    u':rouleau_de_papier:': u'\U0001F9FB',
    u':seau:': u'\U0001FAA3',
    u':savon:': u'\U0001F9FC',
    u':brosse_à_dents:': u'\U0001FAA5',
    u':éponge:': u'\U0001F9FD',
    u':extincteur:': u'\U0001F9EF',
    u':chariot:': u'\U0001F6D2',
    u':cigarette:': u'\U0001F6AC',
    u':cercueil:': u'\U000026B0\U0000FE0F',
    u':pierre_tombale:': u'\U0001FAA6',
    u':urne_funéraire:': u'\U000026B1\U0000FE0F',
    u':moai:': u'\U0001F5FF',
    u':pancarte:': u'\U0001FAA7',
    u':distributeur_de_billets:': u'\U0001F3E7',
    u':icône_poubelle:': u'\U0001F6AE',
    u':eau_potable:': u'\U0001F6B0',
    u':symbole_accès_handicapés:': u'\U0000267F',
    u':symbole_toilettes_hommes:': u'\U0001F6B9',
    u':symbole_toilettes_femmes:': u'\U0001F6BA',
    u':panneau_toilettes:': u'\U0001F6BB',
    u':symbole_bébé:': u'\U0001F6BC',
    u':wc:': u'\U0001F6BE',
    u':contrôle_des_passeports:': u'\U0001F6C2',
    u':douane:': u'\U0001F6C3',
    u':retrait_des_bagages:': u'\U0001F6C4',
    u':consigne:': u'\U0001F6C5',
    u':symbole_d’avertissement:': u'\U000026A0\U0000FE0F',
    u':traversée_d’enfants:': u'\U0001F6B8',
    u':sens_interdit:': u'\U000026D4',
    u':symbole_d’interdiction:': u'\U0001F6AB',
    u':vélos_interdits:': u'\U0001F6B3',
    u':interdiction_de_fumer:': u'\U0001F6AD',
    u':dépôt_d’ordures_interdit:': u'\U0001F6AF',
    u':eau_non_potable:': u'\U0001F6B1',
    u':interdit_aux_piétons:': u'\U0001F6B7',
    u':téléphones_portables_interdits:': u'\U0001F4F5',
    u':18_ans_et_plus:': u'\U0001F51E',
    u':radioactif:': u'\U00002622\U0000FE0F',
    u':danger_biologique:': u'\U00002623\U0000FE0F',
    u':flèche_haut:': u'\U00002B06\U0000FE0F',
    u':flèche_haut_droite:': u'\U00002197\U0000FE0F',
    u':flèche_droite:': u'\U000027A1\U0000FE0F',
    u':flèche_bas_droite:': u'\U00002198\U0000FE0F',
    u':flèche_bas:': u'\U00002B07\U0000FE0F',
    u':flèche_bas_gauche:': u'\U00002199\U0000FE0F',
    u':flèche_gauche:': u'\U00002B05\U0000FE0F',
    u':flèche_haut_gauche:': u'\U00002196\U0000FE0F',
    u':flèche_haut_bas:': u'\U00002195\U0000FE0F',
    u':flèche_gauche_droite:': u'\U00002194\U0000FE0F',
    u':flèche_courbe_gauche:': u'\U000021A9\U0000FE0F',
    u':flèche_courbe_droite:': u'\U000021AA\U0000FE0F',
    u':flèche_courbe_haut:': u'\U00002934\U0000FE0F',
    u':flèche_courbe_bas:': u'\U00002935\U0000FE0F',
    u':flèches_dans_le_sens_horaire:': u'\U0001F503',
    u':flèches_dans_le_sens_antihoraire:': u'\U0001F504',
    u':flèche_retour:': u'\U0001F519',
    u':flèche_fin:': u'\U0001F51A',
    u':flèche_activé:': u'\U0001F51B',
    u':flèche_bientôt:': u'\U0001F51C',
    u':flèche_en_haut:': u'\U0001F51D',
    u':lieu_de_culte:': u'\U0001F6D0',
    u':symbole_de_l’atome:': u'\U0000269B\U0000FE0F',
    u':om:': u'\U0001F549\U0000FE0F',
    u':étoile_de_david:': u'\U00002721\U0000FE0F',
    u':roue_du_dharma:': u'\U00002638\U0000FE0F',
    u':yin_yang:': u'\U0000262F\U0000FE0F',
    u':croix_latine:': u'\U0000271D\U0000FE0F',
    u':croix_orthodoxe:': u'\U00002626\U0000FE0F',
    u':lune_et_étoile:': u'\U0000262A\U0000FE0F',
    u':symbole_de_paix:': u'\U0000262E\U0000FE0F',
    u':chandelier_à_sept_branches:': u'\U0001F54E',
    u':étoile_à_6_branches:': u'\U0001F52F',
    u':bélier_zodiaque:': u'\U00002648',
    u':taureau:': u'\U00002649',
    u':gémeaux:': u'\U0000264A',
    u':cancer:': u'\U0000264B',
    u':lion:': u'\U0000264C',
    u':vierge:': u'\U0000264D',
    u':balance:': u'\U0000264E',
    u':scorpion_zodiaque:': u'\U0000264F',
    u':sagittaire:': u'\U00002650',
    u':capricorne:': u'\U00002651',
    u':verseau:': u'\U00002652',
    u':poissons:': u'\U00002653',
    u':serpentaire:': u'\U000026CE',
    u':bouton_lecture_aléatoire:': u'\U0001F500',
    u':bouton_répétition:': u'\U0001F501',
    u':bouton_répétition_de_la_piste:': u'\U0001F502',
    u':bouton_lecture:': u'\U000025B6\U0000FE0F',
    u':bouton_avance_rapide:': u'\U000023E9',
    u':bouton_piste_suivante:': u'\U000023ED\U0000FE0F',
    u':bouton_lecture/pause:': u'\U000023EF\U0000FE0F',
    u':bouton_retour:': u'\U000025C0\U0000FE0F',
    u':bouton_retour_rapide:': u'\U000023EA',
    u':bouton_piste_précédente:': u'\U000023EE\U0000FE0F',
    u':petit_triangle_haut:': u'\U0001F53C',
    u':double_flèche_vers_le_haut:': u'\U000023EB',
    u':petit_triangle_bas:': u'\U0001F53D',
    u':double_flèche_vers_le_bas:': u'\U000023EC',
    u':bouton_pause:': u'\U000023F8\U0000FE0F',
    u':bouton_stop:': u'\U000023F9\U0000FE0F',
    u':bouton_enregistrer:': u'\U000023FA\U0000FE0F',
    u':bouton_éjecter:': u'\U000023CF\U0000FE0F',
    u':cinéma:': u'\U0001F3A6',
    u':luminosité_faible:': u'\U0001F505',
    u':luminosité_élevée:': u'\U0001F506',
    u':barres_de_réseau:': u'\U0001F4F6',
    u':mode_vibreur:': u'\U0001F4F3',
    u':téléphone_éteint:': u'\U0001F4F4',
    u':symbole_de_la_femme:': u'\U00002640\U0000FE0F',
    u':symbole_de_l’homme:': u'\U00002642\U0000FE0F',
    u':symbole_de_la_communauté_transgenre:': u'\U000026A7\U0000FE0F',
    u':signe_multiplier:': u'\U00002716\U0000FE0F',
    u':signe_plus:': u'\U00002795',
    u':signe_moins:': u'\U00002796',
    u':signe_diviser:': u'\U00002797',
    u':infini:': u'\U0000267E\U0000FE0F',
    u':double_point_d’exclamation:': u'\U0000203C\U0000FE0F',
    u':points_d’exclamation_et_d’interrogation:': u'\U00002049\U0000FE0F',
    u':point_d’interrogation:': u'\U00002753',
    u':point_d’interrogation_blanc:': u'\U00002754',
    u':point_d’exclamation_blanc:': u'\U00002755',
    u':point_d’exclamation:': u'\U00002757',
    u':ligne_ondulée:': u'\U00003030\U0000FE0F',
    u':conversion_de_devise:': u'\U0001F4B1',
    u':dollar:': u'\U0001F4B2',
    u':caducée:': u'\U00002695\U0000FE0F',
    u':symbole_recyclage:': u'\U0000267B\U0000FE0F',
    u':fleur_de_lys:': u'\U0000269C\U0000FE0F',
    u':trident:': u'\U0001F531',
    u':badge_nominatif:': u'\U0001F4DB',
    u':symbole_japonais_de_débutant:': u'\U0001F530',
    u':cercle_rouge:': u'\U00002B55',
    u':bouton_coché:': u'\U00002705',
    u':case_cochée:': u'\U00002611\U0000FE0F',
    u':coche:': u'\U00002714\U0000FE0F',
    u':croix:': u'\U0000274C',
    u':bouton_croix:': u'\U0000274E',
    u':boucle:': u'\U000027B0',
    u':double_boucle:': u'\U000027BF',
    u':alternance:': u'\U0000303D\U0000FE0F',
    u':astérisque_huit_branches:': u'\U00002733\U0000FE0F',
    u':étoile_huit_branches:': u'\U00002734\U0000FE0F',
    u':éclat:': u'\U00002747\U0000FE0F',
    u':symbole_copyright:': u'\U000000A9\U0000FE0F',
    u':marque_déposée:': u'\U000000AE\U0000FE0F',
    u':marque_commerciale_déposée:': u'\U00002122\U0000FE0F',
    u':touches_#:': u'\U00000023\U0000FE0F\U000020E3',
    u':touches_*:': u'\U0000002A\U0000FE0F\U000020E3',
    u':touches_0:': u'\U00000030\U0000FE0F\U000020E3',
    u':touches_1:': u'\U00000031\U0000FE0F\U000020E3',
    u':touches_2:': u'\U00000032\U0000FE0F\U000020E3',
    u':touches_3:': u'\U00000033\U0000FE0F\U000020E3',
    u':touches_4:': u'\U00000034\U0000FE0F\U000020E3',
    u':touches_5:': u'\U00000035\U0000FE0F\U000020E3',
    u':touches_6:': u'\U00000036\U0000FE0F\U000020E3',
    u':touches_7:': u'\U00000037\U0000FE0F\U000020E3',
    u':touches_8:': u'\U00000038\U0000FE0F\U000020E3',
    u':touches_9:': u'\U00000039\U0000FE0F\U000020E3',
    u':touches_10:': u'\U0001F51F',
    u':majuscules:': u'\U0001F520',
    u':minuscules:': u'\U0001F521',
    u':saisie_de_chiffres:': u'\U0001F522',
    u':saisie_de_symboles:': u'\U0001F523',
    u':alphabet_latin:': u'\U0001F524',
    u':groupe_sanguin_a:': u'\U0001F170\U0000FE0F',
    u':groupe_sanguin_ab:': u'\U0001F18E',
    u':groupe_sanguin_b:': u'\U0001F171\U0000FE0F',
    u':bouton_effacer:': u'\U0001F191',
    u':bouton_cool:': u'\U0001F192',
    u':bouton_gratuit:': u'\U0001F193',
    u':source_d’informations:': u'\U00002139\U0000FE0F',
    u':bouton_identifiant:': u'\U0001F194',
    u':m_encerclé:': u'\U000024C2\U0000FE0F',
    u':bouton_nouveau:': u'\U0001F195',
    u':bouton_pas_bien:': u'\U0001F196',
    u':groupe_sanguin_o:': u'\U0001F17E\U0000FE0F',
    u':bouton_ok:': u'\U0001F197',
    u':bouton_p:': u'\U0001F17F\U0000FE0F',
    u':bouton_sos:': u'\U0001F198',
    u':bouton_vers_le_haut:': u'\U0001F199',
    u':bouton_vs:': u'\U0001F19A',
    u':bouton_ici_en_japonais:': u'\U0001F201',
    u':bouton_frais_de_service_en_japonais:': u'\U0001F202\U0000FE0F',
    u':bouton_montant_mensuel_en_japonais:': u'\U0001F237\U0000FE0F',
    u':bouton_pas_gratuit_en_japonais:': u'\U0001F236',
    u':bouton_réservé_en_japonais:': u'\U0001F22F',
    u':bouton_bonne_affaire_en_japonais:': u'\U0001F250',
    u':bouton_réduction_en_japonais:': u'\U0001F239',
    u':bouton_gratuit_en_japonais:': u'\U0001F21A',
    u':bouton_interdit_en_japonais:': u'\U0001F232',
    u':bouton_accepter_en_japonais:': u'\U0001F251',
    u':bouton_application_en_japonais:': u'\U0001F238',
    u':bouton_note_pour_réussir_en_japonais:': u'\U0001F234',
    u':bouton_chambres_disponibles_en_japonais:': u'\U0001F233',
    u':bouton_félicitations_en_japonais:': u'\U00003297\U0000FE0F',
    u':bouton_secret_en_japonais:': u'\U00003299\U0000FE0F',
    u':bouton_ouvert_pour_affaires_en_japonais:': u'\U0001F23A',
    u':bouton_complet_en_japonais:': u'\U0001F235',
    u':disque_rouge:': u'\U0001F534',
    u':disque_orange:': u'\U0001F7E0',
    u':disque_jaune:': u'\U0001F7E1',
    u':disque_vert:': u'\U0001F7E2',
    u':disque_bleu:': u'\U0001F535',
    u':disque_violet:': u'\U0001F7E3',
    u':disque_marron:': u'\U0001F7E4',
    u':disque_noir:': u'\U000026AB',
    u':disque_blanc:': u'\U000026AA',
    u':carré_rouge:': u'\U0001F7E5',
    u':carré_orange:': u'\U0001F7E7',
    u':carré_jaune:': u'\U0001F7E8',
    u':carré_vert:': u'\U0001F7E9',
    u':carré_bleu:': u'\U0001F7E6',
    u':carré_violet:': u'\U0001F7EA',
    u':carré_marron:': u'\U0001F7EB',
    u':grand_carré_noir:': u'\U00002B1B',
    u':grand_carré_blanc:': u'\U00002B1C',
    u':carré_moyen_noir:': u'\U000025FC\U0000FE0F',
    u':carré_moyen_blanc:': u'\U000025FB\U0000FE0F',
    u':carré_petit_moyen_noir:': u'\U000025FE',
    u':carré_petit_moyen_blanc:': u'\U000025FD',
    u':petit_carré_noir:': u'\U000025AA\U0000FE0F',
    u':petit_carré_blanc:': u'\U000025AB\U0000FE0F',
    u':grand_losange_orange:': u'\U0001F536',
    u':grand_losange_bleu:': u'\U0001F537',
    u':petit_losange_orange:': u'\U0001F538',
    u':petit_losange_bleu:': u'\U0001F539',
    u':triangle_rouge_pointant_vers_le_haut:': u'\U0001F53A',
    u':triangle_rouge_pointant_vers_le_bas:': u'\U0001F53B',
    u':diamant_avec_un_point:': u'\U0001F4A0',
    u':bouton_radio:': u'\U0001F518',
    u':carré_blanc:': u'\U0001F533',
    u':carré_noir:': u'\U0001F532',
    u':drapeau_à_damier:': u'\U0001F3C1',
    u':drapeau_triangulaire:': u'\U0001F6A9',
    u':drapeaux_croisés:': u'\U0001F38C',
    u':drapeau_noir:': u'\U0001F3F4',
    u':drapeau_blanc:': u'\U0001F3F3\U0000FE0F',
    u':drapeau_arc-en-ciel:': u'\U0001F3F3\U0000FE0F\U0000200D\U0001F308',
    u':drapeau_transgenre:': u'\U0001F3F3\U0000FE0F\U0000200D\U000026A7\U0000FE0F',
    u':drapeau_de_pirate:': u'\U0001F3F4\U0000200D\U00002620\U0000FE0F',
    u':drapeau_île_de_l’ascension:': u'\U0001F1E6\U0001F1E8',
    u':drapeau_andorre:': u'\U0001F1E6\U0001F1E9',
    u':drapeau_émirats_arabes_unis:': u'\U0001F1E6\U0001F1EA',
    u':drapeau_afghanistan:': u'\U0001F1E6\U0001F1EB',
    u':drapeau_antigua-et-barbuda:': u'\U0001F1E6\U0001F1EC',
    u':drapeau_anguilla:': u'\U0001F1E6\U0001F1EE',
    u':drapeau_albanie:': u'\U0001F1E6\U0001F1F1',
    u':drapeau_arménie:': u'\U0001F1E6\U0001F1F2',
    u':drapeau_angola:': u'\U0001F1E6\U0001F1F4',
    u':drapeau_antarctique:': u'\U0001F1E6\U0001F1F6',
    u':drapeau_argentine:': u'\U0001F1E6\U0001F1F7',
    u':drapeau_samoa_américaines:': u'\U0001F1E6\U0001F1F8',
    u':drapeau_autriche:': u'\U0001F1E6\U0001F1F9',
    u':drapeau_australie:': u'\U0001F1E6\U0001F1FA',
    u':drapeau_aruba:': u'\U0001F1E6\U0001F1FC',
    u':drapeau_îles_åland:': u'\U0001F1E6\U0001F1FD',
    u':drapeau_azerbaïdjan:': u'\U0001F1E6\U0001F1FF',
    u':drapeau_bosnie-herzégovine:': u'\U0001F1E7\U0001F1E6',
    u':drapeau_barbade:': u'\U0001F1E7\U0001F1E7',
    u':drapeau_bangladesh:': u'\U0001F1E7\U0001F1E9',
    u':drapeau_belgique:': u'\U0001F1E7\U0001F1EA',
    u':drapeau_burkina_faso:': u'\U0001F1E7\U0001F1EB',
    u':drapeau_bulgarie:': u'\U0001F1E7\U0001F1EC',
    u':drapeau_bahreïn:': u'\U0001F1E7\U0001F1ED',
    u':drapeau_burundi:': u'\U0001F1E7\U0001F1EE',
    u':drapeau_bénin:': u'\U0001F1E7\U0001F1EF',
    u':drapeau_saint-barthélemy:': u'\U0001F1E7\U0001F1F1',
    u':drapeau_bermudes:': u'\U0001F1E7\U0001F1F2',
    u':drapeau_brunéi_darussalam:': u'\U0001F1E7\U0001F1F3',
    u':drapeau_bolivie:': u'\U0001F1E7\U0001F1F4',
    u':drapeau_pays-bas_caribéens:': u'\U0001F1E7\U0001F1F6',
    u':drapeau_brésil:': u'\U0001F1E7\U0001F1F7',
    u':drapeau_bahamas:': u'\U0001F1E7\U0001F1F8',
    u':drapeau_bhoutan:': u'\U0001F1E7\U0001F1F9',
    u':drapeau_île_bouvet:': u'\U0001F1E7\U0001F1FB',
    u':drapeau_botswana:': u'\U0001F1E7\U0001F1FC',
    u':drapeau_biélorussie:': u'\U0001F1E7\U0001F1FE',
    u':drapeau_belize:': u'\U0001F1E7\U0001F1FF',
    u':drapeau_canada:': u'\U0001F1E8\U0001F1E6',
    u':drapeau_îles_cocos:': u'\U0001F1E8\U0001F1E8',
    u':drapeau_congo-kinshasa:': u'\U0001F1E8\U0001F1E9',
    u':drapeau_république_centrafricaine:': u'\U0001F1E8\U0001F1EB',
    u':drapeau_congo-brazzaville:': u'\U0001F1E8\U0001F1EC',
    u':drapeau_suisse:': u'\U0001F1E8\U0001F1ED',
    u':drapeau_côte_d’ivoire:': u'\U0001F1E8\U0001F1EE',
    u':drapeau_îles_cook:': u'\U0001F1E8\U0001F1F0',
    u':drapeau_chili:': u'\U0001F1E8\U0001F1F1',
    u':drapeau_cameroun:': u'\U0001F1E8\U0001F1F2',
    u':drapeau_chine:': u'\U0001F1E8\U0001F1F3',
    u':drapeau_colombie:': u'\U0001F1E8\U0001F1F4',
    u':drapeau_île_clipperton:': u'\U0001F1E8\U0001F1F5',
    u':drapeau_costa_rica:': u'\U0001F1E8\U0001F1F7',
    u':drapeau_cuba:': u'\U0001F1E8\U0001F1FA',
    u':drapeau_cap-vert:': u'\U0001F1E8\U0001F1FB',
    u':drapeau_curaçao:': u'\U0001F1E8\U0001F1FC',
    u':drapeau_île_christmas:': u'\U0001F1E8\U0001F1FD',
    u':drapeau_chypre:': u'\U0001F1E8\U0001F1FE',
    u':drapeau_tchéquie:': u'\U0001F1E8\U0001F1FF',
    u':drapeau_allemagne:': u'\U0001F1E9\U0001F1EA',
    u':drapeau_diego_garcia:': u'\U0001F1E9\U0001F1EC',
    u':drapeau_djibouti:': u'\U0001F1E9\U0001F1EF',
    u':drapeau_danemark:': u'\U0001F1E9\U0001F1F0',
    u':drapeau_dominique:': u'\U0001F1E9\U0001F1F2',
    u':drapeau_république_dominicaine:': u'\U0001F1E9\U0001F1F4',
    u':drapeau_algérie:': u'\U0001F1E9\U0001F1FF',
    u':drapeau_ceuta_et_melilla:': u'\U0001F1EA\U0001F1E6',
    u':drapeau_équateur:': u'\U0001F1EA\U0001F1E8',
    u':drapeau_estonie:': u'\U0001F1EA\U0001F1EA',
    u':drapeau_égypte:': u'\U0001F1EA\U0001F1EC',
    u':drapeau_sahara_occidental:': u'\U0001F1EA\U0001F1ED',
    u':drapeau_érythrée:': u'\U0001F1EA\U0001F1F7',
    u':drapeau_espagne:': u'\U0001F1EA\U0001F1F8',
    u':drapeau_éthiopie:': u'\U0001F1EA\U0001F1F9',
    u':drapeau_union_européenne:': u'\U0001F1EA\U0001F1FA',
    u':drapeau_finlande:': u'\U0001F1EB\U0001F1EE',
    u':drapeau_fidji:': u'\U0001F1EB\U0001F1EF',
    u':drapeau_îles_malouines:': u'\U0001F1EB\U0001F1F0',
    u':drapeau_états_fédérés_de_micronésie:': u'\U0001F1EB\U0001F1F2',
    u':drapeau_îles_féroé:': u'\U0001F1EB\U0001F1F4',
    u':drapeau_france:': u'\U0001F1EB\U0001F1F7',
    u':drapeau_gabon:': u'\U0001F1EC\U0001F1E6',
    u':drapeau_royaume-uni:': u'\U0001F1EC\U0001F1E7',
    u':drapeau_grenade:': u'\U0001F1EC\U0001F1E9',
    u':drapeau_géorgie:': u'\U0001F1EC\U0001F1EA',
    u':drapeau_guyane_française:': u'\U0001F1EC\U0001F1EB',
    u':drapeau_guernesey:': u'\U0001F1EC\U0001F1EC',
    u':drapeau_ghana:': u'\U0001F1EC\U0001F1ED',
    u':drapeau_gibraltar:': u'\U0001F1EC\U0001F1EE',
    u':drapeau_groenland:': u'\U0001F1EC\U0001F1F1',
    u':drapeau_gambie:': u'\U0001F1EC\U0001F1F2',
    u':drapeau_guinée:': u'\U0001F1EC\U0001F1F3',
    u':drapeau_guadeloupe:': u'\U0001F1EC\U0001F1F5',
    u':drapeau_guinée_équatoriale:': u'\U0001F1EC\U0001F1F6',
    u':drapeau_grèce:': u'\U0001F1EC\U0001F1F7',
    u':drapeau_géorgie_du_sud_et_îles_sandwich_du_sud:': u'\U0001F1EC\U0001F1F8',
    u':drapeau_guatemala:': u'\U0001F1EC\U0001F1F9',
    u':drapeau_guam:': u'\U0001F1EC\U0001F1FA',
    u':drapeau_guinée-bissau:': u'\U0001F1EC\U0001F1FC',
    u':drapeau_guyana:': u'\U0001F1EC\U0001F1FE',
    u':drapeau_r.a.s._chinoise_de_hong_kong:': u'\U0001F1ED\U0001F1F0',
    u':drapeau_îles_heard_et_mcdonald:': u'\U0001F1ED\U0001F1F2',
    u':drapeau_honduras:': u'\U0001F1ED\U0001F1F3',
    u':drapeau_croatie:': u'\U0001F1ED\U0001F1F7',
    u':drapeau_haïti:': u'\U0001F1ED\U0001F1F9',
    u':drapeau_hongrie:': u'\U0001F1ED\U0001F1FA',
    u':drapeau_îles_canaries:': u'\U0001F1EE\U0001F1E8',
    u':drapeau_indonésie:': u'\U0001F1EE\U0001F1E9',
    u':drapeau_irlande:': u'\U0001F1EE\U0001F1EA',
    u':drapeau_israël:': u'\U0001F1EE\U0001F1F1',
    u':drapeau_île_de_man:': u'\U0001F1EE\U0001F1F2',
    u':drapeau_inde:': u'\U0001F1EE\U0001F1F3',
    u':drapeau_territoire_britannique_de_l’océan_indien:': u'\U0001F1EE\U0001F1F4',
    u':drapeau_irak:': u'\U0001F1EE\U0001F1F6',
    u':drapeau_iran:': u'\U0001F1EE\U0001F1F7',
    u':drapeau_islande:': u'\U0001F1EE\U0001F1F8',
    u':drapeau_italie:': u'\U0001F1EE\U0001F1F9',
    u':drapeau_jersey:': u'\U0001F1EF\U0001F1EA',
    u':drapeau_jamaïque:': u'\U0001F1EF\U0001F1F2',
    u':drapeau_jordanie:': u'\U0001F1EF\U0001F1F4',
    u':drapeau_japon:': u'\U0001F1EF\U0001F1F5',
    u':drapeau_kenya:': u'\U0001F1F0\U0001F1EA',
    u':drapeau_kirghizistan:': u'\U0001F1F0\U0001F1EC',
    u':drapeau_cambodge:': u'\U0001F1F0\U0001F1ED',
    u':drapeau_kiribati:': u'\U0001F1F0\U0001F1EE',
    u':drapeau_comores:': u'\U0001F1F0\U0001F1F2',
    u':drapeau_saint-christophe-et-niévès:': u'\U0001F1F0\U0001F1F3',
    u':drapeau_corée_du_nord:': u'\U0001F1F0\U0001F1F5',
    u':drapeau_corée_du_sud:': u'\U0001F1F0\U0001F1F7',
    u':drapeau_koweït:': u'\U0001F1F0\U0001F1FC',
    u':drapeau_îles_caïmans:': u'\U0001F1F0\U0001F1FE',
    u':drapeau_kazakhstan:': u'\U0001F1F0\U0001F1FF',
    u':drapeau_laos:': u'\U0001F1F1\U0001F1E6',
    u':drapeau_liban:': u'\U0001F1F1\U0001F1E7',
    u':drapeau_sainte-lucie:': u'\U0001F1F1\U0001F1E8',
    u':drapeau_liechtenstein:': u'\U0001F1F1\U0001F1EE',
    u':drapeau_sri_lanka:': u'\U0001F1F1\U0001F1F0',
    u':drapeau_libéria:': u'\U0001F1F1\U0001F1F7',
    u':drapeau_lesotho:': u'\U0001F1F1\U0001F1F8',
    u':drapeau_lituanie:': u'\U0001F1F1\U0001F1F9',
    u':drapeau_luxembourg:': u'\U0001F1F1\U0001F1FA',
    u':drapeau_lettonie:': u'\U0001F1F1\U0001F1FB',
    u':drapeau_libye:': u'\U0001F1F1\U0001F1FE',
    u':drapeau_maroc:': u'\U0001F1F2\U0001F1E6',
    u':drapeau_monaco:': u'\U0001F1F2\U0001F1E8',
    u':drapeau_moldavie:': u'\U0001F1F2\U0001F1E9',
    u':drapeau_monténégro:': u'\U0001F1F2\U0001F1EA',
    u':drapeau_saint-martin:': u'\U0001F1F2\U0001F1EB',
    u':drapeau_madagascar:': u'\U0001F1F2\U0001F1EC',
    u':drapeau_îles_marshall:': u'\U0001F1F2\U0001F1ED',
    u':drapeau_macédoine_du_nord:': u'\U0001F1F2\U0001F1F0',
    u':drapeau_mali:': u'\U0001F1F2\U0001F1F1',
    u':drapeau_myanmar_(birmanie):': u'\U0001F1F2\U0001F1F2',
    u':drapeau_mongolie:': u'\U0001F1F2\U0001F1F3',
    u':drapeau_r.a.s._chinoise_de_macao:': u'\U0001F1F2\U0001F1F4',
    u':drapeau_îles_mariannes_du_nord:': u'\U0001F1F2\U0001F1F5',
    u':drapeau_martinique:': u'\U0001F1F2\U0001F1F6',
    u':drapeau_mauritanie:': u'\U0001F1F2\U0001F1F7',
    u':drapeau_montserrat:': u'\U0001F1F2\U0001F1F8',
    u':drapeau_malte:': u'\U0001F1F2\U0001F1F9',
    u':drapeau_maurice:': u'\U0001F1F2\U0001F1FA',
    u':drapeau_maldives:': u'\U0001F1F2\U0001F1FB',
    u':drapeau_malawi:': u'\U0001F1F2\U0001F1FC',
    u':drapeau_mexique:': u'\U0001F1F2\U0001F1FD',
    u':drapeau_malaisie:': u'\U0001F1F2\U0001F1FE',
    u':drapeau_mozambique:': u'\U0001F1F2\U0001F1FF',
    u':drapeau_namibie:': u'\U0001F1F3\U0001F1E6',
    u':drapeau_nouvelle-calédonie:': u'\U0001F1F3\U0001F1E8',
    u':drapeau_niger:': u'\U0001F1F3\U0001F1EA',
    u':drapeau_île_norfolk:': u'\U0001F1F3\U0001F1EB',
    u':drapeau_nigéria:': u'\U0001F1F3\U0001F1EC',
    u':drapeau_nicaragua:': u'\U0001F1F3\U0001F1EE',
    u':drapeau_pays-bas:': u'\U0001F1F3\U0001F1F1',
    u':drapeau_norvège:': u'\U0001F1F3\U0001F1F4',
    u':drapeau_népal:': u'\U0001F1F3\U0001F1F5',
    u':drapeau_nauru:': u'\U0001F1F3\U0001F1F7',
    u':drapeau_niue:': u'\U0001F1F3\U0001F1FA',
    u':drapeau_nouvelle-zélande:': u'\U0001F1F3\U0001F1FF',
    u':drapeau_oman:': u'\U0001F1F4\U0001F1F2',
    u':drapeau_panama:': u'\U0001F1F5\U0001F1E6',
    u':drapeau_pérou:': u'\U0001F1F5\U0001F1EA',
    u':drapeau_polynésie_française:': u'\U0001F1F5\U0001F1EB',
    u':drapeau_papouasie-nouvelle-guinée:': u'\U0001F1F5\U0001F1EC',
    u':drapeau_philippines:': u'\U0001F1F5\U0001F1ED',
    u':drapeau_pakistan:': u'\U0001F1F5\U0001F1F0',
    u':drapeau_pologne:': u'\U0001F1F5\U0001F1F1',
    u':drapeau_saint-pierre-et-miquelon:': u'\U0001F1F5\U0001F1F2',
    u':drapeau_îles_pitcairn:': u'\U0001F1F5\U0001F1F3',
    u':drapeau_porto_rico:': u'\U0001F1F5\U0001F1F7',
    u':drapeau_territoires_palestiniens:': u'\U0001F1F5\U0001F1F8',
    u':drapeau_portugal:': u'\U0001F1F5\U0001F1F9',
    u':drapeau_palaos:': u'\U0001F1F5\U0001F1FC',
    u':drapeau_paraguay:': u'\U0001F1F5\U0001F1FE',
    u':drapeau_qatar:': u'\U0001F1F6\U0001F1E6',
    u':drapeau_la_réunion:': u'\U0001F1F7\U0001F1EA',
    u':drapeau_roumanie:': u'\U0001F1F7\U0001F1F4',
    u':drapeau_serbie:': u'\U0001F1F7\U0001F1F8',
    u':drapeau_russie:': u'\U0001F1F7\U0001F1FA',
    u':drapeau_rwanda:': u'\U0001F1F7\U0001F1FC',
    u':drapeau_arabie_saoudite:': u'\U0001F1F8\U0001F1E6',
    u':drapeau_îles_salomon:': u'\U0001F1F8\U0001F1E7',
    u':drapeau_seychelles:': u'\U0001F1F8\U0001F1E8',
    u':drapeau_soudan:': u'\U0001F1F8\U0001F1E9',
    u':drapeau_suède:': u'\U0001F1F8\U0001F1EA',
    u':drapeau_singapour:': u'\U0001F1F8\U0001F1EC',
    u':drapeau_sainte-hélène:': u'\U0001F1F8\U0001F1ED',
    u':drapeau_slovénie:': u'\U0001F1F8\U0001F1EE',
    u':drapeau_svalbard_et_jan_mayen:': u'\U0001F1F8\U0001F1EF',
    u':drapeau_slovaquie:': u'\U0001F1F8\U0001F1F0',
    u':drapeau_sierra_leone:': u'\U0001F1F8\U0001F1F1',
    u':drapeau_saint-marin:': u'\U0001F1F8\U0001F1F2',
    u':drapeau_sénégal:': u'\U0001F1F8\U0001F1F3',
    u':drapeau_somalie:': u'\U0001F1F8\U0001F1F4',
    u':drapeau_suriname:': u'\U0001F1F8\U0001F1F7',
    u':drapeau_soudan_du_sud:': u'\U0001F1F8\U0001F1F8',
    u':drapeau_sao_tomé-et-principe:': u'\U0001F1F8\U0001F1F9',
    u':drapeau_salvador:': u'\U0001F1F8\U0001F1FB',
    u':drapeau_saint-martin_(partie_néerlandaise):': u'\U0001F1F8\U0001F1FD',
    u':drapeau_syrie:': u'\U0001F1F8\U0001F1FE',
    u':drapeau_eswatini:': u'\U0001F1F8\U0001F1FF',
    u':drapeau_tristan_da_cunha:': u'\U0001F1F9\U0001F1E6',
    u':drapeau_îles_turques-et-caïques:': u'\U0001F1F9\U0001F1E8',
    u':drapeau_tchad:': u'\U0001F1F9\U0001F1E9',
    u':drapeau_terres_australes_françaises:': u'\U0001F1F9\U0001F1EB',
    u':drapeau_togo:': u'\U0001F1F9\U0001F1EC',
    u':drapeau_thaïlande:': u'\U0001F1F9\U0001F1ED',
    u':drapeau_tadjikistan:': u'\U0001F1F9\U0001F1EF',
    u':drapeau_tokelau:': u'\U0001F1F9\U0001F1F0',
    u':drapeau_timor_oriental:': u'\U0001F1F9\U0001F1F1',
    u':drapeau_turkménistan:': u'\U0001F1F9\U0001F1F2',
    u':drapeau_tunisie:': u'\U0001F1F9\U0001F1F3',
    u':drapeau_tonga:': u'\U0001F1F9\U0001F1F4',
    u':drapeau_turquie:': u'\U0001F1F9\U0001F1F7',
    u':drapeau_trinité-et-tobago:': u'\U0001F1F9\U0001F1F9',
    u':drapeau_tuvalu:': u'\U0001F1F9\U0001F1FB',
    u':drapeau_taïwan:': u'\U0001F1F9\U0001F1FC',
    u':drapeau_tanzanie:': u'\U0001F1F9\U0001F1FF',
    u':drapeau_ukraine:': u'\U0001F1FA\U0001F1E6',
    u':drapeau_ouganda:': u'\U0001F1FA\U0001F1EC',
    u':drapeau_îles_mineures_éloignées_des_états-unis:': u'\U0001F1FA\U0001F1F2',
    u':drapeau_nations_unies:': u'\U0001F1FA\U0001F1F3',
    u':drapeau_états-unis:': u'\U0001F1FA\U0001F1F8',
    u':drapeau_uruguay:': u'\U0001F1FA\U0001F1FE',
    u':drapeau_ouzbékistan:': u'\U0001F1FA\U0001F1FF',
    u':drapeau_état_de_la_cité_du_vatican:': u'\U0001F1FB\U0001F1E6',
    u':drapeau_saint-vincent-et-les-grenadines:': u'\U0001F1FB\U0001F1E8',
    u':drapeau_venezuela:': u'\U0001F1FB\U0001F1EA',
    u':drapeau_îles_vierges_britanniques:': u'\U0001F1FB\U0001F1EC',
    u':drapeau_îles_vierges_des_états-unis:': u'\U0001F1FB\U0001F1EE',
    u':drapeau_vietnam:': u'\U0001F1FB\U0001F1F3',
    u':drapeau_vanuatu:': u'\U0001F1FB\U0001F1FA',
    u':drapeau_wallis-et-futuna:': u'\U0001F1FC\U0001F1EB',
    u':drapeau_samoa:': u'\U0001F1FC\U0001F1F8',
    u':drapeau_kosovo:': u'\U0001F1FD\U0001F1F0',
    u':drapeau_yémen:': u'\U0001F1FE\U0001F1EA',
    u':drapeau_mayotte:': u'\U0001F1FE\U0001F1F9',
    u':drapeau_afrique_du_sud:': u'\U0001F1FF\U0001F1E6',
    u':drapeau_zambie:': u'\U0001F1FF\U0001F1F2',
    u':drapeau_zimbabwe:': u'\U0001F1FF\U0001F1FC',
    u':drapeau_angleterre:': u'\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F',
    u':drapeau_écosse:': u'\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F',
    u':drapeau_pays_de_galles:': u'\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F',
}

UNICODE_EMOJI_FRENCH = {v: k for k, v in EMOJI_UNICODE_FRENCH.items()}
