/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

public abstract class CompositeFileCollection
extends AbstractFileCollection
implements TaskDependencyContainer {
    public CompositeFileCollection(Factory<PatternSet> patternSetFactory) {
        super(patternSetFactory);
    }

    public CompositeFileCollection() {
    }

    @Override
    public boolean contains(File file) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (!fileCollection.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (fileCollection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            fileCollection.addToAntBuilder(builder, nodeName, FileCollection.AntType.ResourceCollection);
        }
    }

    @Override
    public FileCollectionInternal filter(final Spec<? super File> filterSpec) {
        return new CompositeFileCollection(this.patternSetFactory){

            @Override
            public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
                FileCollectionInternal newCollection = CompositeFileCollection.this.replace(original, supplier);
                if (newCollection == CompositeFileCollection.this) {
                    return this;
                }
                return newCollection.filter(filterSpec);
            }

            @Override
            protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
                CompositeFileCollection.this.visitChildren(child -> visitor.accept((FileCollectionInternal)child.filter(filterSpec)));
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                CompositeFileCollection.this.visitDependencies(context);
            }

            @Override
            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }
        };
    }

    protected abstract void visitChildren(Consumer<FileCollectionInternal> var1);

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.visitChildren(arg_0 -> ((TaskDependencyResolveContext)context).add(arg_0));
    }

    protected List<? extends FileCollectionInternal> getSourceCollections() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.visitChildren(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.visitChildren(child -> child.visitStructure(visitor));
    }
}

