/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildResponseRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.router.tunnel.BuildMessageGenerator;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

public class BuildReplyHandler {
    private final I2PAppContext ctx;
    private final Log log;

    public BuildReplyHandler(I2PAppContext context) {
        this.ctx = context;
        this.log = this.ctx.logManager().getLog(BuildReplyHandler.class);
    }

    public int[] decrypt(TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, List<Integer> recordOrder) {
        if (reply.getRecordCount() != recordOrder.size()) {
            this.log.error("Corrupted build reply, expected " + recordOrder.size() + " records, got " + reply.getRecordCount());
            return null;
        }
        int[] rv = new int[reply.getRecordCount()];
        for (int i = 0; i < rv.length; ++i) {
            int hop = recordOrder.get(i);
            if (BuildMessageGenerator.isBlank(cfg, hop)) {
                if (this.log.shouldLog(10)) {
                    this.log.debug(reply.getUniqueId() + ": skipping record " + i + "/" + hop + " for: " + cfg);
                }
                if (cfg.isInbound() && hop + 1 == cfg.getLength()) {
                    byte[] h1 = new byte[32];
                    this.ctx.sha().calculateHash(reply.getRecord(i).getData(), 0, 528, h1, 0);
                    Hash h2 = cfg.getBlankHash();
                    if (h2 != null && DataHelper.eq(h1, h2.getData())) {
                        rv[i] = 0;
                        continue;
                    }
                    if (this.log.shouldWarn()) {
                        this.log.warn("IBEP record corrupt on " + cfg);
                    }
                    return null;
                }
                rv[i] = 0;
                continue;
            }
            int ok = this.decryptRecord(reply, cfg, i, hop);
            if (ok == -1) {
                if (this.log.shouldLog(30)) {
                    this.log.warn(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " fail: " + cfg);
                }
                return null;
            }
            if (this.log.shouldLog(10)) {
                this.log.debug(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " success: " + ok + " for " + cfg);
            }
            rv[i] = ok;
        }
        return rv;
    }

    private int decryptRecord(TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, int recordNum, int hop) {
        int rv;
        byte[] replyIV;
        SessionKey replyKey;
        EncryptedBuildRecord rec = reply.getRecord(recordNum);
        byte[] data = rec.getData();
        int start = cfg.getLength() - 1;
        if (cfg.isInbound()) {
            --start;
        }
        int end = hop;
        boolean isEC = cfg.isEC(hop);
        if (isEC) {
            ++end;
        }
        for (int j = start; j >= end; --j) {
            replyKey = cfg.getAESReplyKey(j);
            replyIV = cfg.getAESReplyIV(j);
            if (this.log.shouldLog(10)) {
                this.log.debug(reply.getUniqueId() + ": Decrypting record " + recordNum + "/" + hop + "/" + j + " with replyKey " + replyKey.toBase64() + "/" + Base64.encode(replyIV) + ": " + cfg);
                this.log.debug(reply.getUniqueId() + ": before decrypt: " + Base64.encode(data));
                this.log.debug(reply.getUniqueId() + ": Full reply rec: sz=" + data.length + " data=" + Base64.encode(data, 0, 528));
            }
            this.ctx.aes().decrypt(data, 0, data, 0, replyKey, replyIV, 0, 528);
            if (!this.log.shouldLog(10)) continue;
            this.log.debug(reply.getUniqueId() + ": after decrypt: " + Base64.encode(data));
        }
        if (isEC) {
            boolean ok;
            replyKey = cfg.getChaChaReplyKey(hop);
            replyIV = cfg.getChaChaReplyAD(hop);
            if (this.log.shouldDebug()) {
                this.log.debug(reply.getUniqueId() + ": Decrypting chacha/poly record " + recordNum + "/" + hop + " with replyKey " + replyKey.toBase64() + "/" + Base64.encode(replyIV) + ": " + cfg);
            }
            if (!(ok = BuildResponseRecord.decrypt(rec, replyKey, replyIV))) {
                if (this.log.shouldWarn()) {
                    this.log.debug(reply.getUniqueId() + ": chacha reply decrypt fail on " + recordNum + "/" + hop);
                }
                return -1;
            }
            rv = data[511] & 0xFF;
        } else {
            byte[] h = SimpleByteCache.acquire(32);
            this.ctx.sha().calculateHash(data, 32, 496, h, 0);
            boolean ok = DataHelper.eq(h, 0, data, 0, 32);
            if (!ok) {
                if (this.log.shouldWarn()) {
                    this.log.warn(reply.getUniqueId() + ": sha256 reply verify fail on " + recordNum + "/" + hop + ": " + Base64.encode(h) + " calculated, " + Base64.encode(data, 0, 32) + " expected\nRecord: " + Base64.encode(data, 32, 496));
                }
                SimpleByteCache.release(h);
                return -1;
            }
            SimpleByteCache.release(h);
            rv = data[527] & 0xFF;
        }
        if (this.log.shouldLog(10)) {
            this.log.debug(reply.getUniqueId() + ": Verified: " + rv + " for record " + recordNum + "/" + hop);
        }
        return rv;
    }
}

