/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) / 12) => ivec3(-3, 2, -7)
 * (ivec3(-36, 32, -88) / -6) => ivec3(6, -5, 14)
 * (ivec3(-36, 32, -88) / 76) => ivec3(0, 0, -1)
 * (ivec3(-36, 32, -88) / -32) => ivec3(1, -1, 2)
 * (ivec3(36, 32, 88) / 12) => ivec3(3, 2, 7)
 * (ivec3(36, 32, 88) / -6) => ivec3(-6, -5, -14)
 * (ivec3(36, 32, 88) / 76) => ivec3(0, 0, 1)
 * (ivec3(36, 32, 88) / -32) => ivec3(-1, -1, -2)
 * (ivec3(59, 77, 68) / 12) => ivec3(4, 6, 5)
 * (ivec3(59, 77, 68) / -6) => ivec3(-9, -12, -11)
 * (ivec3(59, 77, 68) / 76) => ivec3(0, 1, 0)
 * (ivec3(59, 77, 68) / -32) => ivec3(-1, -2, -2)
 */
#version 120

void main()
{
  float[all(equal((ivec3(-36, 32, -88) / 12), ivec3(-3, 2, -7))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) / -6), ivec3(6, -5, 14))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) / 76), ivec3(0, 0, -1))) ? 1 : -1] array2;
  float[all(equal((ivec3(-36, 32, -88) / -32), ivec3(1, -1, 2))) ? 1 : -1] array3;
  float[all(equal((ivec3(36, 32, 88) / 12), ivec3(3, 2, 7))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) / -6), ivec3(-6, -5, -14))) ? 1 : -1] array5;
  float[all(equal((ivec3(36, 32, 88) / 76), ivec3(0, 0, 1))) ? 1 : -1] array6;
  float[all(equal((ivec3(36, 32, 88) / -32), ivec3(-1, -1, -2))) ? 1 : -1] array7;
  float[all(equal((ivec3(59, 77, 68) / 12), ivec3(4, 6, 5))) ? 1 : -1] array8;
  float[all(equal((ivec3(59, 77, 68) / -6), ivec3(-9, -12, -11))) ? 1 : -1] array9;
  float[all(equal((ivec3(59, 77, 68) / 76), ivec3(0, 1, 0))) ? 1 : -1] array10;
  float[all(equal((ivec3(59, 77, 68) / -32), ivec3(-1, -2, -2))) ? 1 : -1] array11;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
