# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2021 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vcenter.lcm.common.
#---------------------------------------------------------------------------

"""
The ``com.vmware.vcenter.lcm.upgrade`` module provides classes for upgrading
vCenter Server to a newer version.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata

class ApplianceSize(Enum):
    """
    The ``ApplianceSize`` class defines the size of the appliance (CPU and
    memory) to be deployed.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    TINY = None
    """
    Appliance size of 'tiny'.

    """
    SMALL = None
    """
    Appliance size of 'small'.

    """
    MEDIUM = None
    """
    Appliance size of 'medium'.

    """
    LARGE = None
    """
    Appliance size of 'large',

    """
    XLARGE = None
    """
    Appliance size of 'extra large'.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`ApplianceSize` instance.
        """
        Enum.__init__(string)

ApplianceSize._set_values([
    ApplianceSize('TINY'),
    ApplianceSize('SMALL'),
    ApplianceSize('MEDIUM'),
    ApplianceSize('LARGE'),
    ApplianceSize('XLARGE'),
])
ApplianceSize._set_binding_type(type.EnumType(
    'com.vmware.vcenter.lcm.common.appliance_size',
    ApplianceSize))



class StorageSize(Enum):
    """
    The ``StorageSize`` class defines the storage size of the appliance to be
    deployed.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    REGULAR = None
    """
    Regular storage

    """
    LARGE = None
    """
    Large storage

    """
    XLARGE = None
    """
    Extra large storage

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`StorageSize` instance.
        """
        Enum.__init__(string)

StorageSize._set_values([
    StorageSize('REGULAR'),
    StorageSize('LARGE'),
    StorageSize('XLARGE'),
])
StorageSize._set_binding_type(type.EnumType(
    'com.vmware.vcenter.lcm.common.storage_size',
    StorageSize))



class HashAlgorithm(Enum):
    """
    The ``HashAlgorithm`` class defines the valid hash algorithms.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    SHA256 = None
    """
    Hash algorithm: SHA-256

    """
    SHA512 = None
    """
    Hash algorithm: SHA-512

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`HashAlgorithm` instance.
        """
        Enum.__init__(string)

HashAlgorithm._set_values([
    HashAlgorithm('SHA256'),
    HashAlgorithm('SHA512'),
])
HashAlgorithm._set_binding_type(type.EnumType(
    'com.vmware.vcenter.lcm.common.hash_algorithm',
    HashAlgorithm))




class Question(VapiStruct):
    """
    The ``Question`` class describes a item of information that must be
    provided by the user in order to perform the update.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'PLAIN_TEXT' : [('allowed_values', False), ('default_answer', False)],
                'BOOLEAN' : [('default_answer', False)],
                'PASSWORD' : [],
            }
        ),
    ]



    def __init__(self,
                 data_item=None,
                 text=None,
                 description=None,
                 type=None,
                 allowed_values=None,
                 default_answer=None,
                ):
        """
        :type  data_item: :class:`str`
        :param data_item: ID of the data item
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.vcenter.lcm.common.dataitem``. When methods return a
            value of this class as a return value, the attribute will be an
            identifier for the resource type:
            ``com.vmware.vcenter.lcm.common.dataitem``.
        :type  text: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param text: Label for the item
        :type  description: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param description: Description of the item
        :type  type: :class:`Question.InputType`
        :param type: The type of the field.
        :type  allowed_values: :class:`list` of :class:`str` or ``None``
        :param allowed_values: List of allowed values
            allowedValues If None any value is valid.
        :type  default_answer: :class:`str` or ``None``
        :param default_answer: Default answer
            defaultAnswer If None then there is no default answer, so an
            explicit answer must be provided
        """
        self.data_item = data_item
        self.text = text
        self.description = description
        self.type = type
        self.allowed_values = allowed_values
        self.default_answer = default_answer
        VapiStruct.__init__(self)


    class InputType(Enum):
        """
        The ``Question.InputType`` class defines the supported field types for
        questions.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        PLAIN_TEXT = None
        """
        Plain text answer.

        """
        BOOLEAN = None
        """
        Yes/No,On/Off,Checkbox answer.

        """
        PASSWORD = None
        """
        Password (masked) answer.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`InputType` instance.
            """
            Enum.__init__(string)

    InputType._set_values([
        InputType('PLAIN_TEXT'),
        InputType('BOOLEAN'),
        InputType('PASSWORD'),
    ])
    InputType._set_binding_type(type.EnumType(
        'com.vmware.vcenter.lcm.common.question.input_type',
        InputType))

Question._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.question', {
        'data_item': type.IdType(resource_types='com.vmware.vcenter.lcm.common.dataitem'),
        'text': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
        'description': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
        'type': type.ReferenceType(__name__, 'Question.InputType'),
        'allowed_values': type.OptionalType(type.ListType(type.StringType())),
        'default_answer': type.OptionalType(type.StringType()),
    },
    Question,
    False,
    None))



class OvaInfo(VapiStruct):
    """
    The ``OvaInfo`` class defines the OVA file location info.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 location=None,
                 ssl_verify=None,
                 ssl_hash=None,
                 hash_algorithm=None,
                ):
        """
        :type  location: :class:`str`
        :param location: The location of the OVA file for installation. It can be web URL or
            absolute filepath i.e https://server.com/appliance.ova or
            file://storage/appliance.ova
        :type  ssl_verify: :class:`bool` or ``None``
        :param ssl_verify: A flag to indicate whether SSL verification is required for the ova
            location.
            If None defaults to True
        :type  ssl_hash: :class:`str` or ``None``
        :param ssl_hash: Hash to verify the SSL OVA location. If ``sslVerify`` is false this
            filed can be omitted. If ``sslVerify`` is true and this field is
            ommited a CA based validation will be used. If ``sslVerify`` is
            true and this field is provided will be used for SSL validation.
            If :class:`set` will be used for SSL validation.
        :type  hash_algorithm: :class:`HashAlgorithm` or ``None``
        :param hash_algorithm: The hash algorithm (SHA256, SHA512) used to calculate the checksum.
            If not specified the default checksum algorithm is
            :attr:`HashAlgorithm.SHA256`.
        """
        self.location = location
        self.ssl_verify = ssl_verify
        self.ssl_hash = ssl_hash
        self.hash_algorithm = hash_algorithm
        VapiStruct.__init__(self)


OvaInfo._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.ova_info', {
        'location': type.URIType(),
        'ssl_verify': type.OptionalType(type.BooleanType()),
        'ssl_hash': type.OptionalType(type.StringType()),
        'hash_algorithm': type.OptionalType(type.ReferenceType(__name__, 'HashAlgorithm')),
    },
    OvaInfo,
    False,
    None))



class ApplianceDeployment(VapiStruct):
    """
    The ``ApplianceDeployment`` class describes the new appliance deployment
    configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 name=None,
                 size=None,
                 thin_disk_mode=None,
                 disk_size=None,
                 root_password=None,
                 ova_info=None,
                 ceip_enabled=None,
                ):
        """
        :type  name: :class:`str`
        :param name: The name of the appliance to deploy.
        :type  size: :class:`ApplianceSize` or ``None``
        :param size: A size descriptor based on the number of virtual machines which
            will be managed by the new vCenter appliance.
            If ``#ApplianceSize`` is not provided, will use the size of the
            source VCSA
        :type  thin_disk_mode: :class:`bool`
        :param thin_disk_mode: Whether to deploy the appliance with thin mode virtual disks.
        :type  disk_size: :class:`StorageSize` or ``None``
        :param disk_size: The disk size of the new vCenter appliance.
            If ``#StorageSize`` is not provided, will use the diskSize of the
            source VCSA.
        :type  root_password: :class:`str`
        :param root_password: Password must conform to the following requirements: 1. At least 8
            characters. 2. No more than 20 characters. 3. At least 1 uppercase
            character. 4. At least 1 lowercase character. 5. At least 1 number.
            6. At least 1 special character (e.g., '!', '(', '\\\\@', etc.). 7.
            Only visible A-Z, a-z, 0-9 and punctuation (spaces are not allowed)
        :type  ova_info: :class:`OvaInfo` or ``None``
        :param ova_info: Location of custom OVA for deployment.
            If None use the OVA file for the desired version in the configured
            repository.
        :type  ceip_enabled: :class:`bool` or ``None``
        :param ceip_enabled: This key describes the enabling option for the VMware's Customer
            Experience Improvement Program (CEIP).
            If None, defaults to True
        """
        self.name = name
        self.size = size
        self.thin_disk_mode = thin_disk_mode
        self.disk_size = disk_size
        self.root_password = root_password
        self.ova_info = ova_info
        self.ceip_enabled = ceip_enabled
        VapiStruct.__init__(self)


ApplianceDeployment._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.appliance_deployment', {
        'name': type.StringType(),
        'size': type.OptionalType(type.ReferenceType(__name__, 'ApplianceSize')),
        'thin_disk_mode': type.BooleanType(),
        'disk_size': type.OptionalType(type.ReferenceType(__name__, 'StorageSize')),
        'root_password': type.SecretType(),
        'ova_info': type.OptionalType(type.ReferenceType(__name__, 'OvaInfo')),
        'ceip_enabled': type.OptionalType(type.BooleanType()),
    },
    ApplianceDeployment,
    False,
    None))



class Connection(VapiStruct):
    """
    The ``Connection`` class contains information for deployment location

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 hostname=None,
                 username=None,
                 password=None,
                 https_port=None,
                 ssl_verify=None,
                 ssl_thumbprint=None,
                ):
        """
        :type  hostname: :class:`str`
        :param hostname: The IP address or DNS resolvable name of the ESX/VC host. If a DNS
            resolvable name is provided, it must be resolvable from the source
            appliance.
        :type  username: :class:`str`
        :param username: A username with administrative privileges on the ESX/VC host.
        :type  password: :class:`str`
        :param password: The password of the :attr:`Connection.username` on the ESX/VC host.
        :type  https_port: :class:`long` or ``None``
        :param https_port: The port number for the ESX/VC.
            If None, defaults to 443
        :type  ssl_verify: :class:`bool` or ``None``
        :param ssl_verify: A flag to indicate whether the ssl verification is required.
            If ``sslThumbprint`` is provided, this field can be omitted If
            None, defaults to True
        :type  ssl_thumbprint: :class:`str` or ``None``
        :param ssl_thumbprint: Thumbprint for SSL verification.
            If ``sslVerify`` if false, this field is not required
        """
        self.hostname = hostname
        self.username = username
        self.password = password
        self.https_port = https_port
        self.ssl_verify = ssl_verify
        self.ssl_thumbprint = ssl_thumbprint
        VapiStruct.__init__(self)


Connection._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.connection', {
        'hostname': type.StringType(),
        'username': type.StringType(),
        'password': type.SecretType(),
        'https_port': type.OptionalType(type.IntegerType()),
        'ssl_verify': type.OptionalType(type.BooleanType()),
        'ssl_thumbprint': type.OptionalType(type.StringType()),
    },
    Connection,
    False,
    None))



class EsxPlacementConfig(VapiStruct):
    """
    The ``EsxPlacementConfig`` class contains configuration of ESX placement of
    the target appliance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 datastore_name=None,
                 network_name=None,
                 resource_pool_path=None,
                ):
        """
        :type  datastore_name: :class:`str`
        :param datastore_name: The datastore on which to store the files of the appliance. This
            value has to be either a specific datastore name, or a specific
            datastore in a datastore cluster. The datastore must be accessible
            from the ESX host.
        :type  network_name: :class:`str` or ``None``
        :param network_name: The network of the ESX host to which the new appliance should
            connect. Omit this parameter if the ESX host has one network.
            If None and there is only one network configured, it will be used.
        :type  resource_pool_path: :class:`str` or ``None``
        :param resource_pool_path: The path to the resource pool on the ESX host in which the
            appliance will be deployed.
            Not applicable when not in resource pool
        """
        self.datastore_name = datastore_name
        self.network_name = network_name
        self.resource_pool_path = resource_pool_path
        VapiStruct.__init__(self)


EsxPlacementConfig._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.esx_placement_config', {
        'datastore_name': type.StringType(),
        'network_name': type.OptionalType(type.StringType()),
        'resource_pool_path': type.OptionalType(type.StringType()),
    },
    EsxPlacementConfig,
    False,
    None))



class VcPlacementConfig(VapiStruct):
    """
    The ``VcPlacementConfig`` class contains configuration of VC placement of
    the target appliance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 vm_folder_path=None,
                 resource_pool_path=None,
                 cluster_path=None,
                 host_path=None,
                 datastore_name=None,
                 datastore_cluster_name=None,
                 network_name=None,
                ):
        """
        :type  vm_folder_path: :class:`str` or ``None``
        :param vm_folder_path: Aboslute path of the VM folder. VM folder must be visible by the
            Data Center of the compute
            resourceFormat:/{dc}/{vm_folder1}/{vm_folder2}e.g.:'/DCenter/VM
            Folder 0/VM Folder1'.
            Mutually exclusive between {\\\\@vm_folder_path},
            ``#resource_pool_path``, ``#cluster_path``, and ``#host_path``
        :type  resource_pool_path: :class:`str` or ``None``
        :param resource_pool_path: Absolute path to resource pool. Format: /{datacenter
            folder}/{datacenter name}/host/{host
            name}/{cluster_name}/Resources/{resource pool}. e.g: Your
            Datacenter Folder/Your Datacenter/host/Your Cluster/Resources/Your
            Resource Pool
            Mutually exclusive between {\\\\@vm_folder_path},
            ``#resource_pool_path``, ``#cluster_path``, and ``#host_path``
        :type  cluster_path: :class:`str` or ``None``
        :param cluster_path: Absolute path to the cluster. Format: /{datacenter
            folder}/{datacenter name}/host/{cluster_name}. e.g: /Your
            Datacenter Folder/Your Datacenter/host/Your Cluster
            Mutually exclusive between {\\\\@vm_folder_path},
            ``#resource_pool_path``, ``#cluster_path``, and ``#host_path``
        :type  host_path: :class:`str` or ``None``
        :param host_path: Absolute path of the ESX host (FQDN/IP) in the vCenter inventory
            tree.
            Mutually exclusive between {\\\\@vm_folder_path},
            ``#resource_pool_path``, ``#cluster_path``, and ``#host_path``
        :type  datastore_name: :class:`str` or ``None``
        :param datastore_name: The datastore on which to store the files of the appliance. This
            value has to be either a specific datastore name, or a specific
            datastore in a datastore cluster. The datastore must have the space
            defined as appliance storage size.
            Mutually exclusive between ``#datastore_name`` and
            ``#datastore_cluster_name``
        :type  datastore_cluster_name: :class:`str` or ``None``
        :param datastore_cluster_name: The datastore cluster on which to store the files of the appliance.
            The datastore cluster must have the space defined as appliance
            storage size.
            Mutually exclusive between ``#datastore_name`` and
            ``#datastore_cluster_name``
        :type  network_name: :class:`str`
        :param network_name: Name of the network. e.g. VM Network
        """
        self.vm_folder_path = vm_folder_path
        self.resource_pool_path = resource_pool_path
        self.cluster_path = cluster_path
        self.host_path = host_path
        self.datastore_name = datastore_name
        self.datastore_cluster_name = datastore_cluster_name
        self.network_name = network_name
        VapiStruct.__init__(self)


VcPlacementConfig._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.vc_placement_config', {
        'vm_folder_path': type.OptionalType(type.StringType()),
        'resource_pool_path': type.OptionalType(type.StringType()),
        'cluster_path': type.OptionalType(type.StringType()),
        'host_path': type.OptionalType(type.StringType()),
        'datastore_name': type.OptionalType(type.StringType()),
        'datastore_cluster_name': type.OptionalType(type.StringType()),
        'network_name': type.StringType(),
    },
    VcPlacementConfig,
    False,
    None))



class Esx(VapiStruct):
    """
    The ``Esx`` class contains ESX configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 connection=None,
                 placement_config=None,
                ):
        """
        :type  connection: :class:`Connection`
        :param connection: The configuration to connect to an ESX/VC.
        :type  placement_config: :class:`EsxPlacementConfig`
        :param placement_config: The location of the new version of the vCSA on the desired ESX.
        """
        self.connection = connection
        self.placement_config = placement_config
        VapiStruct.__init__(self)


Esx._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.esx', {
        'connection': type.ReferenceType(__name__, 'Connection'),
        'placement_config': type.ReferenceType(__name__, 'EsxPlacementConfig'),
    },
    Esx,
    False,
    None))



class VCenter(VapiStruct):
    """
    The ``VCenter`` class contains configuration of the VC that hosts/will host
    an appliance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 connection=None,
                 placement_config=None,
                ):
        """
        :type  connection: :class:`Connection`
        :param connection: The configuration to connect to an ESX/VC.
        :type  placement_config: :class:`VcPlacementConfig`
        :param placement_config: The location of the new version of the vCSA on the desired vCenter.
            
            All names are case-sensitive. you can install the appliance to one
            of the following destinations: 1. A resource pool in a cluster, use
            'cluster_path'. 2. A specific ESX host in a cluster, use
            'host_path'. 3. A resource pool in a specific ESX host being
            managed by the current vCenter, use 'resource_pool_path'. 4. To
            install a new appliance to a specific ESX host in a cluster,
            provide the 'host_path' key, and the 'datastore_name', e.g.
            'host_path': '/MyDataCenter/host/MyCluster/10.20.30.40',
            'datastore_name': 'Your Datastore'. 5. To install a new appliance
            to a specific resource pool, provide the 'resource_pool_path', and
            the 'datastore_name', e.g. 'resource_pool_path': '/Your Datacenter
            Folder/Your Datacenter/host/Your Cluster/Resources/Your Resource
            Pool', 'datastore_name': 'Your Datastore'. 6. To place a new
            appliance to a virtual machine Folder, provide the
            'vm_folder_path', e.g. vm_folder_path': 'VM Folder 0/VM Folder1'.
        """
        self.connection = connection
        self.placement_config = placement_config
        VapiStruct.__init__(self)


VCenter._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.V_center', {
        'connection': type.ReferenceType(__name__, 'Connection'),
        'placement_config': type.ReferenceType(__name__, 'VcPlacementConfig'),
    },
    VCenter,
    False,
    None))



class Location(VapiStruct):
    """
    The ``Location`` class contains configuration of appliance location.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 esx=None,
                 vcenter=None,
                ):
        """
        :type  esx: :class:`Esx` or ``None``
        :param esx: This section describes the ESX host on which to deploy the
            appliance. Required if you are deploying the appliance directly on
            an ESX host.
            Mutual exclusive between ``esx`` and ``vcenter``
        :type  vcenter: :class:`VCenter` or ``None``
        :param vcenter: This subsection describes the vCenter on which to deploy the
            appliance.
            Mutual exclusive between ``esx`` and ``vcenter``
        """
        self.esx = esx
        self.vcenter = vcenter
        VapiStruct.__init__(self)


Location._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.location', {
        'esx': type.OptionalType(type.ReferenceType(__name__, 'Esx')),
        'vcenter': type.OptionalType(type.ReferenceType(__name__, 'VCenter')),
    },
    Location,
    False,
    None))



class ApplianceDeploymentConfig(VapiStruct):
    """
    The ``ApplianceDeploymentConfig`` class contains the new appliance
    deployment configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 appliance=None,
                 location=None,
                ):
        """
        :type  appliance: :class:`ApplianceDeployment`
        :param appliance: Description of the new appliance configuration.
        :type  location: :class:`Location`
        :param location: ESX or VC on which to deploy the appliance.
        """
        self.appliance = appliance
        self.location = location
        VapiStruct.__init__(self)


ApplianceDeploymentConfig._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.common.appliance_deployment_config', {
        'appliance': type.ReferenceType(__name__, 'ApplianceDeployment'),
        'location': type.ReferenceType(__name__, 'Location'),
    },
    ApplianceDeploymentConfig,
    False,
    None))




class StubFactory(StubFactoryBase):
    _attrs = {
    }

