/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup;

import org.apache.solr.core.backup.BackupId;

public class ShardBackupId {
    private static final String FILENAME_SUFFIX = ".json";
    private final String shardName;
    private final BackupId containingBackupId;

    public ShardBackupId(String shardName, BackupId containingBackupId) {
        this.shardName = shardName;
        this.containingBackupId = containingBackupId;
    }

    public String getShardName() {
        return this.shardName;
    }

    public BackupId getContainingBackupId() {
        return this.containingBackupId;
    }

    public String getIdAsString() {
        return "md_" + this.shardName + "_" + this.containingBackupId.getId();
    }

    public String getBackupMetadataFilename() {
        return this.getIdAsString() + FILENAME_SUFFIX;
    }

    public static ShardBackupId from(String idString) {
        String[] idComponents = idString.split("_");
        if (idComponents.length != 3) {
            throw new IllegalArgumentException("Unable to parse invalid ShardBackupId: " + idString);
        }
        BackupId containingBackupId = new BackupId(Integer.parseInt(idComponents[2]));
        return new ShardBackupId(idComponents[1], containingBackupId);
    }

    public static ShardBackupId fromShardMetadataFilename(String filenameString) {
        if (!filenameString.endsWith(FILENAME_SUFFIX)) {
            throw new IllegalArgumentException("'filenameString' arg [" + filenameString + "] does not appear to be a filename");
        }
        String idString = filenameString.substring(0, filenameString.length() - FILENAME_SUFFIX.length());
        return ShardBackupId.from(idString);
    }
}

