/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;

class BoolConstValueSource
extends ConstNumberSource {
    final boolean constant;

    public BoolConstValueSource(boolean constant) {
        this.constant = constant;
    }

    public String description() {
        return "const(" + this.constant + ")";
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        return new BoolDocValues((ValueSource)this){

            public boolean boolVal(int doc) {
                return BoolConstValueSource.this.constant;
            }
        };
    }

    public int hashCode() {
        return this.constant ? 305419896 : -2023406815;
    }

    public boolean equals(Object o) {
        if (BoolConstValueSource.class != o.getClass()) {
            return false;
        }
        BoolConstValueSource other = (BoolConstValueSource)((Object)o);
        return this.constant == other.constant;
    }

    public int getInt() {
        return this.constant ? 1 : 0;
    }

    public long getLong() {
        return this.constant ? 1L : 0L;
    }

    public float getFloat() {
        return this.constant ? 1.0f : 0.0f;
    }

    public double getDouble() {
        return this.constant ? 1.0 : 0.0;
    }

    public Number getNumber() {
        return this.constant ? 1 : 0;
    }

    public boolean getBool() {
        return this.constant;
    }
}

