/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeactivateEncryptionAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        tlsContext.getRecordLayer().setRecordCipher(new RecordNullCipher(tlsContext));
        tlsContext.getRecordLayer().updateDecryptionCipher();
        tlsContext.getRecordLayer().updateEncryptionCipher();
        LOGGER.info("Deactivated Encryption/Decryption");
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.setExecuted(null);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DeactivateEncryptionAction;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        return hash;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

