/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class VtfmsProtocolDecoder
extends BaseProtocolDecoder {
    private static final String[] DIRECTIONS = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
    private static final Pattern PATTERN = new PatternBuilder().text("(").number("(d{15}),").number("[0-9A-Z]{3}dd,").number("(dd),").number("[^,]*,").number("(d+)?,").number("(?:d+)?,").number("(d+)?,").number("[^,]*,").expression("([AV]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(?:(d+)|([NESW]{1,2})),").number("(d+),").number("(d+),").number("(d+),").expression("[KNT],").number("(d+),").expression("([01]),").number("(d+.d+),").number("[^,]*,").number("(d+)?,").number("(d+.d+)?,").number("[^,]*,").number("(d+.d+)?,").expression("([01]),").expression("([01]),").expression("([01]),").expression("([01]),").expression("([01]),").expression("([01]),").expression("([01]),").number("[^,]*,").number("[^,]*").text(")").number("ddd").compile();

    public VtfmsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        switch (value) {
            case 10: {
                return "overspeed";
            }
            case 14: {
                return "powerCut";
            }
            case 15: {
                return "powerRestored";
            }
            case 32: {
                return "hardBraking";
            }
            case 33: {
                return "hardAcceleration";
            }
        }
        return null;
    }

    private double convertToDegrees(double value) {
        double degrees = Math.floor(value / 100.0);
        return degrees + (value - degrees * 100.0) / 60.0;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("alarm", this.decodeAlarm(parser.nextInt()));
        position.set("rssi", parser.nextInt());
        position.set("sat", parser.nextInt());
        position.setValid(parser.next().equals("A"));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        double latitude = parser.nextDouble();
        double longitude = parser.nextDouble();
        if (Math.abs(latitude) > 90.0 || Math.abs(longitude) > 180.0) {
            position.setLatitude(this.convertToDegrees(latitude));
            position.setLongitude(this.convertToDegrees(longitude));
        } else {
            position.setLatitude(latitude);
            position.setLongitude(longitude);
        }
        position.setCourse(parser.nextDouble(0.0));
        if (parser.hasNext()) {
            String direction = parser.next();
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (!direction.equals(DIRECTIONS[i])) continue;
                position.setCourse((double)i * 45.0);
                break;
            }
        }
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.set("hours", UnitsConverter.msFromHours(parser.nextInt().intValue()));
        position.set("idleHours", parser.nextInt());
        position.set("odometer", parser.nextInt() * 100);
        position.set("charge", parser.next().equals("1"));
        position.set("power", parser.nextDouble());
        position.set("fuel", parser.nextInt());
        position.set("adc1", parser.nextDouble());
        position.set("adc2", parser.nextDouble());
        position.set("in1", parser.nextInt());
        position.set("in2", parser.nextInt());
        position.set("in3", parser.nextInt());
        position.set("in4", parser.nextInt());
        position.set("out1", parser.nextInt());
        position.set("out2", parser.nextInt());
        position.set("out3", parser.nextInt());
        return position;
    }
}

