(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/db/sqlite#sqlite-connection::t
    (make-struct-type
     'std/db/sqlite#sqlite-connection::t
     std/db/dbi#connection::t
     '0
     'sqlite-connection
     '((final: . #t))
     '#f
     '()))
  (define std/db/sqlite#sqlite-connection?
    (make-struct-predicate std/db/sqlite#sqlite-connection::t))
  (define std/db/sqlite#make-sqlite-connection
    (lambda _$args2294_
      (apply make-struct-instance
             std/db/sqlite#sqlite-connection::t
             _$args2294_)))
  (define std/db/sqlite#sqlite-statement::t
    (make-struct-type
     'std/db/sqlite#sqlite-statement::t
     std/db/dbi#statement::t
     '0
     'sqlite-statement
     '((final: . #t))
     '#f
     '()))
  (define std/db/sqlite#sqlite-statement?
    (make-struct-predicate std/db/sqlite#sqlite-statement::t))
  (define std/db/sqlite#make-sqlite-statement
    (lambda _$args2291_
      (apply make-struct-instance
             std/db/sqlite#sqlite-statement::t
             _$args2291_)))
  (define std/db/sqlite#sqlite-connection:::init!
    std/db/dbi#connection:::init!)
  (bind-method!
   std/db/sqlite#sqlite-connection::t
   ':init!
   std/db/sqlite#sqlite-connection:::init!
   '#f)
  (define std/db/sqlite#raise-sqlite-error
    (lambda (_where2164_ _err2165_)
      (let ((_errstr2167_ (std/db/_sqlite#sqlite3_errstr _err2165_)))
        (std/db/dbi#raise-sql-error
         _where2164_
         (std/format#format '"SQLite error: ~a" _errstr2167_)
         _err2165_))))
  (define std/db/sqlite#sqlite-open__%
    (lambda (_file2146_ _flags2147_)
      (let* ((_ptr2149_ (std/db/_sqlite#make_sqlite3_ptr_ptr))
             (_r2151_ (std/db/_sqlite#sqlite3_open
                       _ptr2149_
                       _file2146_
                       _flags2147_)))
        (if (let ()
              (declare (not safe))
              (##fx= _r2151_ std/db/_sqlite#SQLITE_OK))
            (let ((__obj5966
                   (make-object std/db/sqlite#sqlite-connection::t '4)))
              (if (let ((__tmp5967
                         (let ()
                           (declare (not safe))
                           (##vector-length __obj5966))))
                    (declare (not safe))
                    (##fx< '1 __tmp5967))
                  (let ((__tmp5968 (std/db/_sqlite#sqlite3_ptr _ptr2149_)))
                    (declare (not safe))
                    (##vector-set! __obj5966 '1 __tmp5968))
                  (error '"struct-instance-init!: too many arguments for struct"
                         __obj5966))
              __obj5966)
            (std/db/sqlite#raise-sqlite-error 'sqlite-open _r2151_)))))
  (define std/db/sqlite#sqlite-open__0
    (lambda (_file2157_)
      (let ((_flags2159_
             (fxior std/db/_sqlite#SQLITE_OPEN_READWRITE
                    std/db/_sqlite#SQLITE_OPEN_CREATE)))
        (std/db/sqlite#sqlite-open__% _file2157_ _flags2159_))))
  (define std/db/sqlite#sqlite-open
    (lambda _g5970_
      (let ((_g5969_ (let () (declare (not safe)) (##length _g5970_))))
        (cond ((let () (declare (not safe)) (##fx= _g5969_ 1))
               (apply std/db/sqlite#sqlite-open__0 _g5970_))
              ((let () (declare (not safe)) (##fx= _g5969_ 2))
               (apply std/db/sqlite#sqlite-open__% _g5970_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/db/sqlite#sqlite-open
                _g5970_))))))
  (define std/db/sqlite#sqlite-connection::close
    (lambda (_self2143_)
      (std/db/_sqlite#sqlite3_close
       (##structure-ref _self2143_ '1 std/db/dbi#connection::t '#f))))
  (define std/db/sqlite#sqlite-connection::close::specialize
    (lambda (__t5951)
      (let* ((__class5952 (struct-subtype? std/db/dbi#connection::t __t5951))
             (__specializer5953
              (lambda (_self2143_)
                (std/db/_sqlite#sqlite3_close
                 (if __class5952
                     (let ()
                       (declare (not safe))
                       (##unchecked-structure-ref
                        _self2143_
                        '1
                        std/db/dbi#connection::t
                        '#f))
                     (error '"Type error; concrete type is not a subclass of expected type"
                            std/db/dbi#connection::t
                            _self2143_))))))
        (if __class5952
            std/db/sqlite#sqlite-connection::close::specialize::unchecked
            __specializer5953))))
  (define std/db/sqlite#sqlite-connection::close::specialize::unchecked
    (lambda (_self2143_)
      (std/db/_sqlite#sqlite3_close
       (let ()
         (declare (not safe))
         (##unchecked-structure-ref
          _self2143_
          '1
          std/db/dbi#connection::t
          '#f)))))
  (bind-specializer!
   std/db/sqlite#sqlite-connection::close
   std/db/sqlite#sqlite-connection::close::specialize)
  (bind-method!
   std/db/sqlite#sqlite-connection::t
   'close
   std/db/sqlite#sqlite-connection::close
   '#f)
  (define std/db/sqlite#sqlite-connection::prepare
    (lambda (_self2013_ _sql2014_)
      (let* ((_ptr2016_ (std/db/_sqlite#make_sqlite3_stmt_ptr_ptr))
             (_r2018_ (std/db/_sqlite#sqlite3_prepare
                       _ptr2016_
                       (##structure-ref
                        _self2013_
                        '1
                        std/db/dbi#connection::t
                        '#f)
                       _sql2014_)))
        (if (let ()
              (declare (not safe))
              (##fx= _r2018_ std/db/_sqlite#SQLITE_OK))
            (let ((__tmp5971 (std/db/_sqlite#sqlite3_stmt_ptr _ptr2016_)))
              (declare (not safe))
              (##structure std/db/sqlite#sqlite-statement::t __tmp5971))
            (std/db/sqlite#raise-sqlite-error 'sqlite-prepare _r2018_)))))
  (define std/db/sqlite#sqlite-connection::prepare::specialize
    (lambda (__t5954)
      (let* ((__class5955 (struct-subtype? std/db/dbi#connection::t __t5954))
             (__specializer5956
              (lambda (_self2013_ _sql2014_)
                (let* ((_ptr2016_ (std/db/_sqlite#make_sqlite3_stmt_ptr_ptr))
                       (_r2018_ (std/db/_sqlite#sqlite3_prepare
                                 _ptr2016_
                                 (if __class5955
                                     (let ()
                                       (declare (not safe))
                                       (##unchecked-structure-ref
                                        _self2013_
                                        '1
                                        std/db/dbi#connection::t
                                        '#f))
                                     (error '"Type error; concrete type is not a subclass of expected type"
                                            std/db/dbi#connection::t
                                            _self2013_))
                                 _sql2014_)))
                  (if (let ()
                        (declare (not safe))
                        (##fx= _r2018_ std/db/_sqlite#SQLITE_OK))
                      (let ((__tmp5972
                             (std/db/_sqlite#sqlite3_stmt_ptr _ptr2016_)))
                        (declare (not safe))
                        (##structure
                         std/db/sqlite#sqlite-statement::t
                         __tmp5972))
                      (std/db/sqlite#raise-sqlite-error
                       'sqlite-prepare
                       _r2018_))))))
        (if __class5955
            std/db/sqlite#sqlite-connection::prepare::specialize::unchecked
            __specializer5956))))
  (define std/db/sqlite#sqlite-connection::prepare::specialize::unchecked
    (lambda (_self2013_ _sql2014_)
      (let* ((_ptr2016_ (std/db/_sqlite#make_sqlite3_stmt_ptr_ptr))
             (_r2018_ (std/db/_sqlite#sqlite3_prepare
                       _ptr2016_
                       (let ()
                         (declare (not safe))
                         (##unchecked-structure-ref
                          _self2013_
                          '1
                          std/db/dbi#connection::t
                          '#f))
                       _sql2014_)))
        (if (let ()
              (declare (not safe))
              (##fx= _r2018_ std/db/_sqlite#SQLITE_OK))
            (let ((__tmp5973 (std/db/_sqlite#sqlite3_stmt_ptr _ptr2016_)))
              (declare (not safe))
              (##structure std/db/sqlite#sqlite-statement::t __tmp5973))
            (std/db/sqlite#raise-sqlite-error 'sqlite-prepare _r2018_)))))
  (bind-specializer!
   std/db/sqlite#sqlite-connection::prepare
   std/db/sqlite#sqlite-connection::prepare::specialize)
  (bind-method!
   std/db/sqlite#sqlite-connection::t
   'prepare
   std/db/sqlite#sqlite-connection::prepare
   '#f)
  (define std/db/sqlite#sqlite-statement::finalize
    (lambda (_self1889_)
      (std/db/_sqlite#sqlite3_finalize
       (##structure-ref _self1889_ '1 std/db/dbi#statement::t '#f))))
  (define std/db/sqlite#sqlite-statement::finalize::specialize
    (lambda (__t5957)
      (let* ((__class5958 (struct-subtype? std/db/dbi#statement::t __t5957))
             (__specializer5959
              (lambda (_self1889_)
                (std/db/_sqlite#sqlite3_finalize
                 (if __class5958
                     (let ()
                       (declare (not safe))
                       (##unchecked-structure-ref
                        _self1889_
                        '1
                        std/db/dbi#statement::t
                        '#f))
                     (error '"Type error; concrete type is not a subclass of expected type"
                            std/db/dbi#statement::t
                            _self1889_))))))
        (if __class5958
            std/db/sqlite#sqlite-statement::finalize::specialize::unchecked
            __specializer5959))))
  (define std/db/sqlite#sqlite-statement::finalize::specialize::unchecked
    (lambda (_self1889_)
      (std/db/_sqlite#sqlite3_finalize
       (let ()
         (declare (not safe))
         (##unchecked-structure-ref
          _self1889_
          '1
          std/db/dbi#statement::t
          '#f)))))
  (bind-specializer!
   std/db/sqlite#sqlite-statement::finalize
   std/db/sqlite#sqlite-statement::finalize::specialize)
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'finalize
   std/db/sqlite#sqlite-statement::finalize
   '#f)
  (define std/db/sqlite#sqlite-statement::bind
    (lambda (_self1662_ . _args1663_)
      (let* ((_self16641670_ _self1662_)
             (_E16661674_
              (lambda () (error '"No clause matching" _self16641670_)))
             (_K16671759_
              (lambda (_stmt1677_)
                (let* ((_params1679_
                        (std/db/_sqlite#sqlite3_bind_parameter_count
                         _stmt1677_))
                       (_g5974_ (if (= _params1679_ (length _args1663_))
                                    '#!void
                                    (error '"bind parameters do not match statement count"
                                           _args1663_
                                           _params1679_))))
                  (let* ((_g16821689_ (std/iter#iter _args1663_))
                         (_g16831692_
                          (std/iter#iter
                           (std/iter#in-iota__1 _params1679_ '1)))
                         (_g16841695_
                          (let ()
                            (declare (not safe))
                            (##unchecked-structure-ref
                             _g16821689_
                             '2
                             std/iter#iterator::t
                             '#f)))
                         (_g16851698_
                          (let ()
                            (declare (not safe))
                            (##unchecked-structure-ref
                             _g16831692_
                             '2
                             std/iter#iterator::t
                             '#f)))
                         (_iter-do1730_
                          (lambda (_g16861701_ _g16871703_)
                            (let ((_g17051711_ _g16861701_)
                                  (_g17061713_ _g16871703_))
                              (let* ((_E17081717_
                                      (lambda ()
                                        (error '"No clause matching"
                                               _g17051711_
                                               _g17061713_)))
                                     (_K17091723_
                                      (lambda (_arg1720_ _param1721_)
                                        (if (not _arg1720_)
                                            (std/db/_sqlite#sqlite3_bind_null
                                             _stmt1677_
                                             _param1721_)
                                            (if (number? _arg1720_)
                                                (if (integer? _arg1720_)
                                                    (if (< (abs _arg1720_)
                                                           (expt '2 '32))
                                                        (std/db/_sqlite#sqlite3_bind_int
                                                         _stmt1677_
                                                         _param1721_
                                                         _arg1720_)
                                                        (std/db/_sqlite#sqlite3_bind_int64
                                                         _stmt1677_
                                                         _param1721_
                                                         _arg1720_))
                                                    (if (real? _arg1720_)
                                                        (std/db/_sqlite#sqlite3_bind_double
                                                         _stmt1677_
                                                         _param1721_
                                                         (exact->inexact
                                                          _arg1720_))
                                                        (error '"cannot bind number; not a real"
                                                               _arg1720_)))
                                                (if (string? _arg1720_)
                                                    (std/db/_sqlite#sqlite3_bind_text
                                                     _stmt1677_
                                                     _param1721_
                                                     _arg1720_)
                                                    (if (u8vector? _arg1720_)
                                                        (std/db/_sqlite#sqlite3_bind_blob
                                                         _stmt1677_
                                                         _param1721_
                                                         _arg1720_)
                                                        (if error
                                                            _arg1720_
                                                            '#!void)))))))
                                     (_arg1726_ _g17051711_)
                                     (_param1728_ _g17061713_))
                                (_K17091723_ _arg1726_ _param1728_))))))
                    (declare (not safe))
                    (begin
                      (let _lp1735_ ()
                        (let ((_g16861739_ (_g16841695_ _g16821689_))
                              (_g16871740_ (_g16851698_ _g16831692_)))
                          (if (or (eq? std/iter#iter-end _g16861739_)
                                  (eq? std/iter#iter-end _g16871740_))
                              '#!void
                              (begin
                                (_iter-do1730_ _g16861739_ _g16871740_)
                                (_lp1735_)))))
                      (let ((_$e1745_
                             (##unchecked-structure-ref
                              _g16821689_
                              '3
                              std/iter#iterator::t
                              '#f)))
                        (if _$e1745_
                            ((lambda (_g17471749_) (_g17471749_ _g16821689_))
                             _$e1745_)
                            '#!void))
                      (let ((_$e1752_
                             (##unchecked-structure-ref
                              _g16831692_
                              '3
                              std/iter#iterator::t
                              '#f)))
                        (if _$e1752_
                            ((lambda (_g17541756_) (_g17541756_ _g16831692_))
                             _$e1752_)
                            '#!void))
                      '#!void))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _self16641670_
               'std/db/sqlite#sqlite-statement::t))
            (let* ((_e16681762_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _self16641670_ '1)))
                   (_stmt1765_ _e16681762_))
              (_K16671759_ _stmt1765_))
            (_E16661674_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'bind
   std/db/sqlite#sqlite-statement::bind
   '#f)
  (define std/db/sqlite#sqlite-statement::clear
    (lambda (_self1538_)
      (std/db/_sqlite#sqlite3_clear_bindings
       (##structure-ref _self1538_ '1 std/db/dbi#statement::t '#f))))
  (define std/db/sqlite#sqlite-statement::clear::specialize
    (lambda (__t5960)
      (let* ((__class5961 (struct-subtype? std/db/dbi#statement::t __t5960))
             (__specializer5962
              (lambda (_self1538_)
                (std/db/_sqlite#sqlite3_clear_bindings
                 (if __class5961
                     (let ()
                       (declare (not safe))
                       (##unchecked-structure-ref
                        _self1538_
                        '1
                        std/db/dbi#statement::t
                        '#f))
                     (error '"Type error; concrete type is not a subclass of expected type"
                            std/db/dbi#statement::t
                            _self1538_))))))
        (if __class5961
            std/db/sqlite#sqlite-statement::clear::specialize::unchecked
            __specializer5962))))
  (define std/db/sqlite#sqlite-statement::clear::specialize::unchecked
    (lambda (_self1538_)
      (std/db/_sqlite#sqlite3_clear_bindings
       (let ()
         (declare (not safe))
         (##unchecked-structure-ref
          _self1538_
          '1
          std/db/dbi#statement::t
          '#f)))))
  (bind-specializer!
   std/db/sqlite#sqlite-statement::clear
   std/db/sqlite#sqlite-statement::clear::specialize)
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'clear
   std/db/sqlite#sqlite-statement::clear
   '#f)
  (define std/db/sqlite#sqlite-statement::reset
    (lambda (_self1414_)
      (std/db/_sqlite#sqlite3_reset
       (##structure-ref _self1414_ '1 std/db/dbi#statement::t '#f))))
  (define std/db/sqlite#sqlite-statement::reset::specialize
    (lambda (__t5963)
      (let* ((__class5964 (struct-subtype? std/db/dbi#statement::t __t5963))
             (__specializer5965
              (lambda (_self1414_)
                (std/db/_sqlite#sqlite3_reset
                 (if __class5964
                     (let ()
                       (declare (not safe))
                       (##unchecked-structure-ref
                        _self1414_
                        '1
                        std/db/dbi#statement::t
                        '#f))
                     (error '"Type error; concrete type is not a subclass of expected type"
                            std/db/dbi#statement::t
                            _self1414_))))))
        (if __class5964
            std/db/sqlite#sqlite-statement::reset::specialize::unchecked
            __specializer5965))))
  (define std/db/sqlite#sqlite-statement::reset::specialize::unchecked
    (lambda (_self1414_)
      (std/db/_sqlite#sqlite3_reset
       (let ()
         (declare (not safe))
         (##unchecked-structure-ref
          _self1414_
          '1
          std/db/dbi#statement::t
          '#f)))))
  (bind-specializer!
   std/db/sqlite#sqlite-statement::reset
   std/db/sqlite#sqlite-statement::reset::specialize)
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'reset
   std/db/sqlite#sqlite-statement::reset
   '#f)
  (define std/db/sqlite#sqlite-statement::exec
    (lambda (_self1263_)
      (let* ((_self12641270_ _self1263_)
             (_E12661274_
              (lambda () (error '"No clause matching" _self12641270_)))
             (_K12671284_
              (lambda (_stmt1277_)
                (let ((_r1279_ (std/db/_sqlite#sqlite3_step _stmt1277_)))
                  (if (or (eq? _r1279_ std/db/_sqlite#SQLITE_DONE)
                          (eq? _r1279_ std/db/_sqlite#SQLITE_ROW))
                      '#!void
                      (std/db/sqlite#raise-sqlite-error
                       'sqlite-exec
                       _r1279_))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _self12641270_
               'std/db/sqlite#sqlite-statement::t))
            (let* ((_e12681287_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _self12641270_ '1)))
                   (_stmt1290_ _e12681287_))
              (_K12671284_ _stmt1290_))
            (_E12661274_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'exec
   std/db/sqlite#sqlite-statement::exec
   '#f)
  (define std/db/sqlite#sqlite-statement::query-start void)
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-start
   std/db/sqlite#sqlite-statement::query-start
   '#f)
  (define std/db/sqlite#sqlite-statement::query-fetch
    (lambda (_self993_)
      (let* ((_self9941000_ _self993_)
             (_E9961004_
              (lambda () (error '"No clause matching" _self9941000_)))
             (_K9971011_
              (lambda (_stmt1007_)
                (let ((_r1009_ (std/db/_sqlite#sqlite3_step _stmt1007_)))
                  (if (eq? _r1009_ std/db/_sqlite#SQLITE_ROW)
                      '#!void
                      (if (eq? _r1009_ std/db/_sqlite#SQLITE_DONE)
                          std/iter#iter-end
                          (std/db/sqlite#raise-sqlite-error
                           'sqlite-query-fetch
                           _r1009_)))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _self9941000_
               'std/db/sqlite#sqlite-statement::t))
            (let* ((_e9981014_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _self9941000_ '1)))
                   (_stmt1017_ _e9981014_))
              (_K9971011_ _stmt1017_))
            (_E9961004_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-fetch
   std/db/sqlite#sqlite-statement::query-fetch
   '#f)
  (define std/db/sqlite#sqlite-statement::query-row
    (lambda (_self807_)
      (let* ((_self808814_ _self807_)
             (_E810818_ (lambda () (error '"No clause matching" _self808814_)))
             (_K811863_
              (lambda (_stmt821_)
                (letrec ((_column-e823_
                          (lambda (_col854_)
                            (let ((_t856_ (std/db/_sqlite#sqlite3_column_type
                                           _stmt821_
                                           _col854_)))
                              (if (eq? _t856_ std/db/_sqlite#SQLITE_INTEGER)
                                  (std/db/_sqlite#sqlite3_column_int64
                                   _stmt821_
                                   _col854_)
                                  (if (eq? _t856_ std/db/_sqlite#SQLITE_FLOAT)
                                      (std/db/_sqlite#sqlite3_column_double
                                       _stmt821_
                                       _col854_)
                                      (if (eq? _t856_
                                               std/db/_sqlite#SQLITE_TEXT)
                                          (std/db/_sqlite#sqlite3_column_text
                                           _stmt821_
                                           _col854_)
                                          (if (eq? _t856_
                                                   std/db/_sqlite#SQLITE_NULL)
                                              '#f
                                              (if (eq? _t856_
                                                       std/db/_sqlite#SQLITE_BLOB)
                                                  (let* ((_count858_
                                                          (std/db/_sqlite#sqlite3_column_bytes
                                                           _stmt821_
                                                           _col854_))
                                                         (_bytes860_
                                                          (make-u8vector
                                                           _count858_)))
                                                    (std/db/_sqlite#sqlite3_column_blob
                                                     _stmt821_
                                                     _col854_
                                                     _bytes860_)
                                                    _bytes860_)
                                                  (error '"Unexpected column type"
                                                         _t856_))))))))))
                  (let* ((_count825_
                          (std/db/_sqlite#sqlite3_column_count _stmt821_))
                         (_$e827_ _count825_))
                    (if (eq? '0 _$e827_)
                        '#!void
                        (if (eq? '1 _$e827_)
                            (_column-e823_ '0)
                            (list->vector
                             (let ((_iter-do835_
                                    (lambda (_n830_)
                                      (let ((_x833_ _n830_))
                                        (_column-e823_ _x833_))))
                                   (_$count837_ _count825_)
                                   (_$start839_ '0)
                                   (_$step841_ '1))
                               (let _lp844_ ((_i847_ '0)
                                             (_val849_ _$start839_)
                                             (_r851_ '()))
                                 (if (fx< _i847_ _$count837_)
                                     (_lp844_ (fx+ _i847_ '1)
                                              (+ _val849_ _$step841_)
                                              (cons (_iter-do835_ _val849_)
                                                    _r851_))
                                     (reverse _r851_))))))))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _self808814_
               'std/db/sqlite#sqlite-statement::t))
            (let* ((_e812866_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _self808814_ '1)))
                   (_stmt869_ _e812866_))
              (_K811863_ _stmt869_))
            (_E810818_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-row
   std/db/sqlite#sqlite-statement::query-row
   '#f)
  (define std/db/sqlite#sqlite-statement::query-fini
    std/db/sqlite#sqlite-statement::reset)
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-fini
   std/db/sqlite#sqlite-statement::query-fini
   '#f)
  (define std/db/sqlite#sqlite-statement::columns
    (lambda (_self530_)
      (let* ((_self531537_ _self530_)
             (_E533541_ (lambda () (error '"No clause matching" _self531537_)))
             (_K534555_
              (lambda (_stmt544_)
                (let ((_count546_
                       (std/db/_sqlite#sqlite3_column_count _stmt544_)))
                  (let _lp548_ ((_k550_ '0) (_cols551_ '()))
                    (if (let () (declare (not safe)) (##fx< _k550_ _count546_))
                        (let ((_name553_
                               (std/db/_sqlite#sqlite3_column_name
                                _stmt544_
                                _k550_)))
                          (_lp548_ (let ()
                                     (declare (not safe))
                                     (##fx+ _k550_ '1))
                                   (cons _name553_ _cols551_)))
                        (reverse _cols551_)))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _self531537_
               'std/db/sqlite#sqlite-statement::t))
            (let* ((_e535558_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _self531537_ '1)))
                   (_stmt561_ _e535558_))
              (_K534555_ _stmt561_))
            (_E533541_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'columns
   std/db/sqlite#sqlite-statement::columns
   '#f))
