(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/text/utf16#string->utf16__%
    (lambda (_str525_ _endianness526_ _BOM?527_)
      (if (string? _str525_) '#!void (error '"Expected string" _str525_))
      (let ((_u16-set!532_
             (let ((_$e529_ _endianness526_))
               (if (eq? 'big _$e529_)
                   std/text/utf16#u16-set!/be
                   (if (eq? 'little _$e529_)
                       std/text/utf16#u16-set!/le
                       (if (eq? 'native _$e529_)
                           std/misc/bytes#&u8vector-u16-set!/native
                           (error '"Bad endianness" _endianness526_)))))))
        (std/text/utf16#utf16-encode _str525_ _u16-set!532_ _BOM?527_))))
  (define std/text/utf16#string->utf16__0
    (lambda (_str537_)
      (let* ((_endianness539_ std/misc/bytes#big) (_BOM?541_ '#f))
        (std/text/utf16#string->utf16__% _str537_ _endianness539_ _BOM?541_))))
  (define std/text/utf16#string->utf16__1
    (lambda (_str543_ _endianness544_)
      (let ((_BOM?546_ '#f))
        (std/text/utf16#string->utf16__% _str543_ _endianness544_ _BOM?546_))))
  (define std/text/utf16#string->utf16
    (lambda _g4189_
      (let ((_g4188_ (##length _g4189_)))
        (cond ((##fx= _g4188_ 1)
               (apply std/text/utf16#string->utf16__0 _g4189_))
              ((##fx= _g4188_ 2)
               (apply std/text/utf16#string->utf16__1 _g4189_))
              ((##fx= _g4188_ 3)
               (apply std/text/utf16#string->utf16__% _g4189_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/utf16#string->utf16
                _g4189_))))))
  (define std/text/utf16#utf16-encode
    (lambda (_str516_ _u16-set!517_ _BOM?518_)
      (if _BOM?518_
          (let ((_bytes520_
                 (make-u8vector (fx+ (fx* '4 (string-length _str516_)) '2))))
            (_u16-set!517_ _bytes520_ '0 '65279)
            (std/text/utf16#utf16-encode!
             _str516_
             _bytes520_
             '2
             _u16-set!517_))
          (let ((_bytes522_ (make-u8vector (fx* '4 (string-length _str516_)))))
            (std/text/utf16#utf16-encode!
             _str516_
             _bytes522_
             '0
             _u16-set!517_)))))
  (define std/text/utf16#utf16-encode!
    (lambda (_str489_ _bytes490_ _j491_ _u16-set!492_)
      (letrec* ((_end494_ (string-length _str489_)))
        (let _lp496_ ((_i498_ '0) (_j499_ _j491_))
          (if (fx< _i498_ _end494_)
              (let* ((_char501_ (string-ref _str489_ _i498_))
                     (_int503_ (char->integer _char501_)))
                (if (and (fixnum? _int503_)
                         (or (fx<= '0 _int503_ '55295)
                             (fx<= '57344 _int503_ '65535)))
                    (begin
                      (_u16-set!492_ _bytes490_ _j499_ _int503_)
                      (_lp496_ (fx+ _i498_ '1) (fx+ _j499_ '2)))
                    (if (<= '65536 _int503_ '1114111)
                        (let* ((_U509_ (- _int503_ '65536))
                               (_W1511_ (fx+ (arithmetic-shift _U509_ '-10)
                                             '55296))
                               (_W2513_ (fx+ (bitwise-and _U509_ '1023)
                                             '56320)))
                          (_u16-set!492_ _bytes490_ _j499_ _W1511_)
                          (_u16-set!492_ _bytes490_ (fx+ _j499_ '2) _W2513_)
                          (_lp496_ (fx+ _i498_ '1) (fx+ _j499_ '4)))
                        (std/error#raise-io-error
                         'utf16-encode!
                         '"Illegal codepoint"
                         _char501_
                         _int503_))))
              (if (fx< _j499_ (u8vector-length _bytes490_))
                  (begin (u8vector-shrink! _bytes490_ _j499_) _bytes490_)
                  _bytes490_))))))
  (define std/text/utf16#utf16->string__%
    (lambda (_bytes462_ _endianness463_ _endianness-mandatory?464_)
      (if (u8vector? _bytes462_)
          '#!void
          (error '"Expected u8vector" _bytes462_))
      (let ((_u16-ref469_
             (let ((_$e466_ _endianness463_))
               (if (eq? 'big _$e466_)
                   std/text/utf16#u16-ref/be
                   (if (eq? 'little _$e466_)
                       std/text/utf16#u16-ref/le
                       (if (eq? 'native _$e466_)
                           std/misc/bytes#&u8vector-u16-ref/native
                           (error '"Bad endianness" _endianness463_)))))))
        (std/text/utf16#utf16-decode
         _bytes462_
         _u16-ref469_
         (not _endianness-mandatory?464_)))))
  (define std/text/utf16#utf16->string__0
    (lambda (_bytes474_)
      (let* ((_endianness476_ std/misc/bytes#big)
             (_endianness-mandatory?478_ '#f))
        (std/text/utf16#utf16->string__%
         _bytes474_
         _endianness476_
         _endianness-mandatory?478_))))
  (define std/text/utf16#utf16->string__1
    (lambda (_bytes480_ _endianness481_)
      (let ((_endianness-mandatory?483_ '#f))
        (std/text/utf16#utf16->string__%
         _bytes480_
         _endianness481_
         _endianness-mandatory?483_))))
  (define std/text/utf16#utf16->string
    (lambda _g4191_
      (let ((_g4190_ (##length _g4191_)))
        (cond ((##fx= _g4190_ 1)
               (apply std/text/utf16#utf16->string__0 _g4191_))
              ((##fx= _g4190_ 2)
               (apply std/text/utf16#utf16->string__1 _g4191_))
              ((##fx= _g4190_ 3)
               (apply std/text/utf16#utf16->string__% _g4191_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/utf16#utf16->string
                _g4191_))))))
  (define std/text/utf16#utf16-decode
    (lambda (_bytes452_ _u16-ref453_ _BOM?454_)
      (letrec* ((_len456_ (u8vector-length _bytes452_)))
        (if (fxeven? _len456_)
            '#!void
            (std/error#raise-io-error
             'utf16-decode
             '"Cannot decode UTF-16; odd length u8vector"
             _bytes452_))
        (if _BOM?454_
            (if (fx>= _len456_ '2)
                (let ((_b0458_ (u8vector-ref _bytes452_ '0))
                      (_b1459_ (u8vector-ref _bytes452_ '1)))
                  (if (and (fx= _b0458_ '254) (fx= _b1459_ '255))
                      (std/text/utf16#utf16-decode!
                       _bytes452_
                       '2
                       std/text/utf16#u16-ref/be)
                      (if (and (fx= _b0458_ '255) (fx= _b1459_ '254))
                          (std/text/utf16#utf16-decode!
                           _bytes452_
                           '2
                           std/text/utf16#u16-ref/le)
                          (std/text/utf16#utf16-decode!
                           _bytes452_
                           '0
                           _u16-ref453_))))
                '"")
            (std/text/utf16#utf16-decode! _bytes452_ '0 _u16-ref453_)))))
  (define std/text/utf16#utf16-decode!
    (lambda (_bytes413_ _i414_ _u16-ref415_)
      (letrec* ((_end417_ (u8vector-length _bytes413_))
                (_str418_ (make-string (fx- _end417_ _i414_))))
        (let _lp420_ ((_i422_ _i414_) (_j423_ '0))
          (if (fx< _i422_ _end417_)
              (let ((_W425_ (_u16-ref415_ _bytes413_ _i422_)))
                (if (or (fx<= '0 _W425_ '55295) (fx<= '57344 _W425_ '65535))
                    (let ((_char430_ (integer->char _W425_)))
                      (string-set! _str418_ _j423_ _char430_)
                      (_lp420_ (fx+ _i422_ '2) (fx+ _j423_ '1)))
                    (let ((_Whi432_ (fxarithmetic-shift _W425_ '-10)))
                      (if (fx= _Whi432_ '54)
                          (let ((_i+2434_ (fx+ _i422_ '2)))
                            (if (fx< _i+2434_ _end417_)
                                (let* ((_W2436_ (_u16-ref415_
                                                 _bytes413_
                                                 _i+2434_))
                                       (_W2hi438_
                                        (fxarithmetic-shift _W2436_ '-10)))
                                  (if (fx= _W2hi438_ '55)
                                      (let* ((_u1441_ (fxand _W425_ '1023))
                                             (_u2443_ (fxand _W2436_ '1023))
                                             (_u*445_ (bitwise-ior
                                                       (arithmetic-shift
                                                        _u1441_
                                                        '10)
                                                       _u2443_))
                                             (_u447_ (+ _u*445_ '65536))
                                             (_char449_
                                              (integer->char _u447_)))
                                        (string-set! _str418_ _j423_ _char449_)
                                        (_lp420_ (fx+ _i422_ '4)
                                                 (fx+ _j423_ '1)))
                                      (begin
                                        (string-set! _str418_ _j423_ '65533)
                                        (_lp420_ (fx+ _i422_ '4)
                                                 (fx+ _j423_ '1)))))
                                (std/error#raise-io-error
                                 'utf16-decode!
                                 '"Incomplete character"
                                 _W425_)))
                          (begin
                            (string-set! _str418_ _j423_ '#\�)
                            (_lp420_ (fx+ _i422_ '2) (fx+ _j423_ '1)))))))
              (if (fx< _j423_ (string-length _str418_))
                  (begin (string-shrink! _str418_ _j423_) _str418_)
                  _str418_))))))
  (define std/text/utf16#u16-ref/be
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#big)
        std/misc/bytes#&u8vector-u16-ref/native
        (lambda (_v410_ _i411_)
          (std/misc/bytes#&u8vector-uint-ref/be _v410_ _i411_ '2))))
  (define std/text/utf16#u16-ref/le
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#little)
        std/misc/bytes#&u8vector-u16-ref/native
        (lambda (_v407_ _i408_)
          (std/misc/bytes#&u8vector-uint-ref/le _v407_ _i408_ '2))))
  (define std/text/utf16#u16-set!/be
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#big)
        std/misc/bytes#&u8vector-u16-set!/native
        (lambda (_v403_ _i404_ _n405_)
          (std/misc/bytes#&u8vector-uint-set!/be _v403_ _i404_ _n405_ '2))))
  (define std/text/utf16#u16-set!/le
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#little)
        std/misc/bytes#&u8vector-u16-set!/native
        (lambda (_v399_ _i400_ _n401_)
          (std/misc/bytes#&u8vector-uint-set!/le _v399_ _i400_ _n401_ '2)))))
