(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/socket#open-socket
    (lambda (_domain1643_ _type1644_ _proto1645_ _dir1646_)
      (let* ((_fd1651_
              (let ((_r1648_ (std/os/_socket#_socket
                              _domain1643_
                              _type1644_
                              _proto1645_)))
                (if (not (let () (declare (not safe)) (##fxnegative? _r1648_)))
                    _r1648_
                    (std/os/error#raise-os-error
                     (let () (declare (not safe)) (##fx- _r1648_))
                     std/os/socket#socket
                     _domain1643_
                     _type1644_
                     _proto1645_))))
             (_raw1653_ (std/os/fd#fdopen _fd1651_ _dir1646_ 'socket)))
        (std/os/fcntl#fd-set-nonblock/closeonexec _raw1653_)
        _raw1653_)))
  (define std/os/socket#socket__%
    (lambda (_domain1627_ _type1628_ _proto1629_)
      (std/os/socket#open-socket _domain1627_ _type1628_ _proto1629_ 'inout)))
  (define std/os/socket#socket__0
    (lambda (_domain1634_ _type1635_)
      (let ((_proto1637_ '0))
        (std/os/socket#socket__% _domain1634_ _type1635_ _proto1637_))))
  (define std/os/socket#socket
    (lambda _g5380_
      (let ((_g5379_ (let () (declare (not safe)) (##length _g5380_))))
        (cond ((let () (declare (not safe)) (##fx= _g5379_ 2))
               (apply std/os/socket#socket__0 _g5380_))
              ((let () (declare (not safe)) (##fx= _g5379_ 3))
               (apply std/os/socket#socket__% _g5380_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket
                _g5380_))))))
  (define std/os/socket#server-socket__%
    (lambda (_domain1610_ _type1611_ _proto1612_)
      (std/os/socket#open-socket _domain1610_ _type1611_ _proto1612_ 'in)))
  (define std/os/socket#server-socket__0
    (lambda (_domain1617_ _type1618_)
      (let ((_proto1620_ '0))
        (std/os/socket#server-socket__% _domain1617_ _type1618_ _proto1620_))))
  (define std/os/socket#server-socket
    (lambda _g5382_
      (let ((_g5381_ (let () (declare (not safe)) (##length _g5382_))))
        (cond ((let () (declare (not safe)) (##fx= _g5381_ 2))
               (apply std/os/socket#server-socket__0 _g5382_))
              ((let () (declare (not safe)) (##fx= _g5381_ 3))
               (apply std/os/socket#server-socket__% _g5382_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#server-socket
                _g5382_))))))
  (define std/os/socket#socket?
    (lambda (_obj1607_) (std/os/fd#fd-type? _obj1607_ 'socket)))
  (define std/os/socket#socket-bind
    (lambda (_sock1601_ _addr1602_)
      (let ((_r1604_ (std/os/_socket#_bind
                      (std/os/fd#fd-e _sock1601_)
                      (std/os/socket#socket-address _addr1602_))))
        (if (not (let () (declare (not safe)) (##fxnegative? _r1604_)))
            _r1604_
            (std/os/error#raise-os-error
             (let () (declare (not safe)) (##fx- _r1604_))
             std/os/socket#socket-bind
             _sock1601_
             _addr1602_)))))
  (define std/os/socket#socket-listen__%
    (lambda (_sock1585_ _backlog1586_)
      (let ((_r1588_ (std/os/_socket#_listen
                      (std/os/fd#fd-e _sock1585_)
                      _backlog1586_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r1588_)))
            _r1588_
            (std/os/error#raise-os-error
             (let () (declare (not safe)) (##fx- _r1588_))
             std/os/socket#socket-listen
             _sock1585_
             _backlog1586_)))))
  (define std/os/socket#socket-listen__0
    (lambda (_sock1594_)
      (let ((_backlog1596_ '10))
        (std/os/socket#socket-listen__% _sock1594_ _backlog1596_))))
  (define std/os/socket#socket-listen
    (lambda _g5384_
      (let ((_g5383_ (let () (declare (not safe)) (##length _g5384_))))
        (cond ((let () (declare (not safe)) (##fx= _g5383_ 1))
               (apply std/os/socket#socket-listen__0 _g5384_))
              ((let () (declare (not safe)) (##fx= _g5383_ 2))
               (apply std/os/socket#socket-listen__% _g5384_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-listen
                _g5384_))))))
  (define std/os/socket#socket-accept__%
    (lambda (_sock1550_ _sa1551_)
      (let ((_fd15521567_
             (let _lp1554_ ()
               (let ((_r1558_ (std/os/_socket#_accept
                               (std/os/fd#fd-e _sock1550_)
                               _sa1551_)))
                 (if (not (let ()
                            (declare (not safe))
                            (##fxnegative? _r1558_)))
                     _r1558_
                     (let ((_errno1561_
                            (let () (declare (not safe)) (##fx- _r1558_))))
                       (if (or (eq? _errno1561_ std/os/error#EAGAIN)
                               (eq? _errno1561_ std/os/error#EWOULDBLOCK))
                           '#f
                           (if (eq? _errno1561_ std/os/error#EINTR)
                               (_lp1554_)
                               (std/os/error#raise-os-error
                                _errno1561_
                                std/os/socket#socket-accept
                                _sock1550_
                                _sa1551_)))))))))
        (if _fd15521567_
            (let* ((_fd1570_ _fd15521567_)
                   (_raw1572_ (std/os/fd#fdopen _fd1570_ 'inout 'socket)))
              (std/os/fcntl#fd-set-nonblock _raw1572_)
              (std/os/fcntl#fd-set-closeonexec _raw1572_)
              _raw1572_)
            '#f))))
  (define std/os/socket#socket-accept__0
    (lambda (_sock1577_)
      (let ((_sa1579_ '#f))
        (std/os/socket#socket-accept__% _sock1577_ _sa1579_))))
  (define std/os/socket#socket-accept
    (lambda _g5386_
      (let ((_g5385_ (let () (declare (not safe)) (##length _g5386_))))
        (cond ((let () (declare (not safe)) (##fx= _g5385_ 1))
               (apply std/os/socket#socket-accept__0 _g5386_))
              ((let () (declare (not safe)) (##fx= _g5385_ 2))
               (apply std/os/socket#socket-accept__% _g5386_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-accept
                _g5386_))))))
  (define std/os/socket#socket-connect
    (lambda (_sock1534_ _sa1535_)
      (let ((_sa1537_ (std/os/socket#socket-address _sa1535_)))
        (let _lp1539_ ()
          (let ((_r1543_ (std/os/_socket#_connect
                          (std/os/fd#fd-e _sock1534_)
                          _sa1537_)))
            (if (not (let () (declare (not safe)) (##fxnegative? _r1543_)))
                _r1543_
                (let ((_errno1546_
                       (let () (declare (not safe)) (##fx- _r1543_))))
                  (if (eq? _errno1546_ std/os/error#EINPROGRESS)
                      '#f
                      (if (eq? _errno1546_ std/os/error#EINTR)
                          (_lp1539_)
                          (std/os/error#raise-os-error
                           _errno1546_
                           std/os/socket#socket-connect
                           _sock1534_
                           _sa1537_))))))))))
  (define std/os/socket#socket-shutdown
    (lambda (_sock1528_ _how1529_)
      (let ((_r1531_ (std/os/_socket#_shutdown
                      (std/os/fd#fd-e _sock1528_)
                      _how1529_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r1531_)))
            _r1531_
            (std/os/error#raise-os-error
             (let () (declare (not safe)) (##fx- _r1531_))
             std/os/socket#socket-shutdown
             _sock1528_
             _how1529_)))
      (if (eq? _how1529_ std/os/_socket#SHUT_RD)
          (close-input-port _sock1528_)
          (if (eq? _how1529_ std/os/_socket#SHUT_WR)
              (close-output-port _sock1528_)
              (if (eq? _how1529_ std/os/_socket#SHUT_RDWR)
                  (close-port _sock1528_)
                  '#!void)))))
  (define std/os/socket#socket-close
    (lambda (_sock1526_) (close-port _sock1526_)))
  (define std/os/socket#socket-send__%
    (lambda (_sock1474_ _bytes1475_ _start1476_ _end1477_ _flags1478_)
      (let _lp1480_ ()
        (let ((_r1484_ (std/os/_socket#_send
                        (std/os/fd#fd-e _sock1474_)
                        _bytes1475_
                        _start1476_
                        _end1477_
                        _flags1478_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r1484_)))
              _r1484_
              (let ((_errno1487_
                     (let () (declare (not safe)) (##fx- _r1484_))))
                (if (or (eq? _errno1487_ std/os/error#EAGAIN)
                        (eq? _errno1487_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno1487_ std/os/error#EINTR)
                        (_lp1480_)
                        (std/os/error#raise-os-error
                         _errno1487_
                         std/os/socket#socket-send
                         _sock1474_
                         _bytes1475_
                         _start1476_
                         _end1477_
                         _flags1478_)))))))))
  (define std/os/socket#socket-send__0
    (lambda (_sock1496_ _bytes1497_)
      (let* ((_start1499_ '0)
             (_end1501_ (u8vector-length _bytes1497_))
             (_flags1503_ '0))
        (std/os/socket#socket-send__%
         _sock1496_
         _bytes1497_
         _start1499_
         _end1501_
         _flags1503_))))
  (define std/os/socket#socket-send__1
    (lambda (_sock1505_ _bytes1506_ _start1507_)
      (let* ((_end1509_ (u8vector-length _bytes1506_)) (_flags1511_ '0))
        (std/os/socket#socket-send__%
         _sock1505_
         _bytes1506_
         _start1507_
         _end1509_
         _flags1511_))))
  (define std/os/socket#socket-send__2
    (lambda (_sock1513_ _bytes1514_ _start1515_ _end1516_)
      (let ((_flags1518_ '0))
        (std/os/socket#socket-send__%
         _sock1513_
         _bytes1514_
         _start1515_
         _end1516_
         _flags1518_))))
  (define std/os/socket#socket-send
    (lambda _g5388_
      (let ((_g5387_ (let () (declare (not safe)) (##length _g5388_))))
        (cond ((let () (declare (not safe)) (##fx= _g5387_ 2))
               (apply std/os/socket#socket-send__0 _g5388_))
              ((let () (declare (not safe)) (##fx= _g5387_ 3))
               (apply std/os/socket#socket-send__1 _g5388_))
              ((let () (declare (not safe)) (##fx= _g5387_ 4))
               (apply std/os/socket#socket-send__2 _g5388_))
              ((let () (declare (not safe)) (##fx= _g5387_ 5))
               (apply std/os/socket#socket-send__% _g5388_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-send
                _g5388_))))))
  (define std/os/socket#socket-sendto__%
    (lambda (_sock1414_ _bytes1415_ _sa1416_ _start1417_ _end1418_ _flags1419_)
      (let ((_sa1421_ (std/os/socket#socket-address _sa1416_)))
        (let _lp1423_ ()
          (let ((_r1427_ (std/os/_socket#_sendto
                          (std/os/fd#fd-e _sock1414_)
                          _bytes1415_
                          _start1417_
                          _end1418_
                          _flags1419_
                          _sa1421_)))
            (if (not (let () (declare (not safe)) (##fxnegative? _r1427_)))
                _r1427_
                (let ((_errno1430_
                       (let () (declare (not safe)) (##fx- _r1427_))))
                  (if (or (eq? _errno1430_ std/os/error#EAGAIN)
                          (eq? _errno1430_ std/os/error#EWOULDBLOCK))
                      '#f
                      (if (eq? _errno1430_ std/os/error#EINTR)
                          (_lp1423_)
                          (std/os/error#raise-os-error
                           _errno1430_
                           std/os/socket#socket-sendto
                           _sock1414_
                           _bytes1415_
                           _sa1421_
                           _start1417_
                           _end1418_
                           _flags1419_))))))))))
  (define std/os/socket#socket-sendto__0
    (lambda (_sock1439_ _bytes1440_ _sa1441_)
      (let* ((_start1443_ '0)
             (_end1445_ (u8vector-length _bytes1440_))
             (_flags1447_ '0))
        (std/os/socket#socket-sendto__%
         _sock1439_
         _bytes1440_
         _sa1441_
         _start1443_
         _end1445_
         _flags1447_))))
  (define std/os/socket#socket-sendto__1
    (lambda (_sock1449_ _bytes1450_ _sa1451_ _start1452_)
      (let* ((_end1454_ (u8vector-length _bytes1450_)) (_flags1456_ '0))
        (std/os/socket#socket-sendto__%
         _sock1449_
         _bytes1450_
         _sa1451_
         _start1452_
         _end1454_
         _flags1456_))))
  (define std/os/socket#socket-sendto__2
    (lambda (_sock1458_ _bytes1459_ _sa1460_ _start1461_ _end1462_)
      (let ((_flags1464_ '0))
        (std/os/socket#socket-sendto__%
         _sock1458_
         _bytes1459_
         _sa1460_
         _start1461_
         _end1462_
         _flags1464_))))
  (define std/os/socket#socket-sendto
    (lambda _g5390_
      (let ((_g5389_ (let () (declare (not safe)) (##length _g5390_))))
        (cond ((let () (declare (not safe)) (##fx= _g5389_ 3))
               (apply std/os/socket#socket-sendto__0 _g5390_))
              ((let () (declare (not safe)) (##fx= _g5389_ 4))
               (apply std/os/socket#socket-sendto__1 _g5390_))
              ((let () (declare (not safe)) (##fx= _g5389_ 5))
               (apply std/os/socket#socket-sendto__2 _g5390_))
              ((let () (declare (not safe)) (##fx= _g5389_ 6))
               (apply std/os/socket#socket-sendto__% _g5390_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-sendto
                _g5390_))))))
  (define std/os/socket#socket-sendmsg
    (lambda (_sock1394_
             _name-bytes1395_
             _io-bytes1396_
             _ctl-bytes1397_
             _flags1398_)
      (let _lp1400_ ()
        (let ((_r1404_ (std/os/_socket#_sendmsg
                        (std/os/fd#fd-e _sock1394_)
                        _name-bytes1395_
                        _io-bytes1396_
                        _ctl-bytes1397_
                        _flags1398_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r1404_)))
              _r1404_
              (let ((_errno1407_
                     (let () (declare (not safe)) (##fx- _r1404_))))
                (if (or (eq? _errno1407_ std/os/error#EAGAIN)
                        (eq? _errno1407_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno1407_ std/os/error#EINTR)
                        (_lp1400_)
                        (std/os/error#raise-os-error
                         _errno1407_
                         std/os/socket#socket-sendmsg
                         _sock1394_
                         _name-bytes1395_
                         _io-bytes1396_
                         _ctl-bytes1397_
                         _flags1398_)))))))))
  (define std/os/socket#socket-recv__%
    (lambda (_sock1342_ _bytes1343_ _start1344_ _end1345_ _flags1346_)
      (let _lp1348_ ()
        (let ((_r1352_ (std/os/_socket#_recv
                        (std/os/fd#fd-e _sock1342_)
                        _bytes1343_
                        _start1344_
                        _end1345_
                        _flags1346_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r1352_)))
              _r1352_
              (let ((_errno1355_
                     (let () (declare (not safe)) (##fx- _r1352_))))
                (if (or (eq? _errno1355_ std/os/error#EAGAIN)
                        (eq? _errno1355_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno1355_ std/os/error#EINTR)
                        (_lp1348_)
                        (std/os/error#raise-os-error
                         _errno1355_
                         std/os/socket#socket-recv
                         _sock1342_
                         _bytes1343_
                         _start1344_
                         _end1345_
                         _flags1346_)))))))))
  (define std/os/socket#socket-recv__0
    (lambda (_sock1364_ _bytes1365_)
      (let* ((_start1367_ '0)
             (_end1369_ (u8vector-length _bytes1365_))
             (_flags1371_ '0))
        (std/os/socket#socket-recv__%
         _sock1364_
         _bytes1365_
         _start1367_
         _end1369_
         _flags1371_))))
  (define std/os/socket#socket-recv__1
    (lambda (_sock1373_ _bytes1374_ _start1375_)
      (let* ((_end1377_ (u8vector-length _bytes1374_)) (_flags1379_ '0))
        (std/os/socket#socket-recv__%
         _sock1373_
         _bytes1374_
         _start1375_
         _end1377_
         _flags1379_))))
  (define std/os/socket#socket-recv__2
    (lambda (_sock1381_ _bytes1382_ _start1383_ _end1384_)
      (let ((_flags1386_ '0))
        (std/os/socket#socket-recv__%
         _sock1381_
         _bytes1382_
         _start1383_
         _end1384_
         _flags1386_))))
  (define std/os/socket#socket-recv
    (lambda _g5392_
      (let ((_g5391_ (let () (declare (not safe)) (##length _g5392_))))
        (cond ((let () (declare (not safe)) (##fx= _g5391_ 2))
               (apply std/os/socket#socket-recv__0 _g5392_))
              ((let () (declare (not safe)) (##fx= _g5391_ 3))
               (apply std/os/socket#socket-recv__1 _g5392_))
              ((let () (declare (not safe)) (##fx= _g5391_ 4))
               (apply std/os/socket#socket-recv__2 _g5392_))
              ((let () (declare (not safe)) (##fx= _g5391_ 5))
               (apply std/os/socket#socket-recv__% _g5392_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-recv
                _g5392_))))))
  (define std/os/socket#socket-recvfrom__%
    (lambda (_sock1284_ _bytes1285_ _sa1286_ _start1287_ _end1288_ _flags1289_)
      (let _lp1291_ ()
        (let ((_r1295_ (std/os/_socket#_recvfrom
                        (std/os/fd#fd-e _sock1284_)
                        _bytes1285_
                        _start1287_
                        _end1288_
                        _flags1289_
                        _sa1286_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r1295_)))
              _r1295_
              (let ((_errno1298_
                     (let () (declare (not safe)) (##fx- _r1295_))))
                (if (or (eq? _errno1298_ std/os/error#EAGAIN)
                        (eq? _errno1298_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno1298_ std/os/error#EINTR)
                        (_lp1291_)
                        (std/os/error#raise-os-error
                         _errno1298_
                         std/os/socket#socket-recvfrom
                         _sock1284_
                         _bytes1285_
                         _sa1286_
                         _start1287_
                         _end1288_
                         _flags1289_)))))))))
  (define std/os/socket#socket-recvfrom__0
    (lambda (_sock1307_ _bytes1308_ _sa1309_)
      (let* ((_start1311_ '0)
             (_end1313_ (u8vector-length _bytes1308_))
             (_flags1315_ '0))
        (std/os/socket#socket-recvfrom__%
         _sock1307_
         _bytes1308_
         _sa1309_
         _start1311_
         _end1313_
         _flags1315_))))
  (define std/os/socket#socket-recvfrom__1
    (lambda (_sock1317_ _bytes1318_ _sa1319_ _start1320_)
      (let* ((_end1322_ (u8vector-length _bytes1318_)) (_flags1324_ '0))
        (std/os/socket#socket-recvfrom__%
         _sock1317_
         _bytes1318_
         _sa1319_
         _start1320_
         _end1322_
         _flags1324_))))
  (define std/os/socket#socket-recvfrom__2
    (lambda (_sock1326_ _bytes1327_ _sa1328_ _start1329_ _end1330_)
      (let ((_flags1332_ '0))
        (std/os/socket#socket-recvfrom__%
         _sock1326_
         _bytes1327_
         _sa1328_
         _start1329_
         _end1330_
         _flags1332_))))
  (define std/os/socket#socket-recvfrom
    (lambda _g5394_
      (let ((_g5393_ (let () (declare (not safe)) (##length _g5394_))))
        (cond ((let () (declare (not safe)) (##fx= _g5393_ 3))
               (apply std/os/socket#socket-recvfrom__0 _g5394_))
              ((let () (declare (not safe)) (##fx= _g5393_ 4))
               (apply std/os/socket#socket-recvfrom__1 _g5394_))
              ((let () (declare (not safe)) (##fx= _g5393_ 5))
               (apply std/os/socket#socket-recvfrom__2 _g5394_))
              ((let () (declare (not safe)) (##fx= _g5393_ 6))
               (apply std/os/socket#socket-recvfrom__% _g5394_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-recvfrom
                _g5394_))))))
  (define std/os/socket#socket-recvmsg*
    (lambda (_sock1261_
             _name-bytes1262_
             _rname1263_
             _io-bytes1264_
             _ctl-bytes1265_
             _rctl1266_
             _flags1267_
             _rflags1268_)
      (let _lp1270_ ()
        (let ((_r1274_ (std/os/_socket#_recvmsg
                        (std/os/fd#fd-e _sock1261_)
                        _name-bytes1262_
                        _rname1263_
                        _io-bytes1264_
                        _ctl-bytes1265_
                        _rctl1266_
                        _flags1267_
                        _rflags1268_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r1274_)))
              _r1274_
              (let ((_errno1277_
                     (let () (declare (not safe)) (##fx- _r1274_))))
                (if (or (eq? _errno1277_ std/os/error#EAGAIN)
                        (eq? _errno1277_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno1277_ std/os/error#EINTR)
                        (_lp1270_)
                        (std/os/error#raise-os-error
                         _errno1277_
                         std/os/socket#socket-recvmsg
                         _sock1261_
                         _name-bytes1262_
                         _io-bytes1264_
                         _ctl-bytes1265_
                         _flags1267_)))))))))
  (define std/os/socket#socket-recvmsg
    (lambda (_sock1240_ _name1241_ _io1242_ _ctl1243_ _flags1244_)
      (let* ((_rname1249_
              (if _name1241_
                  (let ((_r1246_ (std/os/_socket#make_int_ptr)))
                    (if _r1246_
                        _r1246_
                        (error '"Error allocating memory" 'make_int_ptr)))
                  '#f))
             (_rctl1254_
              (if _ctl1243_
                  (let ((_r1251_ (std/os/_socket#make_int_ptr)))
                    (if _r1251_
                        _r1251_
                        (error '"Error allocating memory" 'make_int_ptr)))
                  '#f))
             (_rflags1256_ (std/os/_socket#make_int_ptr))
             (_r1258_ (std/os/socket#socket-recvmsg*
                       _sock1240_
                       _name1241_
                       _rname1249_
                       _io1242_
                       _ctl1243_
                       _rctl1254_
                       _flags1244_
                       _rflags1256_)))
        (if _r1258_
            (values _r1258_
                    (if _rname1249_
                        (std/os/_socket#int_ptr_value _rname1249_)
                        '#f)
                    (if _rctl1254_
                        (std/os/_socket#int_ptr_value _rctl1254_)
                        '#f)
                    (std/os/_socket#int_ptr_value _rflags1256_))
            '#f))))
  (define std/os/socket#socket-getpeername__%
    (lambda (_sock1219_ _sa1220_)
      (let ((_sa1225_
             (let ((_$e1222_ _sa1220_))
               (if _$e1222_
                   _$e1222_
                   (std/os/socket#make-socket-address
                    (std/os/socket#socket-domain _sock1219_))))))
        (let ((_r1227_ (std/os/_socket#_getpeername
                        (std/os/fd#fd-e _sock1219_)
                        _sa1225_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r1227_)))
              _r1227_
              (std/os/error#raise-os-error
               (let () (declare (not safe)) (##fx- _r1227_))
               std/os/socket#socket-getpeername
               _sock1219_)))
        _sa1225_)))
  (define std/os/socket#socket-getpeername__0
    (lambda (_sock1233_)
      (let ((_sa1235_ '#f))
        (std/os/socket#socket-getpeername__% _sock1233_ _sa1235_))))
  (define std/os/socket#socket-getpeername
    (lambda _g5396_
      (let ((_g5395_ (let () (declare (not safe)) (##length _g5396_))))
        (cond ((let () (declare (not safe)) (##fx= _g5395_ 1))
               (apply std/os/socket#socket-getpeername__0 _g5396_))
              ((let () (declare (not safe)) (##fx= _g5395_ 2))
               (apply std/os/socket#socket-getpeername__% _g5396_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-getpeername
                _g5396_))))))
  (define std/os/socket#socket-getsockname__%
    (lambda (_sock1197_ _sa1198_)
      (let ((_sa1203_
             (let ((_$e1200_ _sa1198_))
               (if _$e1200_
                   _$e1200_
                   (std/os/socket#make-socket-address
                    (std/os/socket#socket-domain _sock1197_))))))
        (let ((_r1205_ (std/os/_socket#_getsockname
                        (std/os/fd#fd-e _sock1197_)
                        _sa1203_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r1205_)))
              _r1205_
              (std/os/error#raise-os-error
               (let () (declare (not safe)) (##fx- _r1205_))
               std/os/socket#socket-getsockname
               _sock1197_)))
        _sa1203_)))
  (define std/os/socket#socket-getsockname__0
    (lambda (_sock1211_)
      (let ((_sa1213_ '#f))
        (std/os/socket#socket-getsockname__% _sock1211_ _sa1213_))))
  (define std/os/socket#socket-getsockname
    (lambda _g5398_
      (let ((_g5397_ (let () (declare (not safe)) (##length _g5398_))))
        (cond ((let () (declare (not safe)) (##fx= _g5397_ 1))
               (apply std/os/socket#socket-getsockname__0 _g5398_))
              ((let () (declare (not safe)) (##fx= _g5397_ 2))
               (apply std/os/socket#socket-getsockname__% _g5398_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-getsockname
                _g5398_))))))
  (define std/os/socket#socket-domain
    (lambda (_sock1194_)
      (std/os/socket#socket-getsockopt
       _sock1194_
       std/os/_socket#SOL_SOCKET
       std/os/_socket#SO_DOMAIN)))
  (define std/os/socket#socket-address?
    (lambda (_obj1192_) (std/os/_socket#sockaddr? _obj1192_)))
  (define std/os/socket#make-socket-address
    (lambda (_af1187_)
      (let ((_r1189_ (std/os/_socket#make_sockaddr _af1187_)))
        (if _r1189_
            _r1189_
            (error '"Error allocating memory" 'make_sockaddr)))))
  (define std/os/socket#make-socket-address-in
    (lambda () (std/os/socket#make-socket-address std/os/_socket#AF_INET)))
  (define std/os/socket#make-socket-address-in6
    (lambda () (std/os/socket#make-socket-address std/os/_socket#AF_INET6)))
  (define std/os/socket#make-socket-address-un
    (lambda () (std/os/socket#make-socket-address std/os/_socket#AF_UNIX)))
  (define std/os/socket#socket-address-in
    (lambda (_host1176_ _port1177_)
      (let* ((_ip41179_ (std/net/address#ip4-address _host1176_))
             (_sa1181_ (std/os/socket#make-socket-address-in)))
        (std/os/_socket#sockaddr_in_addr_set _sa1181_ _ip41179_)
        (std/os/_socket#sockaddr_in_port_set _sa1181_ _port1177_)
        _sa1181_)))
  (define std/os/socket#socket-address-in6
    (lambda (_host1168_ _port1169_)
      (let* ((_ip61171_ (std/net/address#ip6-address _host1168_))
             (_sa1173_ (std/os/socket#make-socket-address-in6)))
        (std/os/_socket#sockaddr_in6_addr_set _sa1173_ _ip61171_)
        (std/os/_socket#sockaddr_in6_port_set _sa1173_ _port1169_)
        _sa1173_)))
  (define std/os/socket#socket-address-un
    (lambda (_path1162_)
      (let ((_pathlen1164_ (std/text/utf8#string-utf8-length__0 _path1162_)))
        (if (let ()
              (declare (not safe))
              (##fx< _pathlen1164_ std/os/_socket#UNIX_MAX_PATH))
            (let ((_sa1166_ (std/os/socket#make-socket-address-un)))
              (std/os/_socket#sockaddr_un_path_set _sa1166_ _path1162_)
              _sa1166_)
            (error '"Malformed address; path is too long")))))
  (define std/os/socket#socket-address-family
    (lambda (_sa1160_) (std/os/_socket#sockaddr_family _sa1160_)))
  (define std/os/socket#socket-address
    (lambda (_addr1155_)
      (if (std/os/_socket#sockaddr? _addr1155_)
          _addr1155_
          (if (or (std/net/address#inet-address? _addr1155_)
                  (std/net/address#inet-address-string? _addr1155_))
              (std/os/socket#inet-address->socket-address _addr1155_)
              (std/os/socket#socket-address-un _addr1155_)))))
  (define std/os/socket#inet-address->socket-address
    (lambda (_addr1125_)
      (let* ((_g11261133_ (std/net/address#resolve-address _addr1125_))
             (_E11281137_
              (lambda () (error '"No clause matching" _g11261133_)))
             (_K11291143_
              (lambda (_port1140_ _ip1141_)
                (if (std/net/address#ip4-address? _ip1141_)
                    (std/os/socket#socket-address-in _ip1141_ _port1140_)
                    (if (std/net/address#ip6-address? _ip1141_)
                        (std/os/socket#socket-address-in6 _ip1141_ _port1140_)
                        (error '"Bad address; expected ip4 or ip6 inet-address"
                               _addr1125_))))))
        (if (let () (declare (not safe)) (##pair? _g11261133_))
            (let ((_hd11301146_
                   (let () (declare (not safe)) (##car _g11261133_)))
                  (_tl11311148_
                   (let () (declare (not safe)) (##cdr _g11261133_))))
              (let* ((_ip1151_ _hd11301146_) (_port1153_ _tl11311148_))
                (_K11291143_ _port1153_ _ip1151_)))
            (_E11281137_)))))
  (define std/os/socket#socket-address->address
    (lambda (_sa1109_)
      (let ((_saf1111_ (std/os/_socket#sockaddr_family _sa1109_)))
        (if (eq? _saf1111_ std/os/_socket#AF_INET)
            (let* ((_ip41113_ (make-u8vector '4))
                   (_g5399_ (std/os/_socket#sockaddr_in_addr
                             _sa1109_
                             _ip41113_))
                   (_port1116_ (std/os/_socket#sockaddr_in_port _sa1109_)))
              (cons _ip41113_ _port1116_))
            (if (eq? _saf1111_ std/os/_socket#AF_INET6)
                (let* ((_ip61119_ (make-u8vector '16))
                       (_g5400_ (std/os/_socket#sockaddr_in6_addr
                                 _sa1109_
                                 _ip61119_))
                       (_port1122_
                        (std/os/_socket#sockaddr_in6_port _sa1109_)))
                  (cons _ip61119_ _port1122_))
                (if (eq? _saf1111_ std/os/_socket#AF_UNIX)
                    (std/os/_socket#sockaddr_un_path _sa1109_)
                    (error '"Unknown address family" _sa1109_ _saf1111_)))))))
  (define std/os/socket#socket-address->string
    (lambda (_sa1093_)
      (let ((_saf1095_ (std/os/_socket#sockaddr_family _sa1093_)))
        (if (eq? _saf1095_ std/os/_socket#AF_INET)
            (let* ((_ip41097_ (make-u8vector '4))
                   (_g5401_ (std/os/_socket#sockaddr_in_addr
                             _sa1093_
                             _ip41097_))
                   (_port1100_ (std/os/_socket#sockaddr_in_port _sa1093_)))
              (string-append
               (std/net/address#ip4-address->string _ip41097_)
               '":"
               (number->string _port1100_)))
            (if (eq? _saf1095_ std/os/_socket#AF_INET6)
                (let* ((_ip61103_ (make-u8vector '16))
                       (_g5402_ (std/os/_socket#sockaddr_in6_addr
                                 _sa1093_
                                 _ip61103_))
                       (_port1106_
                        (std/os/_socket#sockaddr_in6_port _sa1093_)))
                  (string-append
                   (std/net/address#ip6-address->string _ip61103_)
                   '":"
                   (number->string _port1106_)))
                (if (eq? _saf1095_ std/os/_socket#AF_UNIX)
                    (std/os/_socket#sockaddr_un_path _sa1093_)
                    (error '"Unknown address family" _sa1093_ _saf1095_)))))))
  (define std/os/socket#socket-getsockopt
    (lambda (_sock1047_ _level1048_ _opt1049_ . _args1050_)
      (let ((_$e1052_
             (table-ref std/os/socket#socket-sockopts _level1048_ '#f)))
        (if _$e1052_
            ((lambda (_ht1055_)
               (let ((_$e1057_ (table-ref _ht1055_ _opt1049_ '#f)))
                 (if _$e1057_
                     ((lambda (_e10591061_)
                        (let* ((_g10631070_ _e10591061_)
                               (_E10651074_
                                (lambda ()
                                  (error '"No clause matching" _g10631070_)))
                               (_K10661080_
                                (lambda (_setf1077_ _getf1078_)
                                  (if _getf1078_
                                      (apply _getf1078_
                                             _sock1047_
                                             _level1048_
                                             _opt1049_
                                             _args1050_)
                                      (error '"No getsockopt operation defined for option"
                                             _level1048_
                                             _opt1049_)))))
                          (if (let ((__tmp5403
                                     (if (let ()
                                           (declare (not safe))
                                           (##values? _g10631070_))
                                         (let ()
                                           (declare (not safe))
                                           (##vector-length _g10631070_))
                                         '1)))
                                (declare (not safe))
                                (##fx= __tmp5403 '2))
                              (let* ((_e10671083_
                                      (let ()
                                        (declare (not safe))
                                        (##vector-ref _g10631070_ '0)))
                                     (_getf1086_ _e10671083_)
                                     (_e10681088_
                                      (let ()
                                        (declare (not safe))
                                        (##vector-ref _g10631070_ '1)))
                                     (_setf1091_ _e10681088_))
                                (_K10661080_ _setf1091_ _getf1086_))
                              (_E10651074_))))
                      _$e1057_)
                     (error '"Unknown socket option" _level1048_ _opt1049_))))
             _$e1052_)
            (error '"Unknown socket level" _level1048_ _opt1049_)))))
  (define std/os/socket#socket-setsockopt
    (lambda (_sock1000_ _level1001_ _opt1002_ _val1003_ . _args1004_)
      (let ((_$e1006_
             (table-ref std/os/socket#socket-sockopts _level1001_ '#f)))
        (if _$e1006_
            ((lambda (_ht1009_)
               (let ((_$e1011_ (table-ref _ht1009_ _opt1002_ '#f)))
                 (if _$e1011_
                     ((lambda (_e10131015_)
                        (let* ((_g10171024_ _e10131015_)
                               (_E10191028_
                                (lambda ()
                                  (error '"No clause matching" _g10171024_)))
                               (_K10201034_
                                (lambda (_setf1031_ _getf1032_)
                                  (if _setf1031_
                                      (apply _setf1031_
                                             _sock1000_
                                             _level1001_
                                             _opt1002_
                                             _val1003_
                                             _args1004_)
                                      (error '"No setsockopt operation defined for option"
                                             _level1001_
                                             _opt1002_)))))
                          (if (let ((__tmp5404
                                     (if (let ()
                                           (declare (not safe))
                                           (##values? _g10171024_))
                                         (let ()
                                           (declare (not safe))
                                           (##vector-length _g10171024_))
                                         '1)))
                                (declare (not safe))
                                (##fx= __tmp5404 '2))
                              (let* ((_e10211037_
                                      (let ()
                                        (declare (not safe))
                                        (##vector-ref _g10171024_ '0)))
                                     (_getf1040_ _e10211037_)
                                     (_e10221042_
                                      (let ()
                                        (declare (not safe))
                                        (##vector-ref _g10171024_ '1)))
                                     (_setf1045_ _e10221042_))
                                (_K10201034_ _setf1045_ _getf1040_))
                              (_E10191028_))))
                      _$e1011_)
                     (error '"Unknown socket option" _level1001_ _opt1002_))))
             _$e1006_)
            (error '"Unknown socket level" _level1001_ _opt1002_)))))
  (define std/os/socket#socket-getsockopt-int
    (lambda (_sock993_ _level994_ _opt995_)
      (let ((_r997_ (std/os/_socket#_getsockopt_int
                     (std/os/fd#fd-e _sock993_)
                     _level994_
                     _opt995_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r997_)))
            _r997_
            (std/os/error#raise-os-error
             (let () (declare (not safe)) (##fx- _r997_))
             std/os/socket#socket-getsockopt
             _sock993_
             _level994_
             _opt995_)))))
  (define std/os/socket#socket-setsockopt-int
    (lambda (_sock985_ _level986_ _opt987_ _val988_)
      (if (fixnum? _val988_)
          (let ((_r990_ (std/os/_socket#_setsockopt_int
                         (std/os/fd#fd-e _sock985_)
                         _level986_
                         _opt987_
                         _val988_)))
            (if (not (let () (declare (not safe)) (##fxnegative? _r990_)))
                _r990_
                (std/os/error#raise-os-error
                 (let () (declare (not safe)) (##fx- _r990_))
                 std/os/socket#socket-setsockopt
                 _sock985_
                 _level986_
                 _opt987_
                 _val988_)))
          (error '"Bad argument; expected fixnum" _val988_))))
  (define std/os/socket#socket-getsockopt-tv
    (lambda (_sock973_ _level974_ _opt975_)
      (let ((_tv980_ (let ((_r977_ (std/os/_socket#make_tv)))
                       (if _r977_
                           _r977_
                           (error '"Error allocating memory" 'make_tv)))))
        (let ((_r982_ (std/os/_socket#_getsockopt_tv
                       (std/os/fd#fd-e _sock973_)
                       _level974_
                       _opt975_
                       _tv980_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r982_)))
              _r982_
              (std/os/error#raise-os-error
               (let () (declare (not safe)) (##fx- _r982_))
               std/os/socket#socket-getsockopt
               _sock973_
               _level974_
               _opt975_)))
        (+ (std/os/_socket#tv_sec _tv980_)
           (/ (std/os/_socket#tv_usec _tv980_) '1000000.)))))
  (define std/os/socket#socket-setsockopt-tv
    (lambda (_sock953_ _level954_ _opt955_ _tm956_)
      (if (real? _tm956_)
          (let* ((_tm-sec958_ (floor _tm956_))
                 (_tm-frac960_ (- _tm956_ _tm-sec958_))
                 (_tm-usec962_ (floor (* _tm-frac960_ '1000000.)))
                 (_tv967_ (let ((_r964_ (std/os/_socket#make_tv)))
                            (if _r964_
                                _r964_
                                (error '"Error allocating memory" 'make_tv)))))
            (std/os/_socket#tv_sec_set _tv967_ (inexact->exact _tm-sec958_))
            (std/os/_socket#tv_usec_set _tv967_ (inexact->exact _tm-usec962_))
            (let ((_r970_ (std/os/_socket#_setsockopt_tv
                           (std/os/fd#fd-e _sock953_)
                           _level954_
                           _opt955_
                           _tv967_)))
              (if (not (let () (declare (not safe)) (##fxnegative? _r970_)))
                  _r970_
                  (std/os/error#raise-os-error
                   (let () (declare (not safe)) (##fx- _r970_))
                   std/os/socket#socket-setsockopt
                   _sock953_
                   _level954_
                   _opt955_
                   _tm956_))))
          (error '"Bad argument; expected real" _tm956_))))
  (define std/os/socket#socket-getsockopt-addr-in
    (lambda (_sock944_ _level945_ _opt946_)
      (let ((_sa948_ (std/os/socket#make-socket-address-in)))
        (let ((_r950_ (std/os/_socket#_getsockopt_sa
                       (std/os/fd#fd-e _sock944_)
                       _level945_
                       _opt946_
                       _sa948_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r950_)))
              _r950_
              (std/os/error#raise-os-error
               (let () (declare (not safe)) (##fx- _r950_))
               std/os/socket#socket-getsockopt
               _sock944_
               _level945_
               _opt946_)))
        _sa948_)))
  (define std/os/socket#socket-getsockopt-addr-in6
    (lambda (_sock935_ _level936_ _opt937_)
      (let ((_sa939_ (std/os/socket#make-socket-address-in6)))
        (let ((_r941_ (std/os/_socket#_getsockopt_sa
                       (std/os/fd#fd-e _sock935_)
                       _level936_
                       _opt937_
                       _sa939_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r941_)))
              _r941_
              (std/os/error#raise-os-error
               (let () (declare (not safe)) (##fx- _r941_))
               std/os/socket#socket-getsockopt
               _sock935_
               _level936_
               _opt937_)))
        _sa939_)))
  (define std/os/socket#socket-setsockopt-addr
    (lambda (_sock925_ _level926_ _opt927_ _addr928_)
      (let* ((_sa930_ (std/os/socket#socket-address _addr928_))
             (_r932_ (std/os/_socket#_setsockopt_sa
                      (std/os/fd#fd-e _sock925_)
                      _level926_
                      _opt927_
                      _sa930_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r932_)))
            _r932_
            (std/os/error#raise-os-error
             (let () (declare (not safe)) (##fx- _r932_))
             std/os/socket#socket-setsockopt
             _sock925_
             _level926_
             _opt927_
             _addr928_)))))
  (define std/os/socket#socket-getsockopt-bytes
    (lambda (_sock917_ _level918_ _opt919_ _bytes920_)
      (if (u8vector? _bytes920_)
          (let ((_r922_ (std/os/_socket#_getsockopt_bytes
                         (std/os/fd#fd-e _sock917_)
                         _level918_
                         _opt919_
                         _bytes920_)))
            (if (not (let () (declare (not safe)) (##fxnegative? _r922_)))
                _r922_
                (std/os/error#raise-os-error
                 (let () (declare (not safe)) (##fx- _r922_))
                 std/os/socket#socket-getsockopt
                 _sock917_
                 _level918_
                 _opt919_
                 _bytes920_)))
          (error '"Bad argument; expected bytes" _bytes920_))))
  (define std/os/socket#socket-setsockopt-bytes
    (lambda (_sock909_ _level910_ _opt911_ _bytes912_)
      (if (u8vector? _bytes912_)
          (let ((_r914_ (std/os/_socket#_setsockopt_bytes
                         (std/os/fd#fd-e _sock909_)
                         _level910_
                         _opt911_
                         _bytes912_)))
            (if (not (let () (declare (not safe)) (##fxnegative? _r914_)))
                _r914_
                (std/os/error#raise-os-error
                 (let () (declare (not safe)) (##fx- _r914_))
                 std/os/socket#socket-setsockopt
                 _sock909_
                 _level910_
                 _opt911_
                 _bytes912_)))
          (error '"Bad argument; expected bytes" _bytes912_))))
  (define std/os/socket#socket-setsockopt-mreq
    (lambda (_sock865_ _level866_ _opt867_ _ips868_)
      (let* ((_ips869877_ _ips868_)
             (_else871885_
              (lambda ()
                (error '"Bad argument; expected pair of ip4 addresses"
                       _ips868_)))
             (_K873897_
              (lambda (_laddr888_ _maddr889_)
                (let ((_maddr891_ (std/net/address#ip4-address _maddr889_))
                      (_laddr892_ (std/net/address#ip4-address _laddr888_)))
                  (let ((_r894_ (std/os/_socket#_setsockopt_mreq
                                 (std/os/fd#fd-e _sock865_)
                                 _level866_
                                 _opt867_
                                 _maddr891_
                                 _laddr892_)))
                    (if (not (let ()
                               (declare (not safe))
                               (##fxnegative? _r894_)))
                        _r894_
                        (std/os/error#raise-os-error
                         (let () (declare (not safe)) (##fx- _r894_))
                         std/os/socket#socket-setsockopt
                         _sock865_
                         _level866_
                         _opt867_
                         _ips868_)))))))
        (if (let () (declare (not safe)) (##pair? _ips869877_))
            (let ((_hd874900_
                   (let () (declare (not safe)) (##car _ips869877_)))
                  (_tl875902_
                   (let () (declare (not safe)) (##cdr _ips869877_))))
              (let* ((_maddr905_ _hd874900_) (_laddr907_ _tl875902_))
                (_K873897_ _laddr907_ _maddr905_)))
            (_else871885_)))))
  (define std/os/socket#socket-setsockopt-mreq-src
    (lambda (_sock803_ _level804_ _opt805_ _ips806_)
      (let* ((_ips807819_ _ips806_)
             (_else809827_
              (lambda ()
                (error '"Bad argument; expected list with 3 ip4 addresses"
                       _ips806_)))
             (_K811841_
              (lambda (_saddr830_ _iaddr831_ _maddr832_)
                (let ((_maddr834_ (std/net/address#ip4-address _maddr832_))
                      (_iaddr835_ (std/net/address#ip4-address _iaddr831_))
                      (_saddr836_ (std/net/address#ip4-address _saddr830_)))
                  (let ((_r838_ (std/os/_socket#_setsockopt_mreq_src
                                 (std/os/fd#fd-e _sock803_)
                                 _level804_
                                 _opt805_
                                 _maddr834_
                                 _iaddr835_
                                 _saddr836_)))
                    (if (not (let ()
                               (declare (not safe))
                               (##fxnegative? _r838_)))
                        _r838_
                        (std/os/error#raise-os-error
                         (let () (declare (not safe)) (##fx- _r838_))
                         std/os/socket#socket-setsockopt
                         _sock803_
                         _level804_
                         _opt805_
                         _ips806_)))))))
        (if (let () (declare (not safe)) (##pair? _ips807819_))
            (let ((_hd812844_
                   (let () (declare (not safe)) (##car _ips807819_)))
                  (_tl813846_
                   (let () (declare (not safe)) (##cdr _ips807819_))))
              (let ((_maddr849_ _hd812844_))
                (if (let () (declare (not safe)) (##pair? _tl813846_))
                    (let ((_hd814851_
                           (let () (declare (not safe)) (##car _tl813846_)))
                          (_tl815853_
                           (let () (declare (not safe)) (##cdr _tl813846_))))
                      (let ((_iaddr856_ _hd814851_))
                        (if (let () (declare (not safe)) (##pair? _tl815853_))
                            (let ((_hd816858_
                                   (let ()
                                     (declare (not safe))
                                     (##car _tl815853_)))
                                  (_tl817860_
                                   (let ()
                                     (declare (not safe))
                                     (##cdr _tl815853_))))
                              (let ((_saddr863_ _hd816858_))
                                (if (let ()
                                      (declare (not safe))
                                      (##null? _tl817860_))
                                    (_K811841_
                                     _saddr863_
                                     _iaddr856_
                                     _maddr849_)
                                    (_else809827_))))
                            (_else809827_))))
                    (_else809827_))))
            (_else809827_)))))
  (define std/os/socket#socket-setsockopt-mreq6
    (lambda (_sock760_ _level761_ _opt762_ _ips763_)
      (let* ((_ips764772_ _ips763_)
             (_else766780_
              (lambda ()
                (error '"Bad argument; expected pair of ip6 addresses"
                       _ips763_)))
             (_K768791_
              (lambda (_ifindex783_ _maddr784_)
                (let* ((_maddr786_ (std/net/address#ip6-address _maddr784_))
                       (_r788_ (std/os/_socket#_setsockopt_mreq6
                                (std/os/fd#fd-e _sock760_)
                                _level761_
                                _opt762_
                                _maddr786_
                                _ifindex783_)))
                  (if (not (let ()
                             (declare (not safe))
                             (##fxnegative? _r788_)))
                      _r788_
                      (std/os/error#raise-os-error
                       (let () (declare (not safe)) (##fx- _r788_))
                       std/os/socket#socket-setsockopt
                       _sock760_
                       _level761_
                       _opt762_
                       _ips763_))))))
        (if (let () (declare (not safe)) (##pair? _ips764772_))
            (let ((_hd769794_
                   (let () (declare (not safe)) (##car _ips764772_)))
                  (_tl770796_
                   (let () (declare (not safe)) (##cdr _ips764772_))))
              (let* ((_maddr799_ _hd769794_) (_ifindex801_ _tl770796_))
                (_K768791_ _ifindex801_ _maddr799_)))
            (_else766780_)))))
  (define std/os/socket#socket-getsockopt-linger
    (lambda (_sock748_ _level749_ _opt750_)
      (let ((_linger755_
             (let ((_r752_ (std/os/_socket#make_linger)))
               (if _r752_
                   _r752_
                   (error '"Error allocating memory" 'make_linger)))))
        (let ((_r757_ (std/os/_socket#_getsockopt_linger
                       _sock748_
                       _level749_
                       _opt750_
                       _linger755_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r757_)))
              _r757_
              (std/os/error#raise-os-error
               (let () (declare (not safe)) (##fx- _r757_))
               std/os/socket#socket-getsockopt
               _sock748_
               _level749_
               _opt750_)))
        (if (let ((__tmp5405 (std/os/_socket#linger_onoff _linger755_)))
              (declare (not safe))
              (##fxzero? __tmp5405))
            '#f
            (std/os/_socket#linger_linger _linger755_)))))
  (define std/os/socket#socket-setsockopt-linger
    (lambda (_sock735_ _level736_ _opt737_ _val738_)
      (let ((_linger743_
             (let ((_r740_ (std/os/_socket#make_linger)))
               (if _r740_
                   _r740_
                   (error '"Error allocating memory" 'make_linger)))))
        (if (fixnum? _val738_)
            (begin
              (std/os/_socket#linger_onoff_set _linger743_ '1)
              (std/os/_socket#linger_linger_set _linger743_ _val738_))
            (if (not _val738_)
                (begin
                  (std/os/_socket#linger_onoff_set _linger743_ '0)
                  (std/os/_socket#linger_linger_set _linger743_ '0))
                (error '"Bad argument; expected fixnum or #f" _val738_)))
        (let ((_r745_ (std/os/_socket#_setsockopt_linger
                       _sock735_
                       _level736_
                       _opt737_
                       _linger743_)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r745_)))
              _r745_
              (std/os/error#raise-os-error
               (let () (declare (not safe)) (##fx- _r745_))
               std/os/socket#socket-setsockopt
               _sock735_
               _level736_
               _opt737_
               _val738_))))))
  (define std/os/socket#socket-sockopts
    (let ((_ht732_ (make-table 'test: eq? 'size: '4)))
      (table-set! _ht732_ std/os/_socket#SOL_SOCKET (make-table 'test: eq?))
      (table-set! _ht732_ std/os/_socket#IPPROTO_IP (make-table 'test: eq?))
      (table-set! _ht732_ std/os/_socket#IPPROTO_IPV6 (make-table 'test: eq?))
      (table-set! _ht732_ std/os/_socket#IPPROTO_TCP (make-table 'test: eq?))
      _ht732_))
  (if std/os/_socket#SO_ACCEPTCONN
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_ACCEPTCONN
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#SO_BINDTODEVICE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_BINDTODEVICE
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#SO_BROADCAST
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_BROADCAST
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_DEBUG
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_DEBUG
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_DOMAIN
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_DOMAIN
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#SO_DONTROUTE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_DONTROUTE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_ERROR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_ERROR
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#SO_KEEPALIVE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_KEEPALIVE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_LINGER
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_LINGER
       (values std/os/socket#socket-getsockopt-linger
               std/os/socket#socket-setsockopt-linger))
      '#!void)
  (if std/os/_socket#SO_OOBLINE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_OOBLINE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_PASSCRED
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PASSCRED
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_PEERCRED
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PEERCRED
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#SO_PEEK_OFF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PEEK_OFF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_PROTOCOL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PROTOCOL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_RCVBUF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_RCVBUF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_SNDBUF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_SNDBUF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_RCVLOWAT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_RCVLOWAT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_SNDLOWAT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_SNDLOWAT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_RCVTIMEO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_RCVTIMEO
       (values std/os/socket#socket-getsockopt-tv
               std/os/socket#socket-setsockopt-tv))
      '#!void)
  (if std/os/_socket#SO_SNDTIMEO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_SNDTIMEO
       (values std/os/socket#socket-getsockopt-tv
               std/os/socket#socket-setsockopt-tv))
      '#!void)
  (if std/os/_socket#SO_REUSEADDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_REUSEADDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_REUSEPORT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_REUSEPORT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_TYPE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_TYPE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_TIMESTAMP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_TIMESTAMP
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_USELOOPBACK
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_USELOOPBACK
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_ADD_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_ADD_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq))
      '#!void)
  (if std/os/_socket#IP_DROP_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_DROP_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq))
      '#!void)
  (if std/os/_socket#IP_ADD_SOURCE_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_ADD_SOURCE_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_DROP_SOURCE_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_DROP_SOURCE_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_BLOCK_SOURCE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_BLOCK_SOURCE
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_UNBLOCK_SOURCE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_UNBLOCK_SOURCE
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_FREEBIND
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_FREEBIND
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_HDRINCL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_HDRINCL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MTU
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MTU
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#IP_MTU_DISCOVER
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MTU_DISCOVER
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_ALL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_ALL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_IF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_IF
       (values '#f std/os/socket#socket-setsockopt-mreq))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_LOOP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_LOOP
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_TTL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_TTL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_NODEFRAG
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_NODEFRAG
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_OPTIONS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_OPTIONS
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#IP_PKTINFO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_PKTINFO
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#IP_RECVERR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVERR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVORIGDSTADDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVORIGDSTADDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVTOS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVTOS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVTTL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVTTL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RETOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RETOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_ROUTER_ALERT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_ROUTER_ALERT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_TOS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_TOS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_TTL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_TTL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_ADDRFORM
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_ADDRFORM
       (values '#f std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_ADD_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_ADD_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq6))
      '#!void)
  (if std/os/_socket#IPV6_DROP_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_DROP_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq6))
      '#!void)
  (if std/os/_socket#IPV6_MTU
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MTU
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MTU_DISCOVER
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MTU_DISCOVER
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MULTICAST_HOPS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MULTICAST_HOPS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MULTICAST_IF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MULTICAST_IF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MULTICAST_LOOP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MULTICAST_LOOP
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_RECVPKTINFO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_RECVPKTINFO
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_RTHDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_RTHDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_AUTHHDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_AUTHHDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_DSTOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_DSTOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_HOPOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_HOPOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_FLOWINFO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_FLOWINFO
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_HOPLIMIT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_HOPLIMIT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_ROUTER_ALERT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_ROUTER_ALERT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_UNICAST_HOPS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_UNICAST_HOPS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_V6ONLY
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_V6ONLY
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_CONGESTION
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_CONGESTION
       (values '#f std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#TCP_CORK
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_CORK
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_DEFER_ACCEPT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_DEFER_ACCEPT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_KEEPCNT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_KEEPCNT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_KEEPIDLE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_KEEPIDLE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_KEEPINTVL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_KEEPINTVL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_MAXSEG
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_MAXSEG
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_NODELAY
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_NODELAY
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_SYNCNT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_SYNCNT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void))
