#!/usr/bin/python
#
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for ios_ospfv3
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: ios_ospfv3
short_description: OSPFv3 resource module
description: This module configures and manages the Open Shortest Path First (OSPF)
  version 3 on IOS platforms.
version_added: 1.1.0
author: Sumit Jaiswal (@justjais)
notes:
- Tested against Cisco IOSv Version 15.2 on VIRL.
options:
  config:
    description: A list of configurations for ospfv3.
    type: dict
    suboptions:
      processes:
        description: List of OSPF instance configurations.
        type: list
        elements: dict
        suboptions:
          process_id:
            description: Process ID
            required: true
            type: int
          address_family:
            description: Enter Address Family command mode
            type: list
            elements: dict
            suboptions:
              afi:
                description: Enter Address Family command mode
                type: str
                choices:
                  - ipv4
                  - ipv6
              unicast:
                description: Address Family modifier
                type: bool
              vrf:
                description: Specify parameters for a VPN Routing/Forwarding instance
                type: str
              adjacency:
                description: Control adjacency formation
                type: dict
                suboptions:
                  min_adjacency:
                    description:
                      - Initial number of adjacencies allowed to be forming in an area
                      - Please refer vendor documentation for valid values
                    type: int
                  none:
                    description: No initial
                    type: bool
                  max_adjacency:
                    description:
                      - Maximum number of adjacencies allowed to be forming
                      - Please refer vendor documentation for valid values
                    type: int
                  disable:
                    description: Disable adjacency staggering
                    type: bool
              areas:
                description: OSPF area parameters
                type: list
                elements: dict
                suboptions:
                  area_id:
                    description:
                      - OSPF area ID as a decimal value. Please refer vendor documentation
                        of Valid values.
                      - OSPF area ID in IP address format(e.g. A.B.C.D)
                    type: str
                  authentication:
                    description: Authentication parameters
                    type: dict
                    suboptions:
                      key_chain:
                        description: Use a key-chain for cryptographic authentication keys
                        type: str
                      'null':
                        description: Use no authentication
                        type: bool
                  default_cost:
                    description:
                      - Set the summary default-cost of a NSSA/stub area
                      - Stub's advertised external route metric
                      - Note, please refer vendor documentation for respective valid values
                    type: int
                  filter_list:
                    description: Filter networks between OSPFv3 areas
                    type: list
                    elements: dict
                    suboptions:
                      name:
                        description: Name of an IP prefix-list
                        type: str
                      direction:
                        description: The direction to apply on the filter networks sent to and from this area.
                        type: str
                        choices: ['in', 'out']
                        required: True
                  normal:
                    description: Specify a normal area type
                    type: bool
                  nssa:
                    description: Specify a NSSA area
                    type: dict
                    suboptions:
                      set:
                        description: Enable a NSSA area
                        type: bool
                      default_information_originate:
                        description: Originate Type 7 default into NSSA area
                        type: dict
                        suboptions:
                          metric:
                            description: OSPF default metric
                            type: int
                          metric_type:
                            description:
                              - OSPF metric type for default routes
                              - OSPF Link State type
                            type: int
                            choices: [1, 2]
                          nssa_only:
                            description: Limit default advertisement to this NSSA area
                            type: bool
                      no_redistribution:
                        description: No redistribution into this NSSA area
                        type: bool
                      no_summary:
                        description: Do not send summary LSA into NSSA
                        type: bool
                      translate:
                        description:
                          - Translate LSA
                          - Always translate LSAs on this ABR
                          - Suppress forwarding address in translated LSAs
                        type: str
                        choices: ['always', 'suppress-fa']
                  ranges:
                    description: Summarize routes matching address/mask (border routers only)
                    type: list
                    elements: dict
                    suboptions:
                      address:
                        description: IP address to match
                        type: str
                      netmask:
                        description: IP mask for address
                        type: str
                      advertise:
                        description:
                          - Advertise this range (default)
                          - Since, advertise when enabled is not shown in running-config
                            idempotency won't be maintained for the play in the second or
                            next run of the play.
                        type: bool
                      cost:
                        description: User specified metric for this range
                        type: int
                      not_advertise:
                        description: DoNotAdvertise this range
                        type: bool
                  sham_link:
                    description: Define a sham link and its parameters
                    type: dict
                    suboptions:
                      source:
                        description: IPv6 address associated with sham-link source (X:X:X:X::X)
                        type: str
                      destination:
                        description: IPv6 address associated with sham-link destination (X:X:X:X::X)
                        type: str
                      authentication:
                        description: Authentication parameters
                        type: dict
                        suboptions:
                          key_chain:
                            description: Use a key-chain for cryptographic authentication keys
                            type: str
                          'null':
                            description: Use no authentication
                            type: bool
                      cost:
                        description:
                          - Associate a cost with the sham-link
                          - Cost of the sham-link
                        type: int
                      ttl_security:
                        description:
                          - TTL security check
                          - maximum number of hops allowed
                        type: int
                  stub:
                    description:
                      - Specify a stub area
                      - Backbone can not be configured as stub area
                    type: dict
                    suboptions:
                      set:
                        description: Enable a stub area
                        type: bool
                      no_summary:
                        description: Do not send summary LSA into stub area
                        type: bool
              authentication:
                description:
                  - Authentication parameters
                  - Authentication operation mode
                type: dict
                suboptions:
                  deployment:
                    description: Deployment mode of operation
                    type: bool
                  normal:
                    description: Normal mode of operation
                    type: bool
              auto_cost:
                description: Calculate OSPF interface cost according to bandwidth
                type: dict
                suboptions:
                  set:
                    description: Enable OSPF auto-cost
                    type: bool
                  reference_bandwidth:
                    description:
                      - Use reference bandwidth method to assign OSPF cost
                      - Note, refer vendor documentation for respective valid values
                    type: int
              bfd:
                description: BFD configuration commands
                type: dict
                suboptions:
                  all_interfaces:
                    description: Enable BFD on all interfaces
                    type: bool
                  disable:
                    description: Disable BFD on all interfaces
                    type: bool
              capability:
                description:
                  - Enable a specific feature
                  - Do not perform PE specific checks
                type: bool
              compatible:
                description: OSPFv3 router compatibility list
                type: dict
                suboptions:
                  rfc1583:
                    description: compatible with RFC 1583
                    type: bool
                  rfc1587:
                    description: compatible with RFC 1587
                    type: bool
                  rfc5243:
                    description: supports DBD exchange optimization
                    type: bool
              default_information:
                description: Control distribution of default information
                type: dict
                suboptions:
                  originate:
                    description: Distribute a default route
                    type: bool
                  always:
                    description: Always advertise default route
                    type: bool
                  metric:
                    description:
                      - OSPF default metric
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  metric_type:
                    description:
                      - OSPF metric type for default routes
                      - Note, please refer vendor documentation for respective valid range
                    type: int
                  route_map:
                    description: Route-map reference name
                    type: str
              default_metric:
                description: Set metric of redistributed routes
                type: int
              discard_route:
                description: Enable or disable discard-route installation
                type: dict
                suboptions:
                  sham_link:
                    description: Discard route for sham-link routes
                    type: bool
                  external:
                    description: Discard route for summarised redistributed routes
                    type: bool
                  internal:
                    description: Discard route for summarised inter-area routes
                    type: bool
              distance:
                description:
                  - Define an administrative distance
                  - Note, please refer vendor documentation for respective valid range
                type: int
              distribute_list:
                description: Filter networks in routing updates
                type: dict
                suboptions:
                  acls:
                    description: IP access list
                    type: list
                    elements: dict
                    suboptions:
                      name:
                        description: IP access list name/number
                        type: str
                        required: true
                      direction:
                        description: Filter incoming and outgoing routing updates.
                        type: str
                        required: true
                        choices: ['in', 'out']
                      interface:
                        description:
                          - Interface configuration (GigabitEthernet A/B)
                          - Valid with incoming traffic
                        type: str
                      protocol:
                        description:
                          - Protocol config (bgp 1).
                          - Valid with outgoing traffic
                        type: str
                  prefix:
                    description: Filter prefixes in routing updates
                    type: dict
                    suboptions:
                      name:
                        description: Name of an IP prefix-list
                        type: str
                        required: true
                      gateway_name:
                        description: Gateway name for filtering incoming updates based on gateway
                        type: str
                      direction:
                        description: Filter incoming and outgoing routing updates.
                        type: str
                        required: true
                        choices: ['in', 'out']
                      interface:
                        description:
                          - Interface configuration (GigabitEthernet A/B)
                          - Valid with incoming traffic
                        type: str
                      protocol:
                        description:
                          - Protocol config (bgp 1).
                          - Valid with outgoing traffic
                        type: str
                  route_map:
                    description: Filter prefixes in routing updates
                    type: dict
                    suboptions:
                      name:
                        description: Route-map name
                        type: str
                        required: true
              event_log:
                description: Event Logging
                type: dict
                suboptions:
                  enable:
                    description: Enable event Logging
                    type: bool
                  one_shot:
                    description: Disable Logging When Log Buffer Becomes Full
                    type: bool
                  pause:
                    description: Pause Event Logging
                    type: bool
                  size:
                    description:
                      - Maximum Number of Events Stored in the Event Log
                      - Note, refer vendor documentation for respective valid values
                    type: int
              graceful_restart:
                description:
                  - Graceful-restart options
                  - helper support
                type: dict
                suboptions:
                  enable:
                    description: helper support enabled
                    type: bool
                  disable:
                    description: disable helper support
                    type: bool
                  strict_lsa_checking:
                    description: enable helper strict LSA checking
                    type: bool
              interface_id:
                description: Source of the interface ID
                type: dict
                suboptions:
                  ios_if_index:
                    description: IOS interface number
                    type: bool
                  snmp_if_index:
                    description: SNMP MIB ifIndex
                    type: bool
              limit:
                description: Limit a specific OSPF feature
                type: dict
                suboptions:
                  dc:
                    description: Demand circuit retransmissions
                    type: dict
                    suboptions:
                      number:
                        description: The maximum number of retransmissions
                        type: int
                      disable:
                        description: Disble the feature
                        type: bool
                  non_dc:
                    description: Non-demand-circuit retransmissions
                    type: dict
                    suboptions:
                      number:
                        description: The maximum number of retransmissions
                        type: int
                      disable:
                        description: Disble the feature
                        type: bool
              local_rib_criteria:
                description: Enable or disable usage of local RIB as route criteria
                type: dict
                suboptions:
                  enable:
                    description: Enable usage of local RIB as route criteria
                    type: bool
                  forwarding_address:
                    description: Local RIB used to validate external/NSSA forwarding addresses
                    type: bool
                  inter_area_summary:
                    description: Local RIB used as criteria for inter-area summaries
                    type: bool
                  nssa_translation:
                    description: Local RIB used as criteria for NSSA translation
                    type: bool
              log_adjacency_changes:
                description: Log changes in adjacency state
                type: dict
                suboptions:
                  set:
                    description: Log changes in adjacency state
                    type: bool
                  detail:
                    description: Log all state changes
                    type: bool
              manet:
                description: Specify MANET OSPF parameters
                type: dict
                suboptions:
                  cache:
                    description: Specify MANET cache sizes
                    type: dict
                    suboptions:
                      acknowledgement:
                        description:
                          - Specify MANET acknowledgement cache size
                          - Maximum number of acknowledgements in cache
                        type: int
                      update:
                        description:
                          - Specify MANET LSA cache size
                          - Maximum number of LSAs in cache
                        type: int
                  hello:
                    description: Unicast Hellos rather than multicast
                    type: dict
                    suboptions:
                      multicast:
                        description: Multicast Hello requests and responses rather than unicast
                        type: bool
                      unicast:
                        description: Unicast Hello requests and responses rather than multicast
                        type: bool
                  peering:
                    description: MANET OSPF Smart Peering
                    type: dict
                    suboptions:
                      set:
                        description: Enable selective peering
                        type: bool
                      disable:
                        description: Disable selective peering
                        type: bool
                      per_interface:
                        description: Select peers per interface rather than per node
                        type: bool
                      redundancy:
                        description:
                          - Redundant paths
                          - Number of redundant OSPF paths
                        type: int
                  willingness:
                    description: Specify and Relay willingness value
                    type: int
              max_lsa:
                description: Maximum number of non self-generated LSAs to accept
                type: dict
                suboptions:
                  number:
                    description:
                      - Maximum number of non self-generated LSAs to accept
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  threshold_value:
                    description:
                      - Threshold value (%) at which to generate a warning msg
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  ignore_count:
                    description:
                      - Maximum number of times adjacencies can be suppressed
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  ignore_time:
                    description:
                      - Number of minutes during which all adjacencies are suppressed
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  reset_time:
                    description:
                      - Number of minutes after which ignore-count is reset to zero
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  warning_only:
                    description: Only give a warning message when limit is exceeded
                    type: bool
              max_metric:
                description:
                  - Set maximum metric
                  - Maximum metric in self-originated router-LSAs
                type: dict
                suboptions:
                  disable:
                    description: disable maximum metric in self-originated router-LSAs
                    type: bool
                  external_lsa:
                    description:
                      - Override external-lsa metric with max-metric value
                      - Overriding metric in external-LSAs
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  inter_area_lsas:
                    description:
                      - Override inter-area-lsas metric with max-metric value
                      - Overriding metric in inter-area-LSAs
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  on_startup:
                    description: Set maximum metric temporarily after reboot
                    type: dict
                    suboptions:
                      time:
                        description:
                          - Time, in seconds, router-LSAs are originated with max-metric
                          - Note, please refer vendor documentation for respective valid range
                        type: int
                      wait_for_bgp:
                        description: Let BGP decide when to originate router-LSA with normal metric
                        type: bool
                  stub_prefix_lsa:
                    description: Set maximum metric for stub links in prefix LSAs
                    type: bool
              maximum_paths:
                description:
                  - Forward packets over multiple paths
                  - Number of paths
                type: int
              passive_interface:
                description: Suppress routing updates on an interface
                type: str
              prefix_suppression:
                description: Prefix suppression
                type: dict
                suboptions:
                  enable:
                    description: Enable prefix suppression
                    type: bool
                  disable:
                    description: Disable prefix suppression
                    type: bool
              queue_depth:
                description: Hello/Router process queue depth
                type: dict
                suboptions:
                  hello:
                    description: OSPF Hello process queue depth
                    type: dict
                    suboptions:
                      max_packets:
                        description: maximum number of packets in the queue
                        type: int
                      unlimited:
                        description: Unlimited queue depth
                        type: bool
                  update:
                    description: OSPF Router process queue depth
                    type: dict
                    suboptions:
                      max_packets:
                        description: maximum number of packets in the queue
                        type: int
                      unlimited:
                        description: Unlimited queue depth
                        type: bool
              router_id:
                description:
                  - Router-id address for this OSPF process
                  - OSPF router-id in IP address format (A.B.C.D)
                type: str
              shutdown:
                description: Shutdown the router process
                type: dict
                suboptions:
                  enable:
                    description: Shutdown the router process
                    type: bool
                  disable:
                    description: Disable Shutdown
                    type: bool
              summary_prefix:
                description: Configure IP address summaries
                type: dict
                suboptions:
                  address:
                    description:
                      - IP summary address (A.B.C.D)
                      - IP prefix <network>/<length> (A.B.C.D/nn)
                    type: str
                  mask:
                    description: IP Summary mask
                    type: str
                  not_advertise:
                    description: Do not advertise or translate
                    type: bool
                  nssa_only:
                    description: Limit summary to NSSA areas
                    type: bool
                  tag:
                    description: Set tag
                    type: int
              timers:
                description: Adjust routing timers
                type: dict
                suboptions:
                  lsa:
                    description:
                      - OSPF LSA timers, arrival timer
                      - The minimum interval in milliseconds between accepting the same LSA
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  manet:
                    description: OSPF MANET timers
                    type: dict
                    suboptions:
                      cache:
                        description: Specify MANET cache sizes
                        type: dict
                        suboptions:
                          acknowledgement:
                            description: Specify MANET acknowledgement cache size
                            type: int
                          redundancy:
                            description: Specify MANET LSA cache size
                            type: int
                      hello:
                        description:
                          - Unicast Hellos rather than multicast
                          - Unicast Hello requests and responses rather than multicast
                        type: bool
                      peering:
                        description: MANET OSPF Smart Peering
                        type: dict
                        suboptions:
                          set:
                            description: Enable selective peering
                            type: bool
                          per_interface:
                            description: Select peers per interface rather than per node
                            type: bool
                          redundancy:
                            description:
                              - Redundant paths
                              - Number of redundant OSPF paths
                            type: int
                      willingness:
                        description: Specify and Relay willingness value
                        type: int
                  pacing:
                    description: OSPF pacing timers
                    type: dict
                    suboptions:
                      flood:
                        description:
                          - OSPF flood pacing timer
                          - The minimum interval in msec to pace limit flooding on interface
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      lsa_group:
                        description:
                          - OSPF LSA group pacing timer
                          - Interval in sec between group of LSA being refreshed or maxaged
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      retransmission:
                        description:
                          - OSPF retransmission pacing timer
                          - The minimum interval in msec between neighbor retransmissions
                          - Note, refer vendor documentation for respective valid values
                        type: int
                  throttle:
                    description: OSPF throttle timers
                    type: dict
                    suboptions:
                      lsa:
                        description: OSPF LSA throttle timers
                        type: dict
                        suboptions:
                          first_delay:
                            description:
                              - Delay to generate first occurrence of LSA in milliseconds
                              - Note, refer vendor documentation for respective valid values
                            type: int
                          min_delay:
                            description:
                              - Minimum delay between originating the same LSA in milliseconds
                              - Note, refer vendor documentation for respective valid values
                            type: int
                          max_delay:
                            description:
                              - Maximum delay between originating the same LSA in milliseconds
                              - Note, refer vendor documentation for respective valid values
                            type: int
                      spf:
                        description: OSPF SPF throttle timers
                          - Delay between receiving a change to SPF calculation in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: dict
                        suboptions:
                          receive_delay:
                            description:
                              - Delay between receiving a change to SPF calculation in milliseconds
                              - Note, refer vendor documentation for respective valid values
                            type: int
                          between_delay:
                            description:
                              - Delay between first and second SPF calculation in milliseconds
                              - Note, refer vendor documentation for respective valid values
                            type: int
                          max_delay:
                            description:
                              - Maximum wait time in milliseconds for SPF calculations
                              - Note, refer vendor documentation for respective valid values
                            type: int
          adjacency:
            description: Control adjacency formation
            type: dict
            suboptions:
              min_adjacency:
                description:
                  - Initial number of adjacencies allowed to be forming in an area
                  - Please refer vendor documentation for valid values
                type: int
              max_adjacency:
                description:
                  - Maximum number of adjacencies allowed to be forming
                  - Please refer vendor documentation for valid values
                type: int
              none:
                description: No initial
                type: bool
          areas:
            description: OSPF area parameters
            type: list
            elements: dict
            suboptions:
              area_id:
                description:
                  - OSPF area ID as a decimal value. Please refer vendor documentation
                    of Valid values.
                  - OSPF area ID in IP address format(e.g. A.B.C.D)
                type: str
              authentication:
                description: Authentication parameters
                type: dict
                suboptions:
                  key_chain:
                    description: Use a key-chain for cryptographic authentication keys
                    type: str
                  ipsec:
                    description: Use IPsec authentication
                    type: dict
                    suboptions:
                      spi:
                        description: Set the SPI (Security Parameters Index)
                        type: int
                      md5:
                        description: Use MD5 authentication
                        type: int
                      sha1:
                        description: Use SHA-1 authentication
                        type: int
                      hex_string:
                        description: SHA-1 key (40 chars)
                        type: str
              default_cost:
                description:
                  - Set the summary default-cost of a NSSA/stub area
                  - Stub's advertised external route metric
                  - Note, please refer vendor documentation for respective valid values
                type: int
              nssa:
                description: Specify a NSSA area
                type: dict
                suboptions:
                  set:
                    description: Enable a NSSA area
                    type: bool
                  default_information_originate:
                    description: Originate Type 7 default into NSSA area
                    type: dict
                    suboptions:
                      metric:
                        description: OSPF default metric
                        type: int
                      metric_type:
                        description:
                          - OSPF metric type for default routes
                          - OSPF Link State type
                        type: int
                        choices: [1, 2]
                      nssa_only:
                        description: Limit default advertisement to this NSSA area
                        type: bool
                  no_redistribution:
                    description: No redistribution into this NSSA area
                    type: bool
                  no_summary:
                    description: Do not send summary LSA into NSSA
                    type: bool
                  translate:
                    description:
                      - Translate LSA
                      - Always translate LSAs on this ABR
                      - Suppress forwarding address in translated LSAs
                    type: str
                    choices: ['always', 'suppress-fa']
              stub:
                description:
                  - Specify a stub area
                  - Backbone can not be configured as stub area
                type: dict
                suboptions:
                  set:
                    description: Enable a stub area
                    type: bool
                  no_summary:
                    description: Do not send summary LSA into stub area
                    type: bool
          authentication:
            description:
              - Authentication parameter mode
              - Deployment mode of operation
            type: bool
          auto_cost:
            description: Calculate OSPF interface cost according to bandwidth
            type: dict
            suboptions:
              set:
                description: Enable OSPF auto-cost
                type: bool
              reference_bandwidth:
                description:
                  - Use reference bandwidth method to assign OSPF cost
                  - Note, refer vendor documentation for respective valid values
                type: int
          bfd:
            description:
              - BFD configuration commands
              - Enable BFD on all interfaces
            type: bool
          compatible:
            description: OSPFv3 router compatibility list
            type: dict
            suboptions:
              rfc1583:
                description: compatible with RFC 1583
                type: bool
              rfc1587:
                description: compatible with RFC 1587
                type: bool
              rfc5243:
                description: supports DBD exchange optimization
                type: bool
          event_log:
            description: Event Logging
            type: dict
            suboptions:
              enable:
                description: Enable event Logging
                type: bool
              one_shot:
                description: Disable Logging When Log Buffer Becomes Full
                type: bool
              pause:
                description: Pause Event Logging
                type: bool
              size:
                description:
                  - Maximum Number of Events Stored in the Event Log
                  - Note, refer vendor documentation for respective valid values
                type: int
          graceful_restart:
            description: Graceful-restart options for helper support
            type: dict
            suboptions:
              disable:
                description: disable helper support
                type: bool
              strict_lsa_checking:
                description: enable helper strict LSA checking
                type: bool
          help:
            description: Description of the interactive help system
            type: bool
          interface_id:
            description:
              - Source of the interface ID
              - SNMP MIB ifIndex
            type: bool
          limit:
            description: Limit a specific OSPF feature and LS update, DBD, and LS request retransmissions
            type: dict
            suboptions:
              dc:
                description: Demand circuit retransmissions
                type: dict
                suboptions:
                  number:
                    description: The maximum number of retransmissions
                    type: int
                  disable:
                    description: Disble the feature
                    type: bool
              non_dc:
                description: Non-demand-circuit retransmissions
                type: dict
                suboptions:
                  number:
                    description: The maximum number of retransmissions
                    type: int
                  disable:
                    description: Disble the feature
                    type: bool
          local_rib_criteria:
            description: Enable or disable usage of local RIB as route criteria
            type: dict
            suboptions:
              enable:
                description: Enable usage of local RIB as route criteria
                type: bool
              forwarding_address:
                description: Local RIB used to validate external/NSSA forwarding addresses
                type: bool
              inter_area_summary:
                description: Local RIB used as criteria for inter-area summaries
                type: bool
              nssa_translation:
                description: Local RIB used as criteria for NSSA translation
                type: bool
          log_adjacency_changes:
            description: Log changes in adjacency state
            type: dict
            suboptions:
              set:
                description: Log changes in adjacency state
                type: bool
              detail:
                description: Log all state changes
                type: bool
          manet:
            description: Specify MANET OSPF parameters
            type: dict
            suboptions:
              cache:
                description: Specify MANET cache sizes
                type: dict
                suboptions:
                  acknowledgement:
                    description: Specify MANET acknowledgement cache size
                    type: int
                  redundancy:
                    description: Specify MANET LSA cache size
                    type: int
              hello:
                description:
                  - Unicast Hellos rather than multicast
                  - Unicast Hello requests and responses rather than multicast
                type: bool
              peering:
                description: MANET OSPF Smart Peering
                type: dict
                suboptions:
                  set:
                    description: Enable selective peering
                    type: bool
                  per_interface:
                    description: Select peers per interface rather than per node
                    type: bool
                  redundancy:
                    description:
                      - Redundant paths
                      - Number of redundant OSPF paths
                    type: int
              willingness:
                description: Specify and Relay willingness value
                type: int
          max_lsa:
            description: Maximum number of non self-generated LSAs to accept
            type: dict
            suboptions:
              number:
                description:
                  - Maximum number of non self-generated LSAs to accept
                  - Note, refer vendor documentation for respective valid values
                type: int
              threshold_value:
                description:
                  - Threshold value (%) at which to generate a warning msg
                  - Note, refer vendor documentation for respective valid values
                type: int
              ignore_count:
                description:
                  - Maximum number of times adjacencies can be suppressed
                  - Note, refer vendor documentation for respective valid values
                type: int
              ignore_time:
                description:
                  - Number of minutes during which all adjacencies are suppressed
                  - Note, refer vendor documentation for respective valid values
                type: int
              reset_time:
                description:
                  - Number of minutes after which ignore-count is reset to zero
                  - Note, refer vendor documentation for respective valid values
                type: int
              warning_only:
                description: Only give a warning message when limit is exceeded
                type: bool
          max_metric:
            description: Set maximum metric
            type: dict
            suboptions:
              router_lsa:
                description: Maximum metric in self-originated router-LSAs
                type: bool
                required: true
              external_lsa:
                description:
                  - Override external-lsa metric with max-metric value
                  - Overriding metric in external-LSAs
                  - Note, refer vendor documentation for respective valid values
                type: int
              include_stub:
                description: Set maximum metric for stub links in router-LSAs
                type: bool
              on_startup:
                description: Set maximum metric temporarily after reboot
                type: dict
                suboptions:
                  time:
                    description:
                      - Time, in seconds, router-LSAs are originated with max-metric
                      - Note, please refer vendor documentation for respective valid range
                    type: int
                  wait_for_bgp:
                    description: Let BGP decide when to originate router-LSA with normal metric
                    type: bool
              summary_lsa:
                description:
                  - Override summary-lsa metric with max-metric value
                  - Note, please refer vendor documentation for respective valid range
                type: int
          passive_interface:
            description: Suppress routing updates on an interface
            type: str
          prefix_suppression:
            description: Enable prefix suppression
            type: bool
          queue_depth:
            description: Hello/Router process queue depth
            type: dict
            suboptions:
              hello:
                description: OSPF Hello process queue depth
                type: dict
                suboptions:
                  max_packets:
                    description: maximum number of packets in the queue
                    type: int
                  unlimited:
                    description: Unlimited queue depth
                    type: bool
          router_id:
            description:
              - Router-id address for this OSPF process
              - OSPF router-id in IP address format (A.B.C.D)
            type: str
          shutdown:
            description: Shutdown the router process
            type: bool
          timers:
            description: Adjust routing timers
            type: dict
            suboptions:
              lsa:
                description:
                  - OSPF LSA timers, arrival timer
                  - The minimum interval in milliseconds between accepting the same LSA
                  - Note, refer vendor documentation for respective valid values
                type: int
              manet:
                description: OSPF MANET timers
                type: dict
                suboptions:
                  cache:
                    description: Specify MANET cache sizes
                    type: dict
                    suboptions:
                      acknowledgement:
                        description: Specify MANET acknowledgement cache size
                        type: int
                      redundancy:
                        description: Specify MANET LSA cache size
                        type: int
                  hello:
                    description:
                      - Unicast Hellos rather than multicast
                      - Unicast Hello requests and responses rather than multicast
                    type: bool
                  peering:
                    description: MANET OSPF Smart Peering
                    type: dict
                    suboptions:
                      set:
                        description: Enable selective peering
                        type: bool
                      per_interface:
                        description: Select peers per interface rather than per node
                        type: bool
                      redundancy:
                        description:
                          - Redundant paths
                          - Number of redundant OSPF paths
                        type: int
                  willingness:
                    description: Specify and Relay willingness value
                    type: int
              pacing:
                description: OSPF pacing timers
                type: dict
                suboptions:
                  flood:
                    description:
                      - OSPF flood pacing timer
                      - The minimum interval in msec to pace limit flooding on interface
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  lsa_group:
                    description:
                      - OSPF LSA group pacing timer
                      - Interval in sec between group of LSA being refreshed or maxaged
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  retransmission:
                    description:
                      - OSPF retransmission pacing timer
                      - The minimum interval in msec between neighbor retransmissions
                      - Note, refer vendor documentation for respective valid values
                    type: int
              throttle:
                description: OSPF throttle timers
                type: dict
                suboptions:
                  lsa:
                    description: OSPF LSA throttle timers
                    type: dict
                    suboptions:
                      first_delay:
                        description:
                          - Delay to generate first occurrence of LSA in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      min_delay:
                        description:
                          - Minimum delay between originating the same LSA in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      max_delay:
                        description:
                          - Maximum delay between originating the same LSA in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                  spf:
                    description: OSPF SPF throttle timers
                      - Delay between receiving a change to SPF calculation in milliseconds
                      - Note, refer vendor documentation for respective valid values
                    type: dict
                    suboptions:
                      receive_delay:
                        description:
                          - Delay between receiving a change to SPF calculation in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      between_delay:
                        description:
                          - Delay between first and second SPF calculation in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      max_delay:
                        description:
                          - Maximum wait time in milliseconds for SPF calculations
                          - Note, refer vendor documentation for respective valid values
                        type: int
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the IOS device by
      executing the command B(sh running-config | section ^router ospfv3).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
      - The state the configuration should be left in
      - The states I(rendered), I(gathered) and I(parsed) does not perform any change
        on the device.
      - The state I(rendered) will transform the configuration in C(config) option to
        platform specific CLI commands which will be returned in the I(rendered) key
        within the result. For state I(rendered) active connection to remote host is
        not required.
      - The state I(gathered) will fetch the running configuration from device and transform
        it into structured data in the format as per the resource module argspec and
        the value is returned in the I(gathered) key within the result.
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into JSON format as per the resource module parameters and the
        value is returned in the I(parsed) key within the result. The value of C(running_config)
        option should be the same format as the output of command I(show running-config
        | include ip route|ipv6 route) executed on device. For state I(parsed) active
        connection to remote host is not required.
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - parsed
    - rendered
    default: merged

"""
EXAMPLES = """

# Using deleted

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

- name: Delete provided OSPF V3 processes
  cisco.ios.ios_ospfv3:
    config:
      processes:
      - process_id: 1
    state: deleted

# Commands Fired:
# ---------------
#
# "commands": [
#        "no router ospfv3 1"
#    ]

# After state:
# -------------
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

# Using deleted without any config passed (NOTE: This will delete all OSPFV3 configuration from device)

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

- name: Delete all OSPF processes
  cisco.ios.ios_ospfv3:
    state: deleted

# Commands Fired:
# ---------------
#
# "commands": [
#        "no router ospfv3 200",
#        "no router ospfv3 1"
#    ]

# After state:
# -------------
# router-ios#sh running-config | section ^router ospfv3
# router-ios#

# Using merged

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospfv3
# router-ios#

- name: Merge provided OSPFV3 configuration
  cisco.ios.ios_ospfv3:
    config:
      processes:
      - process_id: 1
        max_metric:
          router_lsa: true
          on_startup:
            time: 110
        address_family:
          - afi: ipv4
            unicast: true
            vrf: blue
            adjacency:
              min_adjacency: 50
              max_adjacency: 50
            areas:
              - area_id: 25
                nssa:
                  default_information_originate:
                    metric: 25
                    nssa_only: true
        areas:
          - area_id: "10"
            nssa:
              default_information_originate:
                metric: 10
        timers:
          throttle:
            lsa:
              first_delay: 12
              min_delay: 14
              max_delay: 16
      - process_id: 200
        address_family:
          - afi: ipv4
            unicast: true
            adjacency:
              min_adjacency: 200
              max_adjacency: 200
        max_metric:
          router_lsa: true
          on_startup:
            time: 100
        auto_cost:
          reference_bandwidth: 4
    state: merged

# Commands Fired:
# ---------------
#
#  "commands": [
#         "router ospfv3 1",
#         "max-metric router-lsa on-startup 110",
#         "area 10 nssa default-information-originate metric 10",
#         "address-family ipv4 unicast vrf blue",
#         "adjacency stagger 50 50",
#         "area 25 nssa default-information-originate metric 25 nssa-only",
#         "exit-address-family",
#         "router ospfv3 200",
#         "auto-cost reference-bandwidth 4",
#         "max-metric router-lsa on-startup 100",
#         "address-family ipv4 unicast",
#         "adjacency stagger 200 200",
#         "exit-address-family"
#     ]

# After state:
# -------------
#
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

# Using overridden

# Before state:
# -------------
#
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

- name: Override provided OSPFV3 configuration
  cisco.ios.ios_ospfv3:
    config:
      processes:
        - process_id: 200
          max_metric:
            router_lsa: true
            on_startup:
              time: 200
          address_family:
            - afi: ipv4
              unicast: true
              adjacency:
                min_adjacency: 50
                max_adjacency: 50
              areas:
                - area_id: 200
                  nssa:
                    default_information_originate:
                      metric: 200
                      nssa_only: true
          areas:
            - area_id: "10"
              nssa:
                default_information_originate:
                  metric: 10
    state: overridden

# Commands Fired:
# ---------------
#
# "commands": [
#         "no router ospfv3 1",
#         "router ospfv3 200",
#         "no auto-cost reference-bandwidth 4",
#         "max-metric router-lsa on-startup 200",
#         "area 10 nssa default-information-originate metric 10",
#         "address-family ipv4 unicast",
#         "adjacency stagger 50 50",
#         "area 200 nssa default-information-originate metric 200 nssa-only",
#         "exit-address-family"
#     ]

# After state:
# -------------
#
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 200
#  max-metric router-lsa on-startup 200
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast
#   adjacency stagger 50 50
#   area 200 nssa default-information-originate metric 200 nssa-only
#  exit-address-family

# Using replaced

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

- name: Replaced provided OSPFV3 configuration
  cisco.ios.ios_ospfv3:
    config:
      processes:
        - process_id: 200
          max_metric:
            router_lsa: true
            on_startup:
              time: 200
          address_family:
            - afi: ipv4
              unicast: true
              adjacency:
                min_adjacency: 50
                max_adjacency: 50
              areas:
                - area_id: 200
                  nssa:
                    default_information_originate:
                      metric: 200
                      nssa_only: true
          areas:
            - area_id: "10"
              nssa:
                default_information_originate:
                  metric: 10
    state: replaced

# Commands Fired:
# ---------------
# "commands": [
#         "router ospfv3 200",
#         "no auto-cost reference-bandwidth 4",
#         "max-metric router-lsa on-startup 200",
#         "area 10 nssa default-information-originate metric 10",
#         "address-family ipv4 unicast",
#         "adjacency stagger 50 50",
#         "area 200 nssa default-information-originate metric 200 nssa-only",
#         "exit-address-family"
#     ]

# After state:
# -------------
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 200
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast
#   adjacency stagger 50 50
#   area 200 nssa default-information-originate metric 200 nssa-only
#  exit-address-family

# Using Gathered

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

- name: Gather OSPFV3 provided configurations
  cisco.ios.ios_ospfv3:
    config:
    state: gathered

# Module Execution Result:
# ------------------------
#
# "gathered": {
#         "processes": [
#             {
#                 "address_family": [
#                     {
#                         "adjacency": {
#                             "max_adjacency": 50,
#                             "min_adjacency": 50
#                         },
#                         "afi": "ipv4",
#                         "areas": [
#                             {
#                                 "area_id": "25",
#                                 "nssa": {
#                                     "default_information_originate": {
#                                         "metric": 25,
#                                         "nssa_only": true
#                                     }
#                                 }
#                             }
#                         ],
#                         "unicast": true,
#                         "vrf": "blue"
#                     }
#                 ],
#                 "areas": [
#                     {
#                         "area_id": "10",
#                         "nssa": {
#                             "default_information_originate": {
#                                 "metric": 10
#                             }
#                         }
#                     }
#                 ],
#                 "max_metric": {
#                     "on_startup": {
#                         "time": 110
#                     },
#                     "router_lsa": true
#                 },
#                 "process_id": 1
#             },
#             {
#                 "address_family": [
#                     {
#                         "adjacency": {
#                             "max_adjacency": 200,
#                             "min_adjacency": 200
#                         },
#                         "afi": "ipv4",
#                         "unicast": true
#                     }
#                 ],
#                 "auto_cost": {
#                     "reference_bandwidth": 4
#                 },
#                 "max_metric": {
#                     "on_startup": {
#                         "time": 100
#                     },
#                     "router_lsa": true
#                 },
#                 "process_id": 200
#             }
#         ]
#     }

# After state:
# ------------
#
# router-ios#sh running-config | section ^router ospfv3
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

# Using Rendered

- name: Render the commands for provided  configuration
  cisco.ios.ios_ospfv3:
    config:
      processes:
      - process_id: 1
        max_metric:
          router_lsa: true
          on_startup:
            time: 110
        address_family:
          - afi: ipv4
            unicast: true
            vrf: blue
            adjacency:
              min_adjacency: 50
              max_adjacency: 50
            areas:
              - area_id: 25
                nssa:
                  default_information_originate:
                    metric: 25
                    nssa_only: true
        areas:
          - area_id: "10"
            nssa:
              default_information_originate:
                metric: 10
        timers:
          throttle:
            lsa:
              first_delay: 12
              min_delay: 14
              max_delay: 16
      - process_id: 200
        address_family:
          - afi: ipv4
            unicast: true
            adjacency:
              min_adjacency: 200
              max_adjacency: 200
        max_metric:
          router_lsa: true
          on_startup:
            time: 100
        auto_cost:
          reference_bandwidth: 4
    state: rendered

# Module Execution Result:
# ------------------------
#
# "rendered": [
#         "router ospfv3 1",
#         "max-metric router-lsa on-startup 110",
#         "area 10 nssa default-information-originate metric 10",
#         "address-family ipv4 unicast vrf blue",
#         "adjacency stagger 50 50",
#         "area 25 nssa default-information-originate metric 25 nssa-only",
#         "exit-address-family",
#         "router ospfv3 200",
#         "auto-cost reference-bandwidth 4",
#         "max-metric router-lsa on-startup 100",
#         "address-family ipv4 unicast",
#         "adjacency stagger 200 200",
#         "exit-address-family"
#     ]

# Using Parsed

# File: parsed.cfg
# ----------------
#
# router ospfv3 1
#  max-metric router-lsa on-startup 110
#  area 10 nssa default-information-originate metric 10
#  !
#  address-family ipv4 unicast vrf blue
#   adjacency stagger 50 50
#   area 25 nssa default-information-originate metric 25 nssa-only
#  exit-address-family
# router ospfv3 200
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  !
#  address-family ipv4 unicast
#   adjacency stagger 200 200
#  exit-address-family

- name: Parse the provided configuration with the existing running configuration
  cisco.ios.ios_ospfv3:
    running_config: "{{ lookup('file', 'parsed.cfg') }}"
    state: parsed

# Module Execution Result:
# ------------------------
#
# "parsed": {
#         "processes": [
#             {
#                 "address_family": [
#                     {
#                         "adjacency": {
#                             "max_adjacency": 50,
#                             "min_adjacency": 50
#                         },
#                         "afi": "ipv4",
#                         "areas": [
#                             {
#                                 "area_id": "25",
#                                 "nssa": {
#                                     "default_information_originate": {
#                                         "metric": 25,
#                                         "nssa_only": true
#                                     }
#                                 }
#                             }
#                         ],
#                         "unicast": true,
#                         "vrf": "blue"
#                     }
#                 ],
#                 "areas": [
#                     {
#                         "area_id": "10",
#                         "nssa": {
#                             "default_information_originate": {
#                                 "metric": 10
#                             }
#                         }
#                     }
#                 ],
#                 "max_metric": {
#                     "on_startup": {
#                         "time": 110
#                     },
#                     "router_lsa": true
#                 },
#                 "process_id": 1
#             }
#         ]
#     }

"""

RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
after:
  description: The resulting configuration model invocation.
  returned: when changed
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['router ospfv3 1', 'address-family ipv4 unicast vrf blue', 'adjacency stagger 50 50']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.cisco.ios.plugins.module_utils.network.ios.argspec.ospfv3.ospfv3 import (
    Ospfv3Args,
)
from ansible_collections.cisco.ios.plugins.module_utils.network.ios.config.ospfv3.ospfv3 import (
    Ospfv3,
)


def main():
    """
    Main entry point for module execution
    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]

    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=Ospfv3Args.argument_spec,
        required_if=required_if,
        mutually_exclusive=mutually_exclusive,
        supports_check_mode=True,
    )

    result = Ospfv3(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
