/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.util.CDPQEntry;

class OutboundGatewayMessage
extends PendingGatewayMessage
implements CDPQEntry {
    private long _seqNum;
    private final int _priority;

    public OutboundGatewayMessage(I2NPMessage message, Hash toRouter, TunnelId toTunnel) {
        super(message, toRouter, toTunnel);
        this._priority = OutboundGatewayMessage.getPriority(message);
    }

    @Override
    public void setSeqNum(long num) {
        this._seqNum = num;
    }

    @Override
    public long getSeqNum() {
        return this._seqNum;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    private static int getPriority(I2NPMessage message) {
        switch (message.getType()) {
            case 10: {
                return 1000;
            }
            case 21: 
            case 23: {
                return 500;
            }
            case 1: {
                return 400;
            }
            case 2: {
                return 300;
            }
            case 11: {
                return 200;
            }
        }
        return 100;
    }
}

