/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import sun.jvm.hotspot.code.DebugInfoReadStream;
import sun.jvm.hotspot.code.Location;
import sun.jvm.hotspot.code.ScopeValue;

public class MonitorValue {
    private ScopeValue owner;
    private Location basicLock;
    private boolean eliminated;

    public MonitorValue(DebugInfoReadStream stream) {
        this.basicLock = new Location(stream);
        this.owner = ScopeValue.readFrom(stream);
        this.eliminated = stream.readBoolean();
    }

    public ScopeValue owner() {
        return this.owner;
    }

    public Location basicLock() {
        return this.basicLock;
    }

    public boolean eliminated() {
        return this.eliminated;
    }

    public void printOn(PrintStream tty) {
        tty.print("monitor{");
        this.owner().printOn(tty);
        tty.print(",");
        this.basicLock().printOn(tty);
        tty.print("}");
        if (this.eliminated) {
            tty.print(" (eliminated)");
        }
    }
}

