# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2021 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.global_infra.sites.enforcement_points.edge_clusters.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class EdgeNodes(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.global_infra.sites.enforcement_points.edge_clusters.edge_nodes'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EdgeNodesStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            site_id,
            enforcementpoint_id,
            edge_cluster_id,
            edge_node_id,
            ):
        """
        Read a Edge Node under an Enforcement Point, Edge Cluster

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  edge_cluster_id: :class:`str`
        :param edge_cluster_id: (required)
        :type  edge_node_id: :class:`str`
        :param edge_node_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyEdgeNode`
        :return: com.vmware.nsx_policy.model.PolicyEdgeNode
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'edge_cluster_id': edge_cluster_id,
                            'edge_node_id': edge_node_id,
                            })

    def list(self,
             site_id,
             enforcementpoint_id,
             edge_cluster_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Edge Nodes under an Enforcement Point, Edge
        Cluster

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  edge_cluster_id: :class:`str`
        :param edge_cluster_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyEdgeNodeListResult`
        :return: com.vmware.nsx_policy.model.PolicyEdgeNodeListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'edge_cluster_id': edge_cluster_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class UrlCategorizationConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.global_infra.sites.enforcement_points.edge_clusters.url_categorization_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UrlCategorizationConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               enforcement_point_id,
               edge_cluster_id,
               url_categorization_config_id,
               ):
        """
        Delete PolicyUrlCategorizationConfig. If deleted, the URL
        categorization will be disabled for that edge cluster.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: (required)
        :type  edge_cluster_id: :class:`str`
        :param edge_cluster_id: (required)
        :type  url_categorization_config_id: :class:`str`
        :param url_categorization_config_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'edge_cluster_id': edge_cluster_id,
                            'url_categorization_config_id': url_categorization_config_id,
                            })

    def get(self,
            site_id,
            enforcement_point_id,
            edge_cluster_id,
            url_categorization_config_id,
            ):
        """
        Gets a PolicyUrlCategorizationConfig. This returns the details of the
        config like whether the URL categorization is enabled or disabled, the
        id of the context profiles which are used to filter the categories, and
        the update frequency of the data from the cloud.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: (required)
        :type  edge_cluster_id: :class:`str`
        :param edge_cluster_id: (required)
        :type  url_categorization_config_id: :class:`str`
        :param url_categorization_config_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyUrlCategorizationConfig`
        :return: com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'edge_cluster_id': edge_cluster_id,
                            'url_categorization_config_id': url_categorization_config_id,
                            })

    def patch(self,
              site_id,
              enforcement_point_id,
              edge_cluster_id,
              url_categorization_config_id,
              policy_url_categorization_config,
              ):
        """
        Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating
        the PolicyUrlCategorizationConfig will enable or disable URL
        categorization for the given edge cluster. If the context_profiles
        field is empty, the edge cluster will detect all the categories of
        URLs. If context_profiles field has any context profiles, the edge
        cluster will detect only the categories listed within those context
        profiles. The context profiles should have attribute type URL_CATEGORY.
        The update_frequency specifies how frequently in minutes, the edge
        cluster will get updates about the URL data from the URL categorization
        cloud service. If the update_frequency is not specified, the default
        update frequency will be 30 min.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: (required)
        :type  edge_cluster_id: :class:`str`
        :param edge_cluster_id: (required)
        :type  url_categorization_config_id: :class:`str`
        :param url_categorization_config_id: (required)
        :type  policy_url_categorization_config: :class:`com.vmware.nsx_policy.model_client.PolicyUrlCategorizationConfig`
        :param policy_url_categorization_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyUrlCategorizationConfig`
        :return: com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'edge_cluster_id': edge_cluster_id,
                            'url_categorization_config_id': url_categorization_config_id,
                            'policy_url_categorization_config': policy_url_categorization_config,
                            })

    def update(self,
               site_id,
               enforcement_point_id,
               edge_cluster_id,
               url_categorization_config_id,
               policy_url_categorization_config,
               ):
        """
        Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating
        the PolicyUrlCategorizationConfig will enable or disable URL
        categorization for the given edge cluster. If the context_profiles
        field is empty, the edge cluster will detect all the categories of
        URLs. If context_profiles field has any context profiles, the edge
        cluster will detect only the categories listed within those context
        profiles. The context profiles should have attribute type URL_CATEGORY.
        The update_frequency specifies how frequently in minutes, the edge
        cluster will get updates about the URL data from the URL categorization
        cloud service. If the update_frequency is not specified, the default
        update frequency will be 30 min.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: (required)
        :type  edge_cluster_id: :class:`str`
        :param edge_cluster_id: (required)
        :type  url_categorization_config_id: :class:`str`
        :param url_categorization_config_id: (required)
        :type  policy_url_categorization_config: :class:`com.vmware.nsx_policy.model_client.PolicyUrlCategorizationConfig`
        :param policy_url_categorization_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyUrlCategorizationConfig`
        :return: com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'edge_cluster_id': edge_cluster_id,
                            'url_categorization_config_id': url_categorization_config_id,
                            'policy_url_categorization_config': policy_url_categorization_config,
                            })
class _EdgeNodesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'edge_cluster_id': type.StringType(),
            'edge_node_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/global-infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/edge-clusters/{edge-cluster-id}/edge-nodes/{edge-node-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'edge_cluster_id': 'edge-cluster-id',
                'edge_node_id': 'edge-node-id',
            },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'edge_cluster_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/global-infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/edge-clusters/{edge-cluster-id}/edge-nodes',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'edge_cluster_id': 'edge-cluster-id',
            },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyEdgeNode'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyEdgeNodeListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.global_infra.sites.enforcement_points.edge_clusters.edge_nodes',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _UrlCategorizationConfigsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'edge_cluster_id': type.StringType(),
            'url_categorization_config_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/global-infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-clusters/{edge-cluster-id}/url-categorization-configs/{url-categorization-config-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'edge_cluster_id': 'edge-cluster-id',
                'url_categorization_config_id': 'url-categorization-config-id',
            },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'edge_cluster_id': type.StringType(),
            'url_categorization_config_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/global-infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-clusters/{edge-cluster-id}/url-categorization-configs/{url-categorization-config-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'edge_cluster_id': 'edge-cluster-id',
                'url_categorization_config_id': 'url-categorization-config-id',
            },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'edge_cluster_id': type.StringType(),
            'url_categorization_config_id': type.StringType(),
            'policy_url_categorization_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyUrlCategorizationConfig'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/global-infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-clusters/{edge-cluster-id}/url-categorization-configs/{url-categorization-config-id}',
            request_body_parameter='policy_url_categorization_config',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'edge_cluster_id': 'edge-cluster-id',
                'url_categorization_config_id': 'url-categorization-config-id',
            },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'edge_cluster_id': type.StringType(),
            'url_categorization_config_id': type.StringType(),
            'policy_url_categorization_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyUrlCategorizationConfig'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/global-infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-clusters/{edge-cluster-id}/url-categorization-configs/{url-categorization-config-id}',
            request_body_parameter='policy_url_categorization_config',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'edge_cluster_id': 'edge-cluster-id',
                'url_categorization_config_id': 'url-categorization-config-id',
            },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyUrlCategorizationConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyUrlCategorizationConfig'),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyUrlCategorizationConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.global_infra.sites.enforcement_points.edge_clusters.url_categorization_configs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'EdgeNodes': EdgeNodes,
        'UrlCategorizationConfigs': UrlCategorizationConfigs,
    }

