/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.converters.ListDelegateConverter;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ListDelegateType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterType;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class ListDelegate
extends Delegate {
    @Parameter(names={"-list"}, description="Plot a list of available parameters", help=true, converter=ListDelegateConverter.class)
    private ListDelegateType listDelegateType = null;

    public boolean isSet() {
        return this.listDelegateType != null;
    }

    public void plotListing() {
        System.out.println(this.getListing());
    }

    public String getListing() {
        if (this.listDelegateType == null) {
            throw new ConfigurationException("Nothing to plot");
        }
        String list = null;
        switch (this.listDelegateType) {
            case ciphers: {
                list = StringUtils.join(CipherSuite.getImplemented(), (char)'\n');
                break;
            }
            case filters: {
                list = StringUtils.join(EnumSet.allOf(FilterType.class), (char)'\n');
                break;
            }
            case groups: {
                list = StringUtils.join(EnumSet.allOf(NamedGroup.class), (char)'\n');
                break;
            }
            case sign_hash_algos: {
                list = StringUtils.join((Object[])SignatureAndHashAlgorithm.values(), (char)'\n');
                break;
            }
            case workflow_trace_types: {
                list = StringUtils.join(EnumSet.allOf(WorkflowTraceType.class), (char)'\n');
            }
        }
        return list;
    }

    @Override
    public void applyDelegate(Config config) {
    }
}

