# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the iosxr_logging_global module
"""


class Logging_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_logging_global module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "archive": {
                    "type": "dict",
                    "options": {
                        "device": {"type": "str"},
                        "archive_length": {"type": "int"},
                        "archive_size": {"type": "int"},
                        "file_size": {"type": "int"},
                        "frequency": {
                            "type": "str",
                            "choices": ["daily", "weekly"],
                        },
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warnings",
                            ],
                        },
                        "threshold": {"type": "int"},
                    },
                },
                "buffered": {
                    "type": "dict",
                    "options": {
                        "size": {"type": "int"},
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warnings",
                            ],
                        },
                        "discriminator": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "match_params": {
                                    "type": "str",
                                    "choices": [
                                        "match1",
                                        "match2",
                                        "match3",
                                        "nomatch1",
                                        "nomatch2",
                                        "nomatch3",
                                    ],
                                },
                                "name": {"type": "str"},
                            },
                        },
                    },
                },
                "console": {
                    "type": "dict",
                    "options": {
                        "state": {
                            "type": "str",
                            "choices": ["enabled", "disabled"],
                        },
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warning",
                            ],
                        },
                        "discriminator": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "match_params": {
                                    "type": "str",
                                    "choices": [
                                        "match1",
                                        "match2",
                                        "match3",
                                        "nomatch1",
                                        "nomatch2",
                                        "nomatch3",
                                    ],
                                },
                                "name": {"type": "str"},
                            },
                        },
                    },
                },
                "correlator": {
                    "type": "dict",
                    "options": {
                        "buffer_size": {"type": "int"},
                        "rules": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "rule_name": {"type": "str"},
                                "rule_type": {
                                    "type": "str",
                                    "choices": ["stateful", "nonstateful"],
                                },
                                "timeout": {"type": "int"},
                                "timeout_rootcause": {"type": "int"},
                                "context_correlation": {"type": "bool"},
                                "reissue_nonbistate": {"type": "bool"},
                                "reparent": {"type": "bool"},
                            },
                        },
                        "rule_sets": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "rulename": {
                                    "type": "list",
                                    "elements": "str",
                                },
                            },
                        },
                    },
                },
                "events": {
                    "type": "dict",
                    "options": {
                        "buffer_size": {"type": "int"},
                        "display_location": {"type": "bool"},
                        "filter_match": {"type": "list", "elements": "str"},
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warnings",
                            ],
                        },
                        "threshold": {"type": "int"},
                    },
                },
                "facility": {
                    "type": "str",
                    "choices": [
                        "auth",
                        "cron",
                        "daemon",
                        "kern",
                        "local0",
                        "local1",
                        "local2",
                        "local3",
                        "local4",
                        "local5",
                        "local6",
                        "local7",
                        "lpr",
                        "mail",
                        "news",
                        "sys10",
                        "sys11",
                        "sys12",
                        "sys13",
                        "sys14",
                        "sys9",
                        "syslog",
                        "user",
                        "uucp",
                    ],
                },
                "files": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "name": {"type": "str"},
                        "path": {"type": "str"},
                        "maxfilesize": {"type": "int"},
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "info",
                                "notifications",
                                "warning",
                            ],
                        },
                    },
                },
                "format": {"type": "bool"},
                "history": {
                    "type": "dict",
                    "options": {
                        "state": {
                            "type": "str",
                            "choices": ["enabled", "disabled"],
                        },
                        "size": {"type": "int"},
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warnings",
                            ],
                        },
                    },
                },
                "hostnameprefix": {"type": "str"},
                "ipv4": {
                    "type": "dict",
                    "options": {
                        "dscp": {"type": "str"},
                        "precedence": {"type": "str"},
                    },
                },
                "ipv6": {
                    "type": "dict",
                    "options": {
                        "dscp": {"type": "str"},
                        "precedence": {"type": "str"},
                    },
                },
                "localfilesize": {"type": "int"},
                "monitor": {
                    "type": "dict",
                    "options": {
                        "state": {
                            "type": "str",
                            "choices": ["enabled", "disabled"],
                        },
                        "discriminator": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "match_params": {
                                    "type": "str",
                                    "choices": [
                                        "match1",
                                        "match2",
                                        "match3",
                                        "nomatch1",
                                        "nomatch2",
                                        "nomatch3",
                                    ],
                                },
                                "name": {"type": "str"},
                            },
                        },
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warning",
                            ],
                        },
                    },
                },
                "source_interfaces": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "interface": {"type": "str"},
                        "vrf": {"type": "str"},
                    },
                },
                "suppress": {
                    "type": "dict",
                    "options": {
                        "apply_rule": {"type": "str"},
                        "duplicates": {"type": "bool"},
                    },
                },
                "tls_servers": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "name": {"type": "str"},
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warnings",
                            ],
                        },
                        "tls_hostname": {"type": "str"},
                        "trustpoint": {"type": "str"},
                        "vrf": {"type": "str"},
                    },
                },
                "trap": {
                    "type": "dict",
                    "options": {
                        "state": {
                            "type": "str",
                            "choices": ["enabled", "disabled"],
                        },
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "errors",
                                "informational",
                                "notifications",
                                "warning",
                            ],
                        },
                    },
                },
                "hosts": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "severity": {
                            "type": "str",
                            "choices": [
                                "alerts",
                                "critical",
                                "debugging",
                                "emergencies",
                                "error",
                                "info",
                                "notifications",
                                "warning",
                            ],
                        },
                        "host": {"type": "str"},
                        "port": {"type": "str", "default": "default"},
                        "vrf": {"type": "str", "default": "default"},
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
