"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../renderers/canvas");
var rendering_1 = require("../../rendering/rendering");
var points_1 = require("./points");
var path_1 = require("./primitives/path");
var area_1 = require("./styles/area");
var line_1 = require("./styles/line");
function renderAreas(ctx, props) {
    canvas_1.withContext(ctx, function (ctx) {
        var sharedStyle = props.sharedStyle, highlightedLegendItem = props.highlightedLegendItem, areas = props.areas, clippings = props.clippings;
        canvas_1.withClip(ctx, clippings, function (ctx) {
            var e_1, _a;
            ctx.save();
            var _loop_1 = function (glyph) {
                var seriesAreaLineStyle = glyph.seriesAreaLineStyle, seriesAreaStyle = glyph.seriesAreaStyle;
                if (seriesAreaStyle.visible) {
                    canvas_1.withContext(ctx, function () {
                        renderArea(ctx, glyph, sharedStyle, highlightedLegendItem, clippings);
                    });
                }
                if (seriesAreaLineStyle.visible) {
                    canvas_1.withContext(ctx, function () {
                        renderAreaLines(ctx, glyph, sharedStyle, highlightedLegendItem, clippings);
                    });
                }
            };
            try {
                for (var areas_1 = __values(areas), areas_1_1 = areas_1.next(); !areas_1_1.done; areas_1_1 = areas_1.next()) {
                    var glyph = areas_1_1.value;
                    _loop_1(glyph);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (areas_1_1 && !areas_1_1.done && (_a = areas_1.return)) _a.call(areas_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            ctx.rect(clippings.x, clippings.y, clippings.width, clippings.height);
            ctx.clip();
            ctx.restore();
        });
        areas.forEach(function (area) {
            var _a;
            var seriesPointStyle = area.seriesPointStyle, seriesIdentifier = area.seriesIdentifier;
            if (seriesPointStyle.visible) {
                var geometryStateStyle_1 = rendering_1.getGeometryStateStyle(seriesIdentifier, highlightedLegendItem, sharedStyle);
                canvas_1.withClip(ctx, clippings, function (ctx) {
                    points_1.renderPoints(ctx, area.points, seriesPointStyle, geometryStateStyle_1);
                }, ((_a = area.points[0]) === null || _a === void 0 ? void 0 : _a.value.mark) !== null);
            }
        });
    });
}
exports.renderAreas = renderAreas;
function renderArea(ctx, glyph, sharedStyle, highlightedLegendItem, clippings) {
    var area = glyph.area, color = glyph.color, transform = glyph.transform, seriesIdentifier = glyph.seriesIdentifier, seriesAreaStyle = glyph.seriesAreaStyle, clippedRanges = glyph.clippedRanges, hideClippedRanges = glyph.hideClippedRanges;
    var geometryStateStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, highlightedLegendItem, sharedStyle);
    var fill = area_1.buildAreaStyles(color, seriesAreaStyle, geometryStateStyle);
    path_1.renderAreaPath(ctx, transform.x, area, fill, clippedRanges, clippings, hideClippedRanges);
}
function renderAreaLines(ctx, glyph, sharedStyle, highlightedLegendItem, clippings) {
    var lines = glyph.lines, color = glyph.color, seriesIdentifier = glyph.seriesIdentifier, transform = glyph.transform, seriesAreaLineStyle = glyph.seriesAreaLineStyle, clippedRanges = glyph.clippedRanges, hideClippedRanges = glyph.hideClippedRanges;
    var geometryStateStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, highlightedLegendItem, sharedStyle);
    var stroke = line_1.buildLineStyles(color, seriesAreaLineStyle, geometryStateStyle);
    path_1.renderLinePaths(ctx, transform.x, lines, stroke, clippedRanges, clippings, hideClippedRanges);
}
//# sourceMappingURL=areas.js.map