/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3DebugLines")
public class B3DebugLines
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NUMDEBUGLINES;
    public static final int M_LINESFROM;
    public static final int M_LINESTO;
    public static final int M_LINESCOLOR;

    public B3DebugLines(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3DebugLines.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int m_numDebugLines() {
        return B3DebugLines.nm_numDebugLines(this.address());
    }

    @NativeType(value="float const *")
    public FloatBuffer m_linesFrom() {
        return B3DebugLines.nm_linesFrom(this.address());
    }

    @NativeType(value="float const *")
    public FloatBuffer m_linesTo() {
        return B3DebugLines.nm_linesTo(this.address());
    }

    @NativeType(value="float const *")
    public FloatBuffer m_linesColor() {
        return B3DebugLines.nm_linesColor(this.address());
    }

    public B3DebugLines m_numDebugLines(int value) {
        B3DebugLines.nm_numDebugLines(this.address(), value);
        return this;
    }

    public B3DebugLines m_linesFrom(@NativeType(value="float const *") FloatBuffer value) {
        B3DebugLines.nm_linesFrom(this.address(), value);
        return this;
    }

    public B3DebugLines m_linesTo(@NativeType(value="float const *") FloatBuffer value) {
        B3DebugLines.nm_linesTo(this.address(), value);
        return this;
    }

    public B3DebugLines m_linesColor(@NativeType(value="float const *") FloatBuffer value) {
        B3DebugLines.nm_linesColor(this.address(), value);
        return this;
    }

    public B3DebugLines set(int m_numDebugLines, FloatBuffer m_linesFrom, FloatBuffer m_linesTo, FloatBuffer m_linesColor) {
        this.m_numDebugLines(m_numDebugLines);
        this.m_linesFrom(m_linesFrom);
        this.m_linesTo(m_linesTo);
        this.m_linesColor(m_linesColor);
        return this;
    }

    public B3DebugLines set(B3DebugLines src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3DebugLines malloc() {
        return (B3DebugLines)B3DebugLines.wrap(B3DebugLines.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3DebugLines calloc() {
        return (B3DebugLines)B3DebugLines.wrap(B3DebugLines.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3DebugLines create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3DebugLines)B3DebugLines.wrap(B3DebugLines.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3DebugLines create(long address) {
        return (B3DebugLines)B3DebugLines.wrap(B3DebugLines.class, (long)address);
    }

    @Nullable
    public static B3DebugLines createSafe(long address) {
        return address == 0L ? null : (B3DebugLines)B3DebugLines.wrap(B3DebugLines.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3DebugLines.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3DebugLines.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3DebugLines.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3DebugLines.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3DebugLines.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3DebugLines.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3DebugLines.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3DebugLines mallocStack() {
        return B3DebugLines.mallocStack(MemoryStack.stackGet());
    }

    public static B3DebugLines callocStack() {
        return B3DebugLines.callocStack(MemoryStack.stackGet());
    }

    public static B3DebugLines mallocStack(MemoryStack stack) {
        return (B3DebugLines)B3DebugLines.wrap(B3DebugLines.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3DebugLines callocStack(MemoryStack stack) {
        return (B3DebugLines)B3DebugLines.wrap(B3DebugLines.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3DebugLines.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3DebugLines.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3DebugLines.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3DebugLines.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_numDebugLines(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NUMDEBUGLINES);
    }

    public static FloatBuffer nm_linesFrom(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_LINESFROM)), (int)(B3DebugLines.nm_numDebugLines(struct) / 3));
    }

    public static FloatBuffer nm_linesTo(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_LINESTO)), (int)(B3DebugLines.nm_numDebugLines(struct) / 3));
    }

    public static FloatBuffer nm_linesColor(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_LINESCOLOR)), (int)(B3DebugLines.nm_numDebugLines(struct) / 3));
    }

    public static void nm_numDebugLines(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NUMDEBUGLINES, value);
    }

    public static void nm_linesFrom(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_LINESFROM), (long)MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nm_linesTo(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_LINESTO), (long)MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nm_linesColor(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_LINESCOLOR), (long)MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_LINESFROM)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_LINESTO)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_LINESCOLOR)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            B3DebugLines.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = B3DebugLines.__struct((Struct.Member[])new Struct.Member[]{B3DebugLines.__member((int)4), B3DebugLines.__member((int)POINTER_SIZE), B3DebugLines.__member((int)POINTER_SIZE), B3DebugLines.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NUMDEBUGLINES = layout.offsetof(0);
        M_LINESFROM = layout.offsetof(1);
        M_LINESTO = layout.offsetof(2);
        M_LINESCOLOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<B3DebugLines, Buffer>
    implements NativeResource {
        private static final B3DebugLines ELEMENT_FACTORY = B3DebugLines.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3DebugLines getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int m_numDebugLines() {
            return B3DebugLines.nm_numDebugLines(this.address());
        }

        @NativeType(value="float const *")
        public FloatBuffer m_linesFrom() {
            return B3DebugLines.nm_linesFrom(this.address());
        }

        @NativeType(value="float const *")
        public FloatBuffer m_linesTo() {
            return B3DebugLines.nm_linesTo(this.address());
        }

        @NativeType(value="float const *")
        public FloatBuffer m_linesColor() {
            return B3DebugLines.nm_linesColor(this.address());
        }

        public Buffer m_numDebugLines(int value) {
            B3DebugLines.nm_numDebugLines(this.address(), value);
            return this;
        }

        public Buffer m_linesFrom(@NativeType(value="float const *") FloatBuffer value) {
            B3DebugLines.nm_linesFrom(this.address(), value);
            return this;
        }

        public Buffer m_linesTo(@NativeType(value="float const *") FloatBuffer value) {
            B3DebugLines.nm_linesTo(this.address(), value);
            return this;
        }

        public Buffer m_linesColor(@NativeType(value="float const *") FloatBuffer value) {
            B3DebugLines.nm_linesColor(this.address(), value);
            return this;
        }
    }
}

