/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.shaderc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct shaderc_include_result")
public class ShadercIncludeResult
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SOURCE_NAME;
    public static final int SOURCE_NAME_LENGTH;
    public static final int CONTENT;
    public static final int CONTENT_LENGTH;
    public static final int USER_DATA;

    public ShadercIncludeResult(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ShadercIncludeResult.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer source_name() {
        return ShadercIncludeResult.nsource_name(this.address());
    }

    @NativeType(value="char const *")
    public String source_nameString() {
        return ShadercIncludeResult.nsource_nameString(this.address());
    }

    @NativeType(value="size_t")
    public long source_name_length() {
        return ShadercIncludeResult.nsource_name_length(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer content() {
        return ShadercIncludeResult.ncontent(this.address());
    }

    @NativeType(value="char const *")
    public String contentString() {
        return ShadercIncludeResult.ncontentString(this.address());
    }

    @NativeType(value="size_t")
    public long content_length() {
        return ShadercIncludeResult.ncontent_length(this.address());
    }

    @NativeType(value="void *")
    public long user_data() {
        return ShadercIncludeResult.nuser_data(this.address());
    }

    public ShadercIncludeResult source_name(@NativeType(value="char const *") ByteBuffer value) {
        ShadercIncludeResult.nsource_name(this.address(), value);
        return this;
    }

    public ShadercIncludeResult content(@NativeType(value="char const *") ByteBuffer value) {
        ShadercIncludeResult.ncontent(this.address(), value);
        return this;
    }

    public ShadercIncludeResult user_data(@NativeType(value="void *") long value) {
        ShadercIncludeResult.nuser_data(this.address(), value);
        return this;
    }

    public ShadercIncludeResult set(ByteBuffer source_name, ByteBuffer content, long user_data) {
        this.source_name(source_name);
        this.content(content);
        this.user_data(user_data);
        return this;
    }

    public ShadercIncludeResult set(ShadercIncludeResult src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ShadercIncludeResult malloc() {
        return (ShadercIncludeResult)ShadercIncludeResult.wrap(ShadercIncludeResult.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ShadercIncludeResult calloc() {
        return (ShadercIncludeResult)ShadercIncludeResult.wrap(ShadercIncludeResult.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ShadercIncludeResult create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ShadercIncludeResult)ShadercIncludeResult.wrap(ShadercIncludeResult.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ShadercIncludeResult create(long address) {
        return (ShadercIncludeResult)ShadercIncludeResult.wrap(ShadercIncludeResult.class, (long)address);
    }

    @Nullable
    public static ShadercIncludeResult createSafe(long address) {
        return address == 0L ? null : (ShadercIncludeResult)ShadercIncludeResult.wrap(ShadercIncludeResult.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ShadercIncludeResult.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ShadercIncludeResult.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ShadercIncludeResult.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ShadercIncludeResult.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ShadercIncludeResult.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ShadercIncludeResult.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ShadercIncludeResult.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ShadercIncludeResult mallocStack() {
        return ShadercIncludeResult.mallocStack(MemoryStack.stackGet());
    }

    public static ShadercIncludeResult callocStack() {
        return ShadercIncludeResult.callocStack(MemoryStack.stackGet());
    }

    public static ShadercIncludeResult mallocStack(MemoryStack stack) {
        return (ShadercIncludeResult)ShadercIncludeResult.wrap(ShadercIncludeResult.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ShadercIncludeResult callocStack(MemoryStack stack) {
        return (ShadercIncludeResult)ShadercIncludeResult.wrap(ShadercIncludeResult.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ShadercIncludeResult.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ShadercIncludeResult.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ShadercIncludeResult.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ShadercIncludeResult.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nsource_name(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)SOURCE_NAME)));
    }

    public static String nsource_nameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)SOURCE_NAME)));
    }

    public static long nsource_name_length(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SOURCE_NAME_LENGTH));
    }

    public static ByteBuffer ncontent(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTENT)));
    }

    public static String ncontentString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTENT)));
    }

    public static long ncontent_length(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTENT_LENGTH));
    }

    public static long nuser_data(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USER_DATA));
    }

    public static void nsource_name(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SOURCE_NAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
        ShadercIncludeResult.nsource_name_length(struct, value.remaining());
    }

    public static void nsource_name_length(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SOURCE_NAME_LENGTH), (long)value);
    }

    public static void ncontent(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTENT), (long)MemoryUtil.memAddress((ByteBuffer)value));
        ShadercIncludeResult.ncontent_length(struct, value.remaining());
    }

    public static void ncontent_length(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTENT_LENGTH), (long)value);
    }

    public static void nuser_data(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USER_DATA), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SOURCE_NAME)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTENT)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)USER_DATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            ShadercIncludeResult.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = ShadercIncludeResult.__struct((Struct.Member[])new Struct.Member[]{ShadercIncludeResult.__member((int)POINTER_SIZE), ShadercIncludeResult.__member((int)POINTER_SIZE), ShadercIncludeResult.__member((int)POINTER_SIZE), ShadercIncludeResult.__member((int)POINTER_SIZE), ShadercIncludeResult.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SOURCE_NAME = layout.offsetof(0);
        SOURCE_NAME_LENGTH = layout.offsetof(1);
        CONTENT = layout.offsetof(2);
        CONTENT_LENGTH = layout.offsetof(3);
        USER_DATA = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<ShadercIncludeResult, Buffer>
    implements NativeResource {
        private static final ShadercIncludeResult ELEMENT_FACTORY = ShadercIncludeResult.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ShadercIncludeResult getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer source_name() {
            return ShadercIncludeResult.nsource_name(this.address());
        }

        @NativeType(value="char const *")
        public String source_nameString() {
            return ShadercIncludeResult.nsource_nameString(this.address());
        }

        @NativeType(value="size_t")
        public long source_name_length() {
            return ShadercIncludeResult.nsource_name_length(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer content() {
            return ShadercIncludeResult.ncontent(this.address());
        }

        @NativeType(value="char const *")
        public String contentString() {
            return ShadercIncludeResult.ncontentString(this.address());
        }

        @NativeType(value="size_t")
        public long content_length() {
            return ShadercIncludeResult.ncontent_length(this.address());
        }

        @NativeType(value="void *")
        public long user_data() {
            return ShadercIncludeResult.nuser_data(this.address());
        }

        public Buffer source_name(@NativeType(value="char const *") ByteBuffer value) {
            ShadercIncludeResult.nsource_name(this.address(), value);
            return this;
        }

        public Buffer content(@NativeType(value="char const *") ByteBuffer value) {
            ShadercIncludeResult.ncontent(this.address(), value);
            return this;
        }

        public Buffer user_data(@NativeType(value="void *") long value) {
            ShadercIncludeResult.nuser_data(this.address(), value);
            return this;
        }
    }
}

