/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class NegateExpression
extends UnaryExpression {
    private boolean backwardsCompatible;

    public NegateExpression(Expression base) {
        super(base);
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.backwardsCompatible = compatible;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression oldop = this.operand;
        RoleLocator role = new RoleLocator(9, (Serializable)((Object)"-"), 0);
        this.operand = TypeChecker.staticTypeCheck(this.operand, SequenceType.OPTIONAL_NUMERIC, this.backwardsCompatible, role, visitor);
        if (this.operand != oldop) {
            this.adoptChildExpression(this.operand);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        NumericValue v1 = (NumericValue)this.operand.evaluateItem(context);
        if (v1 == null) {
            return this.backwardsCompatible ? DoubleValue.NaN : null;
        }
        return v1.negate();
    }

    public Expression copy() {
        return new NegateExpression(this.getBaseExpression().copy());
    }

    protected String displayOperator(Configuration config) {
        return "-";
    }
}

