#         'trust200902',
#         'noModificationTrust200902',
#         'noDerivativesTrust200902',
#         'pre5378Trust200902',
#         'trust200811',
#         'noModificationTrust200811',
#         'noDerivativesTrust200811',





boilerplate_tlp = {
    "2.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-2.htm
        "draft": [
            """
            This Internet-Draft is submitted in full conformance
            with the provisions of BCP 78 and BCP 79.
            """
        ],
        "n/a": [
            """
            Copyright (c) {year} IETF Trust and the persons identified as
            the document authors.  All rights reserved. 
            """,
            """
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents in effect on the date of
            publication of this document (http://trustee.ietf.org/license-info).
            Please review these documents carefully, as they describe your rights
            and restrictions with respect to this document.
            """,
        ],
        "noModification": [
            """
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            """,
        ],
        "noDerivatives": [
            """
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            """,
        ],
        "pre5378": [
            """
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            """
        ],
    },
    "3.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-3.htm
        "draft": [
            """
            This Internet-Draft is submitted to IETF in full conformance with
            the provisions of BCP 78 and BCP 79.
            """
        ],
        "n/a": [
            """
            Copyright (c) {year} IETF Trust and the persons identified as
            the document authors.  All rights reserved. 
            """,
            """
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (http://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents carefully,
            as they describe your rights and restrictions with respect to this
            document.  Code Components extracted from this document must include
            Simplified BSD License text as described in Section 4.e of the Trust
            Legal Provisions and are provided without warranty as described in the
            BSD License.
            """,
        ],
        "noModification": [
            """
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            """,
        ],
        "noDerivatives": [
            """
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            """,
        ],
        "pre5378": [
            """
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            """
        ],
    },
    "4.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-4.htm
        "draft": [
            """
            This Internet-Draft is submitted in full conformance with the
            provisions of BCP 78 and BCP 79.
            """
        ],
        "IETF": [
            """
            Copyright (c) {year} IETF Trust and the persons identified as the document
            authors. All rights reserved.
            """,
            """
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (http://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents carefully,
            as they describe your rights and restrictions with respect to this
            document. Code Components extracted from this document must include
            Simplified BSD License text as described in Section 4.e of the Trust
            Legal Provisions and are provided without warranty as described in the
            Simplified BSD License.
            """,
        ],
        "alt": [
            """
            Copyright (c) {year} IETF Trust and the persons identified as the
            document authors. All rights reserved.
            """,
            """
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (http://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents
            carefully, as they describe your rights and restrictions with
            respect to this document.
            """,
        ],
        "noModification": [
            """
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            """,
        ],
        "noDerivatives": [
            """
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            """,
        ],
        "pre5378": [
            """
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            """
        ],
    },
    "5.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-5.htm
        "draft": [
            """
            This Internet-Draft is submitted in full conformance with the
            provisions of BCP 78 and BCP 79.
            """
        ],
        "IETF": [
            """
            Copyright (c) {year} IETF Trust and the persons identified as the
            document authors. All rights reserved.
            """,
            """
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            ({scheme}://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents
            carefully, as they describe your rights and restrictions with
            respect to this document. Code Components extracted from this
            document must include Simplified BSD License text as described in
            Section 4.e of the Trust Legal Provisions and are provided without
            warranty as described in the Simplified BSD License.
            """,
        ],
        "alt": [
            """
            Copyright (c) {year} IETF Trust and the persons identified as the
            document authors. All rights reserved.
            """,
            """
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            ({scheme}://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents
            carefully, as they describe your rights and restrictions with
            respect to this document.
            """,
        ],
        "noModification": [
            """
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            """,
        ],
        "noDerivatives": [
            """
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            """,
        ],
        "pre5378": [
            """
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            """
        ],
    },
}
