/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.net.Socket;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TwoWayStream;

public final class SocketStream
extends TwoWayStream {
    private final Socket socket;

    public SocketStream(Socket socket, Stream in, Stream out) {
        super(in, out);
        this.socket = socket;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.SOCKET_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SOCKET_STREAM;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SOCKET_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SOCKET_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject close(LispObject abort) {
        try {
            this.socket.close();
            this.setOpen(false);
            return Lisp.T;
        }
        catch (Exception e) {
            return Lisp.error(new LispError(e.getMessage()));
        }
    }
}

