/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.xml;

import ca.sqlpower.xml.UnescapingAttributes;
import ca.sqlpower.xml.XMLHelper;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class UnescapingDefaultHandler
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(UnescapingDefaultHandler.class);
    private final EntityResolver entityResolver;
    private final DTDHandler dtdHandler;
    private final ContentHandler contentHandler;
    private final ErrorHandler errorHandler;

    public UnescapingDefaultHandler(DefaultHandler defaultHandler) {
        this(defaultHandler, defaultHandler, defaultHandler, defaultHandler);
    }

    public UnescapingDefaultHandler(DTDHandler dtdHandler) {
        this(null, dtdHandler, null, null);
    }

    public UnescapingDefaultHandler(ContentHandler contentHandler) {
        this(null, null, contentHandler, null);
    }

    public UnescapingDefaultHandler(ErrorHandler errorHandler) {
        this(null, null, null, errorHandler);
    }

    public UnescapingDefaultHandler(EntityResolver entityResolver) {
        this(entityResolver, null, null, null);
    }

    public UnescapingDefaultHandler(EntityResolver entityResolver, DTDHandler dtdHandler, ContentHandler contentHandler, ErrorHandler errorHandler) {
        this.entityResolver = entityResolver;
        this.dtdHandler = dtdHandler;
        this.contentHandler = contentHandler;
        this.errorHandler = errorHandler;
    }

    @Override
    public void characters(char[] escapedCh, int start, int length) throws SAXException {
        logger.debug((Object)"Unescaping character data");
        String original = new String(escapedCh, start, length);
        String unescaped = XMLHelper.unescape(original);
        this.contentHandler.characters(unescaped.toCharArray(), 0, unescaped.length());
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        logger.debug((Object)"Wrapping Attribute data");
        this.contentHandler.startElement(uri, localName, qName, new UnescapingAttributes(atts));
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void notationDecl(String arg0, String arg1, String arg2) throws SAXException {
        this.dtdHandler.notationDecl(arg0, arg1, arg2);
    }

    @Override
    public void unparsedEntityDecl(String arg0, String arg1, String arg2, String arg3) throws SAXException {
        this.dtdHandler.unparsedEntityDecl(arg0, arg1, arg2, arg3);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.entityResolver.resolveEntity(publicId, systemId);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errorHandler.error(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.errorHandler.fatalError(exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.errorHandler.warning(exception);
    }
}

