/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.Algorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.algorithms.implementations.IntegrityHmac;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Log log = LogFactory.getLog((String)SignatureAlgorithm.class.getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    protected SignatureAlgorithmSpi _signatureAlgorithm;
    private final String algorithmURI;

    public SignatureAlgorithm(Document document, String string) throws XMLSecurityException {
        super(document, string);
        this.algorithmURI = string;
    }

    public SignatureAlgorithm(Document document, String string, int n) throws XMLSecurityException {
        super(document, string);
        this.algorithmURI = string;
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineSetHMACOutputLength(n);
        ((IntegrityHmac)this._signatureAlgorithm).engineAddContextToElement(this._constructionElement);
    }

    private static SignatureAlgorithmSpi getSignatureAlgorithmSpi(String string) throws XMLSignatureException {
        try {
            Class clazz = (Class)_algorithmHash.get(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create URI \"" + string + "\" class \"" + clazz + "\""));
            }
            return (SignatureAlgorithmSpi)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    private void initializeAlgorithm() throws XMLSignatureException {
        this._signatureAlgorithm = SignatureAlgorithm.getSignatureAlgorithmSpi(this.algorithmURI);
        this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String string) throws XMLSecurityException {
        super(element, string);
        this.algorithmURI = this.getURI();
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        try {
            SignatureAlgorithmSpi signatureAlgorithmSpi = SignatureAlgorithm.getSignatureAlgorithmSpi(this.algorithmURI);
            return signatureAlgorithmSpi.engineGetJCEAlgorithmString();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return null;
        }
    }

    public String getJCEProviderName() {
        try {
            SignatureAlgorithmSpi signatureAlgorithmSpi = SignatureAlgorithm.getSignatureAlgorithmSpi(this.algorithmURI);
            return signatureAlgorithmSpi.engineGetJCEProviderName();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return null;
        }
    }

    public void update(byte[] byArray) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray);
    }

    public void update(byte by) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray, n, n2);
    }

    public void initSign(Key key) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitSign(key);
    }

    public void initSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitSign(key, secureRandom);
    }

    public void initSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitSign(key, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(algorithmParameterSpec);
    }

    public void initVerify(Key key) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitVerify(key);
    }

    public void clearVerificationCache() {
    }

    public void clearSignatureCache() {
    }

    public boolean verify(byte[] byArray) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(byArray);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (log == null) {
            log = LogFactory.getLog((String)SignatureAlgorithm.class.getName());
        }
        log.debug((Object)"Init() called");
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException, XMLSignatureException {
        String string3;
        Class clazz;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to register " + string + " " + string2));
        }
        if ((clazz = SignatureAlgorithm.getImplementingClass(string)) != null && (string3 = clazz.getName()) != null && string3.length() != 0) {
            Object[] objectArray = new Object[]{string, string3};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            _algorithmHash.put(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    private static Class getImplementingClass(String string) {
        if (_algorithmHash == null) {
            return null;
        }
        return (Class)_algorithmHash.get(string);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }
}

