/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;

public class FailedShard {
    private final ShardRouting routingEntry;
    private final String message;
    private final Exception failure;
    private final boolean markAsStale;

    public FailedShard(ShardRouting routingEntry, String message, @Nullable Exception failure, boolean markAsStale) {
        assert (routingEntry.assignedToNode()) : "only assigned shards can be failed " + routingEntry;
        this.routingEntry = routingEntry;
        this.message = message;
        this.failure = failure;
        this.markAsStale = markAsStale;
    }

    public String toString() {
        return "failed shard, shard " + this.routingEntry + ", message [" + this.message + "], failure [" + this.failure == null ? "null" : ExceptionsHelper.detailedMessage(this.failure) + "], markAsStale [" + this.markAsStale + "]";
    }

    public ShardRouting getRoutingEntry() {
        return this.routingEntry;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Exception getFailure() {
        return this.failure;
    }

    public boolean markAsStale() {
        return this.markAsStale;
    }
}

