/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.generic.util.datastruct.DynamicValueSortedTreeMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.Spliterators;

public class DynamicSortedTreeSet<E>
extends AbstractSet<E>
implements List<E>,
Deque<E> {
    private final transient DynamicValueSortedTreeMap.ValueSortedTreeMapKeySet keys;
    private final transient DynamicValueSortedTreeMap<E, E> map;

    public DynamicSortedTreeSet() {
        this.map = new DynamicValueSortedTreeMap();
        this.keys = this.map.keySet();
    }

    public DynamicSortedTreeSet(Comparator<E> comparator) {
        this.map = new DynamicValueSortedTreeMap(comparator);
        this.keys = this.map.keySet();
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, e) == null;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAll(c);
    }

    @Override
    public void addFirst(E e) {
        this.add(e);
    }

    @Override
    public void addLast(E e) {
        this.add(e);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.keys.descendingIterator();
    }

    @Override
    public E element() {
        return (E)this.keys.element();
    }

    @Override
    public E get(int index) {
        return (E)this.keys.get(index);
    }

    @Override
    public E getFirst() {
        return (E)this.keys.getFirst();
    }

    @Override
    public E getLast() {
        return (E)this.keys.getLast();
    }

    @Override
    public int indexOf(Object o) {
        return this.keys.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.keys.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.keys.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.keys.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.keys.listIterator(index);
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.add(e);
    }

    @Override
    public E peek() {
        return (E)this.keys.peek();
    }

    @Override
    public E peekFirst() {
        return (E)this.keys.peekFirst();
    }

    @Override
    public E peekLast() {
        return (E)this.keys.peekLast();
    }

    @Override
    public E poll() {
        return (E)this.keys.poll();
    }

    @Override
    public E pollFirst() {
        return (E)this.keys.pollFirst();
    }

    @Override
    public E pollLast() {
        return (E)this.keys.pollLast();
    }

    @Override
    public E pop() {
        return (E)this.keys.pop();
    }

    @Override
    public void push(E e) {
        this.add(e);
    }

    @Override
    public E remove() {
        return (E)this.keys.remove();
    }

    @Override
    public E remove(int index) {
        return (E)this.keys.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.keys.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.keys.removeAll(c);
    }

    @Override
    public E removeFirst() {
        return (E)this.keys.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.keys.removeFirstOccurrence(o);
    }

    @Override
    public E removeLast() {
        return (E)this.keys.removeLast();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.keys.removeLastOccurrence(o);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.keys.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        E result = this.remove(index);
        this.add(element);
        return result;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean update(E e) {
        return this.map.update(e);
    }
}

