/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class RightSidedSquishyBuddyLayout
implements LayoutManager,
Serializable {
    private int hGap;
    private boolean rightAlign;

    public RightSidedSquishyBuddyLayout(int hGap) {
        this(hGap, false);
    }

    public RightSidedSquishyBuddyLayout(int hGap, boolean rightAlign) {
        this.rightAlign = rightAlign;
        this.hGap = hGap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component[] components = container.getComponents();
        if (components.length == 0) {
            return new Dimension(0, 0);
        }
        int width = this.hGap;
        int height = 0;
        for (int i = 0; i < 2 && i < components.length; ++i) {
            Component component = components[i];
            Dimension dim = component.getPreferredSize();
            width += dim.width;
            height = Math.max(height, dim.height);
        }
        Insets insets = container.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container cont) {
        return this.preferredLayoutSize(cont);
    }

    @Override
    public void layoutContainer(Container container) {
        Component[] components = container.getComponents();
        if (components.length == 0) {
            return;
        }
        Insets insets = container.getInsets();
        if (components.length == 1) {
            Dimension size = components[0].getPreferredSize();
            components[0].setBounds(insets.left, insets.top, size.width, size.height);
            return;
        }
        Dimension containerSize = container.getSize();
        int width = containerSize.width - insets.left - insets.right;
        int height = containerSize.height - insets.top - insets.bottom;
        Dimension comp1PrefSize = components[0].getPreferredSize();
        Dimension comp2PrefSize = components[1].getPreferredSize();
        int comp1Width = comp1PrefSize.width;
        int remainingWidth = Math.max(0, width - comp1Width - this.hGap);
        int comp2Width = Math.min(comp2PrefSize.width, remainingWidth);
        remainingWidth = Math.max(0, remainingWidth - comp2Width);
        int y = insets.top;
        int comp1X = insets.left;
        int comp2X = comp1X + comp1Width + this.hGap;
        if (this.rightAlign) {
            comp1X += remainingWidth;
            comp2X += remainingWidth;
        }
        components[0].setBounds(comp1X, y, comp1Width, height);
        components[1].setBounds(comp2X, y, comp2Width, height);
    }
}

