/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.actions.SyncAction;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import java.util.List;

public class UpdateAction
extends SyncAction {
    public static final String MENU_NAME = "Update Datatypes From";

    public UpdateAction(DataTypeManagerPlugin plugin, DataTypeManagerHandler dataTypeManagerHandler, DataTypeManager dtm, ArchiveNode archiveNode, SourceArchive sourceArchive, boolean isEnabled) {
        super("Update Datatypes From Archive", plugin, dataTypeManagerHandler, dtm, archiveNode, sourceArchive, isEnabled);
        this.setPopupMenuData(new MenuData(new String[]{MENU_NAME, sourceArchive.getName()}));
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getHelpTopic()));
    }

    @Override
    protected int getMenuOrder() {
        return 1;
    }

    @Override
    protected String getHelpTopic() {
        return "Update_Data_Types";
    }

    @Override
    protected boolean isAppropriateForAction(DataTypeSyncInfo info) {
        switch (info.getSyncState()) {
            case UPDATE: 
            case CONFLICT: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isPreselectedForAction(DataTypeSyncInfo info) {
        return info.getSyncState() == DataTypeSyncState.UPDATE;
    }

    @Override
    protected String getOperationName() {
        return "Update";
    }

    @Override
    protected void applyOperation(DataTypeSyncInfo info) {
        info.update();
    }

    @Override
    protected String getConfirmationMessage(List<DataTypeSyncInfo> infos) {
        StringBuffer buf = new StringBuffer();
        if (this.containsConflicts(infos)) {
            buf.append("You are updating one or more conflicts which will OVERWRITE\n");
            buf.append("changes in this program or archive!\n\n");
        }
        buf.append("Are you sure you want to UPDATE " + infos.size() + " datatype(s)?");
        return buf.toString();
    }

    @Override
    protected boolean requiresArchiveOpenForEditing() {
        return false;
    }

    @Override
    protected String getTitle(String sourceName, String clientName) {
        return "Update Datatype Changes From Archive \"" + sourceName + "\" To  \"" + clientName + "\"";
    }
}

