/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.reference;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.nav.NavigationUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;

public class SelectForwardRefsAction
extends ListingContextAction {
    private final PluginTool tool;

    SelectForwardRefsAction(PluginTool tool, String owner) {
        super("Forward Refs", owner);
        this.tool = tool;
        String group = "references";
        this.setMenuBarData(new MenuData(new String[]{"Select", "Forward Refs"}, null, group));
        this.setKeyBindingData(new KeyBindingData(46, 2));
        this.setHelpLocation(new HelpLocation("Selection", "Forward"));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        return context.getAddress() != null || context.hasSelection();
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        ProgramSelection addressSet = context.hasSelection() ? context.getSelection() : new AddressSet(context.getAddress());
        ProgramSelection selection = this.getSelection(context.getProgram(), addressSet);
        NavigationUtils.setSelection(this.tool, context.getNavigatable(), selection);
    }

    private ProgramSelection getSelection(Program program, AddressSetView addressSetView) {
        AddressSet addressSet = new AddressSet();
        CodeUnitIterator iter = program.getListing().getCodeUnits(addressSetView, true);
        while (iter.hasNext()) {
            CodeUnit cu = iter.next();
            Reference[] memRef = cu.getReferencesFrom();
            for (int i = 0; i < memRef.length; ++i) {
                Address addr = memRef[i].getToAddress();
                if (!addr.isMemoryAddress()) continue;
                addressSet.addRange(addr, addr);
            }
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }
}

