/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexResolutionScope;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableTypeRef
extends CliAbstractTable {
    public CliTableTypeRef(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliTypeRefRow row = new CliTypeRefRow(CliIndexResolutionScope.readCodedIndex(reader, stream), this.readStringIndex(reader), this.readStringIndex(reader));
            this.rows.add(row);
            this.strings.add(row.typeNameIndex);
            this.strings.add(row.typeNamespaceIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "TypeRef Row", 0);
        rowDt.add(CliIndexResolutionScope.toDataType(this.metadataStream), "ResolutionScope", null);
        rowDt.add(this.metadataStream.getStringIndexDataType(), "TypeName", null);
        rowDt.add(this.metadataStream.getStringIndexDataType(), "TypeNamespace", null);
        return rowDt;
    }

    public class CliTypeRefRow
    extends CliAbstractTableRow {
        public int resolutionScopeIndex;
        public int typeNameIndex;
        public int typeNamespaceIndex;

        public CliTypeRefRow(int resolutionScopeIndex, int typeNameIndex, int typeNamespaceIndex) {
            this.resolutionScopeIndex = resolutionScopeIndex;
            this.typeNameIndex = typeNameIndex;
            this.typeNamespaceIndex = typeNamespaceIndex;
        }

        @Override
        public String getRepresentation() {
            String scopeRep;
            try {
                scopeRep = CliTableTypeRef.this.getRowShortRepSafe(CliIndexResolutionScope.getTableName(this.resolutionScopeIndex), CliIndexResolutionScope.getRowIndex(this.resolutionScopeIndex));
            }
            catch (InvalidInputException e) {
                scopeRep = Integer.toHexString(this.resolutionScopeIndex);
            }
            return String.format("%s.%s (ResolutionScope %s)", CliTableTypeRef.this.metadataStream.getStringsStream().getString(this.typeNameIndex), CliTableTypeRef.this.metadataStream.getStringsStream().getString(this.typeNamespaceIndex), scopeRep);
        }

        @Override
        public String getShortRepresentation() {
            return String.format("%s.%s", CliTableTypeRef.this.metadataStream.getStringsStream().getString(this.typeNamespaceIndex), CliTableTypeRef.this.metadataStream.getStringsStream().getString(this.typeNameIndex));
        }
    }
}

