/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationFactory;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LoaderRelocationHeader
implements StructConverter {
    private short sectionIndex;
    private short reservedA;
    private int relocCount;
    private int firstRelocOffset;
    private List<Relocation> _relocations = new ArrayList<Relocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoaderRelocationHeader(BinaryReader reader, LoaderInfoHeader loader) throws IOException {
        this.sectionIndex = reader.readNextShort();
        this.reservedA = reader.readNextShort();
        this.relocCount = reader.readNextInt();
        this.firstRelocOffset = reader.readNextInt();
        long oldIndex = reader.getPointerIndex();
        int indexToRelocations = loader.getSection().getContainerOffset() + loader.getRelocInstrOffset();
        reader.setPointerIndex(indexToRelocations);
        long endIndex = indexToRelocations + this.relocCount * 2;
        try {
            while (reader.getPointerIndex() < endIndex) {
                Relocation reloc = RelocationFactory.getRelocation(reader);
                this._relocations.add(reloc);
            }
        }
        finally {
            reader.setPointerIndex(oldIndex);
        }
    }

    public short getSectionIndex() {
        return this.sectionIndex;
    }

    public short getReservedA() {
        return this.reservedA;
    }

    public int getRelocCount() {
        return this.relocCount;
    }

    public int getFirstRelocOffset() {
        return this.firstRelocOffset;
    }

    public List<Relocation> getRelocations() {
        return this._relocations;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this.getClass());
    }
}

