/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledObjectFactory;
import ghidra.app.util.demangler.ParameterReceiver;
import ghidra.program.model.data.DataType;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledTemplate;
import util.demangler.GenericDemangledType;

public class DemangledTemplate
implements ParameterReceiver {
    private List<DemangledDataType> parameters = new ArrayList<DemangledDataType>();

    public DemangledTemplate() {
    }

    DemangledTemplate(GenericDemangledTemplate template) {
        List genericParameters = template.getParameters();
        for (GenericDemangledDataType parameter : genericParameters) {
            this.parameters.add((DemangledDataType)DemangledObjectFactory.convert((GenericDemangledType)parameter));
        }
    }

    @Override
    public void addParameter(DemangledDataType parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public List<DemangledDataType> getParameters() {
        return new ArrayList<DemangledDataType>(this.parameters);
    }

    public String toTemplate() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        for (int i = 0; i < this.parameters.size(); ++i) {
            try {
                buffer.append(this.parameters.get(i).toSignature());
            }
            catch (Error e) {
                Msg.error((Object)this, (Object)("Unexpected Error: " + e.getMessage()), (Throwable)e);
            }
            if (i >= this.parameters.size() - 1) continue;
            buffer.append(',');
        }
        buffer.append('>');
        return buffer.toString();
    }

    public String toString() {
        return this.toTemplate();
    }

    public DataType getDataType(int defaultPointerSize) {
        throw new UnsupportedOperationException("We cannot store templated types in the datatype manager!");
    }
}

