/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import ghidra.framework.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LibrarySearchPathManager {
    public static final String CURRENT_DIRECTORY = ".";
    private static List<String> pathList = LibrarySearchPathManager.createPathList();
    private static boolean hasBeenRestored;

    private static List<String> createPathList() {
        pathList = new ArrayList<String>();
        LibrarySearchPathManager.loadJavaLibraryPath();
        return pathList;
    }

    private static void loadJavaLibraryPath() {
        LibrarySearchPathManager.addPath(CURRENT_DIRECTORY);
        List paths = Platform.CURRENT_PLATFORM.getAdditionalLibraryPaths();
        for (String path : paths) {
            LibrarySearchPathManager.addPath(path);
        }
        String libpath = System.getProperty("java.library.path");
        String libpathSep = System.getProperty("path.separator");
        StringTokenizer nizer = new StringTokenizer(libpath, libpathSep);
        while (nizer.hasMoreTokens()) {
            String path = nizer.nextToken();
            LibrarySearchPathManager.addPath(path);
        }
    }

    public static String[] getLibraryPaths() {
        String[] paths = new String[pathList.size()];
        pathList.toArray(paths);
        return paths;
    }

    public static List<String> getLibraryPathsList() {
        return new ArrayList<String>(pathList);
    }

    public static void setLibraryPaths(String[] paths) {
        pathList.clear();
        LibrarySearchPathManager.addPath(CURRENT_DIRECTORY);
        for (String path : paths) {
            LibrarySearchPathManager.addPath(path);
        }
    }

    public static void restoreLibraryPaths(String[] paths) {
        if (hasBeenRestored) {
            return;
        }
        LibrarySearchPathManager.setLibraryPaths(paths);
    }

    public static boolean addPath(String path) {
        if (pathList.indexOf(path) == -1) {
            pathList.add(path);
            return true;
        }
        return false;
    }

    public static boolean addPathAt(int index, String path) {
        if (pathList.indexOf(path) == -1) {
            pathList.add(index, path);
            return true;
        }
        return false;
    }

    public static boolean removePath(String path) {
        if (path.equals(CURRENT_DIRECTORY)) {
            return false;
        }
        return pathList.remove(path);
    }

    public static void reset() {
        pathList.clear();
        LibrarySearchPathManager.loadJavaLibraryPath();
    }

    public static void clear() {
        pathList.clear();
    }
}

