/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.xml.BookmarksXmlMgr;
import ghidra.app.util.xml.CodeXmlMgr;
import ghidra.app.util.xml.CommentsXmlMgr;
import ghidra.app.util.xml.DataTypesXmlMgr;
import ghidra.app.util.xml.DefinedDataXmlMgr;
import ghidra.app.util.xml.EquatesXmlMgr;
import ghidra.app.util.xml.ExtEntryPointXmlMgr;
import ghidra.app.util.xml.ExternalLibXmlMgr;
import ghidra.app.util.xml.FunctionsXmlMgr;
import ghidra.app.util.xml.MarkupXmlMgr;
import ghidra.app.util.xml.MemoryMapXmlMgr;
import ghidra.app.util.xml.MyErrorHandler;
import ghidra.app.util.xml.ProgramInfo;
import ghidra.app.util.xml.ProgramTreeXmlMgr;
import ghidra.app.util.xml.PropertiesXmlMgr;
import ghidra.app.util.xml.RegisterValuesXmlMgr;
import ghidra.app.util.xml.RelocationTableXmlMgr;
import ghidra.app.util.xml.SymbolTableXmlMgr;
import ghidra.app.util.xml.XmlProgramOptions;
import ghidra.framework.Application;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.OldLanguageMappingService;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlMessageLog;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ProgramXmlMgr {
    private static final String PROGRAM_DTD = "program_dtd";
    private int dtdVersion;
    private ProgramInfo info;
    private File file;

    public ProgramXmlMgr(File file) {
        this.file = file;
    }

    public ProgramXmlMgr(ByteProvider bp) {
        this.file = bp.getFSRL() != null && bp.getFSRL().getNestingDepth() == 1 ? new File(bp.getFSRL().getPath()) : bp.getFile();
    }

    public ProgramInfo getProgramInfo() throws SAXException, IOException {
        if (this.info != null) {
            return this.info;
        }
        this.info = new ProgramInfo();
        XmlPullParser parser = XmlPullParserFactory.create((File)this.file, (ErrorHandler)new MyErrorHandler(new MessageLog()), (boolean)false);
        boolean isFileValid = false;
        String ver = parser.getProcessingInstruction(PROGRAM_DTD, "VERSION");
        if (ver != null) {
            try {
                this.dtdVersion = Integer.parseInt(ver);
            }
            catch (NumberFormatException e) {
                Msg.debug((Object)this, (Object)("Unable to parse DTD: " + ver));
            }
        }
        while (parser.hasNext()) {
            XmlElement element = parser.next();
            String name = element.getName();
            if (name.equals("PROGRAM") && element.isStart()) {
                isFileValid = true;
                this.info.programName = element.getAttribute("NAME");
                this.info.exePath = element.getAttribute("EXE_PATH");
                this.info.exeFormat = element.getAttribute("EXE_FORMAT");
                this.info.imageBase = element.getAttribute("IMAGE_BASE");
                continue;
            }
            if (name.equals("INFO_SOURCE") && element.isStart()) {
                this.info.user = element.getAttribute("USER");
                this.info.setTool(element.getAttribute("TOOL"));
                this.info.timestamp = element.getAttribute("TIMESTAMP");
                this.info.version = element.getAttribute("VERSION");
                if (!this.isOldXml() || !this.info.isGhidra()) continue;
                this.info.programName = element.getAttribute("FILE");
                continue;
            }
            if (!name.equals("PROCESSOR") || !element.isStart()) continue;
            String languageString = element.getAttribute("LANGUAGE_PROVIDER");
            LanguageCompilerSpecPair pair = OldLanguageMappingService.processXmlLanguageString((String)languageString);
            if (pair != null) {
                this.info.languageID = pair.languageID;
                this.info.compilerSpecID = pair.compilerSpecID;
            } else {
                this.info.setCompilerSpecID(this.getForCompilerTag(parser));
            }
            this.info.processorName = element.getAttribute("NAME");
            this.info.family = element.getAttribute("FAMILY");
            this.info.addressModel = element.getAttribute("ADDRESS_MODEL");
            this.info.endian = element.getAttribute("ENDIAN");
            break;
        }
        parser.dispose();
        if (!isFileValid) {
            this.info = null;
        }
        return this.info;
    }

    private String getForCompilerTag(XmlPullParser parser) {
        String returnValue = null;
        while (parser.hasNext()) {
            XmlElement element = parser.next();
            String name = element.getName();
            if (!name.equals("COMPILER") || !element.isStart()) continue;
            returnValue = element.getAttribute("NAME");
            break;
        }
        return returnValue;
    }

    public MessageLog read(Program program, TaskMonitor monitor, XmlProgramOptions options) throws SAXException, IOException, AddressFormatException {
        Object mgr;
        MessageLog log;
        if (this.getProgramInfo() == null) {
            throw new SAXException("Unsupported XML Format!");
        }
        if (!options.isAddToProgram()) {
            String[] treeNames;
            MemoryBlock[] blocks;
            Memory memory = program.getMemory();
            for (MemoryBlock block : blocks = memory.getBlocks()) {
                try {
                    memory.removeBlock(block, monitor);
                }
                catch (LockException e) {
                    throw new RuntimeException(e);
                }
            }
            Listing listing = program.getListing();
            for (String treeName : treeNames = listing.getTreeNames()) {
                listing.removeTree(treeName);
            }
        }
        if (this.isOldXml()) {
            log = new MessageLog();
            log.appendMsg("File is old 2.0 XML which is no longer supported!");
            return log;
        }
        log = new XmlMessageLog();
        MyErrorHandler errHandler = new MyErrorHandler(log);
        XmlPullParser parser = XmlPullParserFactory.create((File)this.file, (ErrorHandler)errHandler, (boolean)false);
        log.setParser(parser);
        if (!options.isAddToProgram()) {
            program.setExecutableFormat(ProgramXmlMgr.getStandardName(this.info.exeFormat));
            program.setExecutablePath(this.info.exePath);
            try {
                SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss ZZZ yyyy");
                Date creationDate = format.parse(this.info.timestamp);
                Options pl = program.getOptions("Program Information");
                pl.setDate("Date Created", creationDate);
            }
            catch (Exception e) {
                Options pl = program.getOptions("Program Information");
                pl.setDate("Date Created", Program.JANUARY_1_1970);
            }
        }
        boolean secondPassRequired = false;
        XmlElement programStart = parser.start(new String[]{"PROGRAM"});
        try {
            while (parser.hasNext() && parser.peek().isStart() && !monitor.isCancelled()) {
                XmlElement element = parser.peek();
                String name = element.getName();
                if (options.isData() && name.equals("DATATYPES")) {
                    monitor.setMessage("Processing DATA TYPES ...");
                    mgr = new DataTypesXmlMgr(program.getListing().getDataTypeManager(), log);
                    ((DataTypesXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                if (options.isMemoryBlocks() && name.equals("MEMORY_MAP")) {
                    monitor.setMessage("Processing MEMORY MAP ...");
                    mgr = new MemoryMapXmlMgr(program, log);
                    ((MemoryMapXmlMgr)mgr).read(parser, options.isOverwriteMemoryConflicts(), monitor, this.file.getParent());
                    continue;
                }
                if (options.isRegisters() && name.equals("REGISTER_VALUES")) {
                    monitor.setMessage("Processing REGISTER VALUES ...");
                    mgr = new RegisterValuesXmlMgr(program, log);
                    ((RegisterValuesXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                if (options.isInstructions() && name.equals("CODE")) {
                    monitor.setMessage("Processing CODE ...");
                    mgr = new CodeXmlMgr(program, log);
                    ((CodeXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                if (options.isData() && name.equals("DATA")) {
                    monitor.setMessage("Processing DATA ...");
                    mgr = new DefinedDataXmlMgr(program, log);
                    ((DefinedDataXmlMgr)mgr).read(parser, options.isOverwriteDataConflicts(), monitor);
                    continue;
                }
                if (options.isEquates() && name.equals("EQUATES")) {
                    monitor.setMessage("Processing EQUATES ...");
                    mgr = new EquatesXmlMgr(program, log);
                    ((EquatesXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                if (options.isComments() && name.equals("COMMENTS")) {
                    monitor.setMessage("Processing COMMENTS ...");
                    mgr = new CommentsXmlMgr(program, log);
                    ((CommentsXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                if (options.isProperties() && name.equals("PROPERTIES")) {
                    monitor.setMessage("Processing PROPERTIES ...");
                    mgr = new PropertiesXmlMgr(program, log);
                    ((PropertiesXmlMgr)mgr).read(parser, options.isOverwritePropertyConflicts(), monitor);
                    continue;
                }
                if (options.isBookmarks() && name.equals("BOOKMARKS")) {
                    monitor.setMessage("Processing BOOKMARKS ...");
                    mgr = new BookmarksXmlMgr(program, log);
                    ((BookmarksXmlMgr)mgr).read(parser, options.isOverwriteBookmarkConflicts(), monitor);
                    continue;
                }
                if (options.isTrees() && name.equals("PROGRAM_TREES")) {
                    monitor.setMessage("Processing PROGRAM TREES ...");
                    mgr = new ProgramTreeXmlMgr(program, log);
                    ((ProgramTreeXmlMgr)mgr).read(parser, monitor, options.isAddToProgram());
                    continue;
                }
                if (options.isEntryPoints() && name.equals("PROGRAM_ENTRY_POINTS")) {
                    monitor.setMessage("Processing PROGRAM ENTRY POINTS ...");
                    mgr = new ExtEntryPointXmlMgr(program, log);
                    ((ExtEntryPointXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                if (options.isRelocationTable() && name.equals("RELOCATION_TABLE")) {
                    monitor.setMessage("Processing RELOCATION TABLE ...");
                    mgr = new RelocationTableXmlMgr(program, log);
                    ((RelocationTableXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                if (options.isSymbols() && name.equals("SYMBOL_TABLE")) {
                    monitor.setMessage("Processing SYMBOL TABLE ...");
                    mgr = new SymbolTableXmlMgr(program, log);
                    ((SymbolTableXmlMgr)mgr).read(parser, options.isOverwriteSymbolConflicts(), monitor);
                    secondPassRequired = ((SymbolTableXmlMgr)mgr).isSecondPassRequired();
                    continue;
                }
                if (options.isFunctions() && name.equals("FUNCTIONS")) {
                    monitor.setMessage("Processing FUNCTIONS ...");
                    mgr = new FunctionsXmlMgr(program, log);
                    ((FunctionsXmlMgr)mgr).read(parser, !options.isAddToProgram() || options.isOverwriteSymbolConflicts(), false, monitor);
                    continue;
                }
                if (options.isReferences() && name.equals("MARKUP")) {
                    monitor.setMessage("Processing MARKUP ...");
                    mgr = new MarkupXmlMgr(program, log);
                    ((MarkupXmlMgr)mgr).read(parser, options.isOverwriteReferenceConflicts(), options.isExternalLibraries(), options.isFunctions(), this.info.shouldProcessStack(), monitor);
                    continue;
                }
                if (options.isExternalLibraries() && name.equals("EXT_LIBRARY_TABLE")) {
                    monitor.setMessage("Processing EXT LIBRARY TABLE ...");
                    mgr = new ExternalLibXmlMgr(program, log);
                    ((ExternalLibXmlMgr)mgr).read(parser, monitor);
                    continue;
                }
                monitor.setMessage("Skipping over " + name + " ...");
                parser.discardSubTree(name);
            }
            parser.end(programStart);
        }
        catch (CancelledException e) {
            throw new IOException("XML Read Cancelled");
        }
        finally {
            parser.dispose();
        }
        if (secondPassRequired) {
            parser = XmlPullParserFactory.create((File)this.file, (ErrorHandler)errHandler, (boolean)false);
            log.setParser(parser);
            try {
                while (parser.hasNext() && !monitor.isCancelled()) {
                    XmlElement element = parser.peek();
                    String name = element.getName();
                    if (name.equals("PROGRAM")) {
                        parser.next();
                        continue;
                    }
                    if (options.isSymbols() && name.equals("SYMBOL_TABLE")) {
                        monitor.setMessage("Re-processing SYMBOL TABLE ...");
                        mgr = new SymbolTableXmlMgr(program, log);
                        ((SymbolTableXmlMgr)mgr).readPass2(parser, options.isOverwriteSymbolConflicts(), monitor);
                        continue;
                    }
                    monitor.setMessage("Skipping over " + name + " ...");
                    parser.discardSubTree(name);
                }
            }
            catch (CancelledException e) {
                throw new IOException("XML Read Cancelled");
            }
            finally {
                parser.dispose();
            }
        }
        this.createDefaultTree(program, options);
        if (options.isInstructions()) {
            GhidraProgramUtilities.setAnalyzedFlag(program, true);
        }
        return log;
    }

    public static String getStandardName(String name) {
        if (name == null) {
            return "Unknown";
        }
        if (name.toLowerCase().indexOf("portable executable") >= 0 && name.toLowerCase().indexOf("(pe)") >= 0) {
            return "Portable Executable (PE)";
        }
        if (name.toLowerCase().indexOf("(elf)") != -1) {
            return "Executable and Linking Format (ELF)";
        }
        if (name.toLowerCase().indexOf("dos executable") >= 0) {
            return "Old-style DOS Executable (MZ)";
        }
        if (name.toLowerCase().indexOf("new executable") >= 0) {
            return "New Executable (NE)";
        }
        return name;
    }

    private boolean isOldXml() {
        return this.dtdVersion < 1 && !"2.1 Dev".equals(this.info.version);
    }

    private void createDefaultTree(Program program, XmlProgramOptions options) {
        if (options.isAddToProgram()) {
            return;
        }
        Listing listing = program.getListing();
        if (listing.getTreeNames().length == 0) {
            try {
                listing.createRootModule("Program Tree");
            }
            catch (DuplicateNameException e) {
                Msg.debug((Object)this, (Object)"Unable to create default module", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageLog write(Program program, AddressSetView addrSet, TaskMonitor monitor, XmlProgramOptions options) throws IOException, CancelledException {
        MessageLog log = new MessageLog();
        try (XmlWriter writer = new XmlWriter(this.file, "PROGRAM.DTD");){
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("NAME", program.getDomainFile().getName());
            attrs.addAttribute("EXE_PATH", program.getExecutablePath());
            attrs.addAttribute("EXE_FORMAT", program.getExecutableFormat());
            attrs.addAttribute("IMAGE_BASE", program.getImageBase().toString());
            writer.startElement("PROGRAM", attrs);
            this.writeProgramElements(program, addrSet, writer, monitor, log, options);
            writer.endElement("PROGRAM");
        }
        return log;
    }

    private void writeProgramElements(Program program, AddressSetView addrSet, XmlWriter writer, TaskMonitor monitor, MessageLog log, XmlProgramOptions options) throws IOException, CancelledException {
        Object mgr;
        this.writeInfoSource(writer, monitor);
        this.writeProcessor(program, writer, monitor);
        if (options.isData()) {
            mgr = new DataTypesXmlMgr(program.getListing().getDataTypeManager(), log);
            ((DataTypesXmlMgr)mgr).write(writer, monitor);
        }
        if (options.isMemoryBlocks()) {
            mgr = new MemoryMapXmlMgr(program, log);
            ((MemoryMapXmlMgr)mgr).write(writer, addrSet, monitor, options.isMemoryContents(), this.file);
        }
        if (options.isRegisters()) {
            mgr = new RegisterValuesXmlMgr(program, log);
            ((RegisterValuesXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isInstructions()) {
            mgr = new CodeXmlMgr(program, log);
            ((CodeXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isData()) {
            mgr = new DefinedDataXmlMgr(program, log);
            ((DefinedDataXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isEquates()) {
            mgr = new EquatesXmlMgr(program, log);
            ((EquatesXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isComments()) {
            mgr = new CommentsXmlMgr(program, log);
            ((CommentsXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isProperties()) {
            mgr = new PropertiesXmlMgr(program, log);
            ((PropertiesXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isBookmarks()) {
            mgr = new BookmarksXmlMgr(program, log);
            ((BookmarksXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isTrees()) {
            mgr = new ProgramTreeXmlMgr(program, log);
            ((ProgramTreeXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isEntryPoints()) {
            mgr = new ExtEntryPointXmlMgr(program, log);
            ((ExtEntryPointXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isRelocationTable()) {
            mgr = new RelocationTableXmlMgr(program, log);
            ((RelocationTableXmlMgr)mgr).write(writer, monitor);
        }
        if (options.isSymbols()) {
            mgr = new SymbolTableXmlMgr(program, log);
            ((SymbolTableXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isFunctions()) {
            mgr = new FunctionsXmlMgr(program, log);
            ((FunctionsXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isReferences()) {
            mgr = new MarkupXmlMgr(program, log);
            ((MarkupXmlMgr)mgr).write(writer, addrSet, monitor);
        }
        if (options.isExternalLibraries()) {
            mgr = new ExternalLibXmlMgr(program, log);
            ((ExternalLibXmlMgr)mgr).write(writer, monitor);
        }
    }

    private void writeInfoSource(XmlWriter writer, TaskMonitor monitor) {
        monitor.setMessage("Writing INFO SOURCE ...");
        XmlAttributes attrs = new XmlAttributes();
        String user = SystemUtilities.getUserName();
        if (user != null) {
            attrs.addAttribute("USER", user);
        }
        attrs.addAttribute("TOOL", "Ghidra " + Application.getApplicationVersion());
        attrs.addAttribute("TIMESTAMP", new Date().toString());
        writer.startElement("INFO_SOURCE", attrs);
        writer.endElement("INFO_SOURCE");
    }

    private void writeProcessor(Program program, XmlWriter writer, TaskMonitor monitor) {
        monitor.setMessage("Writing PROCESSOR ...");
        XmlAttributes attrs = new XmlAttributes();
        Language language = program.getLanguage();
        CompilerSpec compilerSpec = program.getCompilerSpec();
        attrs.addAttribute("NAME", language.getProcessor().toString());
        attrs.addAttribute("LANGUAGE_PROVIDER", language.getLanguageID().getIdAsString() + ":" + compilerSpec.getCompilerSpecID().getIdAsString());
        attrs.addAttribute("ENDIAN", language.isBigEndian() ? "big" : "little");
        writer.startElement("PROCESSOR", attrs);
        writer.endElement("PROCESSOR");
    }
}

