/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import ghidra.server.UserManager;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public interface AuthenticationModule {
    public static final String USERNAME_CALLBACK_PROMPT = "User ID";
    public static final String PASSWORD_CALLBACK_PROMPT = "Password";

    public String authenticate(UserManager var1, Subject var2, Callback[] var3) throws LoginException;

    public Callback[] getAuthenticationCallbacks();

    public boolean anonymousCallbacksAllowed();

    public boolean isNameCallbackAllowed();

    public static Callback[] createSimpleNamePasswordCallbacks(boolean allowUserToSpecifyName) {
        PasswordCallback passCb = new PasswordCallback("Password:", false);
        if (allowUserToSpecifyName) {
            NameCallback nameCb = new NameCallback("User ID:");
            return new Callback[]{nameCb, passCb};
        }
        return new Callback[]{passCb};
    }

    public static <T extends Callback> T getFirstCallbackOfType(Class<T> callbackClass, Callback[] callbackArray) {
        if (callbackArray == null) {
            return null;
        }
        for (Callback cb : callbackArray) {
            if (callbackClass != cb.getClass()) continue;
            return (T)((Callback)callbackClass.cast(cb));
        }
        return null;
    }
}

