/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelOnlyWrappingTaskMonitor;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.List;

public class PasteFileTask
extends Task {
    private DomainFolderNode destNode;
    private List<GTreeNode> list;
    private boolean isCut;
    private RepositoryAdapter repository;
    private FrontEndTool tool;

    public PasteFileTask(DomainFolderNode destNode, List<GTreeNode> list, boolean isCut) {
        super(list.size() > 1 ? "Paste Files" : "Paste File", true, true, true);
        this.destNode = destNode;
        this.list = list;
        this.isCut = isCut;
        this.tool = AppInfo.getFrontEndTool();
        this.repository = this.tool.getProject().getRepository();
    }

    public void run(TaskMonitor monitor) {
        TaskMonitor subMonitor = monitor;
        if (this.list.size() > 1) {
            subMonitor = new CancelOnlyWrappingTaskMonitor(monitor);
        }
        try {
            monitor.initialize((long)this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                GTreeNode tnode = this.list.get(i);
                monitor.setProgress((long)i);
                if (tnode instanceof DomainFolderNode) {
                    monitor.setMessage("Pasting folder");
                    this.pasteFolder(((DomainFolderNode)tnode).getDomainFolder(), subMonitor);
                } else if (tnode instanceof DomainFileNode) {
                    monitor.setMessage("Pasting file");
                    this.pasteFile(((DomainFileNode)tnode).getDomainFile(), subMonitor);
                }
                if (!monitor.isCancelled()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)("Paste Files at " + this.destNode.getName()), (Component)this.tool.getToolFrame());
        }
    }

    private void pasteFile(DomainFile file, TaskMonitor monitor) {
        if (this.isCut) {
            this.moveFile(file, this.destNode.getDomainFolder());
        } else {
            this.copyFile(file, this.destNode.getDomainFolder(), monitor);
        }
    }

    private void pasteFolder(DomainFolder folder, TaskMonitor monitor) {
        if (this.isCut) {
            this.moveFolder(folder, this.destNode.getDomainFolder());
        } else {
            this.copyFolder(folder, this.destNode.getDomainFolder(), monitor);
        }
    }

    private void copyFile(DomainFile file, DomainFolder folder, TaskMonitor monitor) {
        try {
            String name = file.getName();
            DomainFile newFile = file.copyTo(folder, monitor);
            Msg.info((Object)((Object)this), (Object)("Copied file " + name + " to " + folder.toString() + " as " + newFile.getName()));
        }
        catch (CancelledException name) {
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Copy Files", (Component)this.tool.getToolFrame());
        }
    }

    private void copyFolder(DomainFolder folder, DomainFolder newParent, TaskMonitor monitor) {
        String name = folder.getName();
        try {
            folder.copyTo(newParent, monitor);
            Msg.info((Object)((Object)this), (Object)("Copied folder " + name + " to " + newParent.toString()));
        }
        catch (CancelledException cancelledException) {
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Copy Folder", (Component)this.tool.getToolFrame());
        }
    }

    private void moveFile(DomainFile file, DomainFolder folder) {
        try {
            String name = file.getName();
            file.moveTo(folder);
            Msg.info((Object)((Object)this), (Object)("Moved file " + name + " to " + folder.toString()));
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Move File", (Component)this.tool.getToolFrame());
        }
    }

    private void moveFolder(DomainFolder folder, DomainFolder newParent) {
        String name = folder.getName();
        try {
            folder.moveTo(newParent);
            Msg.info((Object)((Object)this), (Object)("Moved folder " + name + " to " + folder.toString()));
        }
        catch (Exception e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Move Folder", (Component)this.tool.getToolFrame());
        }
    }
}

